/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.dto.solicitacaoalvara.SolicitacaoAlvaraObservacaoDTO;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryCnaePrestadorServico;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.service.SrvContratoSocial;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvMontaObsAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.exception.CadastroImobiliarioException;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCategoriaMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryClassificacaoMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryEnderecoPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryGuiaRecolhimento;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryRegimeFiscalPeriodoRealAise;
import br.com.elotech.util.list.EloListUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloService(value="srvSolicitacaoAlvaraMEI")
@Scope(value="prototype")
public class SrvSolicitacaoAlvaraMEIImpl
extends SrvSolicitacaoAlvaraImpl
implements SrvSolicitacaoAlvaraMEI {
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositoryGuiaRecolhimento repositoryGuiaRecolhimento;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoValidade;
    @Resource
    private SrvMontaObsAlvara srvMontaObsAlvara;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryEnderecoPessoa repositoryEnderecoPessoa;
    @Resource
    private RepositoryCnaePrestadorServico repositoryCnaePrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private RepositoryRegimeFiscalPeriodoRealAise repositoryRegimeFiscalPeriodoRealAise;
    @Resource
    private RepositoryClassificacaoMobiliario repositoryClassificacaoMobiliario;
    @Resource
    private RepositoryCategoriaMobiliario repositoryCategoriaMobiliario;
    @Resource
    private SrvContratoSocial srvContratoSocial;

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, true);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracaoSemLaudo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, false);
    }

    private SolicitacaoAlvaraEntity saveSolicitacaoAlvaraEventosAlteracao(SolicitacaoAlvaraEntity solicitacao, boolean geraLaudos) throws BaseException {
        String paramInformarEnderecoMEI = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INFORMAR_ENDERECO_MEI);
        if (geraLaudos && solicitacao.isNaturezaMudancaEndereco() && solicitacao.getCadastroImobiliario() == null && SimNaoEnum.getNaoShortText().equals(paramInformarEnderecoMEI)) {
            throw new CadastroImobiliarioException("Essa solicita\u00e7\u00e3o n\u00e3o possui um Cadastro Imobili\u00e1rio v\u00e1lido.");
        }
        boolean geraLaudoMeiNormal = false;
        solicitacao.setDataSolicitacao(Calendar.getInstance().getTime());
        this.carregarEsalvarAtividadesNaSolicitacao(solicitacao);
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && this.validaAlteracaoGeraLaudo(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL)) {
            geraLaudoMeiNormal = true;
        }
        if (solicitacao.isNaturezaMudancaEndereco()) {
            geraLaudoMeiNormal = true;
        }
        if (solicitacao.isNaturezaAlteracaoAtividade()) {
            this.alteraAtividadePrincipalDaSolicitacao(solicitacao);
            geraLaudoMeiNormal = true;
        }
        if (geraLaudos && geraLaudoMeiNormal) {
            this.consultarWSAtividades(solicitacao);
        }
        if (solicitacao.isGrauRiscoBaixo()) {
            this.adicionaValidadeAlvaraProvisorio(solicitacao);
        }
        if (!solicitacao.isSolicitacaoMEIPrestador()) {
            this.carregaGrauRiscoDaSolicitacao(solicitacao);
        }
        if (solicitacao.isRedeSim()) {
            try {
                this.srvContratoSocial.preencherContratoSocialBySolicitacao(solicitacao);
                this.formatLogSolicitacaoContratoSocialAlvara("Natureza de altera\u00e7\u00e3o de s\u00f3cio", solicitacao);
                this.atualizaContratoSocialCadastroMobiliario(solicitacao, true);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Ocorreu uma falha ao preencher o contrato social recebido pela integra\u00e7\u00e3o. " + e.getMessage(), (Throwable)e);
            }
        }
        this.carregarEsalvarAtividadesNaSolicitacao(solicitacao);
        this.logger.info((Object)"MEI-adicionaSolicitacaoContratoSocial------- salvarSolicitacaoAlvaraAlteracao");
        this.adicionaSolicitacaoContratoSocial(solicitacao);
        if (Objects.nonNull(solicitacao.getCadastroMobiliario())) {
            this.salvarCadastroGeralIsencao(solicitacao.getCadastroMobiliario(), solicitacao);
            this.atualizarNaturezaJuridica(solicitacao);
        }
        this.vincularMobiliarioCnae(solicitacao);
        this.getUtilizaMobiliarioAtividade(solicitacao);
        this.carregaMobiliarioAtividades(solicitacao);
        solicitacao.setFinalizado(SimNaoEnum.SIM.getShortText());
        return this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
    }

    public void salvarConsultaPreviaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.setRenovacao("N");
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
            this.atribuirIdAtividadesSolicitacao(solicitacao);
        }
        this.inserirDataValidadeNaSolicitacao(solicitacao);
        this.salvarSolicitacaoAlvara(solicitacao);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoInicial(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean restricaoCadastroExistente) throws BaseException {
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setExclusaoLogica("S");
        this.salvarSolicitacaoAlvaraInicial(solicitacaoAlvara, restricaoCadastroExistente);
        this.ajustarAtividadePrincipalMobiliarioCnae(solicitacaoAlvara);
        if (solicitacaoAlvara.isSolicitacaoMEINormal()) {
            this.geraLaudos(solicitacaoAlvara);
            this.salvarCategoriaMobiliario(solicitacaoAlvara, ParametroAlvaraEnum.CATEGORIA_MOBILIARIO_MEI);
            this.salvarClassificacaoMobiliario(solicitacaoAlvara, ParametroAlvaraEnum.COD_CLASSIFICACAO_MOBILIARIA_MEI);
            this.salvarNaturezaJuridicaMeiMobiliario(solicitacaoAlvara, ParametroAlvaraEnum.COD_NATUREZA_JURIDICA_MEI);
        } else if (solicitacaoAlvara.isSolicitacaoMEIPrestador()) {
            Set laudos = this.srvSolicitacaoAlvaraPrestadorServico.getLaudosAGerar(solicitacaoAlvara);
            this.srvSolicitacaoAlvaraPrestadorServico.geraLaudo(solicitacaoAlvara, laudos);
            if (EloListUtils.safeIsEmpty(new ArrayList(laudos)).booleanValue()) {
                this.adicionaValidadeAlvaraProvisorio(solicitacaoAlvara);
            }
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        }
        return solicitacaoAlvara;
    }

    protected void ajustarAtividadePrincipalMobiliarioCnae(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        CnaeEntity cnaePrincipal = solicitacaoAlvara.getAtividadePrincipal().getAtividadeMei().getCnae();
        for (MobiliarioCnaeEntity mobCnae : solicitacaoAlvara.getCadastroMobiliario().getMobiliarioCnaes()) {
            mobCnae.setCnaePrincipal(SimNaoEnum.NAO.getShortText());
            if (!cnaePrincipal.getId().equals(mobCnae.getId().getCnae().getId())) continue;
            mobCnae.setCnaePrincipal(SimNaoEnum.SIM.getShortText());
        }
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException, URISyntaxException {
        StringBuilder mensagemValidacao = new StringBuilder();
        boolean isValido = true;
        if (!solicitacao.isRenovacaoDeSolicitacao()) {
            if (solicitacao.isGrauRiscoAlto() || solicitacao.isSolicitacaoMEIPrestador()) {
                if (!this.isTodosLaudosLiberados(solicitacao)) {
                    isValido = false;
                    mensagemValidacao.append("Todos os Laudos devem estar Liberados e ");
                }
                if (solicitacao.exigeUploadDocumentos() && !EloListUtils.safeIsEmpty((List)solicitacao.getDocumentos()).booleanValue() && !this.isDocumentoComSituacaoValida(solicitacao.getDocumentos())) {
                    isValido = false;
                    mensagemValidacao.append("Todos os Documentos devem estar validados e ");
                }
                if (!isValido) {
                    throw new SolicitacaoAlvaraException(mensagemValidacao.substring(0, mensagemValidacao.length() - 3));
                }
            }
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL}) && !this.isDocumentoComSituacaoValida(solicitacao.getDocumentos()) && !solicitacao.isRedeSim()) {
                throw new SolicitacaoAlvaraException("Todos os Documentos devem estar validados!");
            }
            if (!this.verificaVencimentoLaudo(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel imprimir o alvar\u00e1, existem laudos ou documentos vencidos. Acompanhar a libera\u00e7\u00e3o dos laudos.");
            }
        } else {
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && !this.isTodosLaudosLiberados(solicitacao)) {
                throw new SolicitacaoAlvaraException("Todos os Laudos devem estar Liberados");
            }
            if (solicitacao.getDataValidadeSefaz() != null) {
                super.validarDocumentosVazios(solicitacao);
                super.validarDocumentosParaImpressao(solicitacao);
            }
            if (!this.verificaVencimentoLaudo(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel imprimir o alvar\u00e1, existem laudos ou documentos vencidos. Acompanhar a libera\u00e7\u00e3o dos laudos.");
            }
            this.verificaSituacaoVencidoOuDesatualizado(solicitacao);
        }
        this.verificaSituacaoEmAnalise(solicitacao);
        if (!solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL}) && !this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
            throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro N\u00e3o \u00e9 v\u00e1lida ou Existe uma data de Validade sem Laudos no alvar\u00e1 online.");
        }
        this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario());
        this.repositoryCadastroMobiliario.flush();
        if (!solicitacao.isNaturezaInicial() && solicitacao.getNumeroAlvara() == null && SimNaoEnum.equalNao((String)solicitacao.getEfetivado()).booleanValue()) {
            this.efetivaAlteracaoSolicitacao(solicitacao);
        }
        List listaValidadeAlvaraAtual = this.repositorySolicitacaoValidade.retornaValidadeBySolicitacao(solicitacao);
        List listaValidadeAlvaraCorrente = this.carregaListaVencimentoAlvara(solicitacao);
        solicitacao.setObservacoes(this.srvMontaObsAlvara.montaObsAlvara(solicitacao));
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && solicitacao.isTodosLaudosLiberados()) {
            solicitacao.setDataValidadeProvisorio(null);
            solicitacao.getCadastroMobiliario().setDataValidadeAlvara(null);
        }
        solicitacao.getCadastroMobiliario().setObservacaoAlvara(solicitacao.getObservacoes());
        solicitacao.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario()));
        this.gerarEImprimirDocumento(listaValidadeAlvaraAtual, listaValidadeAlvaraCorrente, solicitacao);
        this.atualizarSolicitacaoAlvara(solicitacao);
    }

    public void efetivaAlteracaoSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior = SolicitacaoAlvaraObservacaoDTO.of((SolicitacaoAlvaraEntity)solicitacao);
        solicitacao.getCadastroMobiliario().setTelefone(solicitacao.getTelefonePreenchido());
        solicitacao.setEfetivado(SimNaoEnum.SIM.getShortText());
        if (solicitacao.isNaturezaMudancaRazaoSocial()) {
            this.salvarAlteracaoRazaoSocial(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaEndereco()) {
            if (!solicitacao.isSolicitacaoMEIPrestador()) {
                this.alteraAreasNoCadastro(solicitacao);
            }
            this.salvarAlteracaoEndereco(solicitacao);
        }
        List cnaesAntigos = Collections.emptyList();
        if (solicitacao.isNaturezaAlteracaoAtividade()) {
            solicitacao.getCadastroMobiliario().setAtividadePrincipal(PortalUtils.getDescricaoAtividadesMei((SolicitacaoAlvaraEntity)solicitacao));
            cnaesAntigos = this.loadCnaesBySolicitacaoAlvara(solicitacao);
            this.salvarAlteracaoAtividade(solicitacao);
            this.ajustarAtividadePrincipalMobiliarioCnae(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaArea()) {
            this.salvarAlteracaoArea(solicitacao);
        }
        if (solicitacao.isAlteracaoNaturezaJuridica()) {
            this.atualizarNaturezaJuridica(solicitacao);
        }
        this.atualizarContatoPessoa(solicitacao);
        this.salvarObservacao(solicitacao, solicitacaoAlvaraObservacaoAnterior, cnaesAntigos);
        this.atualizarSolicitacaoAlvara(solicitacao);
        SituacaoMobiliarioAlvaraEnum situacaoMobiliarioAlvara = SituacaoMobiliarioAlvaraEnum.SITUACAO_EMITEISSNAOEMITETAXAS;
        if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor()).booleanValue()) {
            situacaoMobiliarioAlvara = SituacaoMobiliarioAlvaraEnum.SITUACAO_CADASTRO_ATUALIZADO_PELA_JUNTA;
        }
        this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacao, situacaoMobiliarioAlvara);
    }

    public void generateLaudos(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.consultarWSAtividades(solicitacao);
    }
}

