/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ParametroException;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.common.CommonGeraDocumento;
import br.com.elotech.portalarrecadacao.common.CommonGeraNumeroDocumento;
import br.com.elotech.portalarrecadacao.common.GeraDocumentoAlvaraLocalizacao;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.CadastroMobiliarioHelper;
import br.com.elotech.portalarrecadacao.domain.vo.AtividadeCnaeVo;
import br.com.elotech.portalarrecadacao.domain.vo.DocumentoAtividadeTipoInscricaoVo;
import br.com.elotech.portalarrecadacao.domain.vo.MensagemTipoInscricaoVo;
import br.com.elotech.portalarrecadacao.domain.vo.ResponsavelSolicitacaoVo;
import br.com.elotech.portalarrecadacao.dto.DocumentoAiseDTO;
import br.com.elotech.portalarrecadacao.dto.solicitacaoalvara.SolicitacaoAlvaraObservacaoDTO;
import br.com.elotech.portalarrecadacao.enumerator.GeraNumeroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoPessoaEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.DocumentoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Atividades;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Endereco;
import br.com.elotech.portalarrecadacao.integration.vo.CodigoLiberacaoIssExterno;
import br.com.elotech.portalarrecadacao.integration.vo.PessoaIssExterno;
import br.com.elotech.portalarrecadacao.integration.vo.PessoaIssExternoEnvio;
import br.com.elotech.portalarrecadacao.repository.RepositoryCadastroRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoHorarioEspecialAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryNaturezaSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryNaturezaSolicitacaoTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvaraNatureza;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoConsultaPrevia;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDebito;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDocumento;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraNumConselho;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocial;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocialPessoa;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.rest.geradocumento.EnvioGeraDocumento;
import br.com.elotech.portalarrecadacao.rest.geradocumento.GeraDocumentoClientAlvara;
import br.com.elotech.portalarrecadacao.rest.imprimirdocumento.ImprimeDocumentoAlvara;
import br.com.elotech.portalarrecadacao.rest.issExterno.SrvClientIssExterno;
import br.com.elotech.portalarrecadacao.service.SrvArquivoDocumentoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.service.SrvContratoSocial;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvGeraBoletimMobiliario;
import br.com.elotech.portalarrecadacao.service.SrvMontaObsAlvara;
import br.com.elotech.portalarrecadacao.service.SrvRestricaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSituacaoMobiliarioAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.portalarrecadacao.service.SrvUsuario;
import br.com.elotech.portalarrecadacao.service.impl.SrvFindEnderecoBySimilarity;
import br.com.elotech.portalarrecadacao.service.impl.SrvFindTipoInscricaoAlvaraImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.AtividadeCnaeEntity;
import br.com.elotech.tributacao.domain.aise.AtividadeEntity;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.BairroPK;
import br.com.elotech.tributacao.domain.aise.BoletimAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.BoletimAtividadePK;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioPK;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroGeralIsencaoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralIsencaoPK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.CnaeServicoEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoHorarioEspecialAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaPK;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPK;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaPK;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoPK;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroGeralEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaPK;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.IsencaoEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioAtividadePK;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaePK;
import br.com.elotech.tributacao.domain.aise.MobiliarioHorarioEspecialEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioHorarioEspecialPK;
import br.com.elotech.tributacao.domain.aise.MobiliarioServicoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioServicoPK;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoPK;
import br.com.elotech.tributacao.domain.aise.ModeloCampoEntity;
import br.com.elotech.tributacao.domain.aise.ModeloIdentificacaoEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaEntity;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.domain.aise.ObservacaoEntity;
import br.com.elotech.tributacao.domain.aise.ObservacaoPK;
import br.com.elotech.tributacao.domain.aise.ParametroEntidadeExercicioEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ProprietarioEntity;
import br.com.elotech.tributacao.domain.aise.ProprietarioPK;
import br.com.elotech.tributacao.domain.aise.RegimeFiscalPeriodoRealAiseEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraGuiaEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.tributacao.enumerator.EnderecoTipoEnum;
import br.com.elotech.tributacao.enumerator.ModeloIdentificacaoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.enumerator.TipoConfiguracaoAtividadeDocEnum;
import br.com.elotech.tributacao.exception.CadastroMobiliarioException;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryAtividadeCnae;
import br.com.elotech.tributacao.repository.aise.RepositoryBairro;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimAtividade;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeralIsencao;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroImobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliarioAtividade;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliarioAtividadeMei;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliarioCBO;
import br.com.elotech.tributacao.repository.aise.RepositoryCategoriaMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryClassificacaoMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCnae;
import br.com.elotech.tributacao.repository.aise.RepositoryCnaeServico;
import br.com.elotech.tributacao.repository.aise.RepositoryContatoPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoImpresso;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoTipo;
import br.com.elotech.tributacao.repository.aise.RepositoryEnderecoCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryGuiaRecolhimento;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestada;
import br.com.elotech.tributacao.repository.aise.RepositoryIsencao;
import br.com.elotech.tributacao.repository.aise.RepositoryLogradouro;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioServico;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloIdentificacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloResposta;
import br.com.elotech.tributacao.repository.aise.RepositoryNaturezaJuridica;
import br.com.elotech.tributacao.repository.aise.RepositoryObservacao;
import br.com.elotech.tributacao.repository.aise.RepositoryParametroEntidadeExercicio;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoaMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryProprietario;
import br.com.elotech.tributacao.repository.aise.RepositoryRegimeFiscalPeriodoRealAise;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliarioAlvara;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.tributacao.security.AuthenticationProviderAise;
import br.com.elotech.tributacao.service.SrvContatoPessoa;
import br.com.elotech.tributacao.service.SrvEnderecoPessoa;
import br.com.elotech.tributacao.service.SrvPessoa;
import br.com.elotech.tributacao.service.SrvUnico;
import br.com.elotech.unico.rest.exception.UnicoClientException;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.sql.EloSqlUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.wicket.util.string.Strings;
import org.springframework.context.annotation.Scope;
import org.springframework.oxm.XmlMappingException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@EloService(value="srvSolicitacaoAlvaraHelper")
@Scope(value="prototype")
public class SrvSolicitacaoAlvaraHelperImpl
extends EloLogger
implements SrvSolicitacaoAlvaraHelper {
    private static final int DAYS_DIFERENCE = 25569;
    private static final int MILLIS_PER_DAY = 86400000;
    private static final String SUFIXO_OBSERVACAO_ALTERACAO_ANTERIOR = " Anterior";
    @Resource
    protected RepositoryModeloIdentificacao repositoryModeloIdentificacao;
    @Resource
    protected RepositoryNaturezaSolicitacaoAlvara repositoryNaturezaSolicitacaoAlvara;
    @Resource
    protected RepositoryCategoriaMobiliario repositoryCategoriaMobiliario;
    @Resource
    protected RepositoryClassificacaoMobiliario repositoryClassificacaoMobiliario;
    @Resource
    protected RepositoryNaturezaJuridica repositoryNaturezaJuridica;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade;
    @Resource
    private RepositorySolicitacaoAlvaraNumConselho repositorySolicitacaoAlvaraNumConselho;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private SrvEnderecoPessoa srvEnderecoPessoa;
    @Resource
    private SrvContatoPessoa srvContatoPessoa;
    @Resource
    private SrvContratoSocial srvContratoSocial;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryIsencao repositoryIsencao;
    @Resource
    private RepositoryCadastroGeralIsencao repositoryCadastrogeralIsencao;
    @Resource
    private RepositoryCadastroImobiliario repositoryCadastroImobiliario;
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;
    @Resource
    private SrvMontaObsAlvara srvMontaObsAlvara;
    @Resource
    private RepositoryObservacao repositoryObservacao;
    @Resource
    private RepositoryParametroAlvaraNatureza repositoryParametroAlvaraNatureza;
    @Resource
    private RepositoryProprietario repositoryProprietario;
    @Resource
    private RepositoryModeloResposta repositoryModeloResposta;
    @Resource
    private RepositoryBoletimMobiliario repositoryBoletimMobiliario;
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private RepositoryParametroEntidadeExercicio repositoryParametroEntidadeExercicio;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositorySolicitacaoAlvaraDebito repositorySolicitacaoAlvaraDebito;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoAlvaraValidade;
    @Resource
    private RepositoryDocumentoTipo repositoryDocumentoTipo;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    @Resource
    private RepositoryDocumentoImpresso repositoryDocumentoImpresso;
    @Resource
    private RepositoryRestricaoAlvara repositoryRestricaoAlvara;
    @Resource
    private RepositoryCadastroRestricaoAlvara repositoryCadastroRestricaoAlvara;
    @Resource
    private RepositoryCadastroMobiliarioAtividadeMei repositoryCadastroMobiliarioAtividadeMei;
    @Resource
    private RepositoryCadastroMobiliarioCBO repositoryCadastroMobiliarioCBO;
    @Resource
    private SrvRestricaoAlvara srvRestricaoAlvara;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryGuiaRecolhimento repositoryGuiaRecolhimento;
    @Resource
    private RepositoryImobiliarioTestada repositoryImobiliarioTestada;
    @Resource
    private RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial;
    @Resource
    private RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoValidade;
    @Resource
    private RepositoryRestricaoConsultaPrevia repositoryRestricaoConsultaPrevia;
    @Resource
    private RepositoryTipoInscricaoAlvara repositoryTipoInscricaoAlvara;
    @Resource
    private RepositoryNaturezaSolicitacaoTipoInscricaoAlvara repositoryNaturezaSolicitacaoTipoInscricaoAlvara;
    @Resource
    private RepositoryUsuario repositoryUsuario;
    @Resource
    private RepositoryEnderecoCadastroGeral repositoryEnderecoCadastroGeral;
    @Resource
    private SrvGeraBoletimMobiliario srvGeraBoletimMobiliarioAlvara;
    @Resource
    private ServletContext scontext;
    @Resource
    private SrvClientIssExterno srvClientIssExterno;
    @Resource
    private RepositorySolicitacaoAlvaraDocumento repositorySolicitacaoAlvaraDocumento;
    @Resource
    private RepositoryAtividadeCnae repositoryAtividadeCnae;
    @Resource
    private RepositoryRegimeFiscalPeriodoRealAise repositoryRegimeFiscalPeriodoRealAise;
    @Resource
    private RepositoryPessoaMobiliario repositoryPessoaMobiliario;
    @Resource
    private RepositoryBoletimAtividade repositoryBoletimAtividade;
    @Resource
    private RepositoryConfiguracaoHorarioEspecialAtividade repositoryConfiguracaoHorarioEspecialAtividade;
    @Resource
    private RepositorySituacaoMobiliarioAlvara repositorySituacaoMobiliarioAlvara;
    @Resource
    private RepositoryCnaeServico repositoryCnaeServico;
    @Resource
    private RepositoryMobiliarioServico repositoryMobiliarioServico;
    @Resource
    private ImprimeDocumentoAlvara imprimeDocumentoAlvara;
    @Resource
    private SrvPessoa srvPessoa;
    @Resource
    private SrvFindTipoInscricaoAlvaraImpl srvFindTipoInscricaoAlvara;
    private CadastroMobiliarioEntity cadastroMobiliarioExistente;
    private PessoaEntity pessoaExistente;
    @Resource
    private SrvConfiguracaoAtividade srvConfiguracaoAtividade;
    @Resource
    private SrvUnico srvUnico;
    @Resource
    private RepositoryContatoPessoa repositoryContatoPessoa;
    @Resource
    private SrvUsuario srvUsuario;
    @Resource
    private AuthenticationProviderAise authenticationProvider;
    @Resource
    private SrvArquivoDocumentoAlvara srvArquivoDocumentoAlvara;
    @Resource
    private RepositoryLogradouro repositoryLogradouro;
    @Resource
    private RepositoryBairro repositoryBairro;
    @Resource
    private SrvSituacaoMobiliarioAlvara srvSituacaoMobiliarioAlvara;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private RepositoryCnae repositoryCnae;
    @Resource
    RepositoryCadastroMobiliarioAtividade repositoryCadastroMobiliarioAtividade;
    @Resource
    private SrvFindEnderecoBySimilarity srvFindEnderecoBySimilarity;

    public static double toDelphi(long javaMillis) {
        return (double)javaMillis / 8.64E7 + 25569.0;
    }

    public static <T> Predicate<T> distinctByKeyValueNotNull(Function<? super T, Object> keyExtractor, Function<? super T, Object> value) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null && value != null;
    }

    public void setSrvUnico(SrvUnico srvUnico) {
        this.srvUnico = srvUnico;
    }

    public void setSrvPessoa(SrvPessoa srvPessoa) {
        this.srvPessoa = srvPessoa;
    }

    public void setSrvContatoPessoa(SrvContatoPessoa srvContatoPessoa) {
        this.srvContatoPessoa = srvContatoPessoa;
    }

    public void setSrvContratoSocial(SrvContratoSocial srvContratoSocial) {
        this.srvContratoSocial = srvContratoSocial;
    }

    public void setRepositoryProprietario(RepositoryProprietario repositoryProprietario) {
        this.repositoryProprietario = repositoryProprietario;
    }

    public void setRepositoryContratoSocial(RepositoryContratoSocial repositoryContratoSocial) {
        this.repositoryContratoSocial = repositoryContratoSocial;
    }

    public void setSrvClientIssExterno(SrvClientIssExterno srvClientIssExterno) {
        this.srvClientIssExterno = srvClientIssExterno;
    }

    public void setSrvEnderecoPessoa(SrvEnderecoPessoa srvEnderecoPessoa) {
        this.srvEnderecoPessoa = srvEnderecoPessoa;
    }

    public void setRepositoryMobiliarioSituacao(RepositoryMobiliarioSituacao repositoryMobiliarioSituacao) {
        this.repositoryMobiliarioSituacao = repositoryMobiliarioSituacao;
    }

    public void setRepositorySituacaoMobiliario(RepositorySituacaoMobiliario repositorySituacaoMobiliario) {
        this.repositorySituacaoMobiliario = repositorySituacaoMobiliario;
    }

    public void setRepositoryParametroGeral(RepositoryParametroGeral repositoryParametroGeral) {
        this.repositoryParametroGeral = repositoryParametroGeral;
    }

    public void setRepositoryEnderecoCadastroGeral(RepositoryEnderecoCadastroGeral repositoryEnderecoCadastroGeral) {
        this.repositoryEnderecoCadastroGeral = repositoryEnderecoCadastroGeral;
    }

    public void setRepositorySolicitacaoContratoSocial(RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial) {
        this.repositorySolicitacaoContratoSocial = repositorySolicitacaoContratoSocial;
    }

    public void setRepositoryNaturezaSolicitacaoAlvara(RepositoryNaturezaSolicitacaoAlvara repositoryNaturezaSolicitacaoAlvara) {
        this.repositoryNaturezaSolicitacaoAlvara = repositoryNaturezaSolicitacaoAlvara;
    }

    public void setRepositoryCadastroMobiliario(RepositoryCadastroMobiliario repositoryCadastroMobiliario) {
        this.repositoryCadastroMobiliario = repositoryCadastroMobiliario;
    }

    public void setRepositoryParametroAlvaraNatureza(RepositoryParametroAlvaraNatureza repositoryParametroAlvaraNatureza) {
        this.repositoryParametroAlvaraNatureza = repositoryParametroAlvaraNatureza;
    }

    public void setRepositoryRestricaoConsultaPrevia(RepositoryRestricaoConsultaPrevia repositoryRestricaoConsultaPrevia) {
        this.repositoryRestricaoConsultaPrevia = repositoryRestricaoConsultaPrevia;
    }

    public RepositorySituacaoMobiliarioAlvara getRepositorySituacaoMobiliarioAlvara() {
        return this.repositorySituacaoMobiliarioAlvara;
    }

    public void setRepositorySituacaoMobiliarioAlvara(RepositorySituacaoMobiliarioAlvara repositorySituacaoMobiliarioAlvara) {
        this.repositorySituacaoMobiliarioAlvara = repositorySituacaoMobiliarioAlvara;
    }

    public void setRepositoryCadastroGeral(RepositoryCadastroGeral repositoryCadastroGeral) {
        this.repositoryCadastroGeral = repositoryCadastroGeral;
    }

    public void setRepositoryPessoa(RepositoryPessoa repositoryPessoa) {
        this.repositoryPessoa = repositoryPessoa;
    }

    public void setRepositoryParametroAlvara(RepositoryParametroAlvara repositoryParametroAlvara) {
        this.repositoryParametroAlvara = repositoryParametroAlvara;
    }

    public void setRepositoryEntidadeTributacao(RepositoryEntidadeTributacao repositoryEntidadeTributacao) {
        this.repositoryEntidadeTributacao = repositoryEntidadeTributacao;
    }

    public void setRepositorySolicitacaoAlvara(RepositorySolicitacaoAlvara repositorySolicitacaoAlvara) {
        this.repositorySolicitacaoAlvara = repositorySolicitacaoAlvara;
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.getNumeroSolicitacao() == null) {
            solicitacao.setNumeroSolicitacao(this.repositorySolicitacaoAlvara.getNumeroSolicitacao(Long.valueOf(1L), solicitacao.getExercicio()));
        }
        if (solicitacao.getSolicitacaoAlvara() == null) {
            solicitacao.setSolicitacaoAlvara(this.repositorySolicitacaoAlvara.getSequence());
        }
        if (solicitacao.getRestricaoConsultaPrevia() != null && solicitacao.getRestricaoConsultaPrevia().getIdRestricao() == null) {
            solicitacao.getRestricaoConsultaPrevia().setIdRestricao(this.repositoryRestricaoConsultaPrevia.getSequence());
        }
        return this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
    }

    public EnderecoPessoaEntity salvarEnderecoPessoa(EnderecoPessoaEntity enderecoPessoa, PessoaEntity pessoa) throws UnicoClientException {
        if (enderecoPessoa.getId() == null) {
            EnderecoPessoaPK enderecoPessoaPK = new EnderecoPessoaPK();
            enderecoPessoaPK.setPessoa(pessoa);
            enderecoPessoa.setId(enderecoPessoaPK);
        }
        enderecoPessoa = this.srvEnderecoPessoa.saveAiseOrUnico(enderecoPessoa);
        return enderecoPessoa;
    }

    public ContatoPessoaEntity salvarContatoPessoa(ContatoPessoaEntity contatoPessoa) throws UnicoClientException {
        this.logger.info((Object)("Criar Contato Pessoa------" + contatoPessoa.toString()));
        return this.srvContatoPessoa.salvar(contatoPessoa);
    }

    public CadastroMobiliarioEntity salvarCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        CadastroMobiliarioEntity retorno = this.repositoryCadastroMobiliario.saveOrUpdate(cadastroMobiliario);
        this.repositoryCadastroMobiliario.flush();
        return retorno;
    }

    public void salvarCadastroGeralIsencao(CadastroMobiliarioEntity cadastroMobiliario, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ParametroAlvaraEntity paramIsencaoJuridica;
        CadastroGeralIsencaoEntity cadastroGeralIsencao = new CadastroGeralIsencaoEntity();
        IsencaoEntity isencao = null;
        if (solicitacaoAlvara.isSolicitacaoMEI()) {
            ParametroAlvaraEnum parametroEnum = solicitacaoAlvara.isSolicitacaoMEIPrestador() ? ParametroAlvaraEnum.ISENCAO_MEI_PRESTADOR : ParametroAlvaraEnum.ISENCAO_MEI;
            ParametroAlvaraEntity codIsencao = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), parametroEnum);
            isencao = this.repositoryIsencao.load(Long.valueOf(codIsencao.getValor()));
        } else if (solicitacaoAlvara.isSolicitacaoCBO()) {
            paramIsencaoJuridica = this.getParametroAlvara(ParametroAlvaraEnum.ISENCAO_CBO);
            isencao = this.repositoryIsencao.load(Long.valueOf(paramIsencaoJuridica.getValor()));
        } else {
            paramIsencaoJuridica = this.getParametroAlvara(ParametroAlvaraEnum.ISENCAO_JURIDICA_NORMAL);
            isencao = this.repositoryIsencao.load(Long.valueOf(paramIsencaoJuridica.getValor()));
        }
        if (Objects.nonNull(isencao)) {
            Long idIsencao = isencao.getId();
            if (Objects.isNull(cadastroMobiliario.getCadastroGeral().getIsencoes())) {
                cadastroMobiliario.getCadastroGeral().setInsencoes(new ArrayList());
            }
            if (!EloListUtils.safeIsEmpty((List)cadastroMobiliario.getCadastroGeral().getIsencoes()).booleanValue()) {
                List<CadastroGeralIsencaoEntity> isencoesParaRemover = cadastroMobiliario.getCadastroGeral().getIsencoes().stream().filter(i -> Objects.nonNull(i.getId()) && Objects.nonNull(i.getId().getIsencao()) && Objects.nonNull(i.getId().getIsencao().getId()) && (long)i.getId().getIsencao().getId().compareTo(0L) != idIsencao).collect(Collectors.toList());
                cadastroMobiliario.getCadastroGeral().getIsencoes().removeIf(isencoesParaRemover::contains);
                isencoesParaRemover.forEach(arg_0 -> ((RepositoryCadastroGeralIsencao)this.repositoryCadastrogeralIsencao).remove(arg_0));
                this.repositoryCadastrogeralIsencao.flush();
            }
            if (EloListUtils.safeIsEmpty((List)cadastroMobiliario.getCadastroGeral().getIsencoes()).booleanValue()) {
                CadastroGeralIsencaoPK cadastroGeralIsencaoPK = new CadastroGeralIsencaoPK();
                cadastroGeralIsencaoPK.setIsencao(isencao);
                cadastroGeralIsencaoPK.setCadastroGeral(cadastroMobiliario.getCadastroGeral());
                cadastroGeralIsencao.setId(cadastroGeralIsencaoPK);
                cadastroMobiliario.getCadastroGeral().getIsencoes().add(this.repositoryCadastrogeralIsencao.saveOrUpdate(cadastroGeralIsencao));
            }
            solicitacaoAlvara.getCadastroMobiliario().setCadastroGeral(this.repositoryCadastroGeral.saveOrUpdate(cadastroMobiliario.getCadastroGeral()));
            this.repositoryCadastroGeral.flush();
        }
    }

    public void salvarCadastroImobiliario(CadastroImobiliarioEntity cadastroImobiliario) {
        this.repositoryCadastroImobiliario.saveOrUpdate(cadastroImobiliario);
    }

    public ContratoSocialEntity salvarContratoSocial(SolicitacaoAlvaraEntity solicitacao, ContratoSocialEntity contratoSocial) {
        this.logger.info((Object)"salvarContratoSocial-------");
        ContratoSocialPK id = new ContratoSocialPK();
        id.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
        id.setSequencia(this.repositoryContratoSocial.retornarSequenciaContratoSocial(solicitacao.getCadastroMobiliario().getId().getCodigo()));
        contratoSocial.setId(id);
        contratoSocial = this.repositoryContratoSocial.saveOrUpdate(contratoSocial);
        this.repositoryContratoSocial.flush();
        solicitacao.setCadastroMobiliario(this.repositoryCadastroMobiliario.refresh(solicitacao.getCadastroMobiliario()));
        return contratoSocial;
    }

    public PessoaEntity salvarPessoa(PessoaEntity pessoa) throws UnicoClientException {
        return this.srvPessoa.salvar(pessoa);
    }

    protected void validarPessoaAPIExterna(SolicitacaoAlvaraEntity solicitacao) throws BaseException, IOException, URISyntaxException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        String linkAPIIssExterno;
        PessoaEntity pessoa = solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa();
        if (pessoa != null && EloStringUtils.isEmpty((String)pessoa.getCodigoLiberacaoSGO()) && !EloStringUtils.isEmpty((String)(linkAPIIssExterno = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidade(), ParametroAlvaraEnum.LINK_API_ISS_EXTERNO).getValor()))) {
            PessoaIssExterno pessoaIssExterno = this.consultarPessoaIssExterno(pessoa.getCnpjCpf(), linkAPIIssExterno);
            if (pessoaIssExterno == null || !EloNumberUtils.isBiggerThanZero((Number)pessoaIssExterno.getId()).booleanValue()) {
                this.inserirPessoaIssExterno(solicitacao, linkAPIIssExterno);
            }
            CodigoLiberacaoIssExterno codigoLiberacao = this.gerarCodigoLiberacaoSGO(pessoa.getCnpjCpf(), linkAPIIssExterno);
            pessoa.setCodigoLiberacaoSGO(codigoLiberacao.getCodigo());
            if ((solicitacao.isNaturezaAlteracaoSocio() || solicitacao.isNaturezaAlteracaoAtividade()) && !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                this.srvPessoa.salvar(pessoa);
            }
        }
    }

    private CodigoLiberacaoIssExterno gerarCodigoLiberacaoSGO(String cnpjCpf, String linkAPIIssExterno) throws ClientProtocolException, IOException, URISyntaxException, BaseException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        return this.srvClientIssExterno.gerarCodigoLiberacaoSGO(cnpjCpf, linkAPIIssExterno);
    }

    private void inserirPessoaIssExterno(SolicitacaoAlvaraEntity solicitacao, String linkAPIIssExterno) throws BaseException {
        this.srvClientIssExterno.incluirPessoa((Object)PessoaIssExternoEnvio.fromSolicitacao((SolicitacaoAlvaraEntity)solicitacao), linkAPIIssExterno);
    }

    private PessoaIssExterno consultarPessoaIssExterno(String cnpjCpf, String linkAPIIssExterno) throws BaseException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        return this.srvClientIssExterno.consultarPessoa(cnpjCpf, linkAPIIssExterno);
    }

    public CadastroGeralAiseEntity salvarCadastroGeral(CadastroGeralAiseEntity cadastroGeral, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        cadastroGeral.getPessoa().setInativo(SimNaoEnum.getNaoShortText());
        if (cadastroGeral.getId().getCodigo() == null) {
            cadastroGeral.getId().setCodigo(this.repositoryCadastroGeral.getSequenceMobiliario());
        }
        if (solicitacao.isSolicitacaoJuridicaNormal() && solicitacao.isNaturezaInicial()) {
            CadastroGeralIsencaoPK isencaoId = new CadastroGeralIsencaoPK();
            isencaoId.setCadastroGeral(cadastroGeral);
            Long idIsencaoPJ = Long.parseLong(this.getParametroAlvara(ParametroAlvaraEnum.ISENCAO_JURIDICA_NORMAL).getValor());
            isencaoId.setIsencao(this.repositoryIsencao.load(idIsencaoPJ));
            CadastroGeralIsencaoEntity isencao = new CadastroGeralIsencaoEntity();
            isencao.setId(isencaoId);
        }
        if (Objects.isNull(cadastroGeral.getIdUnico())) {
            cadastroGeral.setIdUnico(this.repositoryCadastroGeral.getSequenceIdUnicoCadastroGeral());
        }
        if (solicitacao.isMeiInicial()) {
            cadastroGeral.setVisivelNfse(SimNaoEnum.getSimShortText());
        }
        cadastroGeral = this.repositoryCadastroGeral.saveOrUpdate(cadastroGeral);
        this.repositoryCadastroGeral.flush();
        return this.repositoryCadastroGeral.refresh(cadastroGeral);
    }

    public Boolean verificaVencimentoLaudo(SolicitacaoAlvaraEntity solicitacao) {
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            for (LaudoAlvaraEntity laudo : solicitacao.getLaudos()) {
                if (laudo.getDataValidade() == null || laudo.getDataValidade().compareTo(new Date()) >= 0) continue;
                return false;
            }
        }
        if (solicitacao.getDataValidadeSefaz() != null && solicitacao.getDataValidadeSefaz().compareTo(new Date()) < 0) {
            return false;
        }
        return true;
    }

    public Date carregaDataValidadeAlvaraParaCadastroMobiliario(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaValidade = this.srvMontaObsAlvara.preencherVencimentoAlvara(solicitacao);
        if (!EloListUtils.safeIsEmpty((List)listaValidade).booleanValue()) {
            listaValidade = this.ordenarDataValidadeSolicitacao(listaValidade);
            return ((SolicitacaoAlvaraValidadeEntity)listaValidade.get(0)).getDataValidade();
        }
        return null;
    }

    protected List<SolicitacaoAlvaraValidadeEntity> ordenarDataValidadeSolicitacao(List<SolicitacaoAlvaraValidadeEntity> listaValidade) {
        this.ordenarDescricaoValidadeSolicitacao(listaValidade);
        Collections.sort(listaValidade, new /* Unavailable Anonymous Inner Class!! */);
        return listaValidade;
    }

    private List<SolicitacaoAlvaraValidadeEntity> ordenarDescricaoValidadeSolicitacao(List<SolicitacaoAlvaraValidadeEntity> listaValidade) {
        Collections.sort(listaValidade, new /* Unavailable Anonymous Inner Class!! */);
        return listaValidade;
    }

    public NaturezaSolicitacaoAlvaraEntity getNatureza(String codigo) {
        return this.repositoryNaturezaSolicitacaoAlvara.getNatureza(codigo);
    }

    protected MobiliarioSituacaoEntity getMobiliarioSituacaoAtual(CadastroMobiliarioEntity cadastroMobiliario) {
        return this.repositoryMobiliarioSituacao.situacaoCadastroMobiliario(cadastroMobiliario.getId().getCodigo());
    }

    protected Boolean verificarSituacaoMob(SituacaoMobiliarioEntity situacaoMobiliario, Long[] situacaoMob) {
        for (Long situacao : situacaoMob) {
            if (!situacaoMobiliario.getId().equals(situacao)) continue;
            return true;
        }
        return false;
    }

    protected Boolean verificarTipoPessoaMob(PessoaMobiliarioEntity pessoaMob, Long[] tipoPessoaMob) {
        for (Long tipoPessoa : tipoPessoaMob) {
            if (!pessoaMob.getPessoaMobiliario().equals(tipoPessoa)) continue;
            return true;
        }
        return false;
    }

    private void salvarObservacaoGeralMobiliario(CadastroGeralAiseEntity cadastroGeral, String descricao, UsuarioEntity usuario) {
        ObservacaoEntity observacao = new ObservacaoEntity();
        ObservacaoPK id = new ObservacaoPK();
        id.setCadastroGeral(cadastroGeral);
        id.setSequencia(this.repositoryObservacao.getSequencia(cadastroGeral));
        observacao.setId(id);
        observacao.setDescricao(descricao);
        observacao.setData(Calendar.getInstance().getTime());
        observacao.setUsuario(usuario != null ? usuario.getUsuario() : "");
        this.repositoryObservacao.saveOrUpdate(observacao);
    }

    public UserDetails getUsuarioLogado() {
        return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    public UsuarioEntity getUsuarioLogadoFromSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isRedeSim()) {
            return this.usuarioRedeSim();
        }
        return this.srvUsuario.getUsuarioAutenticado();
    }

    private UsuarioEntity usuarioRedeSim() {
        UsuarioEntity usuario = new UsuarioEntity();
        usuario.setUsuario(PortalUtils.getUsuarioalvaraonline());
        PessoaEntity pessoa = new PessoaEntity();
        pessoa.setCnpjCpf("REDESIM");
        usuario.setPessoa(pessoa);
        return usuario;
    }

    public Long nextSequenceSolicitacaoContratoSocial() {
        return this.repositorySolicitacaoContratoSocial.getSequence();
    }

    protected ContratoSocialEntity atualizaContratoSocialCadastroMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean solicitacaoInicial) throws UnicoClientException, BaseException {
        this.logger.info((Object)"atualizaContratoSocialCadastroMobiliario-------");
        SolicitacaoContratoSocialEntity solicitacaoContratoSocial = null;
        if (Objects.nonNull(solicitacaoAlvara.getContratoSocial())) {
            solicitacaoContratoSocial = this.repositorySolicitacaoContratoSocial.load(solicitacaoAlvara.getContratoSocial().getId());
        }
        if (Objects.isNull(solicitacaoContratoSocial) || EloListUtils.safeIsEmpty((List)solicitacaoContratoSocial.getPessoas()).booleanValue()) {
            solicitacaoAlvara = this.srvContratoSocial.preencherContratoSocialBySolicitacao(solicitacaoAlvara);
            solicitacaoContratoSocial = solicitacaoAlvara.getContratoSocial();
        }
        ContratoSocialEntity contratoSocial = null;
        if (Objects.nonNull(solicitacaoContratoSocial) && !EloListUtils.safeIsEmpty((List)solicitacaoContratoSocial.getPessoas()).booleanValue()) {
            contratoSocial = solicitacaoContratoSocial.toContratoSocial();
            contratoSocial.setPessoas(new ArrayList());
            this.excluirProprietarios(solicitacaoAlvara.getCadastroMobiliario());
            Long idSocioResponsavel = this.getSocioResponsavel(solicitacaoContratoSocial.getPessoas());
            List socios = solicitacaoContratoSocial.getPessoas().stream().filter(pessoa -> {
                BigDecimal percentual = Optional.ofNullable(pessoa.getPercentualCapital()).orElse(BigDecimal.ZERO);
                return BigDecimal.ZERO.compareTo(percentual) < 0;
            }).collect(Collectors.toList());
            for (SolicitacaoContratoSocialPessoaEntity solicitacaoContratoPessoa : socios) {
                ContratoSocialPessoaPK contratoSocialPessoaPK = new ContratoSocialPessoaPK();
                contratoSocialPessoaPK.setContratoSocial(contratoSocial);
                contratoSocialPessoaPK.setPessoa(solicitacaoContratoPessoa.getPessoa());
                ContratoSocialPessoaEntity contratoSocialPessoa = solicitacaoContratoPessoa.toContratoSocialPessoa();
                contratoSocialPessoa.setId(contratoSocialPessoaPK);
                if (solicitacaoAlvara.isMeiInicial()) {
                    contratoSocialPessoa.setResponsavel(SimNaoEnum.getSimShortText());
                }
                contratoSocial.getPessoas().add(contratoSocialPessoa);
                if (EloNumberUtils.isBiggerThanZero((Number)idSocioResponsavel).booleanValue()) {
                    if (Objects.nonNull(solicitacaoContratoPessoa.getPessoa().getId()) && idSocioResponsavel.equals(solicitacaoContratoPessoa.getPessoa().getId())) {
                        contratoSocialPessoa.setResponsavel(SimNaoEnum.SIM.getShortText());
                    } else {
                        contratoSocialPessoa.setResponsavel(SimNaoEnum.NAO.getShortText());
                    }
                }
                if (this.isAlteracaoEnderecoSocio(solicitacaoContratoPessoa)) {
                    EnderecoPessoaEntity endereco = null;
                    endereco = solicitacaoContratoPessoa.getPessoa().getEnderecoPessoaPrincipal() != null ? solicitacaoContratoPessoa.getPessoa().getEnderecoPessoaPrincipal() : (EloListUtils.safeIsEmpty((List)solicitacaoContratoPessoa.getPessoa().getEnderecos()) == false ? (EnderecoPessoaEntity)solicitacaoContratoPessoa.getPessoa().getEnderecos().get(0) : new EnderecoPessoaEntity());
                    endereco.setBairro(solicitacaoContratoPessoa.getBairro());
                    endereco.setCep(solicitacaoContratoPessoa.getCep());
                    endereco.setLogradouro(solicitacaoContratoPessoa.getLogradouro());
                    endereco.setLogradouroEndereco(solicitacaoContratoPessoa.getLogradouroEndereco());
                    endereco.setNumero(solicitacaoContratoPessoa.getNumero());
                    endereco.setTipoEndereco(solicitacaoContratoPessoa.getTipoEndereco());
                    if (!Strings.isEmpty((CharSequence)solicitacaoContratoPessoa.getComplemento())) {
                        endereco.setComplemento(solicitacaoContratoPessoa.getComplemento());
                    }
                    if (Objects.isNull(endereco.getId())) {
                        EnderecoPessoaPK enderecoPessoaPK = new EnderecoPessoaPK();
                        enderecoPessoaPK.setPessoa(solicitacaoContratoPessoa.getPessoa());
                        endereco.setId(enderecoPessoaPK);
                        solicitacaoContratoPessoa.getPessoa().getEnderecos().add(endereco);
                    }
                    solicitacaoContratoPessoa.getPessoa().setEnderecoPessoaPrincipal(endereco);
                }
                if (EloListUtils.safeIsEmpty((List)solicitacaoContratoPessoa.getPessoa().getContatos()).booleanValue()) {
                    this.logger.info((Object)("Criando Contato Pessoa do S\u00f3cio.." + solicitacaoContratoPessoa.getPessoa().toString()));
                    ContatoPessoaEntity contatoPessoa = new ContatoPessoaEntity();
                    ContatoPessoaPK id = new ContatoPessoaPK();
                    id.setPessoa(solicitacaoContratoPessoa.getPessoa());
                    contatoPessoa.setId(id);
                    contatoPessoa.setNome(solicitacaoContratoPessoa.getPessoa().getNome());
                    contatoPessoa.setEmail(solicitacaoAlvara.getEmail());
                    contatoPessoa.setTelefoneComercial(solicitacaoAlvara.getTelefone());
                    contatoPessoa.setTelefoneCelular(solicitacaoAlvara.getTelefoneCelular());
                    solicitacaoContratoPessoa.getPessoa().getContatos().add(contatoPessoa);
                    solicitacaoContratoPessoa.getPessoa().setContatoPessoaPrincipal(contatoPessoa);
                }
                solicitacaoContratoPessoa.setPessoa(this.salvarPessoa(solicitacaoContratoPessoa.getPessoa()));
                this.atualizarProprietario(solicitacaoAlvara, solicitacaoContratoPessoa);
            }
            contratoSocial = this.salvarContratoSocial(solicitacaoAlvara, contratoSocial);
        }
        return contratoSocial;
    }

    private Long getSocioResponsavel(List<SolicitacaoContratoSocialPessoaEntity> pessoas) {
        return pessoas.stream().filter(pessoa -> SimNaoEnum.equalSim((String)pessoa.getResponsavel())).map(pessoa -> pessoa.getPessoa().getId()).findFirst().orElseGet(() -> 0L);
    }

    private void excluirProprietarios(CadastroMobiliarioEntity cadastroMobiliario) {
        this.repositoryProprietario.deleteAll(cadastroMobiliario);
    }

    private void atualizarProprietario(SolicitacaoAlvaraEntity solicitacaoAlvara, SolicitacaoContratoSocialPessoaEntity solicitacaoContratoPessoa) {
        ProprietarioPK id = new ProprietarioPK();
        id.setCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
        id.setPessoa(solicitacaoContratoPessoa.getPessoa());
        ProprietarioEntity proprietario = new ProprietarioEntity();
        proprietario.setId(id);
        proprietario.setPrincipal(solicitacaoContratoPessoa.getResponsavel());
        this.salvarProprietario(proprietario);
    }

    private boolean isAlteracaoEnderecoSocio(SolicitacaoContratoSocialPessoaEntity solicitacaoContratoPessoa) {
        return solicitacaoContratoPessoa.getBairro() != null || solicitacaoContratoPessoa.getCep() != null || solicitacaoContratoPessoa.getLogradouro() != null || solicitacaoContratoPessoa.getNumero() != null || solicitacaoContratoPessoa.getLogradouroEndereco() != null || solicitacaoContratoPessoa.getTipoEndereco() != null;
    }

    protected void salvarProprietario(ProprietarioEntity proprietario) {
        this.repositoryProprietario.saveOrUpdate(proprietario);
    }

    protected void salvarMobiliarioSituacao(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean naturezaInicial) throws BaseException {
        this.saveMobiliarioSituacao(solicitacaoAlvara, naturezaInicial, false);
    }

    protected void saveMobiliarioSituacaoWithEnvioInscricaoMunicipal(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean naturezaInicial) throws BaseException {
        this.saveMobiliarioSituacao(solicitacaoAlvara, naturezaInicial, true);
    }

    private void saveMobiliarioSituacao(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean naturezaInicial, boolean isEnvioInscricaoMunicipal) throws BaseException {
        CadastroMobiliarioEntity cadastroMobiliario = solicitacaoAlvara.getCadastroMobiliario();
        MobiliarioSituacaoEntity mobSituacao = new MobiliarioSituacaoEntity();
        mobSituacao.setCadastroMobiliario(cadastroMobiliario);
        if (naturezaInicial) {
            SituacaoMobiliarioEntity situacaoMobAnalise = null;
            if (isEnvioInscricaoMunicipal) {
                situacaoMobAnalise = this.repositorySituacaoMobiliario.getSituacaoMobiliarioBySituacaoMobiliarioAlvara(SituacaoMobiliarioAlvaraEnum.SITUACAO_CADASTRO_ATUALIZADO_PELA_JUNTA.getCodigo());
                mobSituacao.setSituacaoMobiliario(situacaoMobAnalise);
            } else {
                if (this.usaSituacaoMobAnalise()) {
                    situacaoMobAnalise = this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_INICIAL_MOBILIARIO);
                    mobSituacao.setSituacaoMobiliario(situacaoMobAnalise);
                } else if (!this.usaSituacaoMobAnalise() && solicitacaoAlvara.isSolicitacaoJuridicaNormal() || solicitacaoAlvara.isSolicitacaoPrestadorServico()) {
                    mobSituacao.setSituacaoMobiliario(this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL));
                }
                if (solicitacaoAlvara.isSolicitacaoMEI()) {
                    mobSituacao.setSituacaoMobiliario(this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_EMITEISSNAOEMITETAXAS));
                }
            }
        } else {
            mobSituacao.setSituacaoMobiliario(this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_BAIXADO));
        }
        if (EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioSituacao()).booleanValue() || !cadastroMobiliario.getMobiliarioSituacaoAtual().getId().equals(mobSituacao.getSituacaoMobiliario().getId())) {
            List listaMobiliarioSituacao = this.repositoryMobiliarioSituacao.buscaMobiliarioSituacaoPorCodMobiliario(cadastroMobiliario.getId().getCodigo());
            if (listaMobiliarioSituacao != null) {
                listaMobiliarioSituacao.stream().forEach(mobiliarioSituacao -> {
                    mobiliarioSituacao.setAtual(SimNaoEnum.getNaoShortText());
                    this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacao);
                    this.repositoryMobiliarioSituacao.flush();
                });
            }
            mobSituacao.setDataInclusao(new Date());
            mobSituacao.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            MobiliarioSituacaoPK id = new MobiliarioSituacaoPK();
            id.setCadastroGeralPK(cadastroMobiliario.getId());
            id.setSequencia(this.repositoryMobiliarioSituacao.getSequencia(cadastroMobiliario.getId()));
            mobSituacao.setId(id);
            mobSituacao.setAtual("S");
            cadastroMobiliario.addMobiliarioSituacao(this.repositoryMobiliarioSituacao.saveOrUpdate(mobSituacao));
        }
    }

    public void atualizarSituacaoMobiliarioMEI(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CadastroMobiliarioEntity cadastroMobiliario = solicitacaoAlvara.getCadastroMobiliario();
        MobiliarioSituacaoEntity novaMobSituacao = new MobiliarioSituacaoEntity();
        novaMobSituacao.setCadastroMobiliario(cadastroMobiliario);
        MobiliarioSituacaoPK id = new MobiliarioSituacaoPK();
        id.setCadastroGeralPK(cadastroMobiliario.getId());
        id.setSequencia(this.repositoryMobiliarioSituacao.getSequencia(cadastroMobiliario.getId()));
        novaMobSituacao.setId(id);
        novaMobSituacao.setAtual("S");
        Long situacaoMobiliario = SituacaoMobiliarioAlvaraEnum.SITUACAO_EMITEISSNAOEMITETAXAS.getCodigo();
        if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor()).booleanValue()) {
            situacaoMobiliario = SituacaoMobiliarioAlvaraEnum.SITUACAO_CADASTRO_ATUALIZADO_PELA_JUNTA.getCodigo();
        }
        novaMobSituacao.setSituacaoMobiliario(this.repositorySituacaoMobiliario.getSituacaoMobiliarioBySituacaoMobiliarioAlvara(situacaoMobiliario));
        novaMobSituacao.setDataInclusao(new Date());
        novaMobSituacao.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
        List listaMobiliarioSituacao = this.repositoryMobiliarioSituacao.buscaMobiliarioSituacaoPorCodMobiliario(cadastroMobiliario.getId().getCodigo());
        if (!EloListUtils.safeIsEmpty((List)listaMobiliarioSituacao).booleanValue()) {
            listaMobiliarioSituacao.forEach(mobiliarioSituacao -> {
                if (mobiliarioSituacao.getAtual().equals(SimNaoEnum.getSimShortText())) {
                    mobiliarioSituacao.setAtual(SimNaoEnum.getNaoShortText());
                    this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacao);
                    this.repositoryMobiliarioSituacao.flush();
                }
            });
        }
        cadastroMobiliario.addMobiliarioSituacao(this.repositoryMobiliarioSituacao.saveOrUpdate(novaMobSituacao));
    }

    private boolean usaSituacaoMobAnalise() throws BaseException {
        if (this.getParametroAlvara(ParametroAlvaraEnum.USA_SITUACAO_MOB_ANALISE).getValor() != null && this.getParametroAlvara(ParametroAlvaraEnum.USA_SITUACAO_MOB_ANALISE).getValor().equals(SimNaoEnum.SIM.getShortText())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected BigDecimal getAreaTotal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        BigDecimal areaTotal = BigDecimal.ZERO;
        ParametroAlvaraEntity somaAreaPatioAreaConstruida = this.getParametroAlvara(ParametroAlvaraEnum.SOMA_AREAPATIO_AREACONSTRUIDA);
        if (solicitacao.getAreaConstruida() != null && solicitacao.getAreaPatio() != null && "S".equals(somaAreaPatioAreaConstruida.getValor())) {
            areaTotal = solicitacao.getAreaConstruida().add(solicitacao.getAreaPatio());
        } else if (solicitacao.getAreaConstruida() != null) {
            areaTotal = solicitacao.getAreaConstruida();
        }
        return areaTotal;
    }

    protected Long getExercicio() {
        return this.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio();
    }

    public EntidadeTributacaoEntity getEntidadeTributacao() {
        return this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
    }

    protected List<DebitoEntity> carregarDebitosSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        return this.repositoryDebito.carregarDebitosAlvara(solicitacao.getSolicitacaoAlvara());
    }

    protected DebitoEntity carregaDebitosSolicitacao(SolicitacaoAlvaraEntity solicitacao, Long exercicio) {
        DebitoEntity debito = this.repositoryDebito.possuiDebitoNaSolicitacaoByExercicio(solicitacao.getSolicitacaoAlvara(), exercicio);
        if (debito != null && debito.getParcelas().size() <= 0) {
            debito.getParcelas();
        }
        return debito;
    }

    protected DebitoEntity geraDebitoLaudo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            Integer idDebitoLaudo = this.internalGeraDebitoLaudos(this.getExercicio(), solicitacao, Integer.valueOf(Integer.parseInt(this.getValorParametro("GUIARECOLHIMENTOLAUDO"))), this.getValorParametro("RECEITALAUDO"), Double.valueOf(Double.parseDouble(this.getValorParametro("VALORLAUDO"))));
            DebitoEntity debitoLaudo = this.repositoryDebito.carregaDebito(Long.valueOf(idDebitoLaudo.intValue()));
            return debitoLaudo;
        }
        catch (IOException | NumberFormatException | XmlMappingException e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    protected String getValorParametro(String param) throws BaseException {
        List listaParametros = this.repositoryParametroEntidadeExercicio.getParametrosDebitoLaudoAlvara(this.getEntidadeTributacao().getId().getEntidade().getId(), this.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio());
        for (ParametroEntidadeExercicioEntity parametro : listaParametros) {
            if (!param.equals(parametro.getId().getParametro())) continue;
            return parametro.getValor();
        }
        return null;
    }

    protected Integer internalGeraDebitoLaudos(Long exercicio, SolicitacaoAlvaraEntity solicitacaoAlvara, Integer guiaRecolhimento, String receita, Double valorPrincipal) throws XmlMappingException, BaseException, IOException {
        Integer idDebito = 0;
        idDebito = this.srvDebitosPortal.gerarDebitoLaudos(this.getUsuarioIntegraSGO().getUsuario(), this.getUsuarioIntegraSGO().getSenha(), exercicio, solicitacaoAlvara.getCadastroMobiliario().getId().getTipo(), solicitacaoAlvara.getCadastroMobiliario().getId().getCodigo(), solicitacaoAlvara.getSolicitacaoAlvara(), guiaRecolhimento, receita, valorPrincipal);
        return idDebito;
    }

    protected List<SolicitacaoAlvaraValidadeEntity> retornaValidadeAlvaraAtualPorSolitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        List listaValidadeAlvaraAtual = this.repositorySolicitacaoAlvaraValidade.retornaValidadeBySolicitacao(solicitacaoAlvara);
        return listaValidadeAlvaraAtual;
    }

    protected List<SolicitacaoAlvaraValidadeEntity> carregaListaVencimentoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        List listaValidade = this.srvMontaObsAlvara.preencherVencimentoAlvara(solicitacao);
        return listaValidade;
    }

    protected String montaObservacoesAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        return this.srvMontaObsAlvara.montaObsAlvara(solicitacaoAlvara);
    }

    protected SolicitacaoAlvaraEntity atualizarSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        SolicitacaoAlvaraEntity solicitacao = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        this.repositorySolicitacaoAlvara.flush();
        return solicitacao;
    }

    protected void gerarEImprimirDocumento(List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraAtual, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraNova, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        DocumentoAiseDTO documentoAise = this.gerarDocumentoGenerico(solicitacao, listaValidadeAlvaraAtual, listaValidadeAlvaraNova);
        this.imprimirDocumentoAlvara(documentoAise.getDocumento().toString(), documentoAise.getExercicio(), solicitacao);
    }

    private DocumentoAiseDTO gerarDocumentoGenerico(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraAtual, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraNova) throws BaseException {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        DocumentoAiseDTO documentoAise = new DocumentoAiseDTO();
        try {
            boolean gerarNovoDocumento;
            listaValidadeAlvaraAtual = this.ordenarDataValidadeSolicitacao(listaValidadeAlvaraAtual);
            listaValidadeAlvaraNova = this.ordenarDataValidadeSolicitacao(listaValidadeAlvaraNova);
            boolean renovacao = this.isRenovacao(solicitacao, listaValidadeAlvaraAtual, listaValidadeAlvaraNova);
            if (renovacao) {
                this.atualizarInformacoesRenovacao(solicitacao, listaValidadeAlvaraAtual, listaValidadeAlvaraNova);
            }
            if (!(gerarNovoDocumento = this.verificarSeGeraNovoDocumento(solicitacao, renovacao))) {
                DocumentoAiseEntity ultimoDocumentoEmitido = this.getUltimoDocumentoEmitido(solicitacao.getCadastroMobiliario().getId(), DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
                DocumentoAiseEntity documento = Optional.ofNullable(ultimoDocumentoEmitido).orElse(this.getDocumentoAlvaraLocalizacaoBySolicitacaoAlvara(solicitacao));
                if (Objects.nonNull(documento)) {
                    documentoAise.setExercicio(documento.getId().getExercicio());
                    documentoAise.setDocumento(documento.getId().getDocumento());
                    if (solicitacao.naoPossuiNumeroAlvara()) {
                        solicitacao.setNumeroAlvara(documento.getId().getDocumento());
                        this.atualizarSolicitacaoAlvara(solicitacao);
                    }
                }
                DocumentoAiseDTO documentoAiseDTO = documentoAise;
                return documentoAiseDTO;
            }
            String userKey = this.srvDebitosPortal.loginWeb();
            ParametroAlvaraEntity paramNumeroAlvara = this.getParametroAlvara(ParametroAlvaraEnum.GERAR_NUMERO_ALVARA);
            Long numeroAlvara = this.gerarNumeroAlvara(solicitacao, paramNumeroAlvara, userKey);
            solicitacao.setNumeroAlvara(numeroAlvara);
            EnvioGeraDocumento documentoAlvara = this.preencherInformacoesEnvioGeraDocumentoAlvaraLocalizacao(solicitacao);
            CommonGeraDocumento documentoGerado = (CommonGeraDocumento)new GeraDocumentoClientAlvara().doPost(CommonGeraDocumento.class, (Object)documentoAlvara, userKey);
            if (Objects.isNull(documentoGerado)) {
                solicitacao.setNumeroAlvara(null);
                this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
                throw new DocumentoNaoEncontradoException("Falha no servi\u00e7o de gera\u00e7\u00e3o de documentos.");
            }
            this.preencherUsuarioImpressao(solicitacao);
            this.atualizarSolicitacaoComDocumentoGerado(solicitacao, documentoGerado, paramNumeroAlvara);
            solicitacao.setGerarAlvara(SimNaoEnum.getNaoShortText());
            this.atualizarSolicitacaoAlvara(solicitacao);
            documentoAise.setExercicio(Long.valueOf(documentoGerado.getExercicio().intValue()));
            documentoAise.setDocumento(Long.valueOf(documentoGerado.getDocumento().intValue()));
            DocumentoAiseDTO documentoAiseDTO = documentoAise;
            return documentoAiseDTO;
        }
        catch (DocumentoNaoEncontradoException dnee) {
            throw new DocumentoNaoEncontradoException(dnee.getMessage());
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException("Ocorreu um erro ao gerar o Documento. " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    protected void atualizarSolicitacaoComDocumentoGerado(SolicitacaoAlvaraEntity solicitacao, CommonGeraDocumento documentoGerado, ParametroAlvaraEntity paramNumeroAlvara) throws BaseException {
        Long exercicioAlvara = (long)documentoGerado.getExercicio();
        if (Objects.nonNull(paramNumeroAlvara) && GeraNumeroAlvaraEnum.SEQUENCE.name().equals(paramNumeroAlvara.getValor()) && Objects.nonNull(solicitacao.getCadastroMobiliario().getNumeroAlvara())) {
            exercicioAlvara = solicitacao.getCadastroMobiliario().getExercicioAlvara();
        }
        solicitacao.setCodAutenticidade(documentoGerado.getCodigoValidacao());
        this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        solicitacao.getCadastroMobiliario().setDataAlvara(DateUtils.truncate((Date)documentoGerado.getDataEmissao(), (int)5));
        solicitacao.getCadastroMobiliario().setExercicioAlvara(exercicioAlvara);
        solicitacao.getCadastroMobiliario().setNumeroAlvara(solicitacao.getNumeroAlvara());
        solicitacao.getCadastroMobiliario().getCadastroGeral().setDataAlteracao(Calendar.getInstance().getTime());
        solicitacao.getCadastroMobiliario().getCadastroGeral().setExclusaoLogica(SimNaoEnum.NAO.getShortText());
        this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario());
        this.salvarCadastroGeral(solicitacao.getCadastroMobiliario().getCadastroGeral(), solicitacao);
    }

    private DocumentoAiseEntity getUltimoDocumentoEmitido(CadastroGeralAisePK id, Long codigo) {
        return this.repositoryDocumentoAise.getUltimoDocumentoEmitido(id, codigo);
    }

    private DocumentoAiseEntity getDocumentoAlvaraLocalizacaoBySolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        DocumentoPK id = new DocumentoPK();
        id.setEntidade(this.getEntidadeTributacao().getId().getEntidade().getId());
        id.setTipoDocumento(this.repositoryDocumentoTipo.getDocumentoTipoAlvaraLocalizacao());
        id.setExercicio(solicitacao.getExercicio());
        id.setDocumento(solicitacao.getNumeroAlvara());
        return this.repositoryDocumentoAise.load(id);
    }

    private void preencherUsuarioImpressao(SolicitacaoAlvaraEntity solicitacao) {
        if (Objects.isNull(SecurityContextHolder.getContext()) || Objects.isNull(SecurityContextHolder.getContext().getAuthentication())) {
            return;
        }
        if (Objects.nonNull(this.authenticationProvider.getUsuarioLogado())) {
            solicitacao.setUsuarioImpressao(this.authenticationProvider.getUsuarioLogado().getUsername());
        }
    }

    private boolean verificarSeGeraNovoDocumento(SolicitacaoAlvaraEntity solicitacao, boolean renovacao) throws BaseException {
        if (this.isSolicitacaoInicialSemNumero(solicitacao)) {
            return true;
        }
        boolean parametroGerarDocumentoNasAlteracoesAtivo = this.parametroGerarDocumentoNasAlteracoesAtivo();
        if (this.isSolicitacaoInicialComNumeroDeAlvara(solicitacao) && renovacao && parametroGerarDocumentoNasAlteracoesAtivo) {
            return true;
        }
        if (solicitacao.isAlteracao() && solicitacao.naoPossuiNumeroAlvara()) {
            if (!parametroGerarDocumentoNasAlteracoesAtivo) {
                return this.naoPossuiDocumentoDeAlvaraGeradoParaMobiliario(solicitacao);
            }
            return true;
        }
        if (solicitacao.isAlteracao() && solicitacao.naoPossuiNumeroAlvara() && parametroGerarDocumentoNasAlteracoesAtivo || solicitacao.isAlteracao() && solicitacao.possuiNumeroAlvara() && renovacao && parametroGerarDocumentoNasAlteracoesAtivo) {
            return true;
        }
        return solicitacao.isAlteracao() && this.naoPossuiDocumentoDeAlvaraGeradoParaMobiliario(solicitacao);
    }

    private boolean naoPossuiDocumentoDeAlvaraGeradoParaMobiliario(SolicitacaoAlvaraEntity solicitacao) {
        DocumentoAiseEntity documento = this.getUltimoDocumentoEmitido(solicitacao.getCadastroMobiliario().getId(), DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
        return documento == null;
    }

    private boolean isSolicitacaoInicialSemNumero(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.isNaturezaInicial() && solicitacao.naoPossuiNumeroAlvara();
    }

    private boolean isSolicitacaoInicialComNumeroDeAlvara(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.isNaturezaInicial() && solicitacao.possuiNumeroAlvara();
    }

    private boolean isRenovacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraAtual, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraNova) {
        return solicitacao.isRenovacaoDeSolicitacao() && !listaValidadeAlvaraAtual.equals(listaValidadeAlvaraNova) || solicitacao.isRenovacaoDeSolicitacao() && solicitacao.isRedeSim();
    }

    private boolean parametroGerarDocumentoNasAlteracoesAtivo() throws BaseException {
        ParametroAlvaraEntity valorParametroGeraNovoDocumentoNasAlteracoes = this.getParametroAlvara(ParametroAlvaraEnum.GERA_NOVO_DOCUMENTO_NAS_ALTERACOES);
        return SimNaoEnum.equalSim((String)valorParametroGeraNovoDocumentoNasAlteracoes.getValor());
    }

    private void atualizarInformacoesRenovacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraAtual, List<SolicitacaoAlvaraValidadeEntity> listaValidadeAlvaraNova) throws BaseException {
        String descricaoObs = String.format("%s%s", "Renova\u00e7\u00e3o realizada na data de ", EloDateUtils.toAnsiDateString((Date)Calendar.getInstance().getTime(), (String)"dd/MM/yyyy"));
        solicitacao.getCadastroMobiliario().getCadastroGeral().setDataAlteracao(Calendar.getInstance().getTime());
        this.salvarObservacaoGeralMobiliario(solicitacao.getCadastroMobiliario().getCadastroGeral(), descricaoObs, this.getUsuarioLogadoFromSolicitacao(solicitacao));
        this.salvarCadastroGeral(solicitacao.getCadastroMobiliario().getCadastroGeral(), solicitacao);
    }

    private void imprimirDocumentoAlvara(String numeroDoc, Long exercicioDoc, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.imprimeDocumentoAlvara.imprimirDocumentoAlvara(numeroDoc, exercicioDoc, DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo(), solicitacao);
    }

    private EnvioGeraDocumento preencherInformacoesEnvioGeraDocumentoAlvaraLocalizacao(SolicitacaoAlvaraEntity solicitacao) {
        EnvioGeraDocumento envioDocumento = new EnvioGeraDocumento();
        envioDocumento.setClassName("TDocumentoVO");
        envioDocumento.setExercicio(Integer.valueOf(this.getExercicio().intValue()));
        envioDocumento.setEntidade(Integer.valueOf(this.getEntidadeTributacao().getId().getEntidade().getId().intValue()));
        envioDocumento.setTipoDocumento(EnvioGeraDocumento.TIPO_DOCUMENTO_ALVARA_LOCALIZACAO);
        envioDocumento.setDocumento(Integer.valueOf(solicitacao.getNumeroAlvara().intValue()));
        GeraDocumentoAlvaraLocalizacao geraDocumento = new GeraDocumentoAlvaraLocalizacao(solicitacao, this.getEntidadeTributacao());
        envioDocumento.setDocumentoJson(geraDocumento.formatJson());
        return envioDocumento;
    }

    protected Long gerarNumeroAlvara(SolicitacaoAlvaraEntity solicitacao, ParametroAlvaraEntity paramNumeroAlvara, String userKey) throws BaseException {
        if (Objects.nonNull(paramNumeroAlvara)) {
            if (GeraNumeroAlvaraEnum.SEQUENCE.name().equals(paramNumeroAlvara.getValor())) {
                if (Objects.isNull(solicitacao.getCadastroMobiliario().getNumeroAlvara())) {
                    return this.repositorySolicitacaoAlvara.getSequenceNumeroAlvara();
                }
                return solicitacao.getCadastroMobiliario().getNumeroAlvara();
            }
            if (GeraNumeroAlvaraEnum.CADASTROGERAL.name().equals(paramNumeroAlvara.getValor())) {
                return solicitacao.getCadastroMobiliario().getId().getCodigo();
            }
        }
        CommonGeraNumeroDocumento numeroDocumentoGerado = (CommonGeraNumeroDocumento)new GeraDocumentoClientAlvara().doGet(CommonGeraNumeroDocumento.class, userKey, this.getEntidadeTributacao().getId().getEntidade().getId(), this.getEntidadeTributacao().getExercicio());
        return numeroDocumentoGerado.getDocumento();
    }

    public boolean validaAlteracaoGeraLaudo(SolicitacaoAlvaraEntity solicitacao, NaturezaSolicitacaoAlvaraEnum naturezaEnum) throws BaseException {
        if (solicitacao.isSolicitacaoMEIPrestador()) {
            return solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido();
        }
        ParametroAlvaraNaturezaEntity paramTipoPessoa = this.getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum.VERIFICATIPOPESSOAGERALAUDO, this.getNatureza(naturezaEnum.getValue()), solicitacao.getTipoDeInscricao());
        if (solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
            return this.verificarTipoPessoaMob(solicitacao.getCadastroMobiliario().getPessoaMobiliario(), EloStringUtils.strToLong((String[])paramTipoPessoa.getValor().split(",")));
        }
        return false;
    }

    public String getEmailSetorCadastroAlvara() throws BaseException {
        ParametroAlvaraEntity param = this.getParametroAlvara(ParametroAlvaraEnum.EMAILSETORCADASTROALVARA);
        return param.getValor();
    }

    private EntidadeAiseEntity getEntidade() {
        EntidadeAiseEntity entidade = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date()))).getId().getEntidade();
        return entidade;
    }

    public void carregarEsalvarAtividadesNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        if (EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            solicitacao = this.carregarAtividadesMobNaSolicitacao(solicitacao);
        }
        this.atribuirIdAtividadesSolicitacao(solicitacao);
    }

    public SolicitacaoAlvaraEntity carregarAtividadesMobNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        block7: {
            block8: {
                if (solicitacao.isNaturezaAlteracaoAtividade() && !EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
                    this.removerAtividadesDoCadastroMobiliario(solicitacao);
                }
                if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue() || !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL})) break block7;
                solicitacao.setSolicitacaoAlvaraAtividades(new ArrayList());
                if (!solicitacao.isSolicitacaoJuridicaNormal() && !solicitacao.isSolicitacaoPrestadorServico()) break block8;
                if (EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) break block7;
                for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
                    SolicitacaoAlvaraAtividadeEntity atividade = new SolicitacaoAlvaraAtividadeEntity();
                    atividade.setCnae(mobCnae.getId().getCnae());
                    atividade.setSolicitacaoAlvara(solicitacao);
                    solicitacao.getSolicitacaoAlvaraAtividades().add(atividade);
                }
                break block7;
            }
            if (solicitacao.isSolicitacaoMEI() && !EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()).booleanValue()) {
                for (CadastroMobiliarioAtividadeMeiEntity mobMei : solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
                    SolicitacaoAlvaraAtividadeEntity atividade = new SolicitacaoAlvaraAtividadeEntity();
                    atividade.setAtividadeMei(mobMei.getAtividadeMei());
                    atividade.setSolicitacaoAlvara(solicitacao);
                    solicitacao.getSolicitacaoAlvaraAtividades().add(atividade);
                }
            } else if (solicitacao.isSolicitacaoCBO() && !EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCbos()).booleanValue()) {
                for (CadastroMobiliarioCboEntity mobCbo : solicitacao.getCadastroMobiliario().getMobiliarioCbos()) {
                    SolicitacaoAlvaraAtividadeEntity atividade = new SolicitacaoAlvaraAtividadeEntity();
                    atividade.setSequenciaCbo(mobCbo.getRhCbo());
                    atividade.setSolicitacaoAlvara(solicitacao);
                    solicitacao.getSolicitacaoAlvaraAtividades().add(atividade);
                }
            }
        }
        return solicitacao;
    }

    protected List<String> loadCnaesBySolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        ArrayList<String> cnaes = new ArrayList<String>();
        if (solicitacao.isSolicitacaoPJ()) {
            cnaes.addAll(Optional.ofNullable(solicitacao.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getMobiliarioCnaes).orElse(Collections.emptyList()).stream().map(MobiliarioCnaeEntity::getId).map(MobiliarioCnaePK::getCnae).map(CnaeEntity::getCodigo).collect(Collectors.toList()));
        }
        if (solicitacao.isSolicitacaoMEI()) {
            cnaes.addAll(Optional.ofNullable(solicitacao.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getMobiliarioAtividadeMeis).orElse(Collections.emptyList()).stream().map(CadastroMobiliarioAtividadeMeiEntity::getAtividadeMei).map(AtividadeMeiEntity::getCnae).map(CnaeEntity::getCodigo).collect(Collectors.toList()));
        }
        return cnaes;
    }

    public void salvarObservacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.saveObservacoesAlteracao(solicitacao, null, Collections.emptyList());
    }

    public void salvarObservacao(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior, List<String> cnaes) throws BaseException {
        this.saveObservacoesAlteracao(solicitacao, solicitacaoAlvaraObservacaoAnterior, cnaes);
    }

    private void saveObservacoesAlteracao(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior, List<String> cnaes) throws BaseException {
        String descricaoObservacao = "";
        descricaoObservacao = solicitacao.isNaturezaInicial() ? this.montarObservacaoInclusaoCadastroMobiliario(solicitacao) : this.montarObservacaoAlteracaoCadastroMobiliario(solicitacao, solicitacaoAlvaraObservacaoAnterior, cnaes);
        this.salvarObservacaoGeralMobiliario(solicitacao.getCadastroMobiliario().getCadastroGeral(), descricaoObservacao, this.getUsuarioLogadoFromSolicitacao(solicitacao));
    }

    public String montarObservacaoAlvaraGerado(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        String template = " gerado pelo Alvar\u00e1 Online no dia " + format.format(new Date()) + " atrav\u00e9s da solicita\u00e7\u00e3o de n\u00famero " + solicitacaoAlvara.getNumeroSolicitacaoExercicio() + ".";
        return "Alvar\u00e1 inicial" + template;
    }

    public void salvarObservacaoAlvaraGerado(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isNaturezaInicial()) {
            String observacao = this.montarObservacaoAlvaraGerado(solicitacaoAlvara);
            this.salvarObservacaoGeralMobiliario(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), observacao, this.getUsuarioLogadoFromSolicitacao(solicitacaoAlvara));
        }
    }

    public String montarObservacaoInclusaoCadastroMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return "Cadastro Mobili\u00e1rio gerado pelo Alvar\u00e1 Online atrav\u00e9s da solicita\u00e7\u00e3o de n\u00famero " + solicitacaoAlvara.getNumeroSolicitacaoExercicio() + ".";
    }

    public String montarObservacaoAlteracaoCadastroMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara, SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior, List<String> cnaes) throws BaseException {
        List alteracoes = solicitacaoAlvara.getAlteracoes();
        if (EloListUtils.safeIsEmpty((List)alteracoes).booleanValue()) {
            return "";
        }
        SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacao = SolicitacaoAlvaraObservacaoDTO.of((SolicitacaoAlvaraEntity)solicitacaoAlvara);
        StringBuilder observacao = new StringBuilder();
        alteracoes.sort(String::compareTo);
        observacao.append(alteracoes.size() == 1 ? "Altera\u00e7\u00e3o" : "Altera\u00e7\u00f5es").append(" de ").append(StringUtils.join((Iterable)alteracoes, (String)", ")).append(".");
        observacao.append(this.buildObservacaoAtividades(solicitacaoAlvara, cnaes));
        if (solicitacaoAlvara.isNaturezaMudancaEndereco()) {
            observacao.append(this.buildObservacaoMudancaEndereco(solicitacaoAlvaraObservacao, solicitacaoAlvaraObservacaoAnterior));
        }
        if (solicitacaoAlvara.isAlteracaoRazao()) {
            observacao.append(this.buildObservacaoMudancaRazaoSocial(solicitacaoAlvaraObservacao, solicitacaoAlvaraObservacaoAnterior));
        }
        observacao.append(this.buildObservacaoAlteracaoSocio(solicitacaoAlvara));
        if (solicitacaoAlvara.isAlteracaoNaturezaJuridica()) {
            observacao.append(this.buildObservacaoAlteracaoNaturezaJuridica(solicitacaoAlvara, solicitacaoAlvaraObservacaoAnterior));
        }
        observacao.append(String.format("%nRealizada pelo Alvar\u00e1 Online atrav\u00e9s da solicita\u00e7\u00e3o de n\u00famero %s.", solicitacaoAlvara.getNumeroSolicitacaoExercicio()));
        return observacao.toString();
    }

    private String buildObservacaoAlteracaoSocio(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (!solicitacaoAlvara.isNaturezaAlteracaoSocio()) {
            return "";
        }
        return String.format("%n\tAdicionado um novo contrato social: %s", Optional.ofNullable(solicitacaoAlvara.getContratoSocial()).map(SolicitacaoContratoSocialEntity::getNumeroAlteracao).map(Object::toString).orElse(""));
    }

    private String buildObservacaoAlteracaoNaturezaJuridica(SolicitacaoAlvaraEntity solicitacaoAlvara, SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior) {
        StringBuilder observacaoNaturezaJuridica = new StringBuilder();
        if (Objects.nonNull(solicitacaoAlvaraObservacaoAnterior)) {
            observacaoNaturezaJuridica.append(String.format("Natureza jur\u00eddica anterior: %s ", solicitacaoAlvaraObservacaoAnterior.getNaturezaJuridica()));
        }
        String novaNaturezaJuridica = Optional.ofNullable(solicitacaoAlvara.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getNaturezaJuridica).map(NaturezaJuridicaEntity::getIdNaturezaJuridica).map(Object::toString).orElse("");
        observacaoNaturezaJuridica.append(String.format("Nova natureza jur\u00eddica: %s ", novaNaturezaJuridica));
        return observacaoNaturezaJuridica.toString();
    }

    private String buildObservacaoMudancaRazaoSocial(SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacao, SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior) {
        StringBuilder observacaoRazaoSocial = new StringBuilder();
        if (Objects.nonNull(solicitacaoAlvaraObservacaoAnterior)) {
            observacaoRazaoSocial.append(this.getObservacaoRazaoSocialAlvara(solicitacaoAlvaraObservacaoAnterior, SUFIXO_OBSERVACAO_ALTERACAO_ANTERIOR));
        }
        observacaoRazaoSocial.append(this.getObservacaoRazaoSocialAlvara(solicitacaoAlvaraObservacao, ""));
        return observacaoRazaoSocial.toString();
    }

    private String buildObservacaoMudancaEndereco(SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacao, SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacaoAnterior) {
        StringBuilder observacaoMudancaEndereco = new StringBuilder();
        if (Objects.nonNull(solicitacaoAlvaraObservacaoAnterior)) {
            observacaoMudancaEndereco.append(this.getObservacoesAlteracaoCadastro(solicitacaoAlvaraObservacaoAnterior, SUFIXO_OBSERVACAO_ALTERACAO_ANTERIOR));
        }
        observacaoMudancaEndereco.append(this.getObservacoesAlteracaoCadastro(solicitacaoAlvaraObservacao, ""));
        return observacaoMudancaEndereco.toString();
    }

    private String buildObservacaoAtividades(SolicitacaoAlvaraEntity solicitacaoAlvara, List<String> cnaes) {
        if (!solicitacaoAlvara.isNaturezaAlteracaoAtividade()) {
            return "";
        }
        List cnaesInformados = this.loadCnaesBySolicitacaoAlvara(solicitacaoAlvara);
        if (EloListUtils.safeIsEmpty((List)cnaesInformados).booleanValue()) {
            return "%n\tN\u00e3o foram realizadas altera\u00e7\u00f5es de atividades!";
        }
        ArrayList<String> cnaesAlterados = new ArrayList<String>();
        ArrayList<String> cnaesAdicionados = new ArrayList<String>();
        for (String cnae : cnaesInformados) {
            if (!cnaes.contains(cnae)) {
                cnaesAdicionados.add(cnae);
                continue;
            }
            cnaesAlterados.add(cnae);
            cnaes.remove(cnae);
        }
        return String.format("%n\tAtividade(s):%s%s%s.", this.getAtividadesFormatadas(cnaesAdicionados, " Adicionada(s): %s"), this.getAtividadesFormatadas(cnaesAlterados, " Alterada(s): %s"), this.getAtividadesFormatadas(cnaes, " Removida(s): %s"));
    }

    private String getAtividadesFormatadas(List<String> cnaesAdicionados, String s) {
        return EloListUtils.safeIsEmpty(cnaesAdicionados) == false ? String.format(s, StringUtils.join(cnaesAdicionados, (String)", ")) : "";
    }

    private String getObservacoesAlteracaoCadastro(SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacao, String sufixo) {
        if (Objects.isNull(solicitacaoAlvaraObservacao)) {
            return "";
        }
        return String.format("%n\t%s%s%s", Optional.ofNullable(solicitacaoAlvaraObservacao.getCadastroImobiliario()).map(cadastroImobiliario -> String.format("Cadastro Imobili\u00e1rio%s: %d ", sufixo, cadastroImobiliario)).orElse(""), Optional.ofNullable(solicitacaoAlvaraObservacao.getLogradouro()).map(logradouro -> String.format("Logradouro%s: %s ", sufixo, logradouro)).orElse(""), Optional.ofNullable(solicitacaoAlvaraObservacao.getNumeroEndereco()).map(numeroEndereco -> String.format("N\u00famero%s: %s", sufixo, numeroEndereco)).orElse(""));
    }

    private String getObservacaoRazaoSocialAlvara(SolicitacaoAlvaraObservacaoDTO solicitacaoAlvaraObservacao, String sufixo) {
        if (Objects.isNull(solicitacaoAlvaraObservacao)) {
            return "";
        }
        return String.format("%n\t%s%s", Optional.ofNullable(solicitacaoAlvaraObservacao.getNomeRazaoSocial()).map(razao -> String.format("Raz\u00e3o Social%s: %s ", sufixo, razao)).orElse(""), Optional.ofNullable(solicitacaoAlvaraObservacao.getNomeFantasia()).map(fantasia -> String.format("Nome Fantasia%s: %s", sufixo, fantasia)).orElse(""));
    }

    public void salvarConsultaPreviaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.setRenovacao("N");
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO})) {
            this.atribuirIdAtividadesSolicitacao(solicitacao);
        }
        this.inserirDataValidadeNaSolicitacao(solicitacao);
        this.salvarSolicitacaoAlvara(solicitacao);
    }

    protected void inserirDataValidadeNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ParametroAlvaraEntity diasValidade = this.getParametroAlvara(ParametroAlvaraEnum.DIAS_VALIDADE_CONSULTA_PREVIA);
        Date dataValidade = EloDateUtils.addDay((Date)new Date(), (int)Integer.parseInt(diasValidade.getValor()));
        solicitacao.setDataValidadeConsultaPrevia(dataValidade);
    }

    public ParametroAlvaraEntity getParametroAlvara(ParametroAlvaraEnum parametroEnum) throws BaseException {
        ParametroAlvaraEntity parametroAlvara = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), parametroEnum);
        if (parametroAlvara == null) {
            throw new SolicitacaoAlvaraException(String.format("O par\u00e2metro %s n\u00e3o foi encontrado", parametroEnum.name()));
        }
        if (EloStringUtils.isEmpty((String)parametroAlvara.getValor())) {
            throw new ParametroException(String.format("N\u00e3o possui o valor no par\u00e2metro %s", parametroEnum.name()));
        }
        return parametroAlvara;
    }

    public void validaRestricaoCnpjPJ(SolicitacaoAlvaraEntity solicitacaoAlvara, Boolean geraRestricaoCadastroExistente) throws BaseException {
        List pessoasCadastradas = this.repositoryPessoa.carregaPessoasPorCpfCnpj(solicitacaoAlvara.getCpfCnpj());
        if (this.isPermitirPessoaAtivaComCadastroBaixado().booleanValue() && !EloListUtils.safeIsEmpty((List)pessoasCadastradas).booleanValue()) {
            this.pessoaExistente = (PessoaEntity)pessoasCadastradas.stream().findFirst().get();
            this.validarPermissaoPessoaAtivaComCadastrosBaixados(this.pessoaExistente);
        } else if (this.existeRestricaoCnpjPessoaJuridicaNormal(solicitacaoAlvara) && !geraRestricaoCadastroExistente.booleanValue()) {
            throw new SolicitacaoAlvaraException(EloStringUtils.build((Object[])new Object[]{" J\u00e1 existe um cadastro mobili\u00e1rio para este CPF/CNPJ com situa\u00e7\u00e3o que n\u00e3o permite a gera\u00e7\u00e3o de um novo cadastro. Favor entrar em contato atrav\u00e9s do e-mail: ", this.getEmailSetorCadastroAlvara()}));
        }
    }

    protected ParametroAlvaraNaturezaEntity getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum param, NaturezaSolicitacaoAlvaraEntity natureza, TipoInscricaoAlvaraEntity tipoInscricaoAlvara) {
        ParametroAlvaraNaturezaEntity paramSit = this.repositoryParametroAlvaraNatureza.getParametroAlvaraNatureza(natureza, param, tipoInscricaoAlvara);
        return paramSit;
    }

    public ParametroAlvaraEntity getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum parametroEnum) throws BaseException {
        ParametroAlvaraEntity parametroAlvara = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), parametroEnum);
        if (parametroAlvara == null) {
            throw new SolicitacaoAlvaraException(String.format("O par\u00e2metro %s n\u00e3o foi encontrado", parametroEnum.name()));
        }
        return parametroAlvara;
    }

    public ResponsavelSolicitacaoVo getResponsavelSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara != null) {
            if (solicitacaoAlvara.getTipoDeInscricao().isMEI()) {
                return this.getResponsavelSolicitacaoAlvaraMEI(solicitacaoAlvara);
            }
            if (solicitacaoAlvara.getTipoDeInscricao().isPF()) {
                return this.getResponsavelSolicitacaoAlvaraPF(solicitacaoAlvara);
            }
            if (solicitacaoAlvara.getTipoDeInscricao().isPJ()) {
                return this.getResponsavelSolicitacaoAlvaraPJ(solicitacaoAlvara);
            }
        }
        return new ResponsavelSolicitacaoVo();
    }

    private ResponsavelSolicitacaoVo getResponsavelSolicitacaoAlvaraPF(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return new ResponsavelSolicitacaoVo(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf(), "");
    }

    private ResponsavelSolicitacaoVo getResponsavelSolicitacaoAlvaraMEI(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        try {
            solicitacaoAlvara = this.repositorySolicitacaoAlvara.load(solicitacaoAlvara.getSolicitacaoAlvara());
            this.repositorySolicitacaoAlvara.carregarContratoSocial(solicitacaoAlvara);
            PessoaEntity pessoa = ((SolicitacaoContratoSocialPessoaEntity)solicitacaoAlvara.getContratoSocial().getPessoas().stream().findFirst().get()).getPessoa();
            return new ResponsavelSolicitacaoVo(pessoa.getCnpjCpf(), pessoa.getNome());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return new ResponsavelSolicitacaoVo();
        }
    }

    private ResponsavelSolicitacaoVo getResponsavelSolicitacaoAlvaraPJ(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        ContratoSocialEntity contratoSocial;
        ContratoSocialPessoaEntity contratoSocialPessoaEntity;
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getCadastroMobiliario().getContratosSociais()).booleanValue() && (contratoSocialPessoaEntity = this.getPessoaResponsavelContratoSocial(contratoSocial = (ContratoSocialEntity)solicitacaoAlvara.getCadastroMobiliario().getContratosSociais().stream().findFirst().get())) != null) {
            PessoaEntity pessoa = contratoSocialPessoaEntity.getId().getPessoa();
            return new ResponsavelSolicitacaoVo(pessoa.getCnpjCpf(), pessoa.getNome());
        }
        return new ResponsavelSolicitacaoVo(solicitacaoAlvara.getCpfCnpjConsulta(), "");
    }

    private ContratoSocialPessoaEntity getPessoaResponsavelContratoSocial(ContratoSocialEntity contratoSocial) {
        Optional<ContratoSocialPessoaEntity> responsavel = contratoSocial.getPessoas().stream().filter(pessoa -> SimNaoEnum.SIM.getShortText().equalsIgnoreCase(pessoa.getResponsavel())).findFirst();
        return responsavel.isPresent() ? responsavel.get() : null;
    }

    protected void atribuirIdAtividadesSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getSolicitacaoAlvaraAtividades()).booleanValue()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                if (atividade.getIdSolicitacaoAtividade() == null) {
                    atividade.setIdSolicitacaoAtividade(this.repositorySolicitacaoAlvaraAtividade.getSequence());
                }
                if (EloListUtils.safeIsEmpty((List)atividade.getNumerosConselho()).booleanValue()) continue;
                for (SolicitacaoAlvaraNumConselhoEntity numero : atividade.getNumerosConselho()) {
                    if (numero.getId() == null) {
                        numero.setId(this.repositorySolicitacaoAlvaraNumConselho.getSequence());
                    }
                    this.atribuirIdDocumentosConselho(numero);
                }
            }
        }
    }

    private void atribuirIdDocumentosConselho(SolicitacaoAlvaraNumConselhoEntity numero) {
        if (!EloListUtils.safeIsEmpty((List)numero.getDocumentos()).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoConselhoEntity documento : numero.getDocumentos()) {
                if (documento.getId() != null) continue;
                documento.setId(this.repositorySolicitacaoAlvaraNumConselho.getSequenceDocumentos());
            }
        }
    }

    protected void salvarSolicitacaoAlvaraInicial(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean restricaoCadastroExistente) throws BaseException {
        RegimeFiscalPeriodoRealAiseEntity regimeFiscalPeriodo;
        SolicitacaoAlvaraEntity solicitacaoExistente = this.repositorySolicitacaoAlvara.load(solicitacaoAlvara.getSolicitacaoAlvara());
        if (Objects.nonNull(solicitacaoExistente.getContratoSocial()) && Objects.nonNull(solicitacaoAlvara.getContratoSocial())) {
            solicitacaoAlvara.getContratoSocial().setId(solicitacaoExistente.getContratoSocial().getId());
        }
        this.cadastroMobiliarioExistente = null;
        this.pessoaExistente = null;
        this.salvarSolicitacaoDocumentos(solicitacaoAlvara);
        if (!solicitacaoAlvara.isSolicitacaoPrestadorServico() && !solicitacaoAlvara.isSolicitacaoMEIPrestador() && solicitacaoAlvara.isGrauRiscoBaixo()) {
            this.adicionaValidadeAlvaraProvisorio(solicitacaoAlvara);
        }
        if (solicitacaoAlvara.isSolicitacaoCBO()) {
            List pessoas = this.repositoryPessoa.carregaPessoasPorCpfCnpj(solicitacaoAlvara.getCpfCnpj());
            HashMap<Integer, ArrayList<Object>> pessoasAgrupadorPorQtd = new HashMap<Integer, ArrayList<Object>>();
            for (Object pessoa : pessoas) {
                List cadastros = this.repositoryCadastroMobiliario.cadastrosMobiliariosByPessoa((PessoaEntity)pessoa);
                if (cadastros == null) continue;
                Integer qtdIndex = cadastros.size();
                ArrayList<Object> pessoasDoGrupo = (ArrayList<Object>)pessoasAgrupadorPorQtd.get(qtdIndex);
                if (pessoasDoGrupo == null) {
                    pessoasDoGrupo = new ArrayList<Object>();
                    pessoasAgrupadorPorQtd.put(qtdIndex, pessoasDoGrupo);
                }
                pessoasDoGrupo.add(pessoa);
            }
            Integer maior = -1;
            for (Integer qtdIndex : pessoasAgrupadorPorQtd.keySet()) {
                if (maior != -1 && qtdIndex <= maior) continue;
                maior = qtdIndex;
            }
            List pessoasPorMaiorQtd = (List)pessoasAgrupadorPorQtd.get(maior);
            if (pessoasPorMaiorQtd != null) {
                PessoaEntity pessoaMaisAntiga = null;
                for (PessoaEntity pessoa : pessoasPorMaiorQtd) {
                    if (pessoaMaisAntiga != null && (pessoaMaisAntiga == null || pessoa.getDataInclusao().compareTo(pessoaMaisAntiga.getDataInclusao()) <= 0)) continue;
                    pessoaMaisAntiga = pessoa;
                }
                if (pessoaMaisAntiga != null) {
                    this.pessoaExistente = pessoaMaisAntiga;
                }
            }
        } else if (solicitacaoAlvara.isSolicitacaoMEI() && Objects.isNull(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getId().getCodigo())) {
            this.validaCnpjMei(solicitacaoAlvara);
        } else if (Objects.isNull(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getId().getCodigo())) {
            this.validaCnpjPJ(solicitacaoAlvara, restricaoCadastroExistente);
        }
        this.carregaDadosAlvaraInicial(solicitacaoAlvara);
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().setEnderecos(new ArrayList());
        if (this.cadastroMobiliarioExistente != null) {
            this.atualizarCadastroMobExistente(solicitacaoAlvara, solicitacaoAlvara.getCadastroMobiliario().getCmcresponsavel(), this.pessoaExistente, this.cadastroMobiliarioExistente);
        } else {
            if (this.pessoaExistente != null) {
                if (!solicitacaoAlvara.getVerificaRestricaoCadastroExistente().booleanValue()) {
                    this.pessoaExistente.setNome(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
                    this.pessoaExistente.setNomeFantasia(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getNomeFantasia());
                    this.pessoaExistente.setCnpjCpf(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
                    this.pessoaExistente.setNire(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().getNire());
                }
                solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setPessoa(this.pessoaExistente);
            }
            if (solicitacaoAlvara.getCadastroMobiliario().getCmcresponsavel() != null) {
                solicitacaoAlvara.getCadastroMobiliario().setCmcresponsavel(solicitacaoAlvara.getCadastroMobiliario().getCmcresponsavel());
            }
        }
        try {
            this.validarPessoaAPIExterna(solicitacaoAlvara);
        }
        catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao consultar a integra\u00e7\u00e3o de pessoas do ISS-e", (Throwable)e);
        }
        this.logger.info((Object)"adicionaSolicitacaoContratoSocial------- salvarSolicitacaoAlvaraInicial");
        this.adicionaSolicitacaoContratoSocial(solicitacaoAlvara);
        this.atribuirSocioPessoa(solicitacaoAlvara);
        PessoaEntity pessoa = this.salvarPessoa(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa());
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setPessoa(pessoa);
        solicitacaoAlvara.getCadastroMobiliario().setCadastroGeral(this.salvarCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), solicitacaoAlvara));
        if (Objects.nonNull(solicitacaoAlvara.getRegimeFiscalPeriodo()) && (regimeFiscalPeriodo = this.criarRegimeFiscal(solicitacaoAlvara)) != null) {
            this.salvarRegimeFiscal(regimeFiscalPeriodo);
        }
        EnderecoPessoaEntity enderecoPessoa = this.carregaDadosNoEndPessoa(solicitacaoAlvara);
        enderecoPessoa = this.salvarEnderecoPessoa(enderecoPessoa, solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa());
        this.alterarEnderecoCadastroGeral(solicitacaoAlvara, enderecoPessoa, solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
        ContatoPessoaEntity contatoPessoa = this.criarContatoPessoa(solicitacaoAlvara, solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
        if (!this.srvUnico.isIntegradoTotal()) {
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa().setContatoPessoaPrincipal(contatoPessoa);
        }
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setDataAlteracao(new Date());
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setDataInclusao(new Date());
        PessoaEntity pessoaSalva = this.srvPessoa.salvar(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa());
        solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setPessoa(pessoaSalva);
        this.verificarSeGeraCadastroEmExclusaoLogica(solicitacaoAlvara);
        this.salvarCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), solicitacaoAlvara);
        if (solicitacaoAlvara.getCadastroMobiliario().getCmcresponsavel() == null) {
            solicitacaoAlvara.getCadastroMobiliario().setCmcresponsavel(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getId().getCodigo());
        }
        solicitacaoAlvara.getCadastroMobiliario().setCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral());
        solicitacaoAlvara.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario()));
        this.vincularMobiliarioCnae(solicitacaoAlvara);
        this.getUtilizaMobiliarioAtividade(solicitacaoAlvara);
        this.carregaMobiliarioAtividades(solicitacaoAlvara);
        solicitacaoAlvara.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario()));
        this.salvarCadastroGeralIsencao(solicitacaoAlvara.getCadastroMobiliario(), solicitacaoAlvara);
        if (solicitacaoAlvara.getNumeroSolicitacao() == null) {
            solicitacaoAlvara.setNumeroSolicitacao(this.repositorySolicitacaoAlvara.getNumeroSolicitacao(PortalUtils.getEntidade(), solicitacaoAlvara.getExercicio()));
        }
        if (solicitacaoAlvara.getSolicitacaoAlvara() == null) {
            solicitacaoAlvara.setSolicitacaoAlvara(this.repositorySolicitacaoAlvara.getSequence());
        }
        this.salvarCadastroImobiliario(solicitacaoAlvara.getCadastroImobiliario());
        this.atribuirIdAtividadesSolicitacao(solicitacaoAlvara);
        this.atualizaContratoSocialCadastroMobiliario(solicitacaoAlvara, true);
        List boletinsGerados = this.srvGeraBoletimMobiliarioAlvara.geraBoletimMobiliario(solicitacaoAlvara);
        this.srvGeraBoletimMobiliarioAlvara.salvarBoletinsMobiliario(boletinsGerados);
        solicitacaoAlvara.setFinalizado(SimNaoEnum.SIM.getShortText());
        solicitacaoAlvara.setEfetivado(SimNaoEnum.SIM.getShortText());
        solicitacaoAlvara = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacaoAlvara);
        this.repositorySolicitacaoAlvara.flush();
        this.salvarMobiliarioSituacao(solicitacaoAlvara, true);
        this.salvarMobiliarioServico(solicitacaoAlvara);
        this.updateBairroCadastroGeral(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), enderecoPessoa.getBairro().getId());
        this.salvarObservacao(solicitacaoAlvara);
    }

    protected void atribuirSocioPessoa(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isSolicitacaoMEI()) {
            PessoaEntity pessoa = solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().getPessoa();
            pessoa.setPessoaSocio(((SolicitacaoContratoSocialPessoaEntity)solicitacaoAlvara.getContratoSocial().getPessoas().stream().findFirst().get()).getPessoa());
        }
    }

    protected boolean existeRestricaoCnpjPessoaJuridicaNormal(SolicitacaoAlvaraEntity solicitacao) throws CadastroMobiliarioException, BaseException {
        List pessoasCadastradas;
        if (solicitacao.isNaturezaInicial() && !EloListUtils.safeIsEmpty((List)(pessoasCadastradas = this.repositoryPessoa.carregaListaPessoaPorCpfCnpjNome(solicitacao.getCpfCnpj(), null))).booleanValue()) {
            String paramSitMobiliario;
            ParametroAlvaraNaturezaEntity paramValidaTipoPessoaMobExistente = this.getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum.VALIDATIPOPESSOAMOBEXISTENTE, this.getNatureza(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue()), solicitacao.getTipoDeInscricao());
            String paramTipoPessoa = Objects.nonNull(paramValidaTipoPessoaMobExistente) ? paramValidaTipoPessoaMobExistente.getValor() : null;
            ParametroAlvaraNaturezaEntity paramValidaMobExistente = this.getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum.VALIDASITUACAOMOBEXISTENTE, this.getNatureza(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue()), solicitacao.getTipoDeInscricao());
            String string = paramSitMobiliario = Objects.nonNull(paramValidaMobExistente) ? paramValidaMobExistente.getValor() : null;
            if (Objects.nonNull(paramTipoPessoa) && Objects.nonNull(paramSitMobiliario) && this.repositoryCadastroMobiliario.verificarTipoPessoaSituacaoMobiliariaParaAlvaraInicial(pessoasCadastradas, EloStringUtils.strToLong((String[])paramTipoPessoa.split(",")), EloStringUtils.strToLong((String[])paramSitMobiliario.split(",")))) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public void validaCnpjPJ(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean restricaoCadastroExistente) throws BaseException, CadastroMobiliarioException {
        List pessoasCadastradas = this.repositoryPessoa.carregaPessoasPorCpfCnpj(solicitacaoAlvara.getCpfCnpj());
        CadastroMobiliarioHelper cadastroHelper = null;
        if (!EloListUtils.safeIsEmpty((List)pessoasCadastradas).booleanValue()) {
            if (this.isPermitirPessoaAtivaComCadastroBaixado().booleanValue()) {
                this.pessoaExistente = (PessoaEntity)pessoasCadastradas.stream().findFirst().get();
                this.validarPermissaoPessoaAtivaComCadastrosBaixados(this.pessoaExistente);
            } else {
                cadastroHelper = this.carregaCadastroHelper((PessoaEntity)pessoasCadastradas.stream().findFirst().get(), restricaoCadastroExistente);
                if (cadastroHelper != null) {
                    this.cadastroMobiliarioExistente = cadastroHelper.getCadastroMobiliario();
                    this.pessoaExistente = cadastroHelper.getPessoa();
                }
            }
        }
    }

    public void validaCnpjMei(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        try {
            PessoaEntity pessoa = this.repositoryPessoa.carregaPessoaMaisAntigaPorCpfCnpj(solicitacaoAlvara.getCpfCnpj());
            if (pessoa != null) {
                this.pessoaExistente = pessoa;
                if (this.isPermitirPessoaAtivaComCadastroBaixado().booleanValue()) {
                    this.validarPermissaoPessoaAtivaComCadastrosBaixados(pessoa);
                } else {
                    List cadastros = this.repositoryCadastroGeral.findByPessoa(pessoa);
                    this.validarPermissaoPessoaAtivaComUmCadastroAvulso(solicitacaoAlvara.getTipoDeInscricao(), cadastros);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(Strings.join((String)"Falha na valida\u00e7\u00e3o do cnpj ", (String[])new String[]{e.getMessage()}));
        }
    }

    protected void salvarMobiliarioServico(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        Set cnaeServicos = new HashSet();
        solicitacaoAlvara.getCadastroMobiliario().setMobiliarioServicos(new ArrayList());
        cnaeServicos = this.getCnaeServico(solicitacaoAlvara);
        if (!cnaeServicos.isEmpty()) {
            this.criarMobiliarioServico(solicitacaoAlvara, cnaeServicos);
            CadastroMobiliarioEntity cadastroMobiliarioSalvo = this.repositoryCadastroMobiliario.saveOrUpdate(solicitacaoAlvara.getCadastroMobiliario());
            solicitacaoAlvara.setCadastroMobiliario(cadastroMobiliarioSalvo);
        }
    }

    private Set<CnaeServicoEntity> getCnaeServico(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        HashSet<CnaeServicoEntity> cnaeServicos = new HashSet<CnaeServicoEntity>();
        if (solicitacaoAlvara.isSolicitacaoJuridicaNormal()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                cnaeServicos.addAll(this.repositoryCnaeServico.findServicosByCnaeExercicio(atividade.getCnae().getCodigo(), this.getExercicio()));
            }
        } else if (solicitacaoAlvara.isSolicitacaoMEI()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
                cnaeServicos.addAll(this.repositoryCnaeServico.findServicosByCnaeExercicio(atividade.getAtividadeMei().getCnae().getCodigo(), this.getExercicio()));
            }
        }
        if (solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicos() == null) {
            solicitacaoAlvara.getCadastroMobiliario().setMobiliarioServicos(new ArrayList());
        }
        return cnaeServicos;
    }

    private void criarMobiliarioServico(SolicitacaoAlvaraEntity solicitacaoAlvara, Set<CnaeServicoEntity> cnaeServicos) {
        for (CnaeServicoEntity cnaeServico : cnaeServicos) {
            boolean flagAddServico = this.verificarSeExisteServicoNoMobiliario(solicitacaoAlvara, cnaeServico);
            if (!flagAddServico) continue;
            MobiliarioServicoPK mobiliarioServiciopk = new MobiliarioServicoPK();
            mobiliarioServiciopk.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
            mobiliarioServiciopk.setServico(cnaeServico.getServico());
            MobiliarioServicoEntity mobiliarioServico = new MobiliarioServicoEntity();
            mobiliarioServico.setId(mobiliarioServiciopk);
            mobiliarioServico.setPrincipal(this.getCnaePrincipal(solicitacaoAlvara.getSolicitacaoAlvaraAtividades(), cnaeServico.getCnae()));
            mobiliarioServico.setGerarLancamento(SimNaoEnum.SIM.getShortText());
            if (solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicos().contains(mobiliarioServico)) continue;
            solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicos().add(mobiliarioServico);
        }
        if (solicitacaoAlvara.getCadastroMobiliario().possuiMaisDeUmServicoPrincipal()) {
            solicitacaoAlvara.getCadastroMobiliario().addPrincipalEmTodosMobServicos(SimNaoEnum.NAO.getShortText());
        }
    }

    private String getCnaePrincipal(List<SolicitacaoAlvaraAtividadeEntity> atividades, CnaeEntity cnae) {
        for (SolicitacaoAlvaraAtividadeEntity atividade : atividades) {
            if (!(Objects.nonNull(atividade.getAtividadeMei()) ? atividade.getAtividadeMei().getCnae().getId().equals(cnae.getId()) && SimNaoEnum.equalSim((String)atividade.getPrincipal()) != false : Objects.nonNull(atividade.getCnae()) && atividade.getCnae().getId().equals(cnae.getId()) && SimNaoEnum.equalSim((String)atividade.getPrincipal()) != false)) continue;
            return atividade.getPrincipal();
        }
        return SimNaoEnum.NAO.getShortText();
    }

    private boolean verificarSeExisteServicoNoMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara, CnaeServicoEntity cnaeServico) {
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicos()).booleanValue()) {
            for (MobiliarioServicoEntity mobServico : solicitacaoAlvara.getCadastroMobiliario().getMobiliarioServicosExercicioAtual(this.getExercicio())) {
                if (!cnaeServico.getServico().getId().equals((Object)mobServico.getId().getServico().getId())) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected Boolean isPermitirPessoaAtivaComCadastroBaixado() throws BaseException {
        ParametroAlvaraEntity parametroAlvara = this.getParametroAlvara(ParametroAlvaraEnum.PERMITIR_PESSOA_ATIVA_COM_CADASTROBAIXADO);
        return Objects.nonNull(parametroAlvara) && SimNaoEnum.SIM.getShortText().equals(parametroAlvara.getValor());
    }

    protected void validarPermissaoPessoaAtivaComCadastrosBaixados(PessoaEntity pessoa) throws BaseException {
        SituacaoMobiliarioAlvaraEntity situacaoMobiliarioAlvaraEntity;
        List cadastros = this.repositoryCadastroGeral.findByPessoa(pessoa);
        if (!cadastros.isEmpty() && Objects.nonNull(situacaoMobiliarioAlvaraEntity = this.repositorySituacaoMobiliarioAlvara.load(SituacaoMobiliarioAlvaraEnum.SITUACAO_BAIXADO.getCodigo()))) {
            SituacaoMobiliarioEntity situacaoMobiliario = situacaoMobiliarioAlvaraEntity.getSituacaoMobiliario();
            List cadastrosSomenteMobiliarios = cadastros.stream().filter(this.somenteMobiliarios()).collect(Collectors.toList());
            if (!cadastrosSomenteMobiliarios.isEmpty()) {
                long auxQtdeCadastroBaixado = cadastrosSomenteMobiliarios.stream().filter(this.mobiliariosSituacaoBaixados(situacaoMobiliario)).count();
                Long quantidadeMobiliariosBaixados = auxQtdeCadastroBaixado;
                Long quantidadeCadastrosSomenteMobiliarios = cadastrosSomenteMobiliarios.size();
                if (!quantidadeCadastrosSomenteMobiliarios.equals(quantidadeMobiliariosBaixados)) {
                    throw new SolicitacaoAlvaraException(EloStringUtils.build((Object[])new Object[]{" J\u00e1 existe um cadastro mobili\u00e1rio para este CPF/CNPJ com situa\u00e7\u00e3o que n\u00e3o permite a gera\u00e7\u00e3o de um novo cadastro. Favor entrar em contato atrav\u00e9s do e-mail: ", this.getEmailSetorCadastroAlvara()}));
                }
            }
        }
    }

    private Predicate<CadastroGeralAiseEntity> mobiliariosSituacaoBaixados(SituacaoMobiliarioEntity situacaoMobiliario) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Predicate<CadastroGeralAiseEntity> somenteMobiliarios() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void validarPermissaoPessoaAtivaComUmCadastroAvulso(TipoInscricaoAlvaraEntity tipoInscricao, List<CadastroGeralAiseEntity> cadastros) throws BaseException {
        int qtdeCadastroAvulso = 0;
        String paramSituacaoMobExistente = this.getParamAlvaraNatureza(ParametroAlvaraNaturezaEnum.VALIDASITUACAOMOBEXISTENTE, this.getNatureza(NaturezaSolicitacaoAlvaraEnum.INICIAL.getValue()), tipoInscricao).getValor();
        String[] situacoes = paramSituacaoMobExistente.split(",");
        for (CadastroGeralAiseEntity cadastro : cadastros) {
            if (!this.cadastroContemSituacoes(cadastro, situacoes) || !cadastro.getCadastroMobiliario().isCadastroAvulso().booleanValue()) continue;
            ++qtdeCadastroAvulso;
            this.cadastroMobiliarioExistente = cadastro.getCadastroMobiliario();
        }
        if (qtdeCadastroAvulso != 1) {
            throw new SolicitacaoAlvaraException(EloStringUtils.build((Object[])new Object[]{" J\u00e1 existe um cadastro mobili\u00e1rio para este CPF/CNPJ com situa\u00e7\u00e3o que n\u00e3o permite a gera\u00e7\u00e3o de um novo cadastro. Favor entrar em contato atrav\u00e9s do e-mail: ", this.getEmailSetorCadastroAlvara()}));
        }
    }

    private void verificarCnaesHotelMotel(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        if (!EloListUtils.safeIsEmpty((List)solicitacaoAlvara.getAtividadesVo()).booleanValue()) {
            this.gravarInformacoesHotel(solicitacaoAlvara);
        }
    }

    private void gravarInformacoesHotel(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        for (AtividadeCnaeVo atividade : solicitacaoAlvara.getAtividadesVo()) {
            if (EloNumberUtils.isBiggerThanZero((Number)atividade.getNumeroQuarto()).booleanValue()) {
                ModeloIdentificacaoEntity modeloIdentificacaoQuartoHotel = this.carregarModeloIdentificacaoQuartosHotel();
                this.gravarBoletimAtividade(atividade, modeloIdentificacaoQuartoHotel, solicitacaoAlvara.getCadastroMobiliario().getId());
            }
            if (EloNumberUtils.isBiggerThanZero((Number)atividade.getNumeroApartamento()).booleanValue()) {
                ModeloIdentificacaoEntity modeloIdentificacaoApartHotel = this.carregarModeloIdentificacaoApartamentosHotel();
                this.gravarBoletimAtividade(atividade, modeloIdentificacaoApartHotel, solicitacaoAlvara.getCadastroMobiliario().getId());
            }
            if (!EloNumberUtils.isBiggerThanZero((Number)atividade.getNumeroSuite()).booleanValue()) continue;
            ModeloIdentificacaoEntity modeloIdentificacaoSuitesHotel = this.carregarModeloIdentificacaoSuitesHotel();
            this.gravarBoletimAtividade(atividade, modeloIdentificacaoSuitesHotel, solicitacaoAlvara.getCadastroMobiliario().getId());
        }
    }

    private void gravarBoletimAtividade(AtividadeCnaeVo atividade, ModeloIdentificacaoEntity modeloIdentificacao, CadastroGeralAisePK cadastroGeral) throws SolicitacaoAlvaraException {
        BoletimAtividadePK pk = new BoletimAtividadePK();
        pk.setAtividade(atividade.getAtividade().getId());
        pk.setTipoCadastro(cadastroGeral.getTipo());
        pk.setCadastroGeral(cadastroGeral.getCodigo());
        pk.setModelo(modeloIdentificacao.getModeloResposta().getId().getModeloCampo().getId().getModeloGrupo().getId().getModelo().getId());
        pk.setModeloGrupo(modeloIdentificacao.getModeloResposta().getId().getModeloCampo().getId().getModeloGrupo().getId().getModeloGrupo());
        pk.setModeloCampo(modeloIdentificacao.getModeloResposta().getId().getModeloCampo().getId().getModeloCampo());
        pk.setModeloResposta(modeloIdentificacao.getModeloResposta().getId().getModeloResposta());
        BoletimAtividadeEntity boletimAtividade = new BoletimAtividadeEntity();
        if (modeloIdentificacao.getIdentificacao().equals(ModeloIdentificacaoEnum.NUM_QUARTOS_HOTEL.getValor())) {
            boletimAtividade.setDescricaoResposta(String.valueOf(atividade.getNumeroQuarto()));
        } else if (modeloIdentificacao.getIdentificacao().equals(ModeloIdentificacaoEnum.NUM_APART_HOTEL.getValor())) {
            boletimAtividade.setDescricaoResposta(String.valueOf(atividade.getNumeroApartamento()));
        } else if (modeloIdentificacao.getIdentificacao().equals(ModeloIdentificacaoEnum.NUM_SUITE_HOTEL.getValor())) {
            boletimAtividade.setDescricaoResposta(String.valueOf(atividade.getNumeroSuite()));
        }
        boletimAtividade.setId(pk);
        this.repositoryBoletimAtividade.saveOrUpdate(boletimAtividade);
    }

    private ModeloIdentificacaoEntity carregarModeloIdentificacaoQuartosHotel() {
        return this.repositoryModeloIdentificacao.getNumeroQuartosHotel();
    }

    private ModeloIdentificacaoEntity carregarModeloIdentificacaoApartamentosHotel() {
        return this.repositoryModeloIdentificacao.getNumeroApartamentosHotel();
    }

    private ModeloIdentificacaoEntity carregarModeloIdentificacaoSuitesHotel() {
        return this.repositoryModeloIdentificacao.getNumeroSuitesHotel();
    }

    protected void vincularMobiliarioCnae(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        SolicitacaoAlvaraRedeSimDTO solicitacaoDTO;
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) {
            return;
        }
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        if (Objects.nonNull(solicitacaoRedeSim) && Objects.nonNull(solicitacaoDTO = SolicitacaoAlvaraRedeSimDTO.of((String)solicitacaoRedeSim.getArquivoDadosEmpresa()))) {
            for (Atividades atividade : solicitacaoDTO.getDados_solicitacao().getEmpresa().getAtividades()) {
                String cnae = atividade.getCo_cnae().replaceAll("[/-]", "");
                CnaeEntity cnaeEntity = Optional.ofNullable(this.repositoryCnae.consultaCnaePorCodigo(cnae)).orElseThrow(() -> new SolicitacaoAlvaraException(String.format("O Cnae %s n\u00e3o existe na base de dados", cnae)));
                MobiliarioCnaeEntity mobCnae = new MobiliarioCnaeEntity();
                MobiliarioCnaePK id = new MobiliarioCnaePK();
                id.setCnae(cnaeEntity);
                id.setCadastroMobiliarioEntity(solicitacao.getCadastroMobiliario());
                mobCnae.setId(id);
                mobCnae.setCnaePrincipal(SimNaoEnum.toShortText((Boolean)atividade.isIs_atividade_principal()));
                mobCnae.setGerarLancamento(SimNaoEnum.SIM.getShortText());
                mobCnae.setDataInicio(new Date());
                solicitacao.getCadastroMobiliario().getMobiliarioCnaes().add(mobCnae);
            }
        }
    }

    private void vincularMobiliarioAtividade(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        solicitacao.getCadastroMobiliario().getMobiliarioAtividades().forEach(arg_0 -> ((RepositoryCadastroMobiliarioAtividade)this.repositoryCadastroMobiliarioAtividade).remove(arg_0));
        solicitacao.getCadastroMobiliario().getMobiliarioAtividades().clear();
        List atividadesPrincipais = solicitacao.getSolicitacaoAlvaraAtividades().stream().filter(atividade -> Objects.nonNull(atividade.getCnae())).filter(atividade -> SimNaoEnum.equalSim((String)atividade.getPrincipal())).flatMap(atividade -> this.repositoryAtividadeCnae.carregarAtividadesByCnae(atividade.getCnae()).stream()).map(AtividadeCnaeEntity::getAtividade).distinct().collect(Collectors.toList());
        List atividades = solicitacao.getSolicitacaoAlvaraAtividades().stream().filter(atividade -> Objects.nonNull(atividade.getCnae())).flatMap(atividade -> this.repositoryAtividadeCnae.carregarAtividadesByCnae(atividade.getCnae()).stream()).map(AtividadeCnaeEntity::getAtividade).distinct().collect(Collectors.toList());
        for (AtividadeEntity atividade2 : atividades) {
            String principal = EloListUtils.safeIsEmpty(atividadesPrincipais) == false && atividadesPrincipais.contains(atividade2) ? SimNaoEnum.getSimShortText() : SimNaoEnum.getNaoShortText();
            try {
                MobiliarioAtividadePK id = new MobiliarioAtividadePK();
                id.setAtividade(atividade2);
                id.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
                CadastroMobiliarioAtividadeEntity cadastroMobiliarioAtividadeEntity = new CadastroMobiliarioAtividadeEntity();
                cadastroMobiliarioAtividadeEntity.setId(id);
                cadastroMobiliarioAtividadeEntity.setAtividadePrincipal(principal);
                cadastroMobiliarioAtividadeEntity.setGerarLancamento(SimNaoEnum.SIM.getShortText());
                solicitacao.getCadastroMobiliario().addMobiliarioAtividade(this.repositoryCadastroMobiliarioAtividade.saveOrUpdate(cadastroMobiliarioAtividadeEntity));
                if (!SimNaoEnum.equalSim((String)principal).booleanValue()) continue;
                String vincularMobiliarioHorarioEspecial = this.getVincularMobiliarioHorarioEspecial();
                if (!SimNaoEnum.SIM.getShortText().equals(vincularMobiliarioHorarioEspecial)) continue;
                this.vincularMobiliarioHorarioEspecial(solicitacao, atividade2);
            }
            catch (Exception e) {
                throw new SolicitacaoAlvaraException(String.format("Ocorreu uma falha na configura\u00e7\u00e3o de atividades por cnaes %s", e.getMessage()), (Throwable)e);
            }
        }
        if (solicitacao.getCadastroMobiliario().possuiMaisDeUmaAtividadePrincipal()) {
            solicitacao.getCadastroMobiliario().addPrincipalEmTodosMobAtividades(SimNaoEnum.NAO.getShortText());
        }
    }

    private void vincularMobiliarioHorarioEspecial(SolicitacaoAlvaraEntity solicitacao, AtividadeEntity atividade) {
        ConfiguracaoHorarioEspecialAtividadeEntity configuracaoHorarioEspecialAtividade = this.repositoryConfiguracaoHorarioEspecialAtividade.getConfiguracaoHorarioEspecialAtividade(atividade);
        if (Objects.nonNull(configuracaoHorarioEspecialAtividade)) {
            MobiliarioHorarioEspecialEntity mobiliarioHorarioEspecial = new MobiliarioHorarioEspecialEntity();
            mobiliarioHorarioEspecial.setId(new MobiliarioHorarioEspecialPK());
            mobiliarioHorarioEspecial.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
            mobiliarioHorarioEspecial.setHorarioEspecial(configuracaoHorarioEspecialAtividade.getId().getIdHorarioEspecial());
            solicitacao.getCadastroMobiliario().addMobiliarioHorarioEspecial(mobiliarioHorarioEspecial);
        }
    }

    protected void verificarSeGeraCadastroEmExclusaoLogica(SolicitacaoAlvaraEntity solicitacao) {
        try {
            if (solicitacao.isNaturezaInicial()) {
                if (solicitacao.isGrauRiscoAlto()) {
                    ParametroAlvaraEntity parametroAlvara = this.getParametroAlvara(ParametroAlvaraEnum.GERA_CADASTRO_EM_EXCLUSAO_LOGICA);
                    solicitacao.getCadastroMobiliario().getCadastroGeral().setExclusaoLogica(parametroAlvara.getValor());
                } else {
                    solicitacao.getCadastroMobiliario().getCadastroGeral().setExclusaoLogica(SimNaoEnum.NAO.getShortText());
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void alterarEnderecoCadastroGeral(SolicitacaoAlvaraEntity solicitacaoAlvara, EnderecoPessoaEntity enderecoPessoa, CadastroGeralAiseEntity cadastroGeral) throws UnicoClientException, BaseException {
        cadastroGeral.setCep(enderecoPessoa.getCep() != null ? new BigDecimal(enderecoPessoa.getCep()) : null);
        cadastroGeral.setComplemento(solicitacaoAlvara.montarComplementoCadastroGeral());
        if (!this.srvUnico.isIntegradoTotal()) {
            cadastroGeral.getPessoa().setEnderecoPessoaPrincipal(enderecoPessoa);
        }
        cadastroGeral.setSequenciaEndereco(enderecoPessoa.getId().getSequencia());
    }

    private boolean cadastroContemSituacoes(CadastroGeralAiseEntity cadastro, String[] situacoes) {
        if (cadastro.getCadastroMobiliario() != null) {
            String situacaoAtual = cadastro.getCadastroMobiliario().getMobiliarioSituacaoAtual().getId().toString();
            for (int i = 0; i < situacoes.length; ++i) {
                if (!situacaoAtual.equals(situacoes[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected CadastroMobiliarioHelper carregaCadastroHelper(PessoaEntity pessoaCadastro, boolean geraRestricaoCadastroExistente) throws CadastroMobiliarioException {
        CadastroMobiliarioEntity cadastroMobiliarioExistente = null;
        PessoaEntity pessoaExistente = null;
        CadastroMobiliarioHelper cadastroHelper = new CadastroMobiliarioHelper();
        if (!geraRestricaoCadastroExistente) {
            cadastroMobiliarioExistente = this.repositoryCadastroMobiliario.cadastroMobiliarioByCpfCnpjAlvaraInicial(pessoaCadastro.getCnpjCpf());
            cadastroHelper.setCadastroMobiliario(cadastroMobiliarioExistente);
        }
        ParametroAlvaraEntity parametroVerificaPessoaVinculada = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidade(), ParametroAlvaraEnum.VERIFICAPESSOAVINCULADATIPOCADASTRO);
        if (cadastroMobiliarioExistente != null) {
            MobiliarioSituacaoEntity mobiliarioSituacao = this.repositoryMobiliarioSituacao.situacaoCadastroMobiliario(cadastroMobiliarioExistente.getId().getCodigo());
            if (!geraRestricaoCadastroExistente && Objects.nonNull(parametroVerificaPessoaVinculada) && Objects.nonNull(parametroVerificaPessoaVinculada.getValor())) {
                if (mobiliarioSituacao.getSituacaoMobiliario().getId().equals(8L)) {
                    if (this.repositoryCadastroGeral.verificarTiposDeCadastrosExistentes(pessoaCadastro, EloStringUtils.strToLong((String[])parametroVerificaPessoaVinculada.getValor().split(",")))) {
                        pessoaExistente = null;
                        cadastroHelper.setPessoa(null);
                    } else {
                        pessoaExistente = pessoaCadastro;
                        cadastroHelper.setPessoa(pessoaExistente);
                    }
                } else if (mobiliarioSituacao.getSituacaoMobiliario().getId().equals(9L)) {
                    cadastroHelper.setPessoa(null);
                    cadastroHelper.setCadastroMobiliario(null);
                }
            }
        } else if (Objects.nonNull(parametroVerificaPessoaVinculada) && Objects.nonNull(parametroVerificaPessoaVinculada.getValor()) && !this.repositoryCadastroGeral.verificarTiposDeCadastrosExistentes(pessoaCadastro, EloStringUtils.strToLong((String[])parametroVerificaPessoaVinculada.getValor().split(",")))) {
            pessoaExistente = pessoaCadastro;
            cadastroHelper.setPessoa(pessoaExistente);
        }
        return cadastroHelper;
    }

    protected void carregaMobiliarioAtividades(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.isNaturezaAlteracaoAtividade() || solicitacao.isSolicitacaoMEI()) {
            this.removerAtividadesDoCadastroMobiliario(solicitacao);
        }
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            this.setarAtividadePrincipalDeAcordoComAtividadeSelecionadaInicialSemRedeSim(solicitacao, atividade);
            if (solicitacao.isSolicitacaoPJ()) {
                if ("I".equals(atividade.getSituacao())) {
                    this.newMobiliarioCnae(solicitacao, atividade);
                } else {
                    this.atualizarMobiliarioCnaePrincipal(solicitacao, atividade);
                }
            }
            if (solicitacao.isSolicitacaoMEI()) {
                if ("I".equals(atividade.getSituacao())) {
                    if (this.contemAtividadeMeiNoMobiliario(solicitacao, atividade)) {
                        this.atualizarMobiliarioAtividadeMeiPrincipal(solicitacao, atividade);
                        this.atualizarMobiliarioCnaePrincipalMei(solicitacao, atividade);
                    } else {
                        this.novoMobiliarioAtividadeMei(solicitacao, atividade);
                    }
                } else if ("A".equals(atividade.getSituacao())) {
                    this.atualizarMobiliarioAtividadeMeiPrincipal(solicitacao, atividade);
                    this.atualizarMobiliarioCnaePrincipalMei(solicitacao, atividade);
                }
            }
            if (!solicitacao.isSolicitacaoCBO()) continue;
            if ("I".equals(atividade.getSituacao())) {
                this.newMobiliarioCbo(solicitacao, atividade);
                continue;
            }
            this.updateMobiliarioCbo(solicitacao, atividade);
        }
        if (!solicitacao.isNaturezaInicial()) {
            this.atualizarSolicitacaoAlvara(solicitacao);
        }
    }

    public boolean contemAtividadeMeiNoMobiliario(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        return solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis().stream().anyMatch(atvMei -> atvMei.getAtividadeMei().getAtividadeMei().equals(atividade.getAtividadeMei().getAtividadeMei()));
    }

    private void setarAtividadePrincipalDeAcordoComAtividadeSelecionadaInicialSemRedeSim(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        if (solicitacao.isNaturezaInicial() && !solicitacao.isRedeSim() && solicitacao.getSolicitacaoAtividadeSelecionada() != null) {
            atividade.setPrincipal(SimNaoEnum.toShortText((Boolean)atividade.equals((Object)solicitacao.getSolicitacaoAtividadeSelecionada())));
        }
    }

    private void removerAtividadesDoCadastroMobiliario(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.isSolicitacaoPJ()) {
            this.removerAtividadeCnae(solicitacao);
        } else if (solicitacao.isSolicitacaoMEI()) {
            this.removerAtividadeMei(solicitacao);
            this.removerAtividadeCnae(solicitacao);
        } else if (solicitacao.isSolicitacaoCBO()) {
            this.removerAtividadeCbo(solicitacao);
        }
    }

    private void removerAtividadeCnae(SolicitacaoAlvaraEntity solicitacao) {
        ArrayList<MobiliarioCnaeEntity> cnaesRemovidos = new ArrayList<MobiliarioCnaeEntity>();
        List mobiliarioCnaes = solicitacao.getCadastroMobiliario().getMobiliarioCnaes();
        for (MobiliarioCnaeEntity mobCnae : mobiliarioCnaes) {
            if (this.contemCnae(mobCnae, solicitacao)) continue;
            cnaesRemovidos.add(mobCnae);
        }
        solicitacao.getCadastroMobiliario().getMobiliarioCnaes().removeAll(cnaesRemovidos);
    }

    private boolean contemCnae(MobiliarioCnaeEntity mobCnae, SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.isSolicitacaoMEI()) {
            return solicitacao.getSolicitacaoAlvaraAtividades().stream().anyMatch(novaAtividade -> novaAtividade.getAtividadeMei().getCnae().equals((Object)mobCnae.getId().getCnae()));
        }
        return solicitacao.getSolicitacaoAlvaraAtividades().stream().anyMatch(novaAtividade -> novaAtividade.getCnae().equals((Object)mobCnae.getId().getCnae()));
    }

    private void removerAtividadeMei(SolicitacaoAlvaraEntity solicitacao) {
        ArrayList<CadastroMobiliarioAtividadeMeiEntity> meisRemovidos = new ArrayList<CadastroMobiliarioAtividadeMeiEntity>();
        for (CadastroMobiliarioAtividadeMeiEntity mobMei : solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
            if (this.contemAtividadeMei(mobMei, solicitacao)) continue;
            meisRemovidos.add(mobMei);
        }
        solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis().removeAll(meisRemovidos);
    }

    private boolean contemAtividadeMei(CadastroMobiliarioAtividadeMeiEntity mobMei, SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.getSolicitacaoAlvaraAtividades().stream().anyMatch(novaAtividade -> novaAtividade.getAtividadeMei().getAtividadeMei().equals(mobMei.getAtividadeMei().getAtividadeMei()));
    }

    private void removerAtividadeCbo(SolicitacaoAlvaraEntity solicitacao) {
        ArrayList<CadastroMobiliarioCboEntity> cbosRemovidos = new ArrayList<CadastroMobiliarioCboEntity>();
        List mobiliarioCbo = solicitacao.getCadastroMobiliario().getMobiliarioCbos();
        for (CadastroMobiliarioCboEntity mobCbo : mobiliarioCbo) {
            if (this.contemCbo(mobCbo, solicitacao)) continue;
            cbosRemovidos.add(mobCbo);
        }
        solicitacao.getCadastroMobiliario().getMobiliarioCbos().removeAll(cbosRemovidos);
    }

    private boolean contemCbo(CadastroMobiliarioCboEntity mobCbo, SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.getSolicitacaoAlvaraAtividades().stream().anyMatch(atividade -> atividade.getSequenciaCbo().equals((Object)mobCbo.getRhCbo()));
    }

    private void newMobiliarioCbo(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        CadastroMobiliarioCboEntity mobCbo = new CadastroMobiliarioCboEntity();
        Long idMobiliarioCbo = this.repositoryCadastroMobiliarioCBO.getSequenceCadastroMobiliarioCBO();
        mobCbo.setIdMobiliarioCbo(idMobiliarioCbo);
        mobCbo.setRhCbo(atividade.getSequenciaCbo());
        mobCbo.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
        mobCbo.setPrincipal(atividade.getPrincipal());
        if (solicitacao.getCadastroMobiliario().getMobiliarioCbos() == null) {
            solicitacao.getCadastroMobiliario().setMobiliarioCbos(new ArrayList());
        }
        solicitacao.getCadastroMobiliario().getMobiliarioCbos().add(mobCbo);
    }

    protected void novoMobiliarioAtividadeMei(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        CadastroMobiliarioAtividadeMeiEntity mobMei = new CadastroMobiliarioAtividadeMeiEntity();
        Long id = this.repositoryCadastroMobiliarioAtividadeMei.getSequenceCadastroMobiliarioAtividadeMei();
        mobMei.setId(id);
        mobMei.setAtividadeMei(atividade.getAtividadeMei());
        mobMei.getAtividadeMei().setCnae(atividade.getAtividadeMei().getCnae());
        mobMei.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
        mobMei.setPrincipal(EloStringUtils.isEmpty((String)atividade.getPrincipal()) ? SimNaoEnum.NAO.getShortText() : atividade.getPrincipal());
        solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis().add(mobMei);
        SolicitacaoAlvaraAtividadeEntity ati = new SolicitacaoAlvaraAtividadeEntity();
        ati.setCnae(atividade.getAtividadeMei().getCnae());
        ati.setPrincipal(EloStringUtils.isEmpty((String)atividade.getPrincipal()) ? SimNaoEnum.NAO.getShortText() : atividade.getPrincipal());
        this.newMobiliarioCnae(solicitacao, ati);
    }

    public void atualizarMobiliarioAtividadeMeiPrincipal(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        for (CadastroMobiliarioAtividadeMeiEntity mobiliarioAtividadeMei : solicitacao.getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
            if (!mobiliarioAtividadeMei.getAtividadeMei().equals((Object)atividade.getAtividadeMei())) continue;
            mobiliarioAtividadeMei.setPrincipal(atividade.getPrincipal());
        }
    }

    private void atualizarMobiliarioCnaePrincipal(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
            if (!mobCnae.getId().getCnae().equals((Object)atividade.getCnae())) continue;
            mobCnae.setCnaePrincipal(atividade.getPrincipal());
        }
    }

    public void atualizarMobiliarioCnaePrincipalMei(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
            if (!mobCnae.getId().getCnae().equals((Object)atividade.getAtividadeMei().getCnae())) continue;
            mobCnae.setCnaePrincipal(atividade.getPrincipal());
        }
    }

    private void updateMobiliarioCbo(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        for (CadastroMobiliarioCboEntity mobCbo : solicitacao.getCadastroMobiliario().getMobiliarioCbos()) {
            mobCbo.setPrincipal("");
            if (!mobCbo.getRhCbo().equals((Object)atividade.getSequenciaCbo())) continue;
            mobCbo.setPrincipal(atividade.getPrincipal());
        }
    }

    private void newMobiliarioCnae(SolicitacaoAlvaraEntity solicitacao, SolicitacaoAlvaraAtividadeEntity atividade) {
        if (solicitacao.getCadastroMobiliario().getMobiliarioCnaes() == null) {
            solicitacao.getCadastroMobiliario().setMobiliarioCnaes(new ArrayList());
        }
        MobiliarioCnaeEntity mobCnae = new MobiliarioCnaeEntity();
        MobiliarioCnaePK id = new MobiliarioCnaePK();
        id.setCnae(atividade.getCnae());
        id.setCadastroMobiliarioEntity(solicitacao.getCadastroMobiliario());
        mobCnae.setId(id);
        mobCnae.setCnaePrincipal(atividade.getPrincipal());
        mobCnae.setGerarLancamento(SimNaoEnum.SIM.getShortText());
        mobCnae.setDataInicio(new Date());
        solicitacao.getCadastroMobiliario().getMobiliarioCnaes().add(mobCnae);
    }

    protected SolicitacaoAlvaraEntity carregaDadosAlvaraInicial(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (Objects.nonNull(solicitacao.getCadastroImobiliario())) {
            solicitacao.getCadastroMobiliario().setCadastroImobiliario(solicitacao.getCadastroImobiliario());
            try {
                solicitacao.setBairroImobiliario(solicitacao.getCadastroMobiliario().getCadastroImobiliario().getCadastroGeral().getBairro().getDescricao());
            }
            catch (NullPointerException e) {
                solicitacao.setBairroImobiliario("");
            }
            solicitacao.setComplementoImobiliario(solicitacao.getCadastroMobiliario().getCadastroImobiliario().getComplementoLote());
            if (UtilsController.isUtilizaEnderecoCadastroGeral()) {
                if (solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro() == null) {
                    throw new SolicitacaoAlvaraException("O Cadastro Imobili\u00e1rio dessa Solicita\u00e7\u00e3o n\u00e3o possui Logradouro.");
                }
                solicitacao.setLogradouroImobiliario(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro().getDescricao());
            } else {
                if (solicitacao.getTestada() == null) {
                    throw new SolicitacaoAlvaraException("A Solicita\u00e7\u00e3o de Alvar\u00e1 n\u00e3o possui testada vinculada.");
                }
                if (solicitacao.getTestada().getLogradouro() == null) {
                    throw new SolicitacaoAlvaraException("A Testada desta Solicita\u00e7\u00e3o n\u00e3o possui logradouro.");
                }
                solicitacao.setLogradouroImobiliario(solicitacao.getTestada().getLogradouro().getDescricao());
            }
            solicitacao.setQuadraImobiliario(solicitacao.getDescricaoQuadra());
        }
        Optional.ofNullable(solicitacao.getCadastroMobiliario().getCadastroGeral()).ifPresent(cadastroGeral -> {
            cadastroGeral.getPessoa().setNome(solicitacao.getNomeRazaoSocial());
            cadastroGeral.getPessoa().setNomeFantasia(solicitacao.getFantasia());
            cadastroGeral.getPessoa().setCnpjCpf(solicitacao.getCpfCnpj());
            cadastroGeral.getPessoa().setRg(solicitacao.getRg());
            cadastroGeral.getPessoa().setOrgaoEmissor(solicitacao.getRgOrgaoEmissor());
            cadastroGeral.getPessoa().setEstadoEmissor(solicitacao.getRgUfEmissor());
            cadastroGeral.getPessoa().setDataEmissao(solicitacao.getRgDataEmissao());
            cadastroGeral.getPessoa().setInativo(SimNaoEnum.getNaoShortText());
            cadastroGeral.getPessoa().setDataInclusao(new Date());
            if (EloStringUtils.isEmpty((String)cadastroGeral.getPessoa().getUsuarioInclusao())) {
                cadastroGeral.getPessoa().setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            }
            if (cadastroGeral.getPessoa().getCnpjCpf().length() > 11) {
                cadastroGeral.getPessoa().setTipoPessoa(TipoPessoaEnum.JURIDICA.getSigla());
            } else {
                cadastroGeral.getPessoa().setTipoPessoa(TipoPessoaEnum.FISICA.getSigla());
            }
            cadastroGeral.setCorrespondenciaLocal(SimNaoEnum.getSimShortText());
        });
        solicitacao.getCadastroMobiliario().setTelefone(solicitacao.getTelefonePreenchido());
        solicitacao.getCadastroMobiliario().setAtividadePrincipal(solicitacao.getDescricaoAtividades());
        solicitacao.getCadastroMobiliario().setDataAbertura(new Date());
        solicitacao.getCadastroMobiliario().setPessoaMobiliario(solicitacao.getPessoaMobiliario());
        solicitacao.setDataSolicitacao(new Date());
        if (!solicitacao.isSolicitacaoPrestadorServico()) {
            solicitacao.getCadastroMobiliario().setAreaUtilizada(this.getAreaTotal(solicitacao));
            solicitacao.getCadastroMobiliario().setAreaBombeiro(this.getAreaTotal(solicitacao));
            solicitacao.getCadastroMobiliario().setAreaPatio(solicitacao.getAreaPatio());
            solicitacao.getCadastroMobiliario().setAreaConstruida(solicitacao.getAreaConstruida());
        }
        this.preencheEnderecoCadastroGeral(solicitacao);
        return solicitacao;
    }

    protected CadastroGeralAiseEntity preencheEnderecoCadastroGeral(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CadastroGeralAiseEntity cadastroGeral = solicitacao.getCadastroMobiliario().getCadastroGeral();
        if (Objects.isNull(solicitacao.getTestada()) && Objects.isNull(solicitacao.getCadastroImobiliario())) {
            this.srvFindEnderecoBySimilarity.addEnderecoCadastroGeral(solicitacao);
        } else {
            SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            Endereco enderecoJson = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa()).getDados_solicitacao().getEmpresa().getEndereco();
            if (UtilsController.isUtilizaEnderecoCadastroGeral()) {
                LogradouroEntity logradouro = Optional.ofNullable(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro()).orElseGet(() -> this.srvFindEnderecoBySimilarity.findDescricaoLogradouroBySimilarity(enderecoJson.getDs_tipo_logradouro().concat(" ").concat(enderecoJson.getDs_endereco())));
                cadastroGeral.setLogradouro(logradouro);
                cadastroGeral.setNumero(solicitacao.getCadastroImobiliario().getCadastroGeral().getNumero());
            } else {
                cadastroGeral.setLogradouro(solicitacao.getTestada().getLogradouro());
                cadastroGeral.setNumero(solicitacao.getTestada().getNumero());
            }
            BairroEntity bairro = Optional.ofNullable(solicitacao.getCadastroImobiliario().getCadastroGeral().getBairro()).orElseGet(() -> this.srvFindEnderecoBySimilarity.findDescricaoBairroBySimilarity(enderecoJson.getDs_bairro()));
            cadastroGeral.setBairro(bairro);
            cadastroGeral.setComplemento(solicitacao.montarComplementoCadastroGeral());
            BigDecimal cep = Optional.ofNullable(solicitacao.getCadastroImobiliario().getCadastroGeral().getCep()).orElse(new BigDecimal(enderecoJson.getCo_cep()));
            cadastroGeral.setCep(cep);
            solicitacao.getCadastroMobiliario().setCadastroImobiliario(solicitacao.getCadastroImobiliario());
        }
        return cadastroGeral;
    }

    protected EnderecoPessoaEntity carregaDadosNoEndPessoa(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        EnderecoPessoaEntity enderecoPessoa = new EnderecoPessoaEntity();
        enderecoPessoa.setTipoEndereco(EnderecoTipoEnum.COMERCIAL.getId().toString());
        try {
            if (Objects.nonNull(solicitacao.getCadastroImobiliario()) && Objects.nonNull(solicitacao.getTestada())) {
                enderecoPessoa.setBairro(solicitacao.getCadastroImobiliario().getCadastroGeral().getBairro());
                if (UtilsController.isUtilizaEnderecoCadastroGeral()) {
                    enderecoPessoa.setLogradouro(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro().getId().getLogradouro());
                    enderecoPessoa.setLogradouroEndereco(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro());
                    enderecoPessoa.setNumero(solicitacao.getCadastroImobiliario().getCadastroGeral().getNumero());
                } else {
                    enderecoPessoa.setLogradouro(solicitacao.getTestada().getLogradouro().getId().getLogradouro());
                    enderecoPessoa.setLogradouroEndereco(solicitacao.getTestada().getLogradouro());
                    enderecoPessoa.setNumero(solicitacao.getTestada().getNumero());
                }
                enderecoPessoa.setComplemento(solicitacao.montarComplementoCadastroGeral());
                EnderecoCadastroGeralEntity enderecoPrincipal = this.buscaEnderecoPrincipal(solicitacao.getCadastroImobiliario());
                enderecoPessoa.setCep(Objects.nonNull(enderecoPrincipal) && !EloStringUtils.isEmpty((String)enderecoPrincipal.getCep()) ? Long.valueOf(EloStringUtils.retiraChars((String)enderecoPrincipal.getCep(), (char[])new char[]{'.', '-', '/'})) : null);
                enderecoPessoa.setUnidadeFederacao(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro().getId().getCidade().getUnidadeFederacao().getId().getUnidadeFederacao());
                return enderecoPessoa;
            }
            this.srvFindEnderecoBySimilarity.addEnderecoCadastroGeral(solicitacao);
            enderecoPessoa = this.preencherEnderecoPessoa(solicitacao.getCadastroMobiliario().getCadastroGeral());
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException("Ocorreu uma falha ao carregar os dados na tabela endere\u00e7o pessoa ", e.getCause());
        }
        return enderecoPessoa;
    }

    private EnderecoCadastroGeralEntity buscaEnderecoPrincipal(CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        return this.repositoryEnderecoCadastroGeral.buscaEnderecoImobiliarioPrincipal(cadastroImobiliario.getId().getCodigo());
    }

    protected void atualizarCadastroMobExistente(SolicitacaoAlvaraEntity solicitacao, Long cmcResponsavel, PessoaEntity pessoaExistente, CadastroMobiliarioEntity cadastroMobiliarioExistente) throws BaseException {
        if (pessoaExistente == null) {
            cadastroMobiliarioExistente.getCadastroGeral().setPessoa(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa());
        } else {
            cadastroMobiliarioExistente.getCadastroGeral().getPessoa().setNome(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
            cadastroMobiliarioExistente.getCadastroGeral().getPessoa().setNomeFantasia(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNomeFantasia());
            cadastroMobiliarioExistente.getCadastroGeral().getPessoa().setCnpjCpf(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
            solicitacao.setNomeRazaoSocial(pessoaExistente.getNome());
        }
        cadastroMobiliarioExistente.getCadastroGeral().setComplemento("");
        cadastroMobiliarioExistente.setTelefone(solicitacao.getCadastroMobiliario().getTelefone());
        cadastroMobiliarioExistente.setAtividadePrincipal(solicitacao.getCadastroMobiliario().getAtividadePrincipal());
        cadastroMobiliarioExistente.setPessoaMobiliario(solicitacao.getPessoaMobiliario());
        cadastroMobiliarioExistente.setAreaBombeiro(solicitacao.getAreaUtilizada());
        cadastroMobiliarioExistente.setAreaUtilizada(this.getAreaTotal(solicitacao));
        cadastroMobiliarioExistente.setAreaPatio(solicitacao.getAreaPatio());
        cadastroMobiliarioExistente.setAreaConstruida(solicitacao.getAreaConstruida());
        if (cmcResponsavel != null) {
            cadastroMobiliarioExistente.setCmcresponsavel(cmcResponsavel);
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) {
            for (MobiliarioCnaeEntity mobiliarioCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
                mobiliarioCnae.getId().setCadastroMobiliarioEntity(cadastroMobiliarioExistente);
            }
            cadastroMobiliarioExistente.setMobiliarioCnaes(solicitacao.getCadastroMobiliario().getMobiliarioCnaes());
        }
        cadastroMobiliarioExistente.setCadastroImobiliario(solicitacao.getCadastroMobiliario().getCadastroImobiliario());
        cadastroMobiliarioExistente.getCadastroImobiliario().getCadastroGeral().setBairro(solicitacao.getCadastroMobiliario().getCadastroImobiliario().getCadastroGeral().getBairro());
        cadastroMobiliarioExistente.getCadastroImobiliario().setComplementoLote(solicitacao.getCadastroMobiliario().getCadastroImobiliario().getComplementoLote());
        cadastroMobiliarioExistente.getCadastroGeral().setComplemento(solicitacao.getCadastroMobiliario().getCadastroGeral().getComplemento());
        if (UtilsController.isUtilizaEnderecoCadastroGeral()) {
            cadastroMobiliarioExistente.getCadastroGeral().setLogradouro(solicitacao.getCadastroImobiliario().getCadastroGeral().getLogradouro());
            cadastroMobiliarioExistente.getCadastroGeral().setNumero(solicitacao.getCadastroImobiliario().getCadastroGeral().getNumero());
        } else {
            cadastroMobiliarioExistente.getCadastroGeral().setLogradouro(solicitacao.getImobiliarioTestada().getId().getLogradouroTestada().getLogradouro());
            cadastroMobiliarioExistente.getCadastroGeral().setNumero(solicitacao.getImobiliarioTestada().getNumero());
        }
        if (solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf().length() == 14) {
            cadastroMobiliarioExistente.getCadastroGeral().getPessoa().setTipoPessoa("J");
        } else {
            cadastroMobiliarioExistente.getCadastroGeral().getPessoa().setTipoPessoa("F");
        }
        solicitacao.setCadastroMobiliario(cadastroMobiliarioExistente);
    }

    protected ContatoPessoaEntity criarContatoPessoa(SolicitacaoAlvaraEntity solicitacaoAlvara, CadastroGeralAiseEntity cadastroGeral) throws UnicoClientException {
        this.logger.info((Object)"CRIANDO CONTATOPESSOA CNPJ....");
        ContatoPessoaPK id = new ContatoPessoaPK();
        id.setPessoa(cadastroGeral.getPessoa());
        ContatoPessoaEntity contatoPessoa = new ContatoPessoaEntity();
        contatoPessoa.setId(id);
        contatoPessoa.setNome(cadastroGeral.getPessoa().getNome());
        contatoPessoa.setEmail(solicitacaoAlvara.getEmail());
        contatoPessoa.setTelefoneComercial(solicitacaoAlvara.getTelefone());
        contatoPessoa.setTelefoneCelular(solicitacaoAlvara.getTelefoneCelular());
        contatoPessoa = this.salvarContatoPessoa(contatoPessoa);
        cadastroGeral.getPessoa().setContatoPessoaPrincipal(contatoPessoa);
        return contatoPessoa;
    }

    public void adicionaSolicitacaoContratoSocial(SolicitacaoAlvaraEntity solicitacaoAlvara) throws UnicoClientException {
        SolicitacaoContratoSocialEntity solicitacaoContratoSocial = solicitacaoAlvara.getContratoSocial();
        if (solicitacaoContratoSocial != null) {
            if (solicitacaoContratoSocial.getId() == null) {
                solicitacaoContratoSocial.setId(this.nextSequenceSolicitacaoContratoSocial());
            }
            this.logger.info((Object)String.format("Quantidade de pessoas do contrato social: %d", solicitacaoContratoSocial.getPessoas().size()));
            for (SolicitacaoContratoSocialPessoaEntity solicitacaoContratoPessoa : solicitacaoContratoSocial.getPessoas()) {
                if (Objects.isNull(solicitacaoContratoPessoa.getId())) {
                    solicitacaoContratoPessoa.setId(this.nextSequenceSolicitacaoContratoSocial());
                }
                if (!this.srvUnico.isIntegradoTotal()) {
                    solicitacaoContratoPessoa.setPessoa(this.salvarPessoa(solicitacaoContratoPessoa.getPessoa()));
                    continue;
                }
                this.logger.info((Object)"adicionaSolicitacaoContratoSocial-------");
                solicitacaoContratoPessoa.setPessoa(this.salvarPessoa(solicitacaoContratoPessoa.getPessoa()));
                if (!Objects.isNull(solicitacaoContratoPessoa.getPessoa())) continue;
                throw new UnicoClientException("Falha ao salvar a pessoa no \u00danico");
            }
            this.logger.info((Object)String.format("M\u00e9todo: adicionaSolicitacaoContratoSocial - Preenchido a solicita\u00e7\u00e3o do alvar\u00e1 %d com a solicita\u00e7\u00e3o de contrato social: %d", solicitacaoAlvara.getSolicitacaoAlvara(), solicitacaoContratoSocial.getId()));
            solicitacaoAlvara.setContratoSocial(this.repositorySolicitacaoContratoSocial.saveOrUpdate(solicitacaoContratoSocial));
        }
    }

    public void salvarAlteracaoSocio(SolicitacaoAlvaraEntity solicitacao) throws UnicoClientException, BaseException {
        ContratoSocialEntity contratoSocial = this.atualizaContratoSocialCadastroMobiliario(solicitacao, false);
        if (contratoSocial != null) {
            ModeloIdentificacaoEntity modeloIdentificacaoEntity;
            int qtdSociosNovoContrato;
            int qtdSociosContratoAnterior = 0;
            ContratoSocialEntity ultimoContrato = this.repositoryContratoSocial.getUltimoContratoSocial(solicitacao.getCadastroMobiliario());
            if (ultimoContrato != null) {
                qtdSociosContratoAnterior = ultimoContrato.getPessoas().size();
            }
            if (qtdSociosContratoAnterior != (qtdSociosNovoContrato = contratoSocial.getPessoas().size()) && (modeloIdentificacaoEntity = this.repositoryModeloIdentificacao.getNumeroSocios()) != null) {
                ModeloCampoEntity modeloCampo;
                CadastroGeralAiseEntity cadastroGeral = solicitacao.getCadastroMobiliario().getCadastroGeral();
                BoletimMobiliarioEntity boletim = this.repositoryBoletimMobiliario.findByCadastroGeralAndModelCampo(cadastroGeral, modeloCampo = modeloIdentificacaoEntity.getModeloResposta().getId().getModeloCampo());
                if (boletim == null) {
                    boletim = this.criarBoletimMobiliarioEntity(solicitacao.getCadastroMobiliario(), modeloIdentificacaoEntity.getModeloResposta());
                }
                boletim.setDescricaoResposta(String.valueOf(qtdSociosNovoContrato));
                this.repositoryBoletimMobiliario.saveOrUpdate(boletim);
            }
        }
    }

    public BoletimMobiliarioEntity criarBoletimMobiliarioEntity(CadastroMobiliarioEntity cadastroMobiliario, ModeloRespostaEntity modeloResposta) {
        BoletimMobiliarioEntity boletimMobiliarioEntity = new BoletimMobiliarioEntity();
        BoletimMobiliarioPK boletimMobiliarioPK = new BoletimMobiliarioPK();
        boletimMobiliarioPK.setCadastroMobiliario(cadastroMobiliario);
        boletimMobiliarioPK.setModeloResposta(modeloResposta);
        boletimMobiliarioEntity.setId(boletimMobiliarioPK);
        return boletimMobiliarioEntity;
    }

    public boolean isDocumentoComSituacaoValida(List<SolicitacaoAlvaraDocumentoEntity> listaDocumentos) {
        boolean renderBotao = true;
        if (!EloListUtils.safeIsEmpty(listaDocumentos).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : listaDocumentos) {
                if (!documento.isDocumentoEmAnalise() && (!documento.isDocumentoNaoValidado() || this.possuiOutroDocumentoValidadoParaMesmoTipo(documento.getTipoDocumento(), listaDocumentos) || documento.getSolicitacaoAlvara().isRedeSim())) continue;
                renderBotao = false;
                break;
            }
        } else {
            renderBotao = false;
        }
        return renderBotao;
    }

    private boolean possuiOutroDocumentoValidadoParaMesmoTipo(TipoDocumentoEntity tipoDocumento, List<SolicitacaoAlvaraDocumentoEntity> listaDocumentos) {
        return listaDocumentos.stream().anyMatch(doc -> tipoDocumento.getTipoDocumento().equals(doc.getTipoDocumento().getTipoDocumento()) && doc.isDocumentoValidado());
    }

    protected void verificaSituacaoVencidoOuDesatualizado(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaValidadeAlvaraAtual = this.repositorySolicitacaoValidade.retornaValidadeBySolicitacao(solicitacao);
        if (7L == this.getMobiliarioSituacaoAtual(solicitacao).getSituacaoMobiliario().getId()) {
            List listaValidadeAlvaraCorrente = this.carregaListaVencimentoAlvara(solicitacao);
            if (solicitacao.possuiTodosLaudosLiberadoDefinitivo() || !solicitacao.possuiTodosLaudosLiberadoDefinitivo() && !listaValidadeAlvaraAtual.equals(listaValidadeAlvaraCorrente)) {
                solicitacao.getCadastroMobiliario().setDataValidadeAlvara(this.carregaDataValidadeAlvaraParaCadastroMobiliario(solicitacao));
                if (solicitacao.getCadastroMobiliario().getDataValidadeAlvara() == null || solicitacao.getCadastroMobiliario().getDataValidadeAlvara().compareTo(new Date()) >= 0) {
                    this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacao, solicitacao.isSolicitacaoMEI() ? SituacaoMobiliarioAlvaraEnum.SITUACAO_EMITEISSNAOEMITETAXAS : SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL);
                }
            }
        } else if (6L == this.getMobiliarioSituacaoAtual(solicitacao).getSituacaoMobiliario().getId()) {
            solicitacao.getCadastroMobiliario().setDataEncerramento(null);
            this.srvDebitosPortal.alteraMobiliarioSituacaoParaNormal(solicitacao.getCadastroMobiliario());
        }
    }

    protected MobiliarioSituacaoEntity getMobiliarioSituacaoAtual(SolicitacaoAlvaraEntity solicitacao) {
        MobiliarioSituacaoEntity mobiliarioSituacao = this.repositoryMobiliarioSituacao.situacaoCadastroMobiliario(solicitacao.getCadastroMobiliario().getId().getCodigo());
        return mobiliarioSituacao;
    }

    protected GuiaRecolhimentoEntity getGuiaRecolhimentoByTipoInscricao(SolicitacaoAlvaraEntity solicitacao) {
        TipoInscricaoAlvaraGuiaEntity tipoInscricaoGuia = this.repositoryTipoInscricaoAlvara.carregaTipoInscricaoAlvaraGuiaBySigla(solicitacao.getTipoDeInscricao().getSigla(), this.getExercicio());
        return Optional.ofNullable(tipoInscricaoGuia).map(TipoInscricaoAlvaraGuiaEntity::getGuiaRecolhimento).orElse(null);
    }

    protected SolicitacaoAlvaraEntity adicionaValidadeAlvaraProvisorio(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        Boolean enviaAlvaraProvisorio = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_ALVARA_PROVISORIO_REDE_SIM));
        if (Boolean.FALSE.equals(enviaAlvaraProvisorio)) {
            return solicitacaoAlvara;
        }
        if (solicitacaoAlvara.isNaturezaMudancaArea() && solicitacaoAlvara.getNaturezas().size() == 1 && SimNaoEnum.NAO.getShortText().equals(solicitacaoAlvara.getAreaMaiorQueAtual()) && !solicitacaoAlvara.isSituacaoMobiliarioDesatualizadoOuVencido()) {
            return solicitacaoAlvara;
        }
        ParametroAlvaraEntity param = this.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.DIASALVARAPROVISORIO);
        if (Objects.nonNull(param.getValor()) && Objects.isNull(solicitacaoAlvara.getDataValidadeProvisorio())) {
            try {
                Integer diasAlvaraProvisorio = Integer.parseInt(param.getValor());
                Date dataValidadeAlvara = EloDateUtils.addDay((Date)new Date(), (int)diasAlvaraProvisorio);
                solicitacaoAlvara.setDataValidadeProvisorio(dataValidadeAlvara);
            }
            catch (NumberFormatException ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw new SolicitacaoAlvaraException("Ocorreu um erro ao converter a quantidade de dias do Alvar\u00e1 Provis\u00f3rio. " + ex.getMessage(), (Throwable)ex);
            }
        }
        return solicitacaoAlvara;
    }

    protected Boolean verificaSitCadastroParaAlteracoes(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.possuiTodosLaudosLiberado()) {
            return true;
        }
        if (solicitacao.getCadastroMobiliario().getDataValidadeAlvara() != null) {
            Date validadeAlvaraAnual = this.srvMontaObsAlvara.montarDataValidadeAlvaraAnual();
            if (validadeAlvaraAnual != null && validadeAlvaraAnual.compareTo(solicitacao.getCadastroMobiliario().getDataValidadeAlvara()) == 0) {
                return true;
            }
            Date validadeAlvaraAnualAtual = this.montarDataValidadeAlvaraAnualAtual();
            if (validadeAlvaraAnualAtual != null && validadeAlvaraAnualAtual.compareTo(solicitacao.getCadastroMobiliario().getDataValidadeAlvara()) == 0) {
                return true;
            }
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
                for (LaudoAlvaraEntity laudo : solicitacao.getLaudos()) {
                    if (laudo.getDataValidade() == null || laudo.getDataValidade().compareTo(solicitacao.getCadastroMobiliario().getDataValidadeAlvara()) != 0) continue;
                    return true;
                }
            }
            if (solicitacao.getDataValidadeSefaz() != null && solicitacao.getDataValidadeSefaz().compareTo(solicitacao.getCadastroMobiliario().getDataValidadeAlvara()) == 0) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void atualizarContatoPessoa(SolicitacaoAlvaraEntity solicitacao) throws UnicoClientException {
        PessoaEntity pessoa = solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa();
        ContatoPessoaEntity contato = pessoa.getPessoaContatoPrincipalOuMaisRecente();
        if (Objects.nonNull(contato)) {
            contato.setEmail(solicitacao.getEmail());
            contato.setTelefoneComercial(solicitacao.getTelefone());
            contato.setTelefoneCelular(solicitacao.getTelefoneCelular());
            this.srvContatoPessoa.salvar(contato);
        } else {
            ContatoPessoaEntity contatoPessoa = this.criarContatoPessoa(solicitacao, solicitacao.getCadastroMobiliario().getCadastroGeral());
            solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().setContatoPessoaPrincipal(contatoPessoa);
            this.salvarPessoa(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa());
        }
        if (this.srvUnico.isIntegradoTotal()) {
            this.repositoryPessoa.refresh(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa());
        }
    }

    public void salvarAlteracaoRazaoSocial(SolicitacaoAlvaraEntity solicitacao) throws UnicoClientException {
        solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().setNome(solicitacao.getNomeRazaoSocial());
        solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().setNomeFantasia(solicitacao.getFantasia());
        this.srvPessoa.salvar(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa());
    }

    protected void alteraAtividadePrincipalDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (solicitacao.getSolicitacaoAtividadeSelecionada() == null) continue;
            if (atividade.equals((Object)solicitacao.getSolicitacaoAtividadeSelecionada())) {
                atividade.setPrincipal(SimNaoEnum.SIM.getShortText());
                continue;
            }
            atividade.setPrincipal(SimNaoEnum.NAO.getShortText());
        }
    }

    protected void salvarAlteracaoEndereco(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CadastroGeralAiseEntity cadastroGeral = this.salvarCadastroGeral(this.preencheEnderecoCadastroGeral(solicitacao), solicitacao);
        EnderecoPessoaEntity enderecoPessoa = this.preencherEnderecoPessoa(cadastroGeral);
        enderecoPessoa = this.salvarEnderecoPessoa(enderecoPessoa, cadastroGeral.getPessoa());
        this.alterarEnderecoCadastroGeral(solicitacao, enderecoPessoa, cadastroGeral);
        cadastroGeral.setDataAlteracao(new Date());
        CadastroMobiliarioEntity cadastroMobiliario = solicitacao.getCadastroMobiliario();
        cadastroMobiliario.setCadastroGeral(cadastroGeral);
        this.salvarCadastroMobiliario(cadastroMobiliario);
        PessoaEntity pessoaSalva = this.srvPessoa.salvar(cadastroGeral.getPessoa());
        cadastroGeral.setPessoa(pessoaSalva);
        cadastroGeral = this.salvarCadastroGeral(cadastroGeral, solicitacao);
        if (Objects.nonNull(enderecoPessoa.getBairro())) {
            this.updateBairroCadastroGeral(cadastroGeral, enderecoPessoa.getBairro().getId());
        }
    }

    private EnderecoPessoaEntity preencherEnderecoPessoa(CadastroGeralAiseEntity cadastroGeral) throws BaseException {
        EnderecoPessoaEntity enderecoPessoa = new EnderecoPessoaEntity();
        enderecoPessoa.setNumero(cadastroGeral.getNumero());
        enderecoPessoa.setCep(Long.valueOf(cadastroGeral.getCep().longValue()));
        enderecoPessoa.setBairro(cadastroGeral.getBairro());
        enderecoPessoa.setComplemento(cadastroGeral.getComplemento());
        if (Objects.nonNull(cadastroGeral.getLogradouro())) {
            enderecoPessoa.setLogradouroEndereco(cadastroGeral.getLogradouro());
            enderecoPessoa.setLogradouro(cadastroGeral.getLogradouro().getId().getLogradouro());
            enderecoPessoa.setUnidadeFederacao(cadastroGeral.getLogradouro().getId().getCidade().getUnidadeFederacao().getId().getUnidadeFederacao());
        }
        return enderecoPessoa;
    }

    public UsuarioEntity getUsuarioIntegraSGO() {
        return this.repositoryUsuario.getUsuarioIntegraSGO();
    }

    protected void salvarAlteracaoArea(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        this.alteraAreasNoCadastro(solicitacao);
        CadastroMobiliarioEntity cadastroMobiliarioSalvo = this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario());
        solicitacao.setCadastroMobiliario(cadastroMobiliarioSalvo);
    }

    protected void alteraAreasNoCadastro(SolicitacaoAlvaraEntity solicitacao) {
        solicitacao.setAreaConstruida(solicitacao.getAreaConstruida() != null ? solicitacao.getAreaConstruida() : BigDecimal.ZERO);
        solicitacao.setAreaPatio(solicitacao.getAreaPatio() != null ? solicitacao.getAreaPatio() : BigDecimal.ZERO);
        solicitacao.getCadastroMobiliario().setAreaBombeiro(solicitacao.getAreaConstruida().add(solicitacao.getAreaPatio()));
        solicitacao.getCadastroMobiliario().setAreaUtilizada(solicitacao.getAreaConstruida().add(solicitacao.getAreaPatio()));
        solicitacao.getCadastroMobiliario().setAreaPatio(solicitacao.getAreaPatio());
        solicitacao.getCadastroMobiliario().setAreaConstruida(solicitacao.getAreaConstruida());
    }

    protected void updateBairroCadastroGeral(CadastroGeralAiseEntity cadastroGeral, BairroPK idBairro) {
        if (idBairro != null) {
            String sql = " UPDATE TRIBCADASTROGERAL SET BAIRRO = ? WHERE CADASTROGERAL = ? AND TIPOCADASTRO = ?";
            EloSqlUtils.executeUpdateQuery((String)sql, (Object[])new Object[]{idBairro.getBairro(), cadastroGeral.getId().getCodigo(), cadastroGeral.getId().getTipo()});
        }
    }

    protected void getUtilizaMobiliarioAtividade(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ParametroAlvaraEntity utilizaMobiliarioAtividade = this.getParametroAlvara(ParametroAlvaraEnum.UTILIZA_MOBILIARIO_ATIVIDADE);
        if (SimNaoEnum.equalSim((String)utilizaMobiliarioAtividade.getValor()).booleanValue()) {
            this.vincularMobiliarioAtividade(solicitacaoAlvara);
            this.verificarCnaesHotelMotel(solicitacaoAlvara);
        }
    }

    protected String getVincularMobiliarioHorarioEspecial() throws SolicitacaoAlvaraException {
        try {
            ParametroAlvaraEntity param = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.VINCULAR_MOBILIARIO_HORARIO_ESPECIAL);
            if (param != null) {
                return param.getValor();
            }
            throw new SolicitacaoAlvaraException(String.format("Par\u00e2metro  %s n\u00e3o configurado.", ParametroAlvaraEnum.VINCULAR_MOBILIARIO_HORARIO_ESPECIAL));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao carregar o par\u00e2metro %s.", ParametroAlvaraEnum.VINCULAR_MOBILIARIO_HORARIO_ESPECIAL));
        }
    }

    protected String getEmailSetorLaudoAlvara() throws SolicitacaoAlvaraException {
        try {
            ParametroAlvaraEntity param = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.EMAILSETORLAUDOALVARA);
            if (param != null) {
                return param.getValor();
            }
            throw new SolicitacaoAlvaraException(String.format("Par\u00e2metro  %s n\u00e3o configurado.", ParametroAlvaraEnum.EMAILSETORLAUDOALVARA));
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(String.format("Ocorreu um erro ao carregar o par\u00e2metro %s.", ParametroAlvaraEnum.EMAILSETORLAUDOALVARA));
        }
    }

    protected boolean exercicioAtualEqualsDataAbertura(CadastroMobiliarioEntity cadastroMobiliario) {
        return this.getExercicio().equals(this.getAnoAberturaCadastro(cadastroMobiliario));
    }

    protected Long getAnoAberturaCadastro(CadastroMobiliarioEntity cadastroMobiliario) {
        return EloDateUtils.getYear((Date)cadastroMobiliario.getDataAbertura());
    }

    public void addComplemento(SolicitacaoAlvaraEntity solicitacao, String complemento) throws SolicitacaoAlvaraException {
        if (!EloStringUtils.isEmpty((String)complemento)) {
            StringBuilder strComplemento = new StringBuilder();
            if (solicitacao.getCadastroMobiliario().getCadastroGeral().getComplemento() != null && !solicitacao.isNaturezaMudancaEndereco()) {
                strComplemento.append(solicitacao.getCadastroMobiliario().getCadastroGeral().getComplemento().trim()).append("; ");
            }
            strComplemento.append(complemento.trim());
            solicitacao.setComplementoCadGeral(strComplemento.toString().replaceAll("\r", " ").replaceAll("\t", " ").replaceAll("\n", " "));
        }
    }

    public void efetuarAlteracaoSocio(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        boolean todosDocumentosValidados = true;
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getDocumentos()).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : solicitacao.getDocumentos()) {
                if (documento.isDocumentoValidado()) continue;
                todosDocumentosValidados = false;
            }
        } else {
            todosDocumentosValidados = false;
        }
        if (todosDocumentosValidados || solicitacao.isRedeSim()) {
            try {
                this.validarPessoaAPIExterna(solicitacao);
            }
            catch (IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Falha ao consultar a integra\u00e7\u00e3o de pessoas do ISS-e", (Throwable)e);
            }
            solicitacao.setEfetivado(SimNaoEnum.SIM.getShortText());
            this.salvarAlteracaoSocio(solicitacao);
            this.salvarObservacao(solicitacao);
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        }
    }

    public void salvarAtividadesSolicitacao(SolicitacaoAlvaraAtividadeEntity solicitacaoAlvaraAtividade) {
        if (solicitacaoAlvaraAtividade.getNumerosConselho() != null) {
            for (SolicitacaoAlvaraNumConselhoEntity numero : solicitacaoAlvaraAtividade.getNumerosConselho()) {
                if (numero.getId() != null) continue;
                numero.setId(this.repositorySolicitacaoAlvaraNumConselho.getSequence());
            }
        }
        this.repositorySolicitacaoAlvaraAtividade.saveOrUpdate(solicitacaoAlvaraAtividade);
    }

    protected boolean validaSituacaoCadastroParaGerarLaudo() throws BaseException {
        ParametroAlvaraEnum parametro = ParametroAlvaraEnum.VALIDA_SITUACAO_CADASTRO_PARA_GERAR_LAUDO;
        ParametroAlvaraEntity validaSituacaoCadastro = UtilsController.getParametroAlvara((ParametroAlvaraEnum)parametro);
        if (validaSituacaoCadastro != null && validaSituacaoCadastro.getValor() != null) {
            return validaSituacaoCadastro.getValor().equals(SimNaoEnum.SIM.getShortText());
        }
        throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o est\u00e1 configurado.", parametro.name()));
    }

    protected boolean validaAreaMaiorQueAtualParaGerarLaudo() throws BaseException {
        ParametroAlvaraEnum parametro = ParametroAlvaraEnum.VALIDA_AREA_MAIOR_QUE_ATUAL_PARA_GERAR_LAUDO;
        ParametroAlvaraEntity validaArea = UtilsController.getParametroAlvara((ParametroAlvaraEnum)parametro);
        if (validaArea != null && validaArea.getValor() != null) {
            return validaArea.getValor().equals(SimNaoEnum.SIM.getShortText());
        }
        throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o est\u00e1 configurado.", parametro.name()));
    }

    protected boolean geraLaudo(ParametroAlvaraNaturezaEnum parametroEnum, NaturezaSolicitacaoAlvaraEnum naturezaEnum, TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        ParametroAlvaraNaturezaEntity parametro = this.getParamAlvaraNatureza(parametroEnum, this.getNatureza(naturezaEnum.getValue()), tipoInscricao);
        if (parametro != null && parametro.getValor() != null) {
            return parametro.getValor().equals(SimNaoEnum.SIM.getShortText());
        }
        throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o est\u00e1 configurado para %s", parametroEnum.name(), naturezaEnum.name()));
    }

    public Long nextNumeroContratoSocialByCadastroGeral(CadastroGeralAisePK cadastroGeralAisePK) {
        ContratoSocialEntity contrato = this.repositoryContratoSocial.findLastContratoByCadastroGeral(cadastroGeralAisePK);
        if (contrato != null && contrato.getNumeroAlteracao() != null) {
            return contrato.getNumeroAlteracao() + 1L;
        }
        return 1L;
    }

    public void validarDocumento(SolicitacaoAlvaraDocumentoEntity documento) throws BaseException {
        if (documento.idIsNull()) {
            documento.setSolicitacaoAlvaraDocumento(this.repositorySolicitacaoAlvaraDocumento.getSequence());
        }
        this.repositorySolicitacaoAlvaraDocumento.saveOrUpdate(documento);
        SolicitacaoAlvaraEntity solicitacaoSelecionada = documento.getSolicitacaoAlvara();
        if (solicitacaoSelecionada.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS}) && "N".equals(solicitacaoSelecionada.getEfetivado())) {
            this.efetuarAlteracaoSocio(solicitacaoSelecionada);
        }
    }

    private Date montarDataValidadeAlvaraAnualAtual() throws BaseException {
        Date dataValidadeAnual = null;
        try {
            ParametroAlvaraEntity parametroValidadeAlvara = this.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.VALIDADE_ALVARA_ANUAL);
            if (parametroValidadeAlvara != null && !EloStringUtils.isEmpty((String)parametroValidadeAlvara.getValor())) {
                Long exercicioAtual = this.getExercicio();
                String dataValidade = parametroValidadeAlvara.getValor() + "/" + exercicioAtual;
                dataValidadeAnual = EloDateUtils.fromDateString((String)dataValidade);
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel montar a data de validade anual do alvar\u00e1. " + e.getMessage());
        }
        return dataValidadeAnual;
    }

    public void verificaSituacaoEmAnalise(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        SituacaoMobiliarioAlvaraEnum situacao = null;
        CadastroMobiliarioEntity cadastroMobiliario = solicitacao.getCadastroMobiliario();
        boolean situacaoAlvaraVencido = this.isSituacaoMobiliarioAlvaraVencido(cadastroMobiliario);
        if (solicitacao.isSolicitacaoMEIPrestador() && situacaoAlvaraVencido) {
            situacao = SituacaoMobiliarioAlvaraEnum.SITUACAO_NAOEMITEISSEMITETAXAS;
        } else {
            SituacaoMobiliarioAlvaraEnum situacaoMobiliarioAlvara = SituacaoMobiliarioAlvaraEnum.SITUACAO_INICIAL_MOBILIARIO;
            if (SimNaoEnum.equalSim((String)this.getParametroAlvara(ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS).getValor()).booleanValue()) {
                situacaoMobiliarioAlvara = SituacaoMobiliarioAlvaraEnum.SITUACAO_CADASTRO_ATUALIZADO_PELA_JUNTA;
            }
            if (this.temSituacao(cadastroMobiliario, situacaoMobiliarioAlvara)) {
                situacao = SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL;
            }
        }
        if (Objects.nonNull(situacao)) {
            this.srvDebitosPortal.alteraMobiliarioSituacao(solicitacao, situacao);
        }
    }

    private boolean temSituacao(CadastroMobiliarioEntity cadastroMobiliario, SituacaoMobiliarioAlvaraEnum situacao) {
        SituacaoMobiliarioEntity situacaoAise = this.repositorySituacaoMobiliario.getSituacaoMobiliario(situacao);
        return Objects.nonNull(situacaoAise) && cadastroMobiliario.getMobiliarioSituacaoAtual().getId().equals(situacaoAise.getId());
    }

    private boolean isSituacaoMobiliarioAlvaraVencido(CadastroMobiliarioEntity cadastroMobiliario) {
        return this.temSituacao(cadastroMobiliario, SituacaoMobiliarioAlvaraEnum.SITUACAO_VENCIDO);
    }

    protected RegimeFiscalPeriodoRealAiseEntity criarRegimeFiscal(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.getRegimeFiscalPeriodo().setIdCadastro(solicitacao.getCadastroMobiliario().getCadastroGeral().getIdUnico());
        return solicitacao.getRegimeFiscalPeriodo();
    }

    protected void salvarRegimeFiscal(RegimeFiscalPeriodoRealAiseEntity regimeFiscalPeriodo) {
        this.repositoryRegimeFiscalPeriodoRealAise.saveOrUpdate(regimeFiscalPeriodo);
        this.repositoryRegimeFiscalPeriodoRealAise.flush();
    }

    public TipoInscricaoAlvaraEntity carregarTipoInscricaoDoMobiliario(CadastroMobiliarioEntity cadastroMobiliario) {
        TipoInscricaoAlvaraEntity tipoInscricaoAlvara = null;
        List tiposIncricaoAlvara = this.repositoryNaturezaSolicitacaoTipoInscricaoAlvara.carregarTiposInscricaoAlvaraAtivos();
        Map tiposInscricao = this.criarMapTipoInscricaoPorSigla(tiposIncricaoAlvara);
        tipoInscricaoAlvara = tiposInscricao.get("M") != null ? this.carregarTipoInscricaoDoMobiliarioMeiAtivo(cadastroMobiliario, tiposInscricao) : this.carregarTipoInscricaoDoMobiliarioMeiInativo(cadastroMobiliario, tiposInscricao);
        return tipoInscricaoAlvara;
    }

    private TipoInscricaoAlvaraEntity carregarTipoInscricaoDoMobiliarioMeiInativo(CadastroMobiliarioEntity cadastroMobiliario, Map<String, TipoInscricaoAlvaraEntity> tiposInscricao) {
        TipoInscricaoAlvaraEntity tipoInscricaoAlvara = null;
        try {
            tipoInscricaoAlvara = cadastroMobiliario.getPessoaMobiliario().getPessoaMobiliario().equals(this.getPessoaMobiliarioMei().getPessoaMobiliario()) ? tiposInscricao.get("M") : (EloNumberUtils.isBiggerThanZero((Number)cadastroMobiliario.getAreaUtilizada()).booleanValue() ? ("J".equals(cadastroMobiliario.getCadastroGeral().getPessoa().getTipoPessoa()) ? tiposInscricao.get("N") : tiposInscricao.get("C")) : tiposInscricao.get("P"));
        }
        catch (BaseException e) {
            this.logger.error((Object)String.format("Falha ao carregar o objeto pessoa mobili\u00e1rio : %s", e.getMessage()), (Throwable)e);
        }
        return tipoInscricaoAlvara;
    }

    private TipoInscricaoAlvaraEntity carregarTipoInscricaoDoMobiliarioMeiAtivo(CadastroMobiliarioEntity cadastroMobiliario, Map<String, TipoInscricaoAlvaraEntity> tiposInscricao) {
        TipoInscricaoAlvaraEntity tipoInscricaoAlvara = null;
        if (!EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioAtividadeMeis()).booleanValue()) {
            tipoInscricaoAlvara = tiposInscricao.get("M");
        } else if (!EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioCnaes()).booleanValue()) {
            tipoInscricaoAlvara = tiposInscricao.get("N");
        } else if (!EloListUtils.safeIsEmpty((List)cadastroMobiliario.getMobiliarioCbos()).booleanValue()) {
            tipoInscricaoAlvara = tiposInscricao.get("C");
        }
        return tipoInscricaoAlvara;
    }

    private Map<String, TipoInscricaoAlvaraEntity> criarMapTipoInscricaoPorSigla(List<TipoInscricaoAlvaraEntity> tiposIncricaoAlvara) {
        HashMap tiposInscricao = Maps.newHashMap();
        for (TipoInscricaoAlvaraEntity tipo : tiposIncricaoAlvara) {
            tiposInscricao.put(tipo.getSigla(), tipo);
        }
        return tiposInscricao;
    }

    private PessoaMobiliarioEntity getPessoaMobiliarioMei() throws BaseException {
        ParametroAlvaraEntity param = this.getParametroAlvara(ParametroAlvaraEnum.TIPOPESSOA_MEI);
        PessoaMobiliarioEntity pessoaMobiliario = null;
        if (Objects.nonNull(param) && Objects.nonNull(param.getValor())) {
            pessoaMobiliario = this.repositoryPessoaMobiliario.load(Long.valueOf(param.getValor()));
        }
        return pessoaMobiliario;
    }

    public void validarImpressaoLicencaSanitaria(SolicitacaoAlvaraEntity solicitacao) throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        if (solicitacao.hasLaudoNaoLiberado(solicitacao)) {
            ve.adicionarMensagem("Todos os Laudos devem estar liberados!");
        }
        ve.lancarException();
    }

    public void imprimirLicencaSanitaria(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.validarImpressaoLicencaSanitaria(solicitacao);
        DocumentoAiseEntity licencaSanitariaMaisRecente = this.repositoryDocumentoAise.getLicencaSanitariaMaisRecente(solicitacao.getCadastroMobiliario().getId(), (List)Lists.newArrayList((Object[])new Long[]{DocumentoTipoEnum.LICENCA_SANITARIA.getCodigo(), DocumentoTipoEnum.LICENCA_SANITARIA_PROVISORIA.getCodigo()}));
        this.validarDocumentoParaImpressao(licencaSanitariaMaisRecente);
        try {
            this.imprimeDocumentoAlvara.reimpressaoDocumentoAlvara(Long.toString(licencaSanitariaMaisRecente.getId().getDocumento()), licencaSanitariaMaisRecente.getId().getExercicio(), licencaSanitariaMaisRecente.getId().getTipoDocumento().getTipoDocumento());
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidacaoException(e.getMessage());
        }
    }

    public void imprimirDocumento(CadastroGeralAisePK cadastrogeral, Long tipoDocumento) throws BaseException {
        DocumentoAiseEntity documento = this.getUltimoDocumentoEmitido(cadastrogeral, tipoDocumento);
        this.validarDocumentoParaImpressao(documento);
        try {
            this.imprimeDocumentoAlvara.reimpressaoDocumentoAlvara(Long.toString(documento.getId().getDocumento()), documento.getId().getExercicio(), tipoDocumento);
        }
        catch (URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ValidacaoException(e.getMessage());
        }
    }

    public void validarDocumentoParaImpressao(DocumentoAiseEntity documento) throws ValidacaoException {
        if (documento == null || documento.getId() == null || "S".equals(documento.getCancelado()) || "S".equals(documento.getSituacao().getCancelamento())) {
            throw new ValidacaoException("N\u00e3o foi encontrado nenhum documento para este cadastro. Entre em contato com a prefeitura.");
        }
    }

    public MensagemTipoInscricaoVo definirMensagemTipoInscricao(TipoInscricaoAlvaraEntity tipoInscricao) {
        StringBuilder msg = new StringBuilder("");
        String title = "";
        if (tipoInscricao != null) {
            if ("M".equals(tipoInscricao.getSigla())) {
                title = "Microempreendedor Individual (MEI)";
                msg.append("\u00c9 a pessoa que trabalha por conta pr\u00f3pria e que se legaliza como pequeno ");
                msg.append("empres\u00e1rio. Para ser um microempreendedor individual, \u00e9 necess\u00e1rio faturar ");
                msg.append("no m\u00e1ximo at\u00e9 R$ 60.000,00 por ano e n\u00e3o ter participa\u00e7\u00e3o em ");
                msg.append("outra empresa como s\u00f3cio ou titular. O MEI tamb\u00e9m pode ter um ");
                msg.append("empregado contratado que receba o sal\u00e1rio m\u00ednimo ou o piso da categoria.");
            } else if ("P".equals(tipoInscricao.getSigla())) {
                msg.append("Prestador de Servi\u00e7os sem Alvar\u00e1 de Localiza\u00e7\u00e3o");
                msg.append("\u00c9 uma modalidade de licen\u00e7a para aquelas empresas prestadoras de servi\u00e7os ");
                msg.append("que n\u00e3o possuem atividade localizada, e que necessitam apenas de endere\u00e7o para ");
                msg.append("contato (ponto de refer\u00eancia). A sede da empresa, que dever\u00e1 ser a resid\u00eancia de um ");
                msg.append("dos s\u00f3cios, ser\u00e1 exclusivamente para contato. No local n\u00e3o poder\u00e1 haver atendimento ");
                msg.append("ao p\u00fablico, nem estoque de mercadorias ou equipamentos.");
            } else if ("N".equals(tipoInscricao.getSigla())) {
                title = "Normal (Com alvar\u00e1)";
                msg.append("O Alvar\u00e1 de Localiza\u00e7\u00e3o \u00e9 a licen\u00e7a emitida pela Prefeitura para os ");
                msg.append("estabelecimentos comerciais, industriais, de presta\u00e7\u00e3o de servi\u00e7os ou de outra ");
                msg.append("natureza que poder\u00e1 se estabelecer ou funcionar no Munic\u00edpio, e que atestar\u00e1 as ");
                msg.append("condi\u00e7\u00f5es do estabelecimento concernentes \u00e0 localiza\u00e7\u00e3o, \u00e0 seguran\u00e7a, ");
                msg.append("\u00e0 higiene, \u00e0 sa\u00fade, \u00e0 ordem, aos costumes, ao exerc\u00edcio de atividades dependentes ");
                msg.append("de concess\u00e3o, permiss\u00e3o ou autoriza\u00e7\u00e3o do Poder P\u00fablico, \u00e0 tranq\u00fcilidade p\u00fablica, ");
                msg.append("ao respeito \u00e0 propriedade e aos direitos individuais ou coletivos, \u00e0 garantia do ");
                msg.append("cumprimento da legisla\u00e7\u00e3o urban\u00edstica e demais normas de posturas.");
            }
        }
        return new MensagemTipoInscricaoVo(title, msg.toString());
    }

    public void validarDocObrigatorioPorAtividade(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraDocumentoEntity> documentos) throws BaseException {
        List documentosObrigatorios = this.srvConfiguracaoAtividade.carregarDocumentosPorAtividadeETipoInscricao(solicitacao, TipoConfiguracaoAtividadeDocEnum.RENOVACAO);
        if (!EloListUtils.safeIsEmpty((List)documentosObrigatorios).booleanValue()) {
            for (DocumentoAtividadeTipoInscricaoVo docObrigatorio : documentosObrigatorios) {
                if (!SimNaoEnum.SIM.getShortText().equals(docObrigatorio.getObrigatorio()) || this.isDocValidadoNaSolicitacao(docObrigatorio, solicitacao)) continue;
                if (!EloListUtils.safeIsEmpty(documentos).booleanValue()) {
                    boolean validarDocumentosPorAtividade = Boolean.TRUE;
                    for (SolicitacaoAlvaraDocumentoEntity docRenovacao : documentos) {
                        if (!docObrigatorio.getTipoDocumento().getTipoDocumento().equals(docRenovacao.getTipoDocumento().getTipoDocumento())) continue;
                        validarDocumentosPorAtividade = Boolean.FALSE;
                    }
                    if (!validarDocumentosPorAtividade) continue;
                    throw new SolicitacaoAlvaraException(String.format("O documento %s \u00e9 obrigat\u00f3rio para as atividades da solicita\u00e7\u00e3o", docObrigatorio.getTipoDocumento().getDescricao()));
                }
                throw new SolicitacaoAlvaraException(String.format("O documento %s \u00e9 obrigat\u00f3rio para as atividades da solicita\u00e7\u00e3o", docObrigatorio.getTipoDocumento().getDescricao()));
            }
        }
    }

    private boolean isDocValidadoNaSolicitacao(DocumentoAtividadeTipoInscricaoVo docObrigatorio, SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        return this.possuiOutroDocumentoValidadoParaMesmoTipo(docObrigatorio.getTipoDocumento(), solicitacao.getDocumentos());
    }

    protected boolean isSituacaoValidaTipoPessoaMEI(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.TIPOPESSOA_MEI);
        if (parametro == null) {
            throw new ParametroNaoEncontradoException(EloStringUtils.build((Object[])new Object[]{"Par\u00e2metro ", ParametroAlvaraEnum.TIPOPESSOA_MEI, " n\u00e3o encontrado"}));
        }
        return this.isPessoaValida(cadastroMobiliario, parametro);
    }

    protected boolean isPessoaValida(CadastroMobiliarioEntity cadastroMobiliario, ParametroAlvaraEntity parametro) throws ParametroNaoEncontradoException {
        if (StringUtils.isBlank((CharSequence)parametro.getValor())) {
            throw new ParametroNaoEncontradoException(String.format("O par\u00e2metro %s n\u00e3o est\u00e1 configurado.", parametro.getParametro()));
        }
        String[] tiposPessoa = null;
        if (!EloStringUtils.isEmpty((String)parametro.getValor())) {
            tiposPessoa = parametro.getValor().split(",");
        }
        ArrayList<Object> lista = new ArrayList();
        if (tiposPessoa != null) {
            lista = new ArrayList<String>(Arrays.asList(tiposPessoa));
        }
        return lista.stream().anyMatch(i -> cadastroMobiliario.getPessoaMobiliario().getPessoaMobiliario().toString().equals(i));
    }

    protected void salvarSolicitacaoDocumentos(SolicitacaoAlvaraEntity solicitacao) {
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getDocumentos()).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity doc : solicitacao.getDocumentos()) {
                if (doc.idIsNull()) {
                    doc.setSolicitacaoAlvaraDocumento(this.repositorySolicitacaoAlvaraDocumento.getSequence());
                }
                doc.setSolicitacaoAlvara(solicitacao);
            }
        }
    }

    public Date calcularDataAlvaraProvisorio() throws BaseException {
        try {
            ParametroAlvaraEntity paramDiasAlvaraProvisorio = this.getParametroAlvara(ParametroAlvaraEnum.DIASALVARAPROVISORIO);
            return EloDateUtils.addDay((Date)new Date(), (int)Integer.parseInt(paramDiasAlvaraProvisorio.getValor()));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Ocorreu um erro ao calcular a data do alvar\u00e1 provis\u00f3rio. " + e.getMessage(), (Throwable)e);
        }
    }

    protected void setEnderecoRural(CadastroGeralAiseEntity cadastrogeral, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        cadastrogeral.setLogradouro(this.repositoryLogradouro.findByIdLogradouroIdCidade(solicitacaoAlvara.getLogradouro(), solicitacaoAlvara.getCidadeLogradouro()));
        cadastrogeral.setComplemento(solicitacaoAlvara.getComplementoLogradouro());
        cadastrogeral.setCep(new BigDecimal(Optional.ofNullable(solicitacaoAlvara.getCep()).orElse(0L)));
        cadastrogeral.setNumero(solicitacaoAlvara.getNumero());
        cadastrogeral.setBairro(this.repositoryBairro.findByIdBairroIdCidade(solicitacaoAlvara.getBairro(), solicitacaoAlvara.getCidadeLogradouro()));
    }

    public boolean gerarLaudoLiberadoRiscoBaixo(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        return solicitacaoAlvara.isGrauRiscoBaixo() && SimNaoEnum.getNaoShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_LAUDO_RISCO_B));
    }

    protected void atualizarNaturezaJuridica(SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraRedeSimException {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacaoAlvara.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        SolicitacaoAlvaraRedeSimDTO solicitacaoDTO = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa());
        if (Objects.nonNull(solicitacaoDTO)) {
            NaturezaJuridicaEntity naturezaJuridica = this.repositoryNaturezaJuridica.findById(new Long(solicitacaoDTO.getDados_solicitacao().getEmpresa().getCo_natureza_juridica()));
            Optional.ofNullable(naturezaJuridica).ifPresent(n -> {
                if (solicitacaoAlvara.isSolicitacaoMEI()) {
                    solicitacaoAlvara.setPessoaMobiliario(n.getIdPessoaMobiliarioMEI());
                } else {
                    solicitacaoAlvara.setPessoaMobiliario(n.getIdPessoaMobiliario());
                }
                solicitacaoAlvara.getCadastroMobiliario().setNaturezaJuridica(n);
                solicitacaoAlvara.getCadastroMobiliario().setPessoaMobiliario(solicitacaoAlvara.getPessoaMobiliario());
            });
        }
    }

    public void setRepositoryNaturezaJuridica(RepositoryNaturezaJuridica repositoryNaturezaJuridica) {
        this.repositoryNaturezaJuridica = repositoryNaturezaJuridica;
    }

    public void setSrvFindTipoInscricaoAlvara(SrvFindTipoInscricaoAlvaraImpl srvFindTipoInscricaoAlvara) {
        this.srvFindTipoInscricaoAlvara = srvFindTipoInscricaoAlvara;
    }

    public void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
    }

    public void setRepositoryCnae(RepositoryCnae repositoryCnae) {
        this.repositoryCnae = repositoryCnae;
    }

    public void setSrvFindEnderecoBySimilarity(SrvFindEnderecoBySimilarity srvFindEnderecoBySimilarity) {
        this.srvFindEnderecoBySimilarity = srvFindEnderecoBySimilarity;
    }
}

