/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.portalarrecadacao.exception.GeraDebitoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroMobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvMontaObsAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraImpl;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CategoriaMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ClassificacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioServicoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioServicoPK;
import br.com.elotech.tributacao.domain.aise.NaturezaJuridicaEntity;
import br.com.elotech.tributacao.domain.aise.ServicoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryEnderecoPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.repository.aise.RepositoryServico;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;

@EloService(value="srvSolicitacaoAlvaraCBO")
public class SrvSolicitacaoAlvaraCBOImpl
extends SrvSolicitacaoAlvaraImpl
implements SrvSolicitacaoAlvaraCBO {
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private RepositoryServico repositoryServico;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoValidade;
    @Resource
    private SrvMontaObsAlvara srvMontaObsAlvara;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryEnderecoPessoa repositoryEnderecoPessoa;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, true);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracaoSemLaudo(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.saveSolicitacaoAlvaraEventosAlteracao(solicitacao, false);
    }

    private SolicitacaoAlvaraEntity saveSolicitacaoAlvaraEventosAlteracao(SolicitacaoAlvaraEntity solicitacao, boolean geraLaudos) throws BaseException {
        boolean geraLaudoCBO = false;
        solicitacao.setDataSolicitacao(Calendar.getInstance().getTime());
        this.carregarEsalvarAtividadesNaSolicitacao(solicitacao);
        solicitacao.atribuirGrauRiscoCadastroMobiliario();
        if (this.geraLaudo(ParametroAlvaraNaturezaEnum.GERAR_LAUDO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, solicitacao.getTipoDeInscricao()) && this.validaSituacaoCadastroParaGerarLaudo()) {
            if (this.validaAlteracaoGeraLaudo(solicitacao, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL)) {
                geraLaudoCBO = true;
            }
        } else if (this.geraLaudo(ParametroAlvaraNaturezaEnum.GERAR_LAUDO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, solicitacao.getTipoDeInscricao())) {
            geraLaudoCBO = true;
        }
        if (this.geraLaudo(ParametroAlvaraNaturezaEnum.GERAR_LAUDO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, solicitacao.getTipoDeInscricao())) {
            geraLaudoCBO = true;
        }
        if (this.geraLaudo(ParametroAlvaraNaturezaEnum.GERAR_LAUDO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, solicitacao.getTipoDeInscricao())) {
            this.alteraAtividadePrincipalDaSolicitacao(solicitacao);
            geraLaudoCBO = true;
        }
        if (this.geraLaudo(ParametroAlvaraNaturezaEnum.GERAR_LAUDO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, solicitacao.getTipoDeInscricao())) {
            if (solicitacao.isAreaMaiorQueAtual()) {
                solicitacao.setAreaMaiorQueAtual(SimNaoEnum.SIM.getShortText());
            } else {
                solicitacao.setAreaMaiorQueAtual(SimNaoEnum.NAO.getShortText());
            }
            if (this.validaAreaMaiorQueAtualParaGerarLaudo() || this.validaSituacaoCadastroParaGerarLaudo()) {
                if (solicitacao.isAreaMaiorQueAtual() || solicitacao.isSituacaoMobiliarioDesatualizadoOuVencido()) {
                    geraLaudoCBO = true;
                }
            } else {
                geraLaudoCBO = true;
            }
        }
        if (geraLaudos && geraLaudoCBO) {
            this.geraLaudos(solicitacao);
        }
        solicitacao.setFinalizado(SimNaoEnum.SIM.getShortText());
        solicitacao = this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        this.carregaGrauRiscoDaSolicitacao(solicitacao);
        return solicitacao;
    }

    public void salvarConsultaPreviaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        super.salvarConsultaPreviaSolicitacao(solicitacao);
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoInicial(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean restricaoCadastroExistente) throws BaseException {
        this.salvarSolicitacaoAlvaraInicial(solicitacaoAlvara, restricaoCadastroExistente);
        this.atribuirCategoriaEClassificacaoMobiliario(solicitacaoAlvara.getCadastroMobiliario());
        this.atribuirNaturezaJuridicaMobiliario(solicitacaoAlvara.getCadastroMobiliario());
        this.salvarCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
        this.salvarMobiliarioServicoCBO(solicitacaoAlvara);
        this.geraLaudos(solicitacaoAlvara);
        return solicitacaoAlvara;
    }

    protected void atribuirNaturezaJuridicaMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = this.getParametroAlvara(ParametroAlvaraEnum.NATUREZA_JURIDICA_MOBILIARIO_CBO);
        if (parametro != null && parametro.getValor() != null) {
            NaturezaJuridicaEntity naturezaJuridica = this.repositoryNaturezaJuridica.findById(Long.valueOf(Long.parseLong(parametro.getValor())));
            cadastroMobiliario.setNaturezaJuridica(naturezaJuridica);
        }
    }

    protected void atribuirCategoriaEClassificacaoMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        if (this.utilizaClassificacaoECategoriaMobiliario()) {
            this.setCategoriaMobiliario(cadastroMobiliario);
            this.setClassificacaoMobiliario(cadastroMobiliario);
        }
    }

    private boolean utilizaClassificacaoECategoriaMobiliario() throws BaseException {
        String valorParametro = ((FacadeCadastroMobiliario)SpringContext.getBean(FacadeCadastroMobiliario.class)).getParametroGeral(ParametroGeralEnum.UTILIZACLASSIFCATEGMOBILIARIO);
        return valorParametro != null && valorParametro.equals(SimNaoEnum.SIM.getShortText());
    }

    private void setClassificacaoMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CLASSIFICACAO_MOBILIARIO_CBO);
        if (parametro != null && parametro.getValor() != null) {
            ClassificacaoMobiliarioEntity classificacaoMobiliario = this.repositoryClassificacaoMobiliario.recuperarClassificacaoMobiliario(Long.valueOf(Long.parseLong(parametro.getValor())));
            cadastroMobiliario.setClassificacaoMobiliario(classificacaoMobiliario);
        }
    }

    private void setCategoriaMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        ParametroAlvaraEntity parametro = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CATEGORIA_MOBILIARIO_CBO);
        if (parametro != null && parametro.getValor() != null) {
            CategoriaMobiliarioEntity categoriaMobiliario = this.repositoryCategoriaMobiliario.recuperarCategoriaMobiliario(Long.valueOf(Long.parseLong(parametro.getValor())));
            cadastroMobiliario.setCategoriaMobiliario(categoriaMobiliario);
        }
    }

    private void salvarMobiliarioServicoCBO(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (this.getIntegradoGeo().booleanValue()) {
            EntidadeTributacaoEntity entidadeTributacao = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
            Integer maiorCodigoISSQN = this.srvDebitosPortal.retornaMaiorCodigoISSQN(solicitacao);
            ServicoEntity servico = this.repositoryServico.getServico(entidadeTributacao.getId().getEntidade().getId(), this.getExercicio(), maiorCodigoISSQN);
            if (servico != null) {
                MobiliarioServicoEntity mobiliarioServico = new MobiliarioServicoEntity();
                MobiliarioServicoPK idMobiliarioServico = new MobiliarioServicoPK();
                idMobiliarioServico.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
                idMobiliarioServico.setServico(servico);
                mobiliarioServico.setId(idMobiliarioServico);
                mobiliarioServico.setGerarLancamento(SimNaoEnum.NAO.getShortText());
                mobiliarioServico.setPrincipal(SimNaoEnum.SIM.getShortText());
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).salvarMobiliarioServico(mobiliarioServico);
            } else {
                throw new SolicitacaoAlvaraException("Servi\u00e7o: " + maiorCodigoISSQN + " n\u00e3o encontrado!");
            }
        }
    }

    public ImprimirTaxasAlvara imprimirTaxas(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        try {
            if (!this.cobrarTaxa(solicitacao)) {
                throw new SolicitacaoAlvaraException("N\u00e3o existe taxas para esta solicita\u00e7\u00e3o.");
            }
            if (solicitacao.isGrauRiscoAlto() && !solicitacao.possuiTodosLaudosLiberado()) {
                throw new SolicitacaoAlvaraException("Todos os Laudos devem estar liberados!");
            }
            List debitosAlvara = new ArrayList();
            debitosAlvara = SimNaoEnum.equalSim((String)solicitacao.getRenovacao()) != false ? this.processaSolicitacaoRenovacao(solicitacao, debitosAlvara) : this.processaSolicitacaoNaoRenovacao(solicitacao);
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && solicitacao.getNumeroAlvara() == null && SimNaoEnum.equalNao((String)solicitacao.getEfetivado()).booleanValue()) {
                this.efetivaAlteracaoSolicitacao(solicitacao);
            }
            UsuarioEntity usuario = this.getUsuarioLogadoFromSolicitacao(solicitacao);
            String idBloqueto = null;
            DebitoEntity debitoAlvara = null;
            if (usuario != null) {
                for (DebitoEntity debito : debitosAlvara) {
                    if (debito == null || debito.getParcelas().size() <= 0) continue;
                    if (debito.getId().getGuiaRecolhimento().getGuiaAlvaraOnline() != null && SimNaoEnum.equalSim((String)debito.getId().getGuiaRecolhimento().getGuiaAlvaraOnline()).booleanValue()) {
                        debitoAlvara = debito;
                    } else {
                        Integer bloqueto = this.srvDebitosPortal.geraBloqueto(debito.getParcelas());
                        if (bloqueto != null) {
                            idBloqueto = bloqueto.toString();
                        }
                    }
                    this.logger.info((Object)(">>>>>GUIA " + debito.getId().getGuiaRecolhimento().getId().getGuiaRecolhimento()));
                }
                String carne = this.geraCarne(solicitacao, debitoAlvara);
                if (carne == null && idBloqueto == null) {
                    throw new SolicitacaoAlvaraException("N\u00e3o existe taxas a serem impressas para esta solicita\u00e7\u00e3o.");
                }
                return new ImprimirTaxasAlvara(carne, idBloqueto, UtilsController.getExercicio());
            }
            throw new GeraDebitoException(" Usu\u00e1rio n\u00e3o Autenticado!");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException, URISyntaxException {
        if (this.cobrarTaxa(solicitacao) && Objects.isNull(this.carregarDebitoTaxaMobiliariaDaSolicitacao(solicitacao)) && !this.existeDebitoTaxaMobiliariaNoCadastroNoExercicioAtual(solicitacao).booleanValue()) {
            throw new GeraDebitoException("Clique no bot\u00e3o de Imprimir Taxas antes de Imprimir o Alvar\u00e1");
        }
        if (!this.isImprimeAlvaraComDebitoPendente() && this.isDebitoPendente(solicitacao)) {
            throw new SolicitacaoAlvaraException("A impress\u00e3o do alvar\u00e1 s\u00f3 ser\u00e1 permitida ap\u00f3s o pagamento de todos os d\u00e9bitos, favor comparecer \u00e0 Prefeitura para regulariza\u00e7\u00e3o.");
        }
        if (solicitacao.isGrauRiscoAlto()) {
            if (solicitacao.exigeUploadDocumentos() && !this.isDocumentoComSituacaoValida(solicitacao.getDocumentos())) {
                throw new SolicitacaoAlvaraException("Todos os Documentos devem estar validados!");
            }
            if (!this.isTodosLaudosLiberados(solicitacao)) {
                throw new SolicitacaoAlvaraException("Todos os Laudos devem estar liberados!");
            }
        }
        if (SimNaoEnum.equalNao((String)solicitacao.getRenovacao()).booleanValue()) {
            this.validaImpressaoAlvaraNaoRenovacao(solicitacao);
        } else {
            if (!this.isTodosLaudosLiberados(solicitacao)) {
                throw new SolicitacaoAlvaraException("Todos os Laudos devem estar liberados!");
            }
            if (solicitacao.getDataValidadeSefaz() != null && solicitacao.exigeUploadDocumentos() && (solicitacao.getDocumentos().isEmpty() || !this.isDocumentoComSituacaoValida(solicitacao.getDocumentos()))) {
                throw new SolicitacaoAlvaraException("Todos os Documentos devem estar validados!");
            }
            if (!this.verificaVencimentoLaudo(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("N\u00e3o \u00e9 poss\u00edvel imprimir o alvar\u00e1, existem laudos ou documentos vencidos. Acompanhar a libera\u00e7\u00e3o dos laudos.");
            }
        }
        if (!solicitacao.isNaturezaInicial() && solicitacao.getNumeroAlvara() == null && SimNaoEnum.equalNao((String)solicitacao.getEfetivado()).booleanValue()) {
            this.efetivaAlteracaoSolicitacao(solicitacao);
        }
        List listaValidadeAlvaraAtual = this.repositorySolicitacaoValidade.retornaValidadeBySolicitacao(solicitacao);
        List listaValidadeAlvaraCorrente = this.carregaListaVencimentoAlvara(solicitacao);
        solicitacao.setObservacoes("");
        solicitacao.setObservacoes(this.srvMontaObsAlvara.montaObsAlvara(solicitacao));
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue() && solicitacao.isTodosLaudosLiberados()) {
            solicitacao.setDataValidadeProvisorio(null);
            solicitacao.getCadastroMobiliario().setDataValidadeAlvara(null);
        }
        solicitacao.getCadastroMobiliario().setObservacaoAlvara(solicitacao.getObservacoes());
        solicitacao.setCadastroMobiliario(this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario()));
        this.atualizarSolicitacaoAlvara(solicitacao);
        this.verificaSituacaoEmAnalise(solicitacao);
        this.gerarEImprimirDocumento(listaValidadeAlvaraAtual, listaValidadeAlvaraCorrente, solicitacao);
        this.atualizarSolicitacaoAlvara(solicitacao);
    }

    protected boolean isDebitoPendente(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isNaturezaInicial()) {
            CadastroMobiliarioEntity cadastroMobiliario = solicitacao.getCadastroMobiliario();
            return this.repositoryDebitoParcela.possuiDebitosAPagar(cadastroMobiliario.getCadastroGeral().getId().getTipo(), cadastroMobiliario.getCadastroGeral().getId().getCodigo());
        }
        return this.isPrimeiraParcelaPaga(solicitacao);
    }

    protected void validaImpressaoAlvaraNaoRenovacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List debitosAlvara = this.carregarDebitosSolicitacaoAlvara(solicitacao);
        if (EloListUtils.safeIsEmpty((List)debitosAlvara).booleanValue()) {
            if (this.cobrarTaxa(solicitacao)) {
                throw new GeraDebitoException("Clique no bot\u00e3o de Imprimir Taxas antes de Imprimir o Alvar\u00e1");
            }
            if (solicitacao.isNaturezaInicial() && !this.verificaSitCadastroParaAlteracoes(solicitacao).booleanValue()) {
                throw new SolicitacaoAlvaraException("Situa\u00e7\u00e3o do Cadastro n\u00e3o \u00e9 v\u00e1lida ou existe uma data de validade sem laudos no alvar\u00e1 online.\nEnviar e-mail para " + this.getEmailSetorCadastroAlvara() + ", informar o n\u00famero da Solicita\u00e7\u00e3o do Alvar\u00e1.");
            }
        }
    }

    public void efetivaAlteracaoSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.getCadastroMobiliario().setAtividadePrincipal(solicitacao.getDescricaoAtividades());
        solicitacao.getCadastroMobiliario().setTelefone(solicitacao.getTelefonePreenchido());
        solicitacao.setEfetivado(SimNaoEnum.SIM.getShortText());
        if (solicitacao.isNaturezaMudancaRazaoSocial()) {
            this.salvarAlteracaoRazaoSocial(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaEndereco()) {
            this.salvarAlteracaoEndereco(solicitacao);
        }
        if (solicitacao.isNaturezaAlteracaoAtividade()) {
            this.salvarAlteracaoAtividade(solicitacao);
        }
        if (solicitacao.isNaturezaMudancaArea()) {
            this.salvarAlteracaoArea(solicitacao);
        }
        this.atualizarContatoPessoa(solicitacao);
        this.salvarObservacao(solicitacao);
        solicitacao.setEfetivado(SimNaoEnum.SIM.getShortText());
    }
}

