/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.factory.SrvConsultaAtividadeFactory;
import br.com.elotech.portalarrecadacao.repository.RepositoryCadastroRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvaraNatureza;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraAtividade;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividade;
import br.com.elotech.portalarrecadacao.service.SrvRestricaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvRestricoesCadastroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvWebServiceGeo;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.BoletimImobiliarioSegmentoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioSegmentoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.domain.aise.ModeloIdentificacaoEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoSegmentoImobEnum;
import br.com.elotech.tributacao.exception.CadastroImobiliarioException;
import br.com.elotech.tributacao.exception.CadastroMobiliarioException;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimImobiliarioSegmento;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliarioAtividadeMei;
import br.com.elotech.tributacao.repository.aise.RepositoryDebitoParcela;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioSegmento;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloIdentificacao;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.email.EloMailUtils;
import br.com.elotech.util.exceptions.InvalidDateString;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
@EloService(value="srvRestricoesCadastroAlvara")
public class SrvRestricoesCadastroAlvaraImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvRestricoesCadastroAlvara {
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    private boolean restricaoHabitese;
    private boolean restricaoImobiliarioSemSituacao;
    private StringBuilder descricaoRestricoes;
    @Resource
    private RepositoryParametroAlvaraNatureza repositoryParametroAlvaraNatureza;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryBoletimImobiliarioSegmento repositoryBoletimImobiliarioSegmento;
    @Resource
    private RepositoryDebitoParcela repositoryDebitoParcela;
    @Resource
    private RepositoryCadastroRestricaoAlvara repositoryCadastroRestricaoAlvara;
    @Resource
    private RepositoryRestricaoAlvara repositoryRestricaoAlvara;
    @Resource
    private RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade;
    @Resource
    private SrvWebServiceGeo srvWebServiceGeo;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    private ArrayList<CadastroRestricaoAlvaraEntity> listaCadastroRestricaoAlvara;
    private String descricaoRestricao;
    private StringBuilder textoRestricaoBuilder = new StringBuilder();
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private EloMailUtils eloMailUtils;
    @Resource
    private RepositoryModeloIdentificacao repositoryModeloIdentificacao;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private SrvRestricaoAlvara srvRestricaoAlvara;
    @Resource
    private RepositoryCadastroMobiliarioAtividadeMei repositoryCadastroMobiliarioAtividadeMei;
    @Resource
    private RepositoryImobiliarioSegmento repositoryImobiliarioSegmento;
    @Autowired
    private SrvConsultaAtividadeFactory srvConsultaAtividadeFactory;
    private static final BigDecimal VALIDA_AREA_100M = new BigDecimal(100);

    private static boolean possuiSomenteSegmentosSemCertidaoConclusaoEdificacao(CadastroImobiliarioSegmentoEntity segmento) {
        return Objects.nonNull(segmento.getIdSituacaoSegmento()) && (SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_PROJETO_APROVADO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_CONSTRUCAO_DEMOLIDA.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_PROJETO_APROVADO_AMPLIACAO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_PROJETO_CANCELADO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_CONSTRUCAO_DEMOLIDA_SEM_COMUNICADO_DE_DEMOLICAO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_NAO_EXECUTADO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()));
    }

    private static boolean verificarSituacoesRegularesDeAcessibilidade(CadastroImobiliarioSegmentoEntity segmento) {
        return Objects.nonNull(segmento.getIdSituacaoSegmento()) && (segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_NORMAL.getCodigo()) || segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_AMPLIADA.getCodigo()) || segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_INCORPORADA.getCodigo()) || segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_REGULAR_SEM_LANCAR.getCodigo()));
    }

    public String getDescricaoRestricao() {
        return this.descricaoRestricao;
    }

    public void setDescricaoRestricao(String descricaoRestricao) {
        this.descricaoRestricao = descricaoRestricao;
    }

    public RestricaoAlvaraVo verificarRestricaoCadastro(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.textoRestricaoBuilder = new StringBuilder();
        Boolean possuiRestricao = false;
        Boolean debitoMobiliario = false;
        Boolean debitoImobProprietarioMob = false;
        Boolean consultaPrevia = false;
        Boolean renderBtAvancar = true;
        CadastroImobiliarioEntity cadastroImobiliario = null;
        CadastroMobiliarioEntity cadastroMobiliario = null;
        this.restricaoHabitese = false;
        this.restricaoImobiliarioSemSituacao = false;
        if (solicitacao != null) {
            List listaRestricao;
            cadastroImobiliario = solicitacao.getCadastroImobiliario();
            cadastroMobiliario = solicitacao.getCadastroMobiliario();
            if (!solicitacao.isNaturezaInicial() && Objects.nonNull(cadastroMobiliario)) {
                debitoMobiliario = this.possuiDebitoMobiliario(cadastroMobiliario, solicitacao);
                if (Objects.nonNull(cadastroImobiliario)) {
                    debitoImobProprietarioMob = this.possuiDebitoImobProprietarioMob(cadastroMobiliario, cadastroImobiliario, solicitacao);
                }
            }
            consultaPrevia = this.possuiConsultaPrevia(solicitacao);
            this.verificaSituacaoHabitese(cadastroImobiliario, solicitacao);
            Boolean possuiAcessibilidade = true;
            if ((solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoMEINormal() || solicitacao.isSolicitacaoCBO()) && solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                if (Objects.nonNull(cadastroImobiliario)) {
                    List parametrosNatureza = this.repositoryParametroAlvaraNatureza.getParametrosAlvaraNatureza(solicitacao, ParametroAlvaraNaturezaEnum.VALIDAACESSIBILIDADE);
                    for (Object parametro : parametrosNatureza) {
                        if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametro.getValor())) continue;
                        possuiAcessibilidade = this.verificaAcessibilidade(cadastroImobiliario, solicitacao);
                        break;
                    }
                } else {
                    possuiAcessibilidade = Boolean.FALSE;
                }
            }
            Boolean debitoImobiliario = this.possuiDebitoImobiliario(cadastroImobiliario, solicitacao);
            this.descricaoRestricao = null;
            this.listaCadastroRestricaoAlvara = new ArrayList();
            if (!solicitacao.isSolicitacaoMEIPrestador()) {
                SrvConsultaAtividade srvConsultaAtividade = this.srvConsultaAtividadeFactory.getConsultaAtividadeInstance(solicitacao);
                possuiRestricao = srvConsultaAtividade.verificarExisteRestricaoResponsavelTec(solicitacao, this.listaCadastroRestricaoAlvara, this.textoRestricaoBuilder);
            }
            if (possuiAcessibilidade.booleanValue()) {
                solicitacao.setPossuiAcessibilidade(SimNaoEnum.SIM.getShortText());
            } else {
                this.montarTextoAcessibilidade(solicitacao);
                possuiRestricao = true;
            }
            if (debitoMobiliario.booleanValue() || debitoImobiliario.booleanValue() || debitoImobProprietarioMob.booleanValue()) {
                this.montarTextoRestricaoDebitos(solicitacao, debitoMobiliario, debitoImobProprietarioMob, cadastroImobiliario, possuiAcessibilidade, debitoImobiliario);
                possuiRestricao = true;
            }
            if (this.restricaoHabitese || this.restricaoImobiliarioSemSituacao) {
                if (!this.repositoryRestricaoAlvara.verificarLiberacaoSolicitacaoByCadRestricao(solicitacao.getSolicitacaoAlvara(), PortalUtils.getCodRestricaohabitese())) {
                    possuiRestricao = true;
                } else {
                    solicitacao.setPossuiAcessibilidade(SimNaoEnum.SIM.getShortText());
                }
                this.montarTextoRestricaoHabitese(solicitacao);
                if (!consultaPrevia.booleanValue() && (solicitacao.isSolicitacaoPrestadorServico() || solicitacao.isSolicitacaoMEIPrestador())) {
                    this.enviaEmailHabitese(solicitacao);
                    renderBtAvancar = true;
                }
            }
            if (possuiRestricao.booleanValue() && !consultaPrevia.booleanValue()) {
                this.salvarRestricoes(solicitacao, (List)this.listaCadastroRestricaoAlvara);
            }
            if ((listaRestricao = this.repositoryRestricaoAlvara.carregaRestricaoPorSolicitacao(solicitacao.getSolicitacaoAlvara())) != null && !listaRestricao.isEmpty()) {
                for (RestricaoAlvaraEntity restricaoAlvara : listaRestricao) {
                    CadastroRestricaoAlvaraEntity cadastroRestricaoPessoaMesmoCNPJ = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaocadPessoaJaExistente());
                    CadastroRestricaoAlvaraEntity cadastroRestricaoAcessibilidade = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaoacessibilidade());
                    if (restricaoAlvara.getCadastroRestricaoAlvara().equals((Object)cadastroRestricaoPessoaMesmoCNPJ)) {
                        if (restricaoAlvara.isRestricaoAutorizada()) {
                            renderBtAvancar = true;
                        } else if (restricaoAlvara.isBloqueante()) {
                            renderBtAvancar = false;
                            this.textoRestricaoBuilder.append(" J\u00e1 existe um cadastro com este CNPJ/CPF.");
                            break;
                        }
                    }
                    if (restricaoAlvara.getCadastroRestricaoAlvara().equals((Object)cadastroRestricaoAcessibilidade)) {
                        if (restricaoAlvara.getAutorizado() != null && SimNaoEnum.SIM.getShortText().equalsIgnoreCase(restricaoAlvara.getAutorizado())) {
                            renderBtAvancar = true;
                        } else if (restricaoAlvara.isBloqueante()) {
                            renderBtAvancar = false;
                            break;
                        }
                    }
                    CadastroRestricaoAlvaraEntity cadastroRestricaoHabitese = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaohabitese());
                    if (restricaoAlvara.getCadastroRestricaoAlvara().equals((Object)cadastroRestricaoHabitese)) {
                        if (restricaoAlvara.getAutorizado() != null && SimNaoEnum.SIM.getShortText().equals(restricaoAlvara.getAutorizado())) {
                            renderBtAvancar = true;
                        } else if (restricaoAlvara.isBloqueante()) {
                            renderBtAvancar = false;
                            break;
                        }
                    }
                    if (!restricaoAlvara.isBloqueante()) continue;
                    if (restricaoAlvara.getAutorizado().equals(SimNaoEnum.SIM.getShortText())) {
                        renderBtAvancar = true;
                        continue;
                    }
                    renderBtAvancar = false;
                    break;
                }
            }
            RestricaoAlvaraVo restricaoAlvaraVo = new RestricaoAlvaraVo();
            if (!solicitacao.isNaturezaInicial() && !solicitacao.isSolicitacaoCBO() && this.verificaSePossuiMaisdeUmCadastro(solicitacao).booleanValue() && solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
                StringBuilder observacao = new StringBuilder();
                observacao.append("Existe mais de um cadastro mobili\u00e1rio para esse mesmo CNPJ. Ser\u00e1 necess\u00e1rio fazer o mesmo procedimento de ");
                String juncao = "";
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL})) {
                    observacao.append("Mudan\u00e7a de Raz\u00e3o Social");
                    juncao = " e ";
                }
                if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
                    observacao.append(juncao).append("Altera\u00e7\u00e3o de S\u00f3cios");
                }
                observacao.append(" para os demais cadastros.");
                restricaoAlvaraVo.setObservacao(observacao.toString());
            }
            restricaoAlvaraVo.setDescricaoRestricao(this.textoRestricaoBuilder.toString());
            restricaoAlvaraVo.setPossuiRestricao(possuiRestricao);
            restricaoAlvaraVo.setRenderBtAvancar(renderBtAvancar);
            restricaoAlvaraVo.setListaRestricaoAlvaraAtual((List)this.listaCadastroRestricaoAlvara);
            restricaoAlvaraVo.setSolicitacaoAlvara(solicitacao);
            return restricaoAlvaraVo;
        }
        return null;
    }

    public boolean possuiConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) {
        return Objects.isNull(solicitacao.getSolicitacaoAlvara()) || Objects.isNull(solicitacao.getDataConsultaPrevia()) || Objects.isNull(solicitacao.getCadastroMobiliario());
    }

    private Boolean verificaSePossuiMaisdeUmCadastro(SolicitacaoAlvaraEntity solicitacao) throws ParametroNaoEncontradoException {
        List cadastros;
        ParametroAlvaraNaturezaEntity paramSituacaoCad = this.repositoryParametroAlvaraNatureza.getParametroAlvaraNatureza(this.getNatureza(NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue()), ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADMESMOCNPJ, solicitacao.getTipoDeInscricao());
        ParametroAlvaraNaturezaEntity paramTipoPessoa = this.repositoryParametroAlvaraNatureza.getParametroAlvaraNatureza(this.getNatureza(NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL.getValue()), ParametroAlvaraNaturezaEnum.VALIDATIPOPESSOAMESMOCNPJ, solicitacao.getTipoDeInscricao());
        if (paramSituacaoCad == null) {
            throw new ParametroNaoEncontradoException(String.format("Parametro %s n\u00e3o encontrado para o tipo de inscri\u00e7\u00e3o %s - %s", ParametroAlvaraNaturezaEnum.VALIDASITUACAOCADMESMOCNPJ.name(), solicitacao.getTipoDeInscricao().getIdTipoInscricaoAlvara().toString(), solicitacao.getTipoDeInscricao().getDescricao()));
        }
        if (paramTipoPessoa == null) {
            throw new ParametroNaoEncontradoException(String.format("Parametro %s n\u00e3o encontrado para o tipo de inscri\u00e7\u00e3o %s - %s", ParametroAlvaraNaturezaEnum.VALIDATIPOPESSOAMESMOCNPJ.name(), solicitacao.getTipoDeInscricao().getIdTipoInscricaoAlvara().toString(), solicitacao.getTipoDeInscricao().getDescricao()));
        }
        if (!EloStringUtils.isEmpty((String)paramSituacaoCad.getValor()) && !EloStringUtils.isEmpty((String)paramTipoPessoa.getValor()) && (cadastros = this.repositoryCadastroMobiliario.carregarCadastrosPorSituacaoTipoPessoa(solicitacao.getCpfCnpj(), paramSituacaoCad.getValor().split(","), paramTipoPessoa.getValor().split(","))).size() > 1) {
            return true;
        }
        return false;
    }

    private void enviaEmailHabitese(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (!this.isBaseHomologacao() && solicitacao.getMsgEmailHabitese() != null) {
            try {
                ParametroAlvaraEntity emailFiscalizacao = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.EMAILFISCALIZACAO);
                String[] emailsArr = null;
                if (!EloStringUtils.isEmpty((String)emailFiscalizacao.getValor())) {
                    emailsArr = emailFiscalizacao.getValor().split(";");
                }
                ArrayList<Object> listaEmails = new ArrayList();
                if (emailsArr != null) {
                    listaEmails = new ArrayList<String>(Arrays.asList(emailsArr));
                }
                for (String emailFiscal : listaEmails) {
                    this.eloMailUtils.sendMail(this.repositoryParametroGeral.getParametro(PortalUtils.getModuloAlvaraonline(), "REMETENTEEMAIL"), EloStringUtils.safeTrim((String)emailFiscal), null, null, "Habite-se - Alvar\u00e1 On-line", solicitacao.getMsgEmailHabitese(), new ArrayList());
                }
            }
            catch (BaseException e) {
                this.logger.info((Object)"FALHA NO ENVIO DE EMAIL >>>");
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void montarTextoRestricaoHabitese(SolicitacaoAlvaraEntity solicitacao) {
        this.textoRestricaoBuilder.append(" O im\u00f3vel n\u00e3o possui Certid\u00e3o de conclus\u00e3o de edifica\u00e7\u00e3o.");
        StringBuilder msgEmail = new StringBuilder();
        msgEmail.append("Protocolo de Solicita\u00e7\u00e3o de Alvar\u00e1: ").append(solicitacao.getNumeroSolicitacao()).append("/").append(solicitacao.getExercicio()).append("<br />");
        msgEmail.append("O cadastro imobili\u00e1rio ");
        if (Objects.nonNull(solicitacao.getCadastroImobiliario())) {
            msgEmail.append(solicitacao.getCadastroImobiliario().getId().getCodigo());
        }
        msgEmail.append(" n\u00e3o possui Certid\u00e3o de conclus\u00e3o de edifica\u00e7\u00e3o.");
        solicitacao.setMsgEmailHabitese(msgEmail.toString());
        CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaohabitese());
        if (cadastroRestricaoAlvara != null) {
            this.listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
        }
    }

    private void montarTextoRestricaoDebitos(SolicitacaoAlvaraEntity solicitacao, Boolean debitoMobiliario, Boolean debitoImobProprietarioMob, CadastroImobiliarioEntity cadastroImobiliario, Boolean possuiAcessibilidade, Boolean debitoImobiliario) {
        CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara;
        StringBuilder msg = new StringBuilder();
        boolean bloqueiaSolicitacao = false;
        if (debitoMobiliario.booleanValue()) {
            msg.append("O cadastro Mobiliario :").append(solicitacao.getCadastroMobiliario().getId().getCodigo()).append(" possui d\u00e9bito ").append("\n");
            cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaodebitomobiliario());
            if (cadastroRestricaoAlvara != null) {
                if (solicitacao.bloqueiaRestricao(cadastroRestricaoAlvara)) {
                    bloqueiaSolicitacao = true;
                }
                this.listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                cadastroRestricaoAlvara = null;
            }
        }
        if (debitoImobiliario.booleanValue()) {
            msg.append("O cadastro Imobili\u00e1rio :").append(cadastroImobiliario.getId().getCodigo()).append(" possui d\u00e9bito. ").append("\n");
            cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaodebitoimobiliario());
            if (cadastroRestricaoAlvara != null) {
                if (solicitacao.bloqueiaRestricao(cadastroRestricaoAlvara)) {
                    bloqueiaSolicitacao = true;
                }
                this.listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                cadastroRestricaoAlvara = null;
            }
        }
        if (debitoImobProprietarioMob.booleanValue()) {
            msg.append("O cadastro Imobili\u00e1rio :").append(cadastroImobiliario.getId().getCodigo()).append(" possui d\u00e9bito sendo o Mobili\u00e1rio o dono do im\u00f3vel.").append("\n");
            cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaodebitoimobSendoMobilDono());
            if (cadastroRestricaoAlvara != null) {
                if (solicitacao.bloqueiaRestricao(cadastroRestricaoAlvara)) {
                    bloqueiaSolicitacao = true;
                }
                this.listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                cadastroRestricaoAlvara = null;
            }
        }
        solicitacao.setMsgEmailDebito(msg.toString());
        if (this.restricaoHabitese || this.restricaoImobiliarioSemSituacao || !possuiAcessibilidade.booleanValue()) {
            this.textoRestricaoBuilder.append(" Possui d\u00e9bitos no cadastro.");
            this.textoRestricaoBuilder.append("<br/>");
        } else if (!bloqueiaSolicitacao) {
            this.textoRestricaoBuilder.append(" \u00c9 poss\u00edvel concluir a solicita\u00e7\u00e3o, por\u00e9m foram encontrados d\u00e9bitos no cadastro.<br/>");
        } else {
            this.textoRestricaoBuilder.append(" Foram encontrados d\u00e9bitos no cadastro.<br/>");
        }
    }

    private void montarTextoAcessibilidade(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        solicitacao.setPossuiAcessibilidade(SimNaoEnum.NAO.getShortText());
        this.textoRestricaoBuilder.append("O im\u00f3vel possui restri\u00e7\u00e3o de acessibilidade. <br/>");
        CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaoacessibilidade());
        if (cadastroRestricaoAlvara != null) {
            this.listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
        }
    }

    public boolean possuiDebitoImobProprietarioMob(CadastroMobiliarioEntity cadastroMobiliario, CadastroImobiliarioEntity cadastroImobiliario, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List parametrosNatureza = this.repositoryParametroAlvaraNatureza.getParametrosAlvaraNatureza(solicitacao, ParametroAlvaraNaturezaEnum.VALIDADEBITOIMOBPROPMOB);
        for (ParametroAlvaraNaturezaEntity parametro : parametrosNatureza) {
            Boolean isProprietario;
            if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametro.getValor()) || !(isProprietario = this.repositoryCadastroGeral.verificaProprietarioImobiliario(cadastroMobiliario.getId().getCodigo(), cadastroImobiliario.getId().getCodigo())).booleanValue()) continue;
            return this.possuiDebitoImobiliario(cadastroImobiliario, solicitacao);
        }
        return false;
    }

    public boolean possuiDebitoImobiliario(CadastroImobiliarioEntity cadastroImobiliario, SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        try {
            if (Objects.isNull(cadastroImobiliario)) {
                return Boolean.FALSE;
            }
            List parametrosNatureza = this.repositoryParametroAlvaraNatureza.getParametrosAlvaraNatureza(solicitacao, ParametroAlvaraNaturezaEnum.VALIDADEBITOIMOB);
            for (ParametroAlvaraNaturezaEntity parametro : parametrosNatureza) {
                if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametro.getValor())) continue;
                Boolean retorno = this.repositoryDebitoParcela.verificaDebitos(cadastroImobiliario.getId().getTipo(), cadastroImobiliario.getId().getCodigo());
                if (retorno.booleanValue()) {
                    this.addRestricao("Possui d\u00e9bitos imobili\u00e1rios; \n");
                }
                return retorno;
            }
            return false;
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException("Falha na verifica\u00e7\u00e3o de d\u00e9bitos Imobili\u00e1rios", e.getCause());
        }
    }

    public boolean possuiDebitoMobiliario(CadastroMobiliarioEntity cadastroMobiliario, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List parametrosNatureza = this.repositoryParametroAlvaraNatureza.getParametrosAlvaraNatureza(solicitacao, ParametroAlvaraNaturezaEnum.VALIDADEBITOMOB);
        for (ParametroAlvaraNaturezaEntity parametro : parametrosNatureza) {
            if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametro.getValor())) continue;
            Boolean retorno = this.repositoryDebitoParcela.verificaDebitos(cadastroMobiliario.getId().getTipo(), cadastroMobiliario.getId().getCodigo());
            if (retorno.booleanValue()) {
                this.addRestricao("Possui d\u00e9bitos mobili\u00e1rios; \n");
            }
            return retorno;
        }
        return false;
    }

    public boolean verificaAcessibilidade(CadastroImobiliarioEntity cadastroImobiliario, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        Boolean possuiAcessibilidade = this.repositoryBoletimImobiliarioSegmento.verificaPossuiAcessibilidade(cadastroImobiliario.getId().getTipo(), cadastroImobiliario.getId().getCodigo());
        if (possuiAcessibilidade.booleanValue()) {
            List segmentos = this.getSegmentos(solicitacao.getCadastroImobiliario().getCadastroGeral());
            if (this.possuiSomenteSituacoesRegularesDeAcessibilidade(segmentos)) {
                return true;
            }
            if (this.possuiSituacaoNormalAmpliadaIncorporadaRegularSemLancar(segmentos)) {
                return this.analisaAcessibilidade(solicitacao, possuiAcessibilidade.booleanValue());
            }
            if (this.possuiSituacaoProjetoAprovadoOuConstrucaoDemolida(segmentos) && this.possuiSituacaoNormalAmpliadaIncorporadaRegularSemLancar(segmentos)) {
                return this.analisaAcessibilidade(solicitacao, possuiAcessibilidade.booleanValue());
            }
        } else {
            return this.analisaAcessibilidade(solicitacao, possuiAcessibilidade.booleanValue());
        }
        return true;
    }

    private Boolean analisaAcessibilidade(SolicitacaoAlvaraEntity solicitacao, boolean acessibilidadeEBoletimSim) throws InvalidDateString, CadastroImobiliarioException, SolicitacaoAlvaraException {
        this.addRestricao("N\u00e3o possui acessibilidade; ");
        this.addRestricao(System.lineSeparator());
        boolean permiteAlvaraSemAcessibilidade = true;
        boolean verificarArea = false;
        ParametroAlvaraEntity param_DataHabitese = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidadeTributacao().getId().getEntidade(), ParametroAlvaraEnum.DATA_VALIDACAO_HABITESE);
        Date dataValidacaoHabitese = EloDateUtils.fromDateString((String)param_DataHabitese.getValor());
        if (solicitacao.isSolicitacaoJuridicaNormal()) {
            permiteAlvaraSemAcessibilidade = this.isPermiteAlvaraSemAcessibilidadeJuridicaNormal(solicitacao);
            verificarArea = this.isVerificaAreaJuridicaNormal(solicitacao);
        } else if (solicitacao.isSolicitacaoMEINormal()) {
            permiteAlvaraSemAcessibilidade = this.isPermiteAlvaraSemAcessibilidadeMEI(solicitacao);
            verificarArea = this.isVerificaAreaMEI(solicitacao);
        } else if (solicitacao.isSolicitacaoCBO()) {
            permiteAlvaraSemAcessibilidade = this.isPermiteAlvaraSemAcessibilidadeCBO(solicitacao);
            verificarArea = false;
        }
        Date dataAlvaraAtualizacaoBoletim = null;
        BoletimImobiliarioSegmentoEntity boletim = this.getBoletimSegmentoDataAlvara(solicitacao);
        if (boletim != null) {
            dataAlvaraAtualizacaoBoletim = EloDateUtils.fromDateString((String)boletim.getDescricao());
        }
        if (dataAlvaraAtualizacaoBoletim != null) {
            if (!permiteAlvaraSemAcessibilidade) {
                if (verificarArea) {
                    if (!this.verificaDataHabiteseArea(dataAlvaraAtualizacaoBoletim, dataValidacaoHabitese, solicitacao.getAreaConstruida())) {
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (!acessibilidadeEBoletimSim && dataAlvaraAtualizacaoBoletim.compareTo(dataValidacaoHabitese) > 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private BoletimImobiliarioSegmentoEntity getBoletimSegmentoDataAlvara(SolicitacaoAlvaraEntity solicitacao) throws CadastroImobiliarioException, SolicitacaoAlvaraException {
        ModeloIdentificacaoEntity modeloIdentificacao = this.repositoryModeloIdentificacao.getDataAlvara();
        try {
            BoletimImobiliarioSegmentoEntity boletim = this.repositoryBoletimImobiliarioSegmento.findByCadGeralAndModeloCampo(solicitacao.getCadastroImobiliario(), modeloIdentificacao.getModeloResposta().getId().getModeloCampo());
            if (Objects.isNull(boletim)) {
                modeloIdentificacao = this.repositoryModeloIdentificacao.getDataAtualizacao();
                boletim = this.repositoryBoletimImobiliarioSegmento.findByCadGeralAndModeloCampo(solicitacao.getCadastroImobiliario(), modeloIdentificacao.getModeloResposta().getId().getModeloCampo());
            }
            return boletim;
        }
        catch (ParseException e) {
            throw new CadastroImobiliarioException(this.getMensagemRestricaoHabitese());
        }
    }

    private String getMensagemRestricaoHabitese() throws SolicitacaoAlvaraException {
        return String.format("No cadastro imobili\u00e1rio n\u00e3o consta a data de emiss\u00e3o do habite-se, par\u00e2metro utilizado para an\u00e1lise da acessibilidade, por gentileza enviar e-mail para %s informando o n\u00famero do cadastro para que possamos verificar a situa\u00e7\u00e3o e resolv\u00ea-la. <br/>", this.getEmailSetorLaudoAlvara());
    }

    private boolean isPermiteAlvaraSemAcessibilidadeCBO(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                RhCboEntity cbo = solicitacaoAtividade.getSequenciaCbo();
                if (cbo == null || !SimNaoEnum.NAO.getShortText().equalsIgnoreCase(cbo.getPermiteAlvaraSemAcessibilidade())) continue;
                return false;
            }
        } else {
            for (CadastroMobiliarioCboEntity mobCbo : solicitacao.getCadastroMobiliario().getMobiliarioCbos()) {
                RhCboEntity cbo = mobCbo.getRhCbo();
                if (cbo == null || !SimNaoEnum.NAO.getShortText().equalsIgnoreCase(cbo.getPermiteAlvaraSemAcessibilidade())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPermiteAlvaraSemAcessibilidadeJuridicaNormal(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                CnaeEntity cnae = solicitacaoAtividade.getCnae();
                if (cnae == null || !SimNaoEnum.NAO.getShortText().equalsIgnoreCase(cnae.getPermiteAlvaraSemAcessibilidade())) continue;
                return false;
            }
        } else {
            if (Objects.isNull(solicitacao.getCadastroMobiliario())) {
                return false;
            }
            for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
                CnaeEntity cnae = mobCnae.getId().getCnae();
                if (cnae == null || !SimNaoEnum.NAO.getShortText().equalsIgnoreCase(cnae.getPermiteAlvaraSemAcessibilidade())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPermiteAlvaraSemAcessibilidadeMEI(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (!SimNaoEnum.NAO.getShortText().equalsIgnoreCase(solicitacaoAtividade.getAtividadeMei().getPermiteAlvaraSemAcessibilidade())) continue;
                return false;
            }
        } else {
            List mobMeis = this.repositoryCadastroMobiliarioAtividadeMei.pesquisaPorCadastroMobiliario(solicitacao.getCadastroMobiliario());
            for (CadastroMobiliarioAtividadeMeiEntity mobMei : mobMeis) {
                if (!SimNaoEnum.NAO.getShortText().equalsIgnoreCase(mobMei.getAtividadeMei().getPermiteAlvaraSemAcessibilidade())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isVerificaAreaJuridicaNormal(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (solicitacaoAtividade.getCnae() == null || !SimNaoEnum.SIM.getShortText().equalsIgnoreCase(solicitacaoAtividade.getCnae().getVerificarArea())) continue;
                return true;
            }
        } else {
            if (Objects.isNull(solicitacao.getCadastroMobiliario())) {
                return false;
            }
            for (MobiliarioCnaeEntity mobCnae : solicitacao.getCadastroMobiliario().getMobiliarioCnaes()) {
                if (mobCnae.getId().getCnae() == null || !SimNaoEnum.SIM.getShortText().equalsIgnoreCase(mobCnae.getId().getCnae().getVerificarArea())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVerificaAreaMEI(SolicitacaoAlvaraEntity solicitacao) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            for (SolicitacaoAlvaraAtividadeEntity solicitacaoAtividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(solicitacaoAtividade.getAtividadeMei().getVerificarArea())) continue;
                return true;
            }
        } else {
            List mobMeis = this.repositoryCadastroMobiliarioAtividadeMei.pesquisaPorCadastroMobiliario(solicitacao.getCadastroMobiliario());
            for (CadastroMobiliarioAtividadeMeiEntity mobMei : mobMeis) {
                if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(mobMei.getAtividadeMei().getVerificarArea())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean verificaDataHabiteseArea(Date dataHabitese, Date dataValidacaoHabitese, BigDecimal area) {
        if (area.compareTo(VALIDA_AREA_100M) <= 0) {
            return dataHabitese.compareTo(dataValidacaoHabitese) <= 0;
        }
        return false;
    }

    public boolean verificaSituacaoHabitese(CadastroImobiliarioEntity cadastroImobiliario, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (Objects.isNull(cadastroImobiliario)) {
            this.restricaoHabitese = Boolean.TRUE;
            this.restricaoImobiliarioSemSituacao = Boolean.TRUE;
            this.addRestricao("Im\u00f3vel n\u00e3o encontrado, N\u00e3o possui Certificado de conclus\u00e3o de edifica\u00e7\u00e3o; ");
            return Boolean.TRUE;
        }
        List parametrosNatureza = this.repositoryParametroAlvaraNatureza.getParametrosAlvaraNatureza(solicitacao, ParametroAlvaraNaturezaEnum.VALIDAHABITESE);
        for (ParametroAlvaraNaturezaEntity parametro : parametrosNatureza) {
            if (!SimNaoEnum.SIM.getShortText().equalsIgnoreCase(parametro.getValor())) continue;
            this.restricaoHabitese = !this.isPossuiHabitese(cadastroImobiliario.getCadastroGeral());
            this.restricaoImobiliarioSemSituacao = this.repositoryBoletimImobiliarioSegmento.verificaPossuiSituacao(cadastroImobiliario.getId().getTipo(), cadastroImobiliario.getId().getCodigo());
            if (!this.restricaoHabitese && !this.restricaoImobiliarioSemSituacao) continue;
            this.addRestricao("N\u00e3o possui Certificado de conclus\u00e3o de edifica\u00e7\u00e3o; ");
        }
        return this.restricaoHabitese || this.restricaoImobiliarioSemSituacao;
    }

    private boolean isPossuiHabitese(CadastroGeralAiseEntity cadastroGeral) {
        List segmentos = this.getSegmentos(cadastroGeral);
        if (EloListUtils.safeIsEmpty((List)segmentos).booleanValue()) {
            return false;
        }
        return !this.possuiSituacaoSemHabiteseOuSemAprovacao(segmentos) && !this.possuiSituacaoIrregularGeo(segmentos) && !this.possuiSomenteSituacoesSemCertidaoConclusaoEdificacao(segmentos);
    }

    private List<CadastroImobiliarioSegmentoEntity> getSegmentos(CadastroGeralAiseEntity cadastroGeral) {
        return this.repositoryImobiliarioSegmento.getImobiliarioSegmentoPorCadastroImobiliairo(cadastroGeral);
    }

    private boolean possuiSituacaoNormalAmpliadaIncorporadaRegularSemLancar(List<CadastroImobiliarioSegmentoEntity> segmentos) {
        for (CadastroImobiliarioSegmentoEntity segmentoNormal : segmentos) {
            if (!SrvRestricoesCadastroAlvaraImpl.verificarSituacoesRegularesDeAcessibilidade((CadastroImobiliarioSegmentoEntity)segmentoNormal)) continue;
            return true;
        }
        return false;
    }

    private boolean possuiSomenteSituacoesRegularesDeAcessibilidade(List<CadastroImobiliarioSegmentoEntity> segmentos) {
        return segmentos.stream().allMatch(SrvRestricoesCadastroAlvaraImpl::verificarSituacoesRegularesDeAcessibilidade);
    }

    private boolean possuiSomenteSituacoesSemCertidaoConclusaoEdificacao(List<CadastroImobiliarioSegmentoEntity> segmentos) {
        return segmentos.stream().allMatch(SrvRestricoesCadastroAlvaraImpl::possuiSomenteSegmentosSemCertidaoConclusaoEdificacao);
    }

    private boolean possuiSituacaoProjetoAprovadoOuConstrucaoDemolida(List<CadastroImobiliarioSegmentoEntity> segmentos) {
        for (CadastroImobiliarioSegmentoEntity segmento : segmentos) {
            if (!segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_PROJETO_APROVADO.getCodigo()) && !segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_CONSTRUCAO_DEMOLIDA.getCodigo()) && !segmento.getIdSituacaoSegmento().getIdSituacaoSegmento().equals(SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_PROJETO_APROVADO_AMPLIACAO.getCodigo())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean possuiSituacaoSemHabiteseOuSemAprovacao(List<CadastroImobiliarioSegmentoEntity> segmentos) {
        for (CadastroImobiliarioSegmentoEntity segmento : segmentos) {
            if (!Objects.nonNull(segmento.getIdSituacaoSegmento()) || !SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_SEM_HABITESE.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) && !SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_SEM_APROVACAO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento())) continue;
            return true;
        }
        return false;
    }

    private void addRestricao(String restricao) {
        if (this.descricaoRestricoes == null) {
            this.descricaoRestricoes = new StringBuilder();
        }
        this.descricaoRestricoes.append(restricao);
    }

    private void salvarRestricoes(SolicitacaoAlvaraEntity solicitacao, List<CadastroRestricaoAlvaraEntity> listaRestricaoAlvaraAtual) throws BaseException {
        List listaRestricaoAlvaraExistente = this.repositoryRestricaoAlvara.carregaRestricaoPorSolicitacao(solicitacao.getSolicitacaoAlvara());
        try {
            if (listaRestricaoAlvaraExistente != null && !listaRestricaoAlvaraExistente.isEmpty()) {
                ArrayList<CadastroRestricaoAlvaraEntity> listaCadRestricaoExistente = new ArrayList<CadastroRestricaoAlvaraEntity>();
                for (Object restricaoExistente : listaRestricaoAlvaraExistente) {
                    listaCadRestricaoExistente.add(restricaoExistente.getCadastroRestricaoAlvara());
                }
                ArrayList<CadastroRestricaoAlvaraEntity> listaCadInsert = new ArrayList<CadastroRestricaoAlvaraEntity>();
                for (CadastroRestricaoAlvaraEntity cadastroRestricao : listaRestricaoAlvaraAtual) {
                    if (listaCadRestricaoExistente.contains(cadastroRestricao)) continue;
                    listaCadInsert.add(cadastroRestricao);
                }
                for (CadastroRestricaoAlvaraEntity cadastroRestricao : listaCadInsert) {
                    RestricaoAlvaraEntity restricaoAlvara = new RestricaoAlvaraEntity();
                    restricaoAlvara.setCadastroImobiliario(solicitacao.getCadastroImobiliario());
                    if (solicitacao.getCadastroMobiliario() != null && solicitacao.getCadastroMobiliario().getId() != null && solicitacao.getCadastroMobiliario().getId().getCodigo() != null) {
                        restricaoAlvara.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
                    }
                    restricaoAlvara.setAutorizado(SimNaoEnum.NAO.getShortText());
                    restricaoAlvara.setDescricao(cadastroRestricao.getDescricao());
                    restricaoAlvara.setData(Calendar.getInstance().getTime());
                    restricaoAlvara.setSolicitacaoAlvara(solicitacao);
                    restricaoAlvara.setExercicio(this.getEntidadeTributacao());
                    restricaoAlvara.setRestricaoAlvara(solicitacao.getNumeroSolicitacao());
                    restricaoAlvara.setCadastroRestricaoAlvara(cadastroRestricao);
                    if (restricaoAlvara.getIdRestricaoAlvara() == null) {
                        restricaoAlvara.setIdRestricaoAlvara(this.repositoryRestricaoAlvara.getSequence());
                    }
                    if (restricaoAlvara.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente())) {
                        restricaoAlvara.setCampoVerificacao(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
                    }
                    this.repositoryRestricaoAlvara.saveOrUpdate(restricaoAlvara);
                    this.repositoryRestricaoAlvara.flush();
                }
            } else {
                for (CadastroRestricaoAlvaraEntity cadastro : listaRestricaoAlvaraAtual) {
                    RestricaoAlvaraEntity restricaoAlvara = new RestricaoAlvaraEntity();
                    restricaoAlvara.setCadastroImobiliario(solicitacao.getCadastroImobiliario());
                    restricaoAlvara.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
                    restricaoAlvara.setAutorizado(SimNaoEnum.NAO.getShortText());
                    restricaoAlvara.setDescricao(cadastro.getDescricao());
                    restricaoAlvara.setData(Calendar.getInstance().getTime());
                    restricaoAlvara.setSolicitacaoAlvara(solicitacao);
                    restricaoAlvara.setExercicio(this.getEntidadeTributacao());
                    restricaoAlvara.setRestricaoAlvara(solicitacao.getNumeroSolicitacao());
                    restricaoAlvara.setCadastroRestricaoAlvara(cadastro);
                    restricaoAlvara.setObservacoes(new ArrayList());
                    if (restricaoAlvara.getIdRestricaoAlvara() == null) {
                        restricaoAlvara.setIdRestricaoAlvara(this.repositoryRestricaoAlvara.getSequence());
                    }
                    if (restricaoAlvara.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente())) {
                        restricaoAlvara.setCampoVerificacao(solicitacao.getCpfCnpj());
                    }
                    this.repositoryRestricaoAlvara.saveOrUpdate(restricaoAlvara);
                    this.repositoryRestricaoAlvara.flush();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("Falha ao gravar restri\u00e7\u00e3o de alvara: ", e.getCause());
        }
    }

    private boolean isBaseHomologacao() throws BaseException {
        return !this.repositoryParametroGeral.getParametro(PortalUtils.getModuloConfiguracao(), "BASEHOMOLOGACAO").equalsIgnoreCase(SimNaoEnum.NAO.getShortText());
    }

    public boolean isRestricaoCadastroExistente(SolicitacaoAlvaraEntity solicitacao, Boolean geraRestricaoCadastroExistente) throws CadastroMobiliarioException {
        try {
            if (solicitacao.isSolicitacaoJuridicaNormal()) {
                return this.possuiRestricaoCadastroPessoaJuridicaNormal(solicitacao, geraRestricaoCadastroExistente);
            }
            if (solicitacao.isSolicitacaoMEI()) {
                return this.possuiRestricaoCadastroMEI(solicitacao, geraRestricaoCadastroExistente);
            }
            if (solicitacao.isSolicitacaoCBO()) {
                return this.possuiRestricaoCadastroCBO(solicitacao, geraRestricaoCadastroExistente);
            }
            return false;
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new CadastroMobiliarioException(String.format("%s%s", "Ocorreu uma falha na verifica\u00e7\u00e3o do cadastro mobili\u00e1rio. ", e.getMessage()));
        }
    }

    private boolean possuiRestricaoCadastroCBO(SolicitacaoAlvaraEntity solicitacao, Boolean geraRestricaoCadastroExistente) {
        String cpf = solicitacao.getCpfCnpj();
        List pessoas = this.repositoryPessoa.carregaPessoasPorCpfCnpj(cpf);
        return !pessoas.isEmpty();
    }

    private boolean possuiRestricaoCadastroMEI(SolicitacaoAlvaraEntity solicitacao, Boolean geraRestricaoCadastroExistente) {
        return false;
    }

    private boolean possuiRestricaoCadastroPessoaJuridicaNormal(SolicitacaoAlvaraEntity solicitacao, Boolean geraRestricaoCadastroExistente) throws CadastroMobiliarioException, BaseException {
        if (this.existeRestricaoCnpjPessoaJuridicaNormal(solicitacao)) {
            if (geraRestricaoCadastroExistente.booleanValue()) {
                return this.gerarRestricaoCadastroExistente(solicitacao);
            }
            throw new CadastroMobiliarioException(EloStringUtils.build((Object[])new Object[]{" J\u00e1 existe um cadastro mobili\u00e1rio para este CPF/CNPJ com situa\u00e7\u00e3o que n\u00e3o permite a gera\u00e7\u00e3o de um novo cadastro. Favor entrar em contato atrav\u00e9s do e-mail: ", this.getEmailSetorCadastroAlvara()}));
        }
        return false;
    }

    private boolean gerarRestricaoCadastroExistente(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (!this.verificarLiberacaoRestricaoByCadastroRestricao(solicitacao).booleanValue()) {
            solicitacao.setGeraRestricaoCadJaExistente(SimNaoEnum.SIM.getShortText());
            solicitacao.setCadastroMobiliario(null);
            this.salvarRestricaoCadastro(solicitacao);
            return true;
        }
        this.carregaDadosPessoaJaExistente(solicitacao);
        if (!this.verificarCNPJRestricaoPessoaDuplic(solicitacao).booleanValue()) {
            throw new CadastroMobiliarioException(" N\u00e3o \u00e9 poss\u00edvel prosseguir com a solicita\u00e7\u00e3o o Cnpj n\u00e3o \u00e9 o mesmo que foi autorizado.");
        }
        return false;
    }

    private Boolean verificarLiberacaoRestricaoByCadastroRestricao(SolicitacaoAlvaraEntity solicitacao) {
        return this.repositoryRestricaoAlvara.verificarLiberacaoSolicitacaoByCadRestricao(solicitacao.getSolicitacaoAlvara(), Long.valueOf(6L));
    }

    private void salvarRestricaoCadastro(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaRestricoesExistentes = this.repositoryRestricaoAlvara.carregaRestricaoPorSolicitacao(solicitacao.getSolicitacaoAlvara());
        ArrayList<CadastroRestricaoAlvaraEntity> listaCadastroRestricaoAtual = new ArrayList<CadastroRestricaoAlvaraEntity>();
        listaCadastroRestricaoAtual.add(this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaocadPessoaJaExistente()));
        this.srvRestricaoAlvara.salvarRestricaoAlvara(listaRestricoesExistentes, listaCadastroRestricaoAtual, solicitacao, this.getEntidadeTributacao());
    }

    private void carregaDadosPessoaJaExistente(SolicitacaoAlvaraEntity solicitacao) {
        RestricaoAlvaraEntity restricaoAlvara = this.repositoryRestricaoAlvara.carregaRestricaoBySolicitacaoCadRestricao(solicitacao.getSolicitacaoAlvara(), PortalUtils.getCodRestricaocadPessoaJaExistente());
        if (restricaoAlvara != null) {
            solicitacao.getCadastroMobiliario().getCadastroGeral().setPessoa(restricaoAlvara.getPessoa());
        }
    }

    private Boolean verificarCNPJRestricaoPessoaDuplic(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaRestricao = this.repositoryRestricaoAlvara.carregaRestricaoPorSolicitacao(solicitacao.getSolicitacaoAlvara());
        if (listaRestricao != null) {
            for (RestricaoAlvaraEntity restricao : listaRestricao) {
                if (restricao.getCadastroRestricaoAlvara() == null || restricao.getCadastroRestricaoAlvara().getUsuarios().size() > 0) continue;
                restricao.getCadastroRestricaoAlvara().getUsuarios().size();
            }
            for (RestricaoAlvaraEntity restricaoAlvara : listaRestricao) {
                if (!restricaoAlvara.getCadastroRestricaoAlvara().getIdRestricao().equals(PortalUtils.getCodRestricaocadPessoaJaExistente()) || restricaoAlvara.getCampoVerificacao().equals(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean possuiSituacaoIrregularGeo(List<CadastroImobiliarioSegmentoEntity> segmentos) {
        return segmentos.stream().anyMatch(segmento -> Objects.nonNull(segmento.getIdSituacaoSegmento()) && (SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_IRREGULAR_GEO.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_IRREGULAR_GEO_3.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento()) || SituacaoSegmentoImobEnum.SITUACAO_SEGMENTO_IRREGULAR_GEO_4.getCodigo().equals(segmento.getIdSituacaoSegmento().getIdSituacaoSegmento())));
    }
}

