/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.portalarrecadacao.service.SrvRestricaoLote;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RestricoesLote;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RestricoesLoteItem;
import br.com.elotech.tributacao.domain.aise.BoletimImobiliarioTerrenoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.ModeloIdentificacaoEntity;
import br.com.elotech.tributacao.enumerator.ModeloIdentificacaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimImobiliarioTerreno;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloIdentificacao;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloService(value="srvRestricaoLote")
@Scope(value="prototype")
public class SrvRestricaoLoteImpl
implements SrvRestricaoLote {
    @Resource
    private RepositoryModeloIdentificacao repositoryModeloIdentificacao;
    @Resource
    private RepositoryBoletimImobiliarioTerreno repositoryBoletimImobiliarioTerreno;

    public RestricoesLote getRestricaoLote(CadastroGeralAiseEntity cadastroGeral) {
        ModeloIdentificacaoEntity modIdentificacaoRestricaoAcessibilidade = this.repositoryModeloIdentificacao.load(ModeloIdentificacaoEnum.RESTRICAOACESSIBILIDADE.getValor());
        ModeloIdentificacaoEntity modIdentificacaoRestricaoFundoDeVale = this.repositoryModeloIdentificacao.load(ModeloIdentificacaoEnum.RESTRICAOFUNDODEVALE.getValor());
        RestricoesLote restricaoLote = new RestricoesLote();
        ArrayList<RestricoesLoteItem> listaItem = new ArrayList<RestricoesLoteItem>();
        if (modIdentificacaoRestricaoAcessibilidade != null) {
            RestricoesLoteItem restricaoLoteItemAcessibilidade = new RestricoesLoteItem();
            restricaoLoteItemAcessibilidade.setCodigo(Integer.valueOf(this.carregarBoletimRestricaoAcessibilidade(cadastroGeral, modIdentificacaoRestricaoAcessibilidade)));
            listaItem.add(restricaoLoteItemAcessibilidade);
        }
        if (modIdentificacaoRestricaoFundoDeVale != null) {
            RestricoesLoteItem restricaoLoteItemFundoDeVale = new RestricoesLoteItem();
            restricaoLoteItemFundoDeVale.setCodigo(Integer.valueOf(this.carregarBoletimRestricaoFundoDeVale(cadastroGeral, modIdentificacaoRestricaoFundoDeVale)));
            listaItem.add(restricaoLoteItemFundoDeVale);
        }
        restricaoLote.setItemRestricoesLote(listaItem);
        return restricaoLote;
    }

    private String carregarBoletimRestricaoAcessibilidade(CadastroGeralAiseEntity cadastroGeral, ModeloIdentificacaoEntity modeloIdentificacao) {
        String restricaoAcessibilidade = "0";
        BoletimImobiliarioTerrenoEntity boletimRestricaoAcessibilidade = this.repositoryBoletimImobiliarioTerreno.loadByCadastro(cadastroGeral, modeloIdentificacao);
        if (boletimRestricaoAcessibilidade != null && boletimRestricaoAcessibilidade.getId().getModeloResposta().getId().getModeloResposta().compareTo(2L) == 0) {
            restricaoAcessibilidade = boletimRestricaoAcessibilidade.getId().getModeloResposta().getId().getModeloResposta().toString();
        }
        return restricaoAcessibilidade;
    }

    private String carregarBoletimRestricaoFundoDeVale(CadastroGeralAiseEntity cadastroGeral, ModeloIdentificacaoEntity modeloIdentificacao) {
        String restricaoFundoDeVale = "0";
        BoletimImobiliarioTerrenoEntity boletimRestricaoFundoDeVale = this.repositoryBoletimImobiliarioTerreno.loadByCadastro(cadastroGeral, modeloIdentificacao);
        if (boletimRestricaoFundoDeVale != null && boletimRestricaoFundoDeVale.getId().getModeloResposta().getId().getModeloResposta().compareTo(2L) == 0) {
            restricaoFundoDeVale = boletimRestricaoFundoDeVale.getId().getModeloResposta().getId().getModeloResposta().toString();
        }
        return restricaoFundoDeVale;
    }
}

