/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.repository.RepositoryProibicaoAtividade;
import br.com.elotech.portalarrecadacao.service.SrvProibicao;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvProibicao")
public class SrvProibicaoImpl
implements SrvProibicao {
    @Resource
    private RepositoryProibicaoAtividade repositoryProibicao;

    public List<ProibicaoAtividadeEntity> carregarProibicoesPorAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade == null) {
            throw new IllegalArgumentException("Atividade n\u00e3o selecionada para consultar as Proibi\u00e7\u00f5es.");
        }
        return this.repositoryProibicao.carregarProibicoesAtividade(configuracaoAtividade);
    }

    public void salvarProibicaoAtividade(ProibicaoAtividadeEntity proibicaoAtividade) throws BaseException {
        if (this.proibicaoNaoCadastrada(proibicaoAtividade)) {
            this.repositoryProibicao.saveOrUpdate(proibicaoAtividade);
            ShowMessage.addInfoMessage((String)"msgProibicao", (String)("Proibi\u00e7\u00e3o " + proibicaoAtividade.getId().getProibicao().getDescricao() + " adicionada com sucesso"));
        } else {
            ShowMessage.addWarnMessage((String)"msgProibicao", (String)("Proibi\u00e7\u00e3o " + proibicaoAtividade.getId().getProibicao().getDescricao() + " j\u00e1 est\u00e1 vinculada a esta Atividade."));
        }
    }

    private boolean proibicaoNaoCadastrada(ProibicaoAtividadeEntity proibicaoAtividade) {
        return this.repositoryProibicao.proibicaoNaoCadastrada(proibicaoAtividade);
    }

    public void excluirProibicaoAtividade(ProibicaoAtividadeEntity proibicaoAtividade) {
        this.repositoryProibicao.remove(proibicaoAtividade);
    }

    public List<ProibicaoEntity> carregarProibicoesAtivas() {
        return this.repositoryProibicao.carregarProibicoesAtivas();
    }
}

