/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoTipoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.service.SrvMontaObsAlvara;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloService(value="srvMontaObsAlvara")
@Scope(value="prototype")
public class SrvMontaObsAlvaraImpl
extends EloLogger
implements SrvMontaObsAlvara {
    private static final String VALIDADE_ANUAL = "VALIDADE ANUAL";
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private RepositorySolicitacaoAlvaraValidade repositorySolicitacaoAlvaraValidade;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public String montaObsAlvara(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        try {
            StringBuilder obs = new StringBuilder();
            this.validaNaturezaPreencheObs(solicitacao, obs);
            SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            Boolean isAlvaraDefinitivoRedeSim = Objects.nonNull(solicitacaoRedeSim) && Objects.nonNull(solicitacaoRedeSim.getAlvaraEnviado()) && !TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO.equals((Object)solicitacaoRedeSim.getAlvaraEnviado());
            ArrayList listaVencimentoAlvara = new ArrayList();
            if (Boolean.FALSE.equals(isAlvaraDefinitivoRedeSim)) {
                listaVencimentoAlvara.addAll(this.recuperarListaVencimentoAlvara(solicitacao));
                this.ordenarListaVencimentoAlvara(listaVencimentoAlvara);
            }
            TipoAlvaraEnum tipoAlvara = Optional.ofNullable(solicitacaoRedeSim).map(SolicitacaoRedeSimEntity::getAlvaraEnviado).orElse(null);
            this.montarObservacaoVencimentoLaudos(tipoAlvara, solicitacao, obs, listaVencimentoAlvara);
            this.montarObservacaoDasAtividades(solicitacao, obs);
            this.montarObservacaoDosLaudos(solicitacao, obs);
            this.montarObservacaoValidacaoDocumento(solicitacao, obs);
            this.montarObservacaoProibicao(solicitacao, obs);
            String str1 = obs.toString().trim();
            return str1.replaceAll("<br>", "").replaceAll("<strong>", "").replaceAll("</strong>", "");
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException(String.format("%s%s", "Falha em Montar Observa\u00e7\u00e3o do alvar\u00e1 :", e.getMessage()), (Throwable)e);
        }
    }

    private void montarObservacaoDosLaudos(SolicitacaoAlvaraEntity solicitacao, StringBuilder obs) {
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            List listaLaudoAlvara = this.repositoryLaudoAlvara.buscarLaudoPorSolicitacao(solicitacao.getSolicitacaoAlvara());
            for (LaudoAlvaraEntity laudo : listaLaudoAlvara) {
                if (EloStringUtils.isEmpty((String)laudo.getObservacao()) && EloListUtils.safeIsEmpty((List)laudo.getObservacoesTipoLaudo()).booleanValue()) continue;
                if (!EloStringUtils.isEmpty((String)laudo.getObservacao())) {
                    obs.append(laudo.getObservacao()).append(";");
                }
                for (ObservacaoTipoLaudoEntity obsTL : laudo.getObservacoesTipoLaudo()) {
                    if (!obsTL.getExibirNoAlvara().equals(SimNaoEnum.SIM.getShortText())) continue;
                    obs.append("\n");
                    obs.append(obsTL.getDescricao()).append(";");
                }
            }
        }
    }

    private List<SolicitacaoAlvaraValidadeEntity> recuperarListaVencimentoAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        List listaVencimentoAlvara = this.repositorySolicitacaoAlvaraValidade.retornaValidadeBySolicitacao(solicitacao);
        if (EloListUtils.safeIsEmpty((List)listaVencimentoAlvara).booleanValue() || SimNaoEnum.equalSim((String)solicitacao.getRenovacao()).booleanValue()) {
            if (!EloListUtils.safeIsEmpty((List)listaVencimentoAlvara).booleanValue() && SimNaoEnum.equalSim((String)solicitacao.getRenovacao()).booleanValue()) {
                this.alteraSituacaoAtual(listaVencimentoAlvara);
            }
            if (!EloListUtils.safeIsEmpty((List)(listaVencimentoAlvara = this.preencherVencimentoAlvara(solicitacao))).booleanValue()) {
                for (SolicitacaoAlvaraValidadeEntity validade : listaVencimentoAlvara) {
                    if (!Objects.isNull(validade.getIdSolicitacaoAlvaraValidade()) && this.isValidadeAnualAtual(validade)) continue;
                    validade.setSolicitacaoAlvara(solicitacao);
                    validade.setAtual("S");
                    validade.setIdSolicitacaoAlvaraValidade(this.repositorySolicitacaoAlvaraValidade.getSequence());
                    this.salvarSolicitacaoAlvaraValidade(validade);
                }
            }
        }
        return listaVencimentoAlvara;
    }

    private void montarObservacaoProibicao(SolicitacaoAlvaraEntity solicitacao, StringBuilder obs) {
        if (solicitacao.getProibicao() != null && !solicitacao.getProibicao().isEmpty()) {
            obs.append(solicitacao.getProibicao());
        }
    }

    private void montarObservacaoValidacaoDocumento(SolicitacaoAlvaraEntity solicitacao, StringBuilder obs) {
        if (solicitacao.getObsValidacaoDoc() != null) {
            obs.append("\n");
            obs.append(solicitacao.getObsValidacaoDoc());
        }
    }

    private void montarObservacaoVencimentoLaudos(TipoAlvaraEnum tipoAlvara, SolicitacaoAlvaraEntity solicitacao, StringBuilder obs, List<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara) {
        if (!EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            List laudosProvisorios = solicitacao.getLaudos().stream().filter(LaudoAlvaraEntity::isLaudoLiberadoProvisorio).collect(Collectors.toList());
            if (laudosProvisorios.isEmpty()) {
                if (solicitacao.isRedeSim() && !TipoAlvaraEnum.alvaraDefinitivo((TipoAlvaraEnum)tipoAlvara).booleanValue()) {
                    String laudos = solicitacao.getLaudos().stream().map(LaudoAlvaraEntity::getTipoLaudo).map(TipoLaudoEntity::getDescricao).collect(Collectors.joining(", "));
                    obs.append("Laudos exigidos: ").append(laudos).append(";\n");
                }
            } else {
                for (LaudoAlvaraEntity laudo : laudosProvisorios) {
                    obs.append("LAUDO ").append(laudo.getTipoLaudo().getDescricao()).append(" V\u00e1lido at\u00e9 : ").append(EloDateUtils.toAnsiDateString((Date)laudo.getDataValidade(), (String)"dd/MM/yyyy")).append(";\n");
                }
            }
        } else if (!EloListUtils.safeIsEmpty(listaVencimentoAlvara).booleanValue()) {
            solicitacao.getCadastroMobiliario().setDataValidadeAlvara(listaVencimentoAlvara.get(0).getDataValidade());
            for (SolicitacaoAlvaraValidadeEntity vencimentoAlvara : listaVencimentoAlvara) {
                if (vencimentoAlvara.getDescricao().contains(VALIDADE_ANUAL)) continue;
                obs.append(vencimentoAlvara.getDescricao());
                obs.append(" V\u00e1lido at\u00e9 : ").append(EloDateUtils.toAnsiDateString((Date)vencimentoAlvara.getDataValidade(), (String)"dd/MM/yyyy"));
                obs.append(";\n");
            }
        } else {
            solicitacao.getCadastroMobiliario().setDataValidadeAlvara(null);
        }
    }

    private void ordenarListaVencimentoAlvara(List<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara) {
        Collections.sort(listaVencimentoAlvara, new /* Unavailable Anonymous Inner Class!! */);
    }

    private void montarObservacaoDasAtividades(SolicitacaoAlvaraEntity solicitacao, StringBuilder obs) {
        obs.append(solicitacao.getObservacaoDasAtividades(Boolean.FALSE.booleanValue()));
    }

    private void validaNaturezaPreencheObs(SolicitacaoAlvaraEntity solicitacao, StringBuilder obs) {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS, NaturezaSolicitacaoAlvaraEnum.MUDANCA_RAZAO_SOCIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA}) && !solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE, NaturezaSolicitacaoAlvaraEnum.INICIAL}) && (solicitacao.isNaturezaAlteracaoSocio() || solicitacao.isNaturezaMudancaRazaoSocial() || solicitacao.isNaturezaMudancaArea() && !solicitacao.isAreaMaiorQueAtual()) && EloListUtils.safeIsEmpty((List)solicitacao.getLaudos()).booleanValue()) {
            obs.append(solicitacao.getCadastroMobiliario().getObservacaoAlvara() == null ? "" : solicitacao.getCadastroMobiliario().getObservacaoAlvara() + "\n");
        }
    }

    public void salvarSolicitacaoAlvaraValidade(SolicitacaoAlvaraValidadeEntity solicitacaoAlvaraValidade) {
        this.repositorySolicitacaoAlvaraValidade.saveOrUpdate(solicitacaoAlvaraValidade);
    }

    private void alteraSituacaoAtual(List<SolicitacaoAlvaraValidadeEntity> listaValidade) {
        try {
            Date dataValidadeAnual = this.montarDataValidadeAlvaraAnual();
            for (SolicitacaoAlvaraValidadeEntity solicitacaoAlvaraValidade : listaValidade) {
                if (this.isValidadeAnualVigente(solicitacaoAlvaraValidade, dataValidadeAnual)) continue;
                solicitacaoAlvaraValidade.setAtual("N");
                this.repositorySolicitacaoAlvaraValidade.saveOrUpdate(solicitacaoAlvaraValidade);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public List<SolicitacaoAlvaraValidadeEntity> preencherVencimentoAlvara(SolicitacaoAlvaraEntity solicitacao) {
        ArrayList<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara = new ArrayList<SolicitacaoAlvaraValidadeEntity>();
        this.montarVencimentoLaudo(solicitacao, listaVencimentoAlvara);
        this.montarVencimentoProvisorio(solicitacao, listaVencimentoAlvara);
        this.montarVencimentoProvisorioSefaz(solicitacao, listaVencimentoAlvara);
        this.montarValidadeAnual(solicitacao, listaVencimentoAlvara);
        return listaVencimentoAlvara;
    }

    private void montarValidadeAnual(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara) {
        try {
            if (solicitacao.isRenovacao()) {
                SolicitacaoAlvaraValidadeEntity validade = this.repositorySolicitacaoAlvaraValidade.carregarValidadeAnual(solicitacao);
                if (validade != null) {
                    listaVencimentoAlvara.add(validade);
                }
            } else {
                Date dataValidadeAnual = this.montarDataValidadeAlvaraAnual();
                if (Objects.nonNull(dataValidadeAnual) && this.permitRenovacaoAnual(solicitacao)) {
                    SolicitacaoAlvaraValidadeEntity vencimentoAlvara = new SolicitacaoAlvaraValidadeEntity();
                    vencimentoAlvara.setDataValidade(dataValidadeAnual);
                    vencimentoAlvara.setDescricao(VALIDADE_ANUAL);
                    listaVencimentoAlvara.add(vencimentoAlvara);
                }
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean permitRenovacaoAnual(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara.isSolicitacaoMEI()) {
            return Boolean.TRUE;
        }
        if (!this.isValidAlvaraAnual()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean isValidAlvaraAnual() {
        EntidadeTributacaoEntity entidadeTributacao = this.getEntidadeTributacao();
        ParametroAlvaraEntity parametroValidadeAlvara = this.repositoryParametroAlvara.getParametroAlvara(entidadeTributacao.getId().getEntidade(), ParametroAlvaraEnum.VALIDADE_ALVARA_ANUAL);
        return Objects.nonNull(parametroValidadeAlvara) && !EloStringUtils.isEmpty((String)parametroValidadeAlvara.getValor());
    }

    private void montarVencimentoProvisorioSefaz(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara) {
        if (solicitacao.getDataValidadeSefaz() != null) {
            SolicitacaoAlvaraValidadeEntity vencimentoAlvara = new SolicitacaoAlvaraValidadeEntity();
            vencimentoAlvara.setDataValidade(solicitacao.getDataValidadeSefaz());
            vencimentoAlvara.setDescricao("PROVIS\u00d3RIO SEFAZ ");
            listaVencimentoAlvara.add(vencimentoAlvara);
        }
    }

    private void montarVencimentoProvisorio(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara) {
        if (Objects.nonNull(solicitacao.getDataValidadeProvisorio())) {
            SolicitacaoAlvaraValidadeEntity vencimentoAlvara = new SolicitacaoAlvaraValidadeEntity();
            vencimentoAlvara.setDataValidade(solicitacao.getDataValidadeProvisorio());
            vencimentoAlvara.setDescricao("ALVAR\u00c1 PROVIS\u00d3RIO");
            listaVencimentoAlvara.add(vencimentoAlvara);
        }
    }

    private void montarVencimentoLaudo(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraValidadeEntity> listaVencimentoAlvara) {
        List listaLaudoAlvara = this.repositoryLaudoAlvara.buscarLaudoPorSolicitacao(solicitacao.getSolicitacaoAlvara());
        if (listaLaudoAlvara != null) {
            for (LaudoAlvaraEntity laudoAlvara : listaLaudoAlvara) {
                if (!Objects.nonNull(laudoAlvara.getDataValidade())) continue;
                SolicitacaoAlvaraValidadeEntity vencimentoAlvara = new SolicitacaoAlvaraValidadeEntity();
                vencimentoAlvara.setDataValidade(laudoAlvara.getDataValidade());
                vencimentoAlvara.setDescricao(String.format("%s%s", "LAUDO ", laudoAlvara.getTipoLaudo().getDescricao()));
                listaVencimentoAlvara.add(vencimentoAlvara);
            }
        }
    }

    private boolean isValidadeAnualVigente(SolicitacaoAlvaraValidadeEntity validade, Date dataValidadeAnual) throws BaseException {
        return dataValidadeAnual != null && this.isValidadeAnualAtual(validade) && validade.getDataValidade().compareTo(dataValidadeAnual) == 0;
    }

    private boolean isValidadeAnualAtual(SolicitacaoAlvaraValidadeEntity validade) {
        return validade.getDescricao().contains(VALIDADE_ANUAL) && "S".equals(validade.getAtual());
    }

    public Date montarDataValidadeAlvaraAnual() throws BaseException {
        Date dataValidadeAnual = null;
        try {
            EntidadeTributacaoEntity entidadeTributacao = this.getEntidadeTributacao();
            ParametroAlvaraEntity parametroValidadeAlvara = this.repositoryParametroAlvara.getParametroAlvara(entidadeTributacao.getId().getEntidade(), ParametroAlvaraEnum.VALIDADE_ALVARA_ANUAL);
            if (parametroValidadeAlvara != null && !EloStringUtils.isEmpty((String)parametroValidadeAlvara.getValor())) {
                Long exercicioAtual = entidadeTributacao.getId().getExercicioTributacao().getExercicio();
                String dataValidade = null;
                dataValidade = parametroValidadeAlvara.getValor() + "/" + exercicioAtual;
                Date dataValidadeAnualVigente = EloDateUtils.fromDateString((String)dataValidade);
                if (dataValidadeAnualVigente.compareTo(new Date()) > 0) {
                    dataValidadeAnual = dataValidadeAnualVigente;
                } else {
                    dataValidade = parametroValidadeAlvara.getValor() + "/" + (exercicioAtual + 1L);
                    dataValidadeAnual = EloDateUtils.fromDateString((String)dataValidade);
                }
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel montar a data de validade anual do alvar\u00e1. " + e.getMessage());
        }
        return dataValidadeAnual;
    }

    public EntidadeTributacaoEntity getEntidadeTributacao() {
        return this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
    }
}

