/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.tributacao.common.Filtro;
import br.com.elotech.tributacao.common.MenuComponent;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.service.SrvMenu;
import java.time.LocalDate;
import javax.annotation.Resource;

@EloService(value="srvMenu")
public class SrvMenuImpl
extends EloLogger
implements SrvMenu {
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    private EntidadeAiseEntity entidadeAise;
    private MenuComponent menu;

    public MenuComponent carregarMenu(Filtro filtro) throws BaseException {
        this.carregarEntidadeAise();
        this.menu = new MenuComponent();
        this.carregarParametroCriarUsuarioContribuinte();
        this.carregarParametroMenuConsultaPrevia();
        this.carregarParametroMenuAdicionarLaudo();
        this.carregarParametroMenuParecerDosLaudos();
        this.carregarParametroMenuValidacaoDosDocumentos();
        this.carregarParametroMenuLiberarSolicitacao();
        this.carregarParametroMenuAcompanhamentoSolicitacao();
        this.carregarParametroMenuReimpressaoAlvara();
        this.carregarParametroMenuRelatorioConsultaSolicitacao();
        this.carregarParametroMenuRelatorioLaudos();
        this.carregarParametroMenuRelatorioLaudosVencidos();
        this.carregarParametroMenuRelatorioQuantidadeConsultasSolicitacoes();
        this.carregarParametroMenuRelatorioAlvarasEmitidos();
        this.carregarParametroMenuRelatorioHistoricoRenovacoes();
        this.carregarParametroMenuRelatorioSolicitacoesRedeSim();
        this.carregarParametroMenuConfigurarSituacaoMobiliario();
        this.carregarParametroMenuConfigurarTiposDocumentoPorTiposInscricao();
        this.carregarParametroMenuConfigurarTiposDocumentoPorUsuario();
        this.carregarParametroMenuConfigurarNaturezaSolicitacaoPorTipoInscricao();
        this.carregarParametroMenuConfigurarAtividades();
        this.carregarParametroMenuConfigurarTiposExigencia();
        this.carregarParametroMenuConfigurarParametros();
        this.carregarParametroMenuConfigurarObservacaoAtividades();
        this.carregarParametroMenuConfigurarObservacaoTiposLaudo();
        this.carregarParametroMenuConfigurarCadastroRestricao();
        this.carregarParametroMenuCadastroRestricaoUsuario();
        this.carregarParametroMenuLiberarPermissaoUsuarios();
        this.carregarParametroMenuLiberarAcessoLaudos();
        this.carregarParametroMenuConsultaPreviaRedeSim();
        this.carregarParametroMenuSolicitacaoRedeSim();
        this.carregarParametroMenuMotivoIndeferimentoRedeSim();
        this.carregarParametroMenuEventoRedeSim();
        this.carregarParametroMenuExigenciaRedeSim();
        this.carregarParametroMenuAlvaraProvisorioRedeSim();
        this.carregarParametroMenuSituacaoDocumentoPorSituacaoLaudo();
        this.carregarParametroIntegradoRedeSim();
        this.carregarParametroMenuTipoPessoaPorNaturezaRedeSim();
        this.carregarParametroMenuTipoDocumentoTipoLaudoRedeSim();
        this.carregarParametroRestricaoUsuario();
        this.carregarParametroMenuSolicitacaoEncaminhada();
        this.carregarParametroMenuRelatorioSolicitacaoDispensaLicencaAmbiental();
        this.carregarParametroModoSimplificado();
        return this.menu;
    }

    private void carregarParametroModoSimplificado() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.INTEGRADO_REDESIM_SIMPLIFICADO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.INTEGRADO_REDESIM_SIMPLIFICADO));
    }

    private void carregarParametroMenuLiberarAcessoLaudos() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_LIBERAR_ACESSO_LAUDOS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_LIBERAR_ACESSO_LAUDOS));
    }

    private void carregarParametroMenuLiberarPermissaoUsuarios() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_LIBERAR_PERMISSAO_USUARIO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_LIBERAR_PERMISSAO_USUARIO));
    }

    private void carregarParametroMenuConfigurarObservacaoTiposLaudo() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_OBSERVACAO_TIPO_LAUDO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_OBSERVACAO_TIPO_LAUDO));
    }

    private void carregarParametroMenuConfigurarObservacaoAtividades() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_OBSERVACAO_ATIVIDADES.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_OBSERVACAO_ATIVIDADES));
    }

    private void carregarParametroMenuConfigurarParametros() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_PARAMETROS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_PARAMETROS));
    }

    private void carregarParametroMenuConfigurarTiposExigencia() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_TIPO_EXIGENCIA.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_TIPO_EXIGENCIA));
    }

    private void carregarParametroMenuConfigurarAtividades() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_ATIVIDADE.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_ATIVIDADE));
    }

    private void carregarParametroMenuConfigurarNaturezaSolicitacaoPorTipoInscricao() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_NATUREZA_SOLICITACAO_TIPO_INSCRICAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_NATUREZA_SOLICITACAO_TIPO_INSCRICAO));
    }

    private void carregarParametroMenuConfigurarTiposDocumentoPorUsuario() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_TIPO_DOCUMENTO_POR_USUARIO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_TIPO_DOCUMENTO_POR_USUARIO));
    }

    private void carregarParametroMenuConfigurarTiposDocumentoPorTiposInscricao() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_TIPO_DOCUMENTO_TIPO_INSCRICAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_TIPO_DOCUMENTO_TIPO_INSCRICAO));
    }

    private void carregarParametroMenuConfigurarSituacaoMobiliario() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_SITUACAO_MOBILIARIO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_SITUACAO_MOBILIARIO));
    }

    private void carregarParametroMenuConfigurarCadastroRestricao() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_CADASTRO_RESTRICAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONFIGURAR_CADASTRO_RESTRICAO));
    }

    private void carregarParametroMenuCadastroRestricaoUsuario() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CADASTRO_RESTRICAO_USUARIO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CADASTRO_RESTRICAO_USUARIO));
    }

    private void carregarParametroMenuRelatorioSolicitacoesRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_SOLICITACOES_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_SOLICITACOES_REDE_SIM));
    }

    private void carregarParametroMenuRelatorioHistoricoRenovacoes() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_HISTORICO_RENOVACAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_HISTORICO_RENOVACAO));
    }

    private void carregarParametroMenuRelatorioAlvarasEmitidos() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_ALVARAS_EMITIDOS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_ALVARAS_EMITIDOS));
    }

    private void carregarParametroMenuRelatorioQuantidadeConsultasSolicitacoes() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_QUANTIDADE_CONSULTAS_SOLICITACOES.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_QUANTIDADE_CONSULTAS_SOLICITACOES));
    }

    private void carregarParametroMenuRelatorioLaudosVencidos() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_LAUDOS_VENCIDOS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_LAUDOS_VENCIDOS));
    }

    private void carregarParametroMenuRelatorioLaudos() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_LAUDOS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_LAUDOS));
    }

    private void carregarParametroMenuRelatorioConsultaSolicitacao() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_CONSULTA_SOLICITACAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_CONSULTA_SOLICITACAO));
    }

    private void carregarParametroMenuReimpressaoAlvara() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_REIMPRESSAO_ALVARA.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_REIMPRESSAO_ALVARA));
    }

    private void carregarParametroMenuAcompanhamentoSolicitacao() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_ACOMPANHAMENTO_SOLICITACAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_ACOMPANHAMENTO_SOLICITACAO));
    }

    private void carregarParametroMenuLiberarSolicitacao() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_LIBERACAO_SOLICITACAO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_LIBERACAO_SOLICITACAO));
    }

    private void carregarParametroMenuValidacaoDosDocumentos() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_VALIDACAO_DOCUMENTOS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_VALIDACAO_DOCUMENTOS));
    }

    private void carregarParametroMenuParecerDosLaudos() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_PARECER_DOS_LAUDOS.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_PARECER_DOS_LAUDOS));
    }

    private void carregarParametroMenuAdicionarLaudo() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_ADICIONAR_LAUDO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_ADICIONAR_LAUDO));
    }

    private void carregarParametroMenuConsultaPrevia() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONSULTA_PREVIA.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONSULTA_PREVIA));
    }

    private void carregarParametroMenuConsultaPreviaRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_CONSULTA_PREVIA_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_CONSULTA_PREVIA_REDE_SIM));
    }

    private void carregarParametroMenuSolicitacaoRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_SOLICITACAO_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_SOLICITACAO_REDE_SIM));
    }

    private void carregarParametroMenuAlvaraProvisorioRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_ALVARA_PROVISORIO_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_ALVARA_PROVISORIO_REDE_SIM));
    }

    private void carregarParametroMenuEventoRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_EVENTOS_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_EVENTOS_REDE_SIM));
    }

    private void carregarParametroMenuMotivoIndeferimentoRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_MOTIVO_INDEFERIMENTO_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_MOTIVO_INDEFERIMENTO_REDE_SIM));
    }

    private void carregarParametroMenuTipoPessoaPorNaturezaRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_TIPO_PESSOA_POR_NATUREZA_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_TIPO_PESSOA_POR_NATUREZA_REDE_SIM));
    }

    private void carregarParametroMenuExigenciaRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_EXIGENCIA_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_EXIGENCIA_REDE_SIM));
    }

    private void carregarParametroMenuTipoDocumentoTipoLaudoRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_TIPODOCUMENTOTIPOLAUDO_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_TIPODOCUMENTOTIPOLAUDO_REDE_SIM));
    }

    private void carregarParametroMenuSituacaoDocumentoPorSituacaoLaudo() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_SITUACAODOCUMENTOPORLAUDO_REDE_SIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_SITUACAODOCUMENTOPORLAUDO_REDE_SIM));
    }

    private void carregarParametroIntegradoRedeSim() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.INTEGRADO_REDESIM.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.INTEGRADO_REDESIM));
    }

    private void carregarParametroRestricaoUsuario() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_LIBERAR_RESTRICOES_USUARIO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_LIBERAR_RESTRICOES_USUARIO));
    }

    private void carregarParametroMenuSolicitacaoEncaminhada() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_SOLICITACAO_ENCAMINHADA.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_SOLICITACAO_ENCAMINHADA));
    }

    private void carregarParametroMenuRelatorioSolicitacaoDispensaLicencaAmbiental() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_SOLICITACAO_DISPENSA_AMBIENTAL.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.MOSTRA_MENU_RELATORIO_SOLICITACAO_DISPENSA_AMBIENTAL));
    }

    public MenuComponent getMenu() throws BaseException {
        if (this.menu == null) {
            this.menu = this.carregarMenu(null);
        }
        return this.menu;
    }

    public void setMenu(MenuComponent menu) {
        this.menu = menu;
    }

    private void carregarParametroCriarUsuarioContribuinte() throws BaseException {
        this.getMenu().adicionarMenu(ParametroAlvaraEnum.PERMITE_CRIAR_USUARIO.name(), this.carregarParametroEqualSim(ParametroAlvaraEnum.PERMITE_CRIAR_USUARIO));
    }

    private void carregarEntidadeAise() {
        if (this.entidadeAise == null) {
            EntidadeTributacaoEntity entidadeTributacao = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(LocalDate.now().getYear()));
            this.entidadeAise = entidadeTributacao.getId().getEntidade();
        }
    }

    private Boolean carregarParametroEqualSim(ParametroAlvaraEnum parametro) {
        ParametroAlvaraEntity parametroAlvara = this.repositoryParametroAlvara.getParametroAlvara(this.entidadeAise, parametro);
        return parametro != null && SimNaoEnum.equalSim((String)parametroAlvara.getValor()) != false;
    }
}

