/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.FilaEnvioEmailSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoAndamentoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoFilaEnvioEmailSolicitacaoEnum;
import br.com.elotech.portalarrecadacao.exception.LaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryFilaEnvioEmailSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvaraDocumento;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoExigido;
import br.com.elotech.portalarrecadacao.repository.RepositoryObservacaoAndamentoLaudo;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvEnviaEmailAlteracoesSolicitacao;
import br.com.elotech.portalarrecadacao.service.SrvLaudoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraCBO;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraMEI;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.portalarrecadacao.service.impl.SrvAndamentoLaudoAlvaraImpl;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.alvara.RepositoryDocumentoAiseAlvara;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.wicket.util.string.Strings;

@EloService(value="srvLaudoAlvara")
public class SrvLaudoAlvaraImpl
extends EloLogger
implements SrvLaudoAlvara {
    @Resource
    private RepositoryLaudoExigido repositoryLaudoExigido;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private RepositoryDocumentoAiseAlvara repositoryDocumentoAiseAlvara;
    @Resource
    private RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara;
    @Resource
    private RepositoryObservacaoAndamentoLaudo repositoryObservacaoAndamentoLaudo;
    @Resource
    private SrvSolicitacaoAlvaraPrestadorServico srvSolicitacaoAlvaraPrestadorServico;
    @Resource
    private SrvSolicitacaoAlvaraCBO srvSolicitacaoAlvaraCBO;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryLaudoAlvaraDocumento repositoryLaudoAlvaraDocumento;
    @Resource
    private SrvSolicitacaoAlvaraMEI srvSolicitacaoAlvaraMEI;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Resource
    private RepositoryFilaEnvioEmailSolicitacaoAlvara repositoryFilaEnvioEmailSolicitacaoAlvara;
    @Resource
    private SrvEnviaEmailAlteracoesSolicitacao srvEnviaEmailAlteracoesSolicitacao;
    @Resource
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    @Resource
    private SrvAndamentoLaudoAlvaraImpl srvAndamentoLaudoAlvara;

    public void setRepositoryLaudoAlvara(RepositoryLaudoAlvara repositoryLaudoAlvara) {
        this.repositoryLaudoAlvara = repositoryLaudoAlvara;
    }

    public void setRepositoryAndamentoLaudoAlvara(RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara) {
        this.repositoryAndamentoLaudoAlvara = repositoryAndamentoLaudoAlvara;
    }

    public RepositoryObservacaoAndamentoLaudo getRepositoryObservacaoAndamentoLaudo() {
        return this.repositoryObservacaoAndamentoLaudo;
    }

    public void setRepositoryObservacaoAndamentoLaudo(RepositoryObservacaoAndamentoLaudo repositoryObservacaoAndamentoLaudo) {
        this.repositoryObservacaoAndamentoLaudo = repositoryObservacaoAndamentoLaudo;
    }

    public void setSrvSolicitacaoAlvaraHelper(SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper) {
        this.srvSolicitacaoAlvaraHelper = srvSolicitacaoAlvaraHelper;
    }

    public void setSrvEnviaEmailAlteracoesSolicitacao(SrvEnviaEmailAlteracoesSolicitacao srvEnviaEmailAlteracoesSolicitacao) {
        this.srvEnviaEmailAlteracoesSolicitacao = srvEnviaEmailAlteracoesSolicitacao;
    }

    public void setRepositoryFilaEnvioEmailSolicitacaoAlvara(RepositoryFilaEnvioEmailSolicitacaoAlvara repositoryFilaEnvioEmailSolicitacaoAlvara) {
        this.repositoryFilaEnvioEmailSolicitacaoAlvara = repositoryFilaEnvioEmailSolicitacaoAlvara;
    }

    private boolean gerarLaudoLiberadoRiscoBaixo(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        return solicitacaoAlvara.isGrauRiscoBaixo() && SimNaoEnum.getNaoShortText().equals(UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_LAUDO_RISCO_B));
    }

    public void buscarLaudosExigidosPorAtividade(List<SolicitacaoAlvaraAtividadeEntity> listaAtividades, SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraException {
        if (EloListUtils.safeIsEmpty(listaAtividades).booleanValue()) {
            this.srvSolicitacaoAlvaraHelper.carregarEsalvarAtividadesNaSolicitacao(solicitacaoAlvara);
            listaAtividades = solicitacaoAlvara.getSolicitacaoAlvaraAtividades();
        }
        try {
            List listaLaudoExigido = this.repositoryLaudoExigido.getLaudoPorAtividade(listaAtividades);
            for (LaudoExigidoEntity laudoExigido : listaLaudoExigido) {
                LaudoAlvaraEntity laudoAlvara = new LaudoAlvaraEntity();
                laudoAlvara.setTipoLaudo(laudoExigido.getTipoLaudo());
                laudoAlvara.setIdSolicitacaoAlvara(solicitacaoAlvara);
                laudoAlvara.setIdLaudoAlvara(this.repositoryLaudoAlvara.getSequence());
                laudoAlvara.setUsuario((UsuarioEntity)this.srvSolicitacaoAlvaraHelper.getUsuarioLogado());
                if (this.gerarLaudoLiberadoRiscoBaixo(solicitacaoAlvara)) {
                    laudoAlvara.setStatus(StatusLaudoAlvara.LAUDO_LIBERADO_RISCO_B);
                    laudoAlvara.setVistoriar("N");
                } else {
                    laudoAlvara.setStatus(StatusLaudoAlvara.EM_ANDAMENTO);
                }
                laudoAlvara = this.repositoryLaudoAlvara.saveOrUpdate(laudoAlvara);
                if (!this.gerarLaudoLiberadoRiscoBaixo(solicitacaoAlvara)) continue;
                this.srvAndamentoLaudoAlvara.adicionarAndamentoLaudoRiscoBaixo(laudoAlvara, laudoAlvara.getUsuario());
            }
        }
        catch (Exception e) {
            throw new SolicitacaoAlvaraException("Laudo n\u00e3o encontrado, verifique a configura\u00e7\u00e3o dos laudos exigidos por atividade", e.getCause());
        }
    }

    public void salvarAndamento(LaudoAlvaraEntity laudo, AndamentoLaudoAlvaraEntity andamentoLaudo, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (laudo.getIdLaudoAlvara() == null) {
            laudo.setIdLaudoAlvara(this.repositoryLaudoAlvara.getSequence());
        }
        if (!EloListUtils.safeIsEmpty((List)laudo.getDocumentos()).booleanValue()) {
            for (LaudoAlvaraDocumentoEntity documento : laudo.getDocumentos()) {
                if (documento.getId() != null) continue;
                documento.setId(this.repositoryLaudoAlvaraDocumento.getSequence());
            }
        }
        if (andamentoLaudo.getIdAndamentoLaudoAlvara() == null) {
            andamentoLaudo.setIdAndamentoLaudoAlvara(this.repositoryAndamentoLaudoAlvara.getSequence());
        }
        if (andamentoLaudo.getProcessoFiscalizacao() != null && andamentoLaudo.getProcessoFiscalizacao().getId() == null) {
            andamentoLaudo.getProcessoFiscalizacao().setId(this.repositoryAndamentoLaudoAlvara.getSequenceProcessoFiscalizacao());
        }
        this.repositoryAndamentoLaudoAlvara.saveOrUpdate(andamentoLaudo);
        this.repositoryLaudoAlvara.saveOrUpdate(laudo);
        this.repositoryLaudoAlvara.flush();
        this.notificarAlteracaoDeLaudo(laudo, solicitacao);
    }

    private void notificarAlteracaoDeLaudo(LaudoAlvaraEntity laudo, SolicitacaoAlvaraEntity solicitacao) {
        FilaEnvioEmailSolicitacaoAlvaraEntity filaEnvio = new FilaEnvioEmailSolicitacaoAlvaraEntity();
        filaEnvio.setId(this.repositoryFilaEnvioEmailSolicitacaoAlvara.getSequence());
        filaEnvio.setSolicitacaoAlvara(solicitacao);
        filaEnvio.setTipoEnvioEmail(TipoFilaEnvioEmailSolicitacaoEnum.TRAMITE_LAUDO);
        String observacao = String.format("<p>Laudo <b>%s</b> alterado para situa\u00e7\u00e3o de <b>%s</b>.</p>", laudo.getTipoLaudo().getDescricao(), laudo.getStatus().getDescricao());
        filaEnvio.setObservacao(observacao);
        try {
            this.srvEnviaEmailAlteracoesSolicitacao.enviaEmailDireto(solicitacao, (List)Lists.newArrayList((Object[])new FilaEnvioEmailSolicitacaoAlvaraEntity[]{filaEnvio}));
        }
        catch (BaseException e) {
            this.logger.info((Object)"FALHA NO ENVIO DE EMAIL >>>");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.repositoryFilaEnvioEmailSolicitacaoAlvara.saveOrUpdate(filaEnvio);
        }
    }

    public void salvarLaudoExigido(LaudoExigidoEntity laudoExigido) {
        if (this.laudoExigidoNaoCadastrado(laudoExigido)) {
            if (!EloNumberUtils.isBiggerThanZero((Number)laudoExigido.getIdLaudoExigido()).booleanValue()) {
                laudoExigido.setIdLaudoExigido(this.repositoryLaudoExigido.getSequence());
            }
            this.repositoryLaudoExigido.saveOrUpdate(laudoExigido);
            ShowMessage.addInfoMessage((String)"msgLaudo", (String)("Exig\u00eancia " + laudoExigido.getTipoLaudo().getDescricao() + " adicionada com sucesso"));
        } else {
            ShowMessage.addWarnMessage((String)"msgLaudo", (String)("Exig\u00eancia " + laudoExigido.getTipoLaudo().getDescricao() + " j\u00e1 est\u00e1 vinculado a esta Atividade."));
        }
    }

    private boolean laudoExigidoNaoCadastrado(LaudoExigidoEntity laudoExigido) {
        return this.repositoryLaudoExigido.laudoExigidoNaoCadastrado(laudoExigido);
    }

    public void excluirLaudoExigido(LaudoExigidoEntity laudoExigido) {
        this.repositoryLaudoExigido.remove(laudoExigido);
    }

    public LaudoAlvaraEntity findLaudoById(Long idLaudo) throws LaudoNaoEncontradoException {
        LaudoAlvaraEntity laudo = this.repositoryLaudoAlvara.findById(idLaudo);
        if (laudo == null) {
            throw new LaudoNaoEncontradoException("O laudo n\u00e3o foi encontrado");
        }
        return laudo;
    }

    public void addAndamentoCanceladoEmTodosLaudos(SolicitacaoAlvaraEntity solicitacao, String motivoCancelamento) throws SolicitacaoAlvaraException {
        try {
            for (LaudoAlvaraEntity laudo : solicitacao.getLaudos()) {
                AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
                andamento.setStatus(StatusLaudoAlvara.CANCELADO);
                andamento.setDescricao(motivoCancelamento);
                andamento.setUsuario((UsuarioEntity)this.srvSolicitacaoAlvaraHelper.getUsuarioLogado());
                andamento.setDataAndamento(new Date());
                laudo.setStatus(StatusLaudoAlvara.CANCELADO);
                andamento.setIdLaudoAlvara(laudo);
                andamento = this.addObservacaoAndamentoCancelado(andamento);
                this.salvarAndamento(laudo, andamento, solicitacao);
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException(Strings.join((String)"Ocorreu uma falha ao salvar o andamento favor entrar em contato com o Suporte T\u00e9cnico,  ", (String[])new String[]{e.getMessage()}));
        }
    }

    public void reativarLaudosCancelados(SolicitacaoAlvaraEntity solicitacao) throws SolicitacaoAlvaraException {
        try {
            for (LaudoAlvaraEntity laudo : solicitacao.getLaudos()) {
                AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
                andamento.setStatus(StatusLaudoAlvara.EM_ANDAMENTO);
                andamento.setUsuario((UsuarioEntity)this.srvSolicitacaoAlvaraHelper.getUsuarioLogado());
                andamento.setDataAndamento(new Date());
                laudo.setStatus(StatusLaudoAlvara.EM_ANDAMENTO);
                andamento.setIdLaudoAlvara(laudo);
                andamento = this.addObservacaoAndamento(andamento);
                this.salvarAndamento(laudo, andamento, solicitacao);
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraException(Strings.join((String)"Ocorreu uma falha ao salvar o andamento favor entrar em contato com o Suporte T\u00e9cnico,  ", (String[])new String[]{e.getMessage()}));
        }
    }

    private AndamentoLaudoAlvaraEntity addObservacaoAndamento(AndamentoLaudoAlvaraEntity andamento) {
        ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
        observacaoAndamentoLaudo.setId(this.repositoryObservacaoAndamentoLaudo.getSequence());
        observacaoAndamentoLaudo.setDescricao("Laudos reativados pelo sistema.");
        observacaoAndamentoLaudo.setIdAndamentoLaudoAlvara(andamento);
        observacaoAndamentoLaudo.setUsuario((UsuarioEntity)this.srvSolicitacaoAlvaraHelper.getUsuarioLogado());
        observacaoAndamentoLaudo.setDataObservacao(new Date());
        observacaoAndamentoLaudo.setResolvido(SimNaoEnum.NAO.getShortText());
        andamento.getObservacoes().add(observacaoAndamentoLaudo);
        return andamento;
    }

    private AndamentoLaudoAlvaraEntity addObservacaoAndamentoCancelado(AndamentoLaudoAlvaraEntity andamento) {
        ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
        observacaoAndamentoLaudo.setId(this.repositoryObservacaoAndamentoLaudo.getSequence());
        observacaoAndamentoLaudo.setDescricao("Laudos cancelados pelo sistema.");
        observacaoAndamentoLaudo.setIdAndamentoLaudoAlvara(andamento);
        observacaoAndamentoLaudo.setUsuario((UsuarioEntity)this.srvSolicitacaoAlvaraHelper.getUsuarioLogado());
        observacaoAndamentoLaudo.setDataObservacao(new Date());
        observacaoAndamentoLaudo.setResolvido(SimNaoEnum.NAO.getShortText());
        andamento.getObservacoes().add(observacaoAndamentoLaudo);
        return andamento;
    }

    public boolean isDocumentoCancelado(Long tipoDocumento, CadastroGeralAisePK cadastroGeral, Long numeroDoc) {
        if (!EloNumberUtils.isBiggerThanZero((Number)numeroDoc).booleanValue()) {
            return Boolean.TRUE;
        }
        DocumentoAiseEntity documento = this.repositoryDocumentoAise.getDocumentoByTipoDocCadastroGeralAndNumero(tipoDocumento, cadastroGeral, numeroDoc);
        if (Objects.nonNull(documento)) {
            return documento.isDocumentoCancelado();
        }
        return Boolean.TRUE;
    }

    public boolean isExisteLaudoComSituacaoCancelado(SolicitacaoAlvaraEntity solicitacao) {
        for (LaudoAlvaraEntity laudoAlvara : solicitacao.getLaudos()) {
            AndamentoLaudoAlvaraEntity laudoMaisRecente;
            List andamentos = this.repositoryAndamentoLaudoAlvara.getListaAndamentoLaudoAlvaraPorLaudo(laudoAlvara.getIdLaudoAlvara());
            if (EloListUtils.safeIsEmpty((List)andamentos).booleanValue() || !StatusLaudoAlvara.CANCELADO.equals((Object)(laudoMaisRecente = andamentos.stream().max(Comparator.comparing(AndamentoLaudoAlvaraEntity::getDataAndamento)).get()).getStatus())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean contemTodosLaudosCancelados(SolicitacaoAlvaraEntity solicitacao) {
        List laudos = solicitacao.getLaudos();
        for (LaudoAlvaraEntity laudo : laudos) {
            if (laudo.getStatus().equals((Object)StatusLaudoAlvara.CANCELADO)) continue;
            return false;
        }
        return true;
    }

    public boolean renderBotaoAlteracao(LaudoAlvaraEntity laudo) throws BaseException {
        ParametroAlvaraEntity paramIdTipoLaudoAlteracao = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_LAUDO_HABILITA_ALTERACAO);
        if (Objects.nonNull(paramIdTipoLaudoAlteracao)) {
            long idTipoLaudoAlteracao = Long.parseLong(paramIdTipoLaudoAlteracao.getValor());
            return idTipoLaudoAlteracao == laudo.getTipoLaudo().getIdTipoLaudo();
        }
        return false;
    }

    public boolean possuiLaudoAmbiental(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (solicitacaoAlvara == null) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel pesquisar laudos a partir de uma solicita\u00e7\u00e3o Nula.");
        }
        return this.repositoryLaudoAlvara.possuiLaudoAmbiental(solicitacaoAlvara);
    }
}

