/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.BoletimMobiliarioAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.factory.SrvConsultaTaxaMobiliariaFactory;
import br.com.elotech.portalarrecadacao.repository.RepositoryBoletimMobiliarioAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividadeBoletim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaTaxaMobiliaria;
import br.com.elotech.portalarrecadacao.service.SrvGeraBoletimMobiliario;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioPK;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaPK;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCoeficienteCalculo;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloResposta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloService(value="srvGeraBoletimMobiliario")
@Scope(value="prototype")
public class SrvGeraBoletimMobiliarioImpl
extends EloLogger
implements SrvGeraBoletimMobiliario {
    @Resource
    private RepositoryBoletimMobiliarioAlvara repositoryBoletimMobiliarioAlvara;
    @Resource
    private RepositoryModeloResposta repositoryModeloResposta;
    @Resource
    private RepositoryBoletimMobiliario repositoryBoletimMobiliario;
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;
    @Resource
    private RepositoryConfiguracaoAtividadeBoletim repositoryConfiguracaoAtividadeBoletim;
    @Resource
    private RepositoryCoeficienteCalculo repositoryCoeficienteCalculo;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private SrvConsultaTaxaMobiliariaFactory srvConsultaTaxaMobiliariaFactory;
    private final List<BoletimMobiliarioAlvaraEntity> listaBoletimValorFixo = new ArrayList();
    private final List<BoletimMobiliarioAlvaraEntity> listaBoletimValorDinamico = new ArrayList();

    public void setRepositoryConfiguracaoAtividadeBoletim(RepositoryConfiguracaoAtividadeBoletim repositoryConfiguracaoAtividadeBoletim) {
        this.repositoryConfiguracaoAtividadeBoletim = repositoryConfiguracaoAtividadeBoletim;
    }

    public void setRepositoryCoeficienteCalculo(RepositoryCoeficienteCalculo repositoryCoeficienteCalculo) {
        this.repositoryCoeficienteCalculo = repositoryCoeficienteCalculo;
    }

    public void setRepositoryEntidadeTributacao(RepositoryEntidadeTributacao repositoryEntidadeTributacao) {
        this.repositoryEntidadeTributacao = repositoryEntidadeTributacao;
    }

    public List<BoletimMobiliarioEntity> geraBoletimMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        this.separarBoletinsValorFixoEDinamico(solicitacaoAlvara);
        boletins.addAll(this.geraBoletimMobiliarioComValorFixo(solicitacaoAlvara));
        boletins.addAll(this.geraBoletimMobiliarioComValorDinamico(solicitacaoAlvara));
        return boletins;
    }

    private void separarBoletinsValorFixoEDinamico(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        List listaTodosBoletins = this.repositoryBoletimMobiliarioAlvara.recuperarBoletimMobiliarioAlvara(solicitacaoAlvara.getTipoDeInscricao());
        this.listaBoletimValorDinamico.clear();
        this.listaBoletimValorFixo.clear();
        for (BoletimMobiliarioAlvaraEntity boletim : listaTodosBoletins) {
            if (Objects.isNull(boletim.getResposta())) {
                this.listaBoletimValorDinamico.add(boletim);
                continue;
            }
            this.listaBoletimValorFixo.add(boletim);
        }
    }

    private List<BoletimMobiliarioEntity> geraBoletimMobiliarioComValorFixo(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        try {
            for (BoletimMobiliarioAlvaraEntity boletimAlvara : this.listaBoletimValorFixo) {
                BoletimMobiliarioEntity boletim = this.repositoryBoletimMobiliario.findByCadastroGeralAndModelCampo(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), boletimAlvara.getModeloIdentificacao().getModeloCampo());
                ModeloRespostaEntity modeloResposta = new ModeloRespostaEntity();
                ModeloRespostaPK idModeloResposta = new ModeloRespostaPK();
                idModeloResposta.setModeloResposta(boletimAlvara.getResposta());
                modeloResposta.setId(idModeloResposta);
                modeloResposta = this.repositoryModeloResposta.getModeloRespostaPorIdentificacao(boletimAlvara.getModeloIdentificacao(), modeloResposta);
                if (Objects.isNull(boletim)) {
                    boletim = new BoletimMobiliarioEntity();
                    BoletimMobiliarioPK idBoletim = new BoletimMobiliarioPK();
                    idBoletim.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                    idBoletim.setModeloResposta(modeloResposta);
                    boletim.setId(idBoletim);
                } else {
                    boletim.getId().setModeloResposta(modeloResposta);
                }
                boletins.add(boletim);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Erro ao gerar boletins com valores fixos - " + e.getMessage()), (Throwable)e);
        }
        return boletins;
    }

    private List<BoletimMobiliarioEntity> geraBoletimMobiliarioComValorDinamico(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        try {
            SrvConsultaTaxaMobiliaria consultaTaxaMobiliaria = this.srvConsultaTaxaMobiliariaFactory.getConsultaTaxaMobiliariaInstance(solicitacaoAlvara);
            if (Objects.nonNull(consultaTaxaMobiliaria)) {
                for (BoletimMobiliarioAlvaraEntity boletimAlvara : this.listaBoletimValorDinamico) {
                    boletins.addAll(consultaTaxaMobiliaria.getBoletins(solicitacaoAlvara, boletimAlvara));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Erro ao gerar boletins com valores din\u00e2micos - " + e.getMessage()), (Throwable)e);
        }
        return boletins;
    }

    public void salvarBoletinsMobiliario(List<BoletimMobiliarioEntity> boletinsGerados) {
        for (BoletimMobiliarioEntity boletim : boletinsGerados) {
            this.repositoryBoletimMobiliario.saveOrUpdate(boletim);
        }
        this.repositoryBoletimMobiliario.flush();
    }
}

