/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ProcessoFiscalizacaoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.ProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoConfiguradoException;
import br.com.elotech.portalarrecadacao.exception.ProcessoFiscalizacaoException;
import br.com.elotech.portalarrecadacao.integration.vo.Items;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryRestricaoAlvara;
import br.com.elotech.portalarrecadacao.rest.service.RestRequestService;
import br.com.elotech.portalarrecadacao.service.SrvFiscalizacao;
import br.com.elotech.portalarrecadacao.service.SrvLaudoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.portalarrecadacao.service.impl.SrvFiscalizacaoOSmImpl;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.crypto.EloCryptoUtils;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import com.google.gson.Gson;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.wicket.util.string.Strings;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@EloService(value="srvFiscalizacaoOSm")
public class SrvFiscalizacaoOSmImpl
extends EloLogger
implements SrvFiscalizacao {
    public static final String SERVICE_NAME = "srvFiscalizacaoOSm";
    private static final String ATRIBUTO_URL_OS = "url";
    private static final String TIPO_PROTOCOLO = "alvara";
    private static final String ATRIBUTO_ERRO = "error";
    private static final String ATRIBUTO_ID_OS = "id";
    private static final String PARAM_CODVAL = "codval";
    private static final String PARAM_PROTOCOLOTIPO = "protocolotipo";
    private static final String PARAM_PROTOCOLONRO = "protocolonro";
    private static final String PARAM_PROTOCOLOANO = "protocoloano";
    private static final String PARAM_OBS = "obs";
    @Resource
    private RepositoryRestricaoAlvara repositoryRestricaoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;
    @Resource
    private SrvLaudoAlvara srvLaudoAlvara;
    @Resource
    private RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara;

    public List<ProcessoFiscalizacao> abrirProcesso(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> laudos, Optional<Integer> idAssunto) throws BaseException {
        String uri = this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.URL_ABERTURA_PROCESSO_FISCALIZACAO).getValor();
        JSONObject jsonBody = this.montarBody(solicitacao, laudos, idAssunto);
        JSONObject jsonProcesso = this.post(jsonBody, uri);
        if (Objects.nonNull(EloJsonUtils.getObject((JSONObject)jsonProcesso, (String)ATRIBUTO_ERRO))) {
            throw new ProcessoFiscalizacaoException(EloJsonUtils.getObject((JSONObject)jsonProcesso, (String)ATRIBUTO_ERRO).toString());
        }
        Integer idOrdemServico = EloJsonUtils.getInt((JSONObject)jsonProcesso, (String)ATRIBUTO_ID_OS);
        if (Objects.isNull(idOrdemServico) || !EloNumberUtils.isBiggerThanZero((Number)idOrdemServico).booleanValue()) {
            throw new ProcessoFiscalizacaoException("O sistema OSm n\u00e3o disponibilizou o n\u00famero da Ordem de Servi\u00e7o.");
        }
        ProcessoFiscalizacao processo = new ProcessoFiscalizacao();
        processo.setLaudo(laudos.get(0).getIdLaudoAlvara());
        processo.setId(Long.valueOf(idOrdemServico.longValue()));
        processo.setUrl(EloJsonUtils.getString((JSONObject)jsonProcesso, (String)ATRIBUTO_URL_OS));
        return Arrays.asList(processo);
    }

    protected JSONObject post(JSONObject body, String uri) throws ProcessoFiscalizacaoException {
        try {
            String usuario = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.NOME_USUARIO_API_FISCALIZACAO);
            String senha = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SENHA_USUARIO_API_FISCALIZACAO);
            RestRequestService restRequestService = new RestRequestService(usuario, EloCryptoUtils.decifra((String)senha));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            HttpEntity httpEntity = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
            ResponseEntity response = restRequestService.postWithBody(uri, httpEntity, String.class);
            JSONObject json = EloJsonUtils.getJson((String)((String)response.getBody()));
            return json;
        }
        catch (Exception e) {
            throw new ProcessoFiscalizacaoException("Ocorreu uma falha na abertura da O.S. Caso seja a abertura da segunda O.S verifique se j\u00e1 foi encerrada no sistema de fiscaliza\u00e7\u00e3o.", e.getCause());
        }
    }

    protected JSONObject montarBody(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> laudos, Optional<Integer> idAssunto) throws ParametroNaoConfiguradoException, ProcessoFiscalizacaoException {
        OrdemServico os = new OrdemServico(this, null);
        os.tipins = solicitacao.getCadastroImobiliario().getId().getTipo();
        os.insmun = solicitacao.getCadastroImobiliario().getId().getCodigo();
        if (idAssunto.isPresent()) {
            os.osassunto_id = idAssunto.get();
        }
        os.protocolotipo = TIPO_PROTOCOLO;
        os.protocolonro = solicitacao.getNumeroSolicitacao();
        os.protocoloano = solicitacao.getExercicio();
        os.datprotocolo = EloDateUtils.toAnsiDateString((Date)new Date());
        List listaRestricaoAlvara = this.repositoryRestricaoAlvara.carregaRestricaoPorSolicitacao(solicitacao.getSolicitacaoAlvara());
        os.items = Items.getItemsSolicitacao((SolicitacaoAlvaraEntity)solicitacao, (List)listaRestricaoAlvara);
        Gson gson = new Gson();
        return EloJsonUtils.getJson((String)gson.toJson((Object)os));
    }

    public void salvarInformacoesProcesso(SolicitacaoAlvaraEntity solicitacao, List<ProcessoFiscalizacao> processos) throws ProcessoFiscalizacaoException, URISyntaxException {
        try {
            for (ProcessoFiscalizacao processo : processos) {
                LaudoAlvaraEntity laudo = this.srvLaudoAlvara.findLaudoById(processo.getLaudo());
                laudo.setStatus(StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA);
                UsuarioEntity usuarioLogado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
                andamento.setDataAndamento(new Date());
                andamento.setStatus(StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA);
                andamento.setIdLaudoAlvara(laudo);
                andamento.setUsuario(usuarioLogado);
                andamento.setProcessoFiscalizacao(ProcessoFiscalizacaoEntity.of((AndamentoLaudoAlvaraEntity)andamento, (ProcessoFiscalizacao)processo));
                this.srvLaudoAlvara.salvarAndamento(laudo, andamento, solicitacao);
            }
        }
        catch (BaseException e) {
            throw new ProcessoFiscalizacaoException(e.getMessage());
        }
    }

    public void cancelarProcessoFiscalizacao(List<LaudoAlvaraEntity> laudos, String motivo) throws ProcessoFiscalizacaoException {
        try {
            StringBuilder uri = new StringBuilder(this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.URL_ABERTURA_PROCESSO_FISCALIZACAO).getValor());
            String usuario = this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.NOME_USUARIO_API_FISCALIZACAO).getValor();
            String senha = this.srvSolicitacaoAlvaraHelper.getParametroAlvara(ParametroAlvaraEnum.SENHA_USUARIO_API_FISCALIZACAO).getValor();
            for (LaudoAlvaraEntity laudoAlvara : laudos) {
                AndamentoLaudoAlvaraEntity ultimoAndamento;
                List andamentosLaudoAlvara = this.repositoryAndamentoLaudoAlvara.getListaAndamentoLaudoAlvaraPorLaudo(laudoAlvara.getIdLaudoAlvara());
                if (EloListUtils.safeIsEmpty((List)andamentosLaudoAlvara).booleanValue() || !Objects.nonNull((ultimoAndamento = (AndamentoLaudoAlvaraEntity)andamentosLaudoAlvara.stream().findFirst().get()).getProcessoFiscalizacao())) continue;
                if (Objects.isNull(ultimoAndamento.getProcessoFiscalizacao().getProcesso())) {
                    throw new ProcessoFiscalizacaoException("N\u00e3o foi poss\u00edvel cancelar, n\u00e3o existe um processo nesse andamento, provavelmente o processo j\u00e1 doi encerrado ! ");
                }
                String idProcesso = Long.toString(ultimoAndamento.getProcessoFiscalizacao().getProcesso());
                uri.append("/").append(idProcesso);
                String urlOs = ultimoAndamento.getProcessoFiscalizacao().getUrl();
                String[] urlCodval = Strings.split((String)urlOs.substring(urlOs.indexOf(PARAM_CODVAL), urlOs.length()), (char)'/');
                String codVal = urlCodval[1];
                RestRequestService restRequestService = new RestRequestService(usuario, EloCryptoUtils.decifra((String)senha));
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                LinkedMultiValueMap params = new LinkedMultiValueMap();
                params.add((Object)PARAM_CODVAL, (Object)codVal);
                params.add((Object)PARAM_PROTOCOLOTIPO, (Object)TIPO_PROTOCOLO);
                params.add((Object)PARAM_PROTOCOLONRO, (Object)Long.toString(laudoAlvara.getIdSolicitacaoAlvara().getNumeroSolicitacao()));
                params.add((Object)PARAM_PROTOCOLOANO, (Object)Long.toString(laudoAlvara.getIdSolicitacaoAlvara().getExercicio()));
                params.add((Object)PARAM_OBS, (Object)motivo);
                HttpEntity request = new HttpEntity((Object)params, (MultiValueMap)headers);
                restRequestService.patch(uri.toString(), request, String.class);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ProcessoFiscalizacaoException("Ocorreu uma Falha ao chamar o servi\u00e7o de Cancelamento de OS:  ", (Throwable)e);
        }
    }
}

