/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.enumerator.EnquadramentoEmpresaEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.filter.NaturezaSolicitacaoTipoInscricaoFilter;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Atividades;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.FormasAtuacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.TipoUnidade;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvNaturezaSolicitacaoTipoInscricao;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraPrestadorServico;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryAtividadeMei;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloService(value="srvFindTipoInscricaoAlvara")
@Scope(value="prototype")
public class SrvFindTipoInscricaoAlvaraImpl {
    @Resource
    private RepositoryTipoInscricaoAlvara repositoryTipoInscricao;
    @Resource
    private SrvNaturezaSolicitacaoTipoInscricao srvNaturezaSolicitacaoTipoInscricao;
    @Resource
    private RepositoryAtividadeMei repositoryAtividadeMei;

    private SrvSolicitacaoAlvaraPrestadorServico getSrvSolicitacaoAlvaraPrestadorServico() {
        return (SrvSolicitacaoAlvaraPrestadorServico)SpringContext.getBean(SrvSolicitacaoAlvaraPrestadorServico.class);
    }

    public TipoInscricaoAlvaraEntity findTipoInscricaoAlvara(int co_enquadramento, List<Atividades> atividades, List<TipoUnidade> tiposUnidades, List<FormasAtuacao> formasAtuacao) throws BaseException {
        TipoInscricaoAlvaraEntity tipoInscricaoAlvaraPrestador = this.repositoryTipoInscricao.getTipoInscricaoBySigla("P");
        if ("M".equals(EnquadramentoEmpresaEnum.fromCodigo((Integer)co_enquadramento).getSigla())) {
            tipoInscricaoAlvaraPrestador = this.repositoryTipoInscricao.getTipoInscricaoBySigla("MP");
        }
        if (this.isTipoInscricaoAlvaraAtivo(tipoInscricaoAlvaraPrestador).booleanValue() && !this.isExerceAtividadeNoEndereco(atividades) && this.verifyTipoUnidadePrestadorServico(tiposUnidades) && this.verifyFormasAtuacaoPrestadorServico(formasAtuacao) && (tipoInscricaoAlvaraPrestador.isPJPrestador() && this.isTodosCnaePrestador(atividades) || tipoInscricaoAlvaraPrestador.isMeiPrestador() && this.isTodosAtividadeMeiPrestador(atividades))) {
            return tipoInscricaoAlvaraPrestador;
        }
        return this.getTipoInscricaoEnquadramento(co_enquadramento);
    }

    private Boolean isTipoInscricaoAlvaraAtivo(TipoInscricaoAlvaraEntity tipoInscricaoAlvara) {
        NaturezaSolicitacaoTipoInscricaoFilter filter = new NaturezaSolicitacaoTipoInscricaoFilter.BuilderNaturezaSolicitacaoTipoInscricaoFilter().tipoInscricao(tipoInscricaoAlvara).build();
        List naturezaSolicitacaoTipoInscricaoAlvaraList = this.srvNaturezaSolicitacaoTipoInscricao.carregarNaturezasSolicitacaoTipoInscricaoByFilter(filter);
        return naturezaSolicitacaoTipoInscricaoAlvaraList.stream().anyMatch(naturezaSolTipoInscAlvaraEntity -> naturezaSolTipoInscAlvaraEntity.isAtivo());
    }

    private boolean verifyTipoUnidadePrestadorServico(List<TipoUnidade> tiposUnidade) throws BaseException {
        String[] tiposUnidadeParam = Optional.ofNullable(this.getSrvSolicitacaoAlvaraPrestadorServico().getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.TIPO_UNIDADE_PRESTADOR_SERVICO).getValor()).map(tipoUnidade -> tipoUnidade.split(",")).orElse(new String[0]);
        return EloListUtils.safeIsEmpty(tiposUnidade) == false ? tiposUnidade.stream().allMatch(tipoUnidade -> Arrays.stream(tiposUnidadeParam).allMatch(param -> param.equals(String.valueOf(tipoUnidade.getCo_tipo_unidade())))) : Boolean.FALSE.booleanValue();
    }

    private boolean verifyFormasAtuacaoPrestadorServico(List<FormasAtuacao> formasAtuacoes) throws BaseException {
        String[] formasAtuacaoParam = Optional.ofNullable(this.getSrvSolicitacaoAlvaraPrestadorServico().getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.FORMAS_ATUACAO_PRESTADOR_SERVICO).getValor()).map(formaAtuacao -> formaAtuacao.split(",")).orElse(new String[0]);
        return EloListUtils.safeIsEmpty(formasAtuacoes) == false ? formasAtuacoes.stream().allMatch(formas -> Arrays.stream(formasAtuacaoParam).allMatch(param -> param.equals(String.valueOf(formas.getCo_forma_atuacao())))) : Boolean.FALSE.booleanValue();
    }

    private boolean isTodosCnaePrestador(List<Atividades> atividades) {
        List codigosCnae = atividades.stream().map(atividadeItem -> EloStringUtils.somenteNumeros((String)atividadeItem.getCo_cnae())).collect(Collectors.toList());
        return this.getSrvSolicitacaoAlvaraPrestadorServico().verificaCnaePrestadorServico(codigosCnae);
    }

    private boolean isTodosAtividadeMeiPrestador(List<Atividades> atividades) {
        List codigosCnae = atividades.stream().map(atividadeItem -> EloStringUtils.somenteNumeros((String)atividadeItem.getCo_cnae())).collect(Collectors.toList());
        return this.repositoryAtividadeMei.isCnaesPermitidoParaMeiPrestador(codigosCnae);
    }

    private TipoInscricaoAlvaraEntity getTipoInscricaoEnquadramento(int enquadramento) {
        return this.repositoryTipoInscricao.getTipoInscricaoBySigla(EnquadramentoEmpresaEnum.fromCodigo((Integer)enquadramento).getSigla());
    }

    private boolean isExerceAtividadeNoEndereco(List<Atividades> atividades) {
        return atividades.stream().anyMatch(p -> p.isIs_exerce_no_endereco() == Boolean.TRUE.booleanValue());
    }
}

