/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.repository.RepositoryExigencia;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoExigencia;
import br.com.elotech.portalarrecadacao.service.SrvExigencia;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvExigencia")
public class SrvExigenciaImpl
extends EloLogger
implements SrvExigencia {
    @Resource
    private RepositoryExigencia repositoryExigencia;
    @Resource
    private RepositoryTipoExigencia repositoryTipoExigencia;

    public void adicionarExigenciasNaConsultaPrevia(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ArrayList tiposExigencias = Lists.newArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            List tiposExigenciasDaAtividade = this.repositoryExigencia.buscarTiposExigencia(atividade.getConfiguracaoAtividade());
            if (EloListUtils.safeIsEmpty((List)tiposExigenciasDaAtividade).booleanValue()) continue;
            for (TipoExigenciaEntity tipoExigencia : tiposExigenciasDaAtividade) {
                tiposExigencias.add(tipoExigencia);
                if (!tipoExigencia.isResponsavelTecnico()) continue;
                atividade.setResponsavelTec(SimNaoEnum.SIM.getShortText());
            }
        }
        HashSet tiposExigenciasSemRepeticao = new HashSet(tiposExigencias);
        this.adicionarExigenciasNaConsultaPrevia(tiposExigenciasSemRepeticao, solicitacao);
    }

    private void adicionarExigenciasNaConsultaPrevia(Collection<TipoExigenciaEntity> tiposExigencias, SolicitacaoAlvaraEntity solicitacao) {
        StringBuilder exigencias = new StringBuilder();
        for (TipoExigenciaEntity tipoExigencia : tiposExigencias) {
            if (!EloStringUtils.isEmpty((String)exigencias.toString())) {
                exigencias.append(". </br>");
            }
            exigencias.append(tipoExigencia.getDescricao());
        }
        solicitacao.setExigencias(exigencias.toString());
    }

    public List<TipoExigenciaEntity> consultarTipoExigenciaPorDescricao(String descricao) {
        return this.repositoryTipoExigencia.consultarPorDescricao(descricao);
    }

    public List<ExigenciaEntity> consultarExigenciasPorConfiguracaoAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        return this.repositoryExigencia.consultarExigenciasPorConfiguracaoAtividade(configuracaoAtividade);
    }

    public void salvarExigencia(ExigenciaEntity exigencia) throws BaseException {
        if (this.exigenciaNaoCadastrada(exigencia)) {
            if (!EloNumberUtils.isBiggerThanZero((Number)exigencia.getIdExigencia()).booleanValue()) {
                exigencia.setIdExigencia(this.repositoryExigencia.getSequence());
            }
            this.repositoryExigencia.saveOrUpdate(exigencia);
            ShowMessage.addInfoMessage((String)"msgExigencia", (String)("Exig\u00eancia " + exigencia.getTipoExigencia().getDescricao() + " adicionada com sucesso"));
        } else {
            ShowMessage.addWarnMessage((String)"msgExigencia", (String)("Exig\u00eancia " + exigencia.getTipoExigencia().getDescricao() + " j\u00e1 est\u00e1 vinculada a esta Atividade."));
        }
    }

    private boolean exigenciaNaoCadastrada(ExigenciaEntity exigencia) {
        return this.repositoryExigencia.exigenciaNaoCadastrada(exigencia);
    }

    public void excluirExigencia(ExigenciaEntity exigencia) {
        this.repositoryExigencia.remove(exigencia);
    }

    public void removerTipoExigencia(TipoExigenciaEntity tipoExigencia) {
        this.repositoryTipoExigencia.remove(tipoExigencia);
    }

    public void salvarTipoExigencia(TipoExigenciaEntity tipoExigencia) {
        if (!EloNumberUtils.isBiggerThanZero((Number)tipoExigencia.getIdTipoExigencia()).booleanValue()) {
            tipoExigencia.setIdTipoExigencia(this.repositoryTipoExigencia.getSequence());
        }
        this.repositoryTipoExigencia.saveOrUpdate(tipoExigencia);
        ShowMessage.addInfoMessage((String)"msgTipoExigencia", (String)("Tipo de Exig\u00eancia " + tipoExigencia.getDescricao() + " salvo com sucesso."));
    }
}

