/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvEnviarEmailDebitosSocios;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryDebitoParcela;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

@EloService(value="srvEnviarEmailDebitosSocios")
public class SrvEnviarEmailDebitosSociosImpl
extends EloLogger
implements SrvEnviarEmailDebitosSocios {
    @Resource
    private RepositoryDebitoParcela repositoryDebitoParcela;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;

    public List<CadastroMobiliarioEntity> getCadastrosComDebitosDeSocios(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ArrayList<CadastroMobiliarioEntity> cadastrosMobiliariosPossuemDebitos = new ArrayList<CadastroMobiliarioEntity>();
        if (solicitacao.getContratoSocial() != null) {
            for (SolicitacaoContratoSocialPessoaEntity solicitacaoContratoSocialPessoa : solicitacao.getContratoSocial().getPessoas()) {
                List cadastrosMobiliarios = this.repositoryCadastroMobiliario.cadastrosMobiliariosByCpfCnpj(solicitacaoContratoSocialPessoa.getPessoa().getCnpjCpf());
                for (CadastroMobiliarioEntity cm : cadastrosMobiliarios) {
                    Boolean possuiDebitos = this.repositoryDebitoParcela.verificaDebitos(cm.getCadastroGeral().getId().getTipo(), cm.getCadastroGeral().getId().getCodigo());
                    if (!possuiDebitos.booleanValue()) continue;
                    cadastrosMobiliariosPossuemDebitos.add(cm);
                }
            }
        }
        return cadastrosMobiliariosPossuemDebitos;
    }

    public void enviarEmail(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            List cadastrosMobiliariosPossuemDebitos = this.getCadastrosComDebitosDeSocios(solicitacao);
            if (!EloListUtils.safeIsEmpty((List)cadastrosMobiliariosPossuemDebitos).booleanValue()) {
                EmailVo email = new EmailVo();
                email.setAssunto("D\u00e9bitos de S\u00f3cios - Solicita\u00e7\u00e3o " + solicitacao.getNumeroSolicitacaoExercicio());
                email.setMensagem(EloStringUtils.replaceTemplates((String)this.getMensagemEmailDebitosSocios(solicitacao, cadastrosMobiliariosPossuemDebitos), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
                ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).enviarEmail(email);
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)"Erro ao enviar e-mail de notifica\u00e7\u00e3o de d\u00e9bitos de s\u00f3cios");
        }
    }

    public String getMensagemEmailDebitosSocios(SolicitacaoAlvaraEntity solicitacao, List<CadastroMobiliarioEntity> cadastrosMobiliariosPossuemDebitos) {
        StringBuilder mensagem = new StringBuilder();
        mensagem.append("<div style='font-family: Arial, times, Serif;'>");
        mensagem.append("<b>Prezado(a) Sr.(a):</b>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append(String.format("<p>Foram encontrados d\u00e9bitos de s\u00f3cios na solicita\u00e7\u00e3o <b>%s.</b>", solicitacao.getNumeroSolicitacaoExercicio()));
        mensagem.append("</p>");
        mensagem.append("<table style='text-align: center;' border=1 cellspacing=0 cellpadding=5>");
        mensagem.append("<tr>");
        mensagem.append("<th>Tipo</th>");
        mensagem.append("<th>Cadastro</th>");
        mensagem.append("<th>Pessoa</th>");
        mensagem.append("<th>CPF/CNPJ</th>");
        mensagem.append("</tr>");
        for (CadastroMobiliarioEntity cm : cadastrosMobiliariosPossuemDebitos) {
            mensagem.append("<tr>");
            mensagem.append(String.format("<td>%s</td>", cm.getCadastroGeral().getId().getTipo()));
            mensagem.append(String.format("<td>%s</td>", cm.getCadastroGeral().getId().getCodigo()));
            mensagem.append(String.format("<td>%s</td>", cm.getCadastroGeral().getPessoa().getNome()));
            mensagem.append(String.format("<td>%s</td>", cm.getCadastroGeral().getPessoa().getCnpjCpf()));
            mensagem.append("</tr>");
        }
        mensagem.append("</table>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("Atenciosamente,");
        mensagem.append("<br>");
        mensagem.append("<p><b>Alvar\u00e1 Online</b></p>");
        mensagem.append("<br>");
        mensagem.append("<br>");
        mensagem.append("<h5>Obs.: Esta \u00e9 uma mensagem autom\u00e1tica, por favor n\u00e3o responda este e-mail.</h5>");
        mensagem.append("</div>");
        return mensagem.toString();
    }
}

