/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.SefazDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositorySefazDocumento;
import br.com.elotech.portalarrecadacao.service.SrvDocumentoSefaz;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvUsuario;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import javax.annotation.Resource;

@EloService(value="srvDocumentoSefaz")
public class SrvDocumentoSefazImpl
implements SrvDocumentoSefaz {
    @Resource
    private RepositorySefazDocumento repositorySefazDocumento;
    @Resource
    private SrvSolicitacaoAlvara srvSolicitacaoAlvara;
    @Resource
    private SrvUsuario srvUsuario;

    public void adicionarDocumentoSefaz(SefazDocumentoEntity documentoSefaz) throws ValidacaoException {
        documentoSefaz.validar();
        this.atribuirId(documentoSefaz);
        documentoSefaz.setSolicitacaoAlvaraDocumento(this.criarSolicitacaoAlvaraDocumento(documentoSefaz));
        this.repositorySefazDocumento.saveOrUpdate(documentoSefaz);
    }

    private SolicitacaoAlvaraDocumentoEntity criarSolicitacaoAlvaraDocumento(SefazDocumentoEntity documentoSefaz) {
        UsuarioEntity usuarioAutenticado = this.srvUsuario.getUsuarioAutenticado();
        SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento = documentoSefaz.toSolicitacaoAlvaraDocumento(usuarioAutenticado);
        return this.srvSolicitacaoAlvara.adicionarSolicitacaoAlvaraDocumento(solicitacaoAlvaraDocumento);
    }

    private void atribuirId(SefazDocumentoEntity documentoSefaz) {
        if (documentoSefaz.getId() == null) {
            documentoSefaz.setId(this.repositorySefazDocumento.getSequence());
        }
    }

    public void removerDocumentoSefaz(SefazDocumentoEntity documentoSefaz) {
        SolicitacaoAlvaraDocumentoEntity solicitacaoAlvaraDocumento = documentoSefaz.getSolicitacaoAlvaraDocumento();
        this.repositorySefazDocumento.remove(documentoSefaz);
        if (solicitacaoAlvaraDocumento != null) {
            this.srvSolicitacaoAlvara.removerSolicitacaoAlvaraDocumento(solicitacaoAlvaraDocumento);
        }
    }
}

