/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDispensaAmbientalEntity;
import br.com.elotech.portalarrecadacao.domain.vod.DispensaAmbientalVO;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoPesquisaDispensaAmbientalEnum;
import br.com.elotech.portalarrecadacao.filter.FiltroRelatorioDispensaLicencaAmbiental;
import br.com.elotech.portalarrecadacao.repository.RepositoryDispensaLicencaAmbiental;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.relatorioUnico.FiltroRelatorio;
import br.com.elotech.tributacao.domain.dto.ImprimeRelatorioDto;
import br.com.elotech.tributacao.service.impl.SrvRelatorioUtils;
import br.com.elotech.util.sql.Modulo;
import java.util.List;
import javax.annotation.Resource;

@EloService
public class SrvDispensaAmbiental {
    @Resource
    private RepositoryDispensaLicencaAmbiental repositoryDispensaLicencaAmbiental;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;

    public ImprimeRelatorioDto buildRelatorioDTO(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        ImprimeRelatorioDto rel = new ImprimeRelatorioDto().withClassName("TImprimeRelatorio").withDestino("E").withFiltro(SrvRelatorioUtils.montarFiltroRelatorioUnico((FiltroRelatorio)this.getFiltro(solicitacaoAlvara), (String)"tsda")).withModulo(Modulo.TRIBUTOS.getCodigo()).withRelatorio(this.carregarCodigoRelatorioDispensaLicencaAmbiental()).withTipoRelatorio(Integer.valueOf(0)).withToTable(Boolean.valueOf(false));
        return rel;
    }

    private Integer carregarCodigoRelatorioDispensaLicencaAmbiental() throws BaseException {
        String valorParametroAlvara = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.CODIGO_RELATORIO_DISPENSA_LICENCA_AMBIENTAL);
        return Integer.valueOf(valorParametroAlvara);
    }

    private FiltroRelatorioDispensaLicencaAmbiental getFiltro(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return new FiltroRelatorioDispensaLicencaAmbiental(solicitacaoAlvara.getSolicitacaoAlvara());
    }

    public void salvar(SolicitacaoDispensaAmbientalEntity solicitacaoDispensa) throws ValidacaoException {
        solicitacaoDispensa.validar();
        if (!this.possuiSolicitacaoSalva(solicitacaoDispensa)) {
            this.repositoryDispensaLicencaAmbiental.saveOrUpdate(solicitacaoDispensa);
        }
    }

    private boolean possuiSolicitacaoSalva(SolicitacaoDispensaAmbientalEntity solicitacaoDispensa) {
        return this.repositoryDispensaLicencaAmbiental.findBySolicitacaoAlvara(solicitacaoDispensa);
    }

    public List<SolicitacaoDispensaAmbientalEntity> carregarTodasSolicitacoesDispensa() {
        return this.repositoryDispensaLicencaAmbiental.findAll();
    }

    public List<DispensaAmbientalVO> carregarSolicitacoesQuePodemSolicitarDispensa(TipoPesquisaDispensaAmbientalEnum tipoPesquisa) {
        return this.repositorySolicitacaoAlvara.carregarSolicitacoesSemLaudoAmbiental(tipoPesquisa);
    }
}

