/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.service.SrvDesvincularPessoaComCadastro;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaPK;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.EnderecoPessoaPK;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.service.SrvContatoPessoa;
import br.com.elotech.tributacao.service.SrvEnderecoPessoa;
import br.com.elotech.tributacao.service.SrvPessoa;
import br.com.elotech.unico.rest.exception.UnicoClientException;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.SerializationUtils;

@EloService(value="srvDesvincularPessoaComCadastro")
public class SrvDesvincularPessoaComCadastroImpl
implements SrvDesvincularPessoaComCadastro {
    @Resource
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositoryCadastroGeral repositoryCadastroGeral;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private SrvPessoa srvPessoa;
    @Resource
    private SrvEnderecoPessoa srvEnderecoPessoa;
    @Resource
    private SrvContatoPessoa srvContatoPessoa;

    public void setRepositoryPessoa(RepositoryPessoa repositoryPessoa) {
        this.repositoryPessoa = repositoryPessoa;
    }

    public void desvincularPessoaComCadastro(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        PessoaEntity pessoa = solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa();
        if (this.precisaDesvincularPessoaDoCadastro(solicitacao)) {
            Long l;
            Long l2;
            Long sequence;
            List enderecos = this.copiaEnderecoPessoa(pessoa);
            List contatos = this.copiaContatoPessoa(pessoa);
            PessoaEntity novaPessoa = (PessoaEntity)SerializationUtils.clone((Serializable)pessoa);
            novaPessoa.setId(null);
            novaPessoa.setEnderecoPessoaPrincipal(null);
            novaPessoa.setEnderecos(null);
            novaPessoa.setContatos(null);
            novaPessoa = this.salvarPessoa(novaPessoa);
            solicitacao.getCadastroMobiliario().getCadastroGeral().setPessoa(novaPessoa);
            this.salvarCadastroGeral(solicitacao);
            if (!EloListUtils.safeIsEmpty((List)enderecos).booleanValue()) {
                sequence = 1L;
                for (EnderecoPessoaEntity endereco : enderecos) {
                    endereco.setId(EnderecoPessoaPK.novaPk((Long)novaPessoa.getId(), (Long)sequence));
                    this.salvarEnderecoPessoa(endereco, novaPessoa);
                    l2 = sequence;
                    l = sequence = Long.valueOf(sequence + 1L);
                }
            }
            if (!EloListUtils.safeIsEmpty((List)contatos).booleanValue()) {
                sequence = 1L;
                for (ContatoPessoaEntity contato : contatos) {
                    contato.setId(ContatoPessoaPK.novaPk((Long)novaPessoa.getId(), (Long)sequence));
                    this.salvarContatoPessoa(contato, novaPessoa);
                    l2 = sequence;
                    l = sequence = Long.valueOf(sequence + 1L);
                }
            }
        }
    }

    private boolean precisaDesvincularPessoaDoCadastro(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ParametroAlvaraEntity parametroVerificaPessoaVinculada = this.srvSolicitacaoAlvaraHelper.getParametroAlvaraNaoTrataValorNull(ParametroAlvaraEnum.VERIFICAPESSOAVINCULADATIPOCADASTRO);
        if (!EloStringUtils.isEmpty((String)parametroVerificaPessoaVinculada.getValor())) {
            PessoaEntity pessoa = solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa();
            List cadastros = this.recuperarCadastrosMobiliarios(pessoa);
            if (this.possuiCadastroComTipo(pessoa, parametroVerificaPessoaVinculada) || solicitacao.isNaturezaMudancaRazaoSocial() && this.isSituacaoBaixado(cadastros)) {
                return true;
            }
        }
        return false;
    }

    private boolean possuiCadastroComTipo(PessoaEntity pessoa, ParametroAlvaraEntity parametroVerificaPessoaVinculada) {
        return this.repositoryCadastroGeral.verificarTiposDeCadastrosExistentes(pessoa, this.tiposCadastros(parametroVerificaPessoaVinculada));
    }

    private Long[] tiposCadastros(ParametroAlvaraEntity parametroVerificaPessoaVinculada) {
        return EloStringUtils.strToLong((String[])parametroVerificaPessoaVinculada.getValor().split(","));
    }

    private List<CadastroMobiliarioEntity> recuperarCadastrosMobiliarios(PessoaEntity pessoa) {
        return this.repositoryCadastroMobiliario.cadastrosMobiliariosByPessoa(pessoa);
    }

    private void salvarCadastroGeral(SolicitacaoAlvaraEntity solicitacao) {
        this.repositoryCadastroGeral.saveOrUpdate(solicitacao.getCadastroMobiliario().getCadastroGeral());
    }

    private List<EnderecoPessoaEntity> copiaEnderecoPessoa(PessoaEntity pessoa) {
        ArrayList<EnderecoPessoaEntity> enderecosNovaPessoa = new ArrayList<EnderecoPessoaEntity>();
        List listaEnderecoPessoa = this.srvEnderecoPessoa.getListaEnderecoPorPessoa(pessoa);
        if (!EloListUtils.safeIsEmpty((List)listaEnderecoPessoa).booleanValue()) {
            for (EnderecoPessoaEntity enderecoPessoalista : listaEnderecoPessoa) {
                EnderecoPessoaEntity enderecoPessoa = new EnderecoPessoaEntity(enderecoPessoalista);
                enderecoPessoa.setId(null);
                enderecosNovaPessoa.add(enderecoPessoa);
            }
        }
        return enderecosNovaPessoa;
    }

    private List<ContatoPessoaEntity> copiaContatoPessoa(PessoaEntity pessoa) {
        ArrayList<ContatoPessoaEntity> contatosNovaPessoa = new ArrayList<ContatoPessoaEntity>();
        List listaContatoPessoa = this.srvContatoPessoa.getListaContatoPorPessoa(pessoa);
        if (!EloListUtils.safeIsEmpty((List)listaContatoPessoa).booleanValue()) {
            for (ContatoPessoaEntity contatoPessoaLista : listaContatoPessoa) {
                ContatoPessoaEntity contatoPessoa = new ContatoPessoaEntity(contatoPessoaLista);
                contatoPessoa.setId(null);
                contatosNovaPessoa.add(contatoPessoa);
            }
        }
        return contatosNovaPessoa;
    }

    private boolean isSituacaoBaixado(List<CadastroMobiliarioEntity> cadastros) {
        if (!EloListUtils.safeIsEmpty(cadastros).booleanValue()) {
            for (CadastroMobiliarioEntity cadastroMobiliario : cadastros) {
                for (MobiliarioSituacaoEntity situacao : cadastroMobiliario.getMobiliarioSituacao()) {
                    if (!situacao.getAtual().equals(SimNaoEnum.SIM.getShortText()) || !situacao.getSituacaoMobiliario().getId().equals(9L)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private PessoaEntity salvarPessoa(PessoaEntity pessoa) throws UnicoClientException {
        return this.srvPessoa.salvar(pessoa);
    }

    private EnderecoPessoaEntity salvarEnderecoPessoa(EnderecoPessoaEntity enderecoPessoa, PessoaEntity pessoa) throws UnicoClientException {
        if (enderecoPessoa.getId() == null) {
            EnderecoPessoaPK enderecoPessoaPK = new EnderecoPessoaPK();
            enderecoPessoaPK.setPessoa(pessoa);
            enderecoPessoa.setId(enderecoPessoaPK);
        }
        enderecoPessoa = this.srvEnderecoPessoa.saveAiseOrUnico(enderecoPessoa);
        return enderecoPessoa;
    }

    private ContatoPessoaEntity salvarContatoPessoa(ContatoPessoaEntity contatoPessoa, PessoaEntity pessoa) throws UnicoClientException {
        if (contatoPessoa.getId() == null) {
            ContatoPessoaPK contatoPessoaPK = new ContatoPessoaPK();
            contatoPessoaPK.setPessoa(pessoa);
            contatoPessoa.setId(contatoPessoaPK);
        }
        contatoPessoa = this.srvContatoPessoa.salvar(contatoPessoa);
        return contatoPessoa;
    }
}

