/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoAlvaraVo;
import br.com.elotech.portalarrecadacao.domain.vo.DebitoLaudoVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.GeraCarneException;
import br.com.elotech.portalarrecadacao.exception.GeraDebitoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.factory.SrvConsultaAtividadeFactory;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraDebito;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividade;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvWebServiceGeoImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.ws.oxm.CalculoAlvaraOnline;
import br.com.elotech.portalarrecadacao.ws.oxm.CalculoAlvaraOnlineEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.CalculoAlvaraOnlineResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.Debito;
import br.com.elotech.portalarrecadacao.ws.oxm.DebitoListEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraBloquetoEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraBloquetoResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraCarneAlvaraOnlineEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraCarneAlvaraOnlineResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebito;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWeb;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWebEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.GeraDebitoWebResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.Item;
import br.com.elotech.portalarrecadacao.ws.oxm.ListaDebitoEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.ListaDebitoItem;
import br.com.elotech.portalarrecadacao.ws.oxm.LoginEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.LoginResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.LogoffEnvio;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import br.com.elotech.tributacao.domain.aise.DebitoParcelaEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoPK;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.domain.vo.DebitoVO;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.exception.LoginWebServiceException;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCoeficienteCalculo;
import br.com.elotech.tributacao.repository.aise.RepositoryDebito;
import br.com.elotech.tributacao.repository.aise.RepositoryDebitoParcela;
import br.com.elotech.tributacao.repository.aise.RepositoryFormaCalculo;
import br.com.elotech.tributacao.repository.aise.RepositoryMobiliarioSituacao;
import br.com.elotech.tributacao.repository.aise.RepositoryParametroEntidadeExercicio;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.castor.CastorMarshaller;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.ws.client.core.WebServiceTemplate;

@EloService(value="srvDebitosPortal")
public class SrvDebitosPortalImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvDebitosPortal {
    private static final int DIAVENCIMENTOLAUDO = 20;
    private static final int ADDMES = 1;
    private static final String RESPONSE_FALSE = "false";
    @Resource
    private WebServiceTemplate webServiceTemplateAise;
    @Resource
    private WebServiceTemplate webServiceTemplateTributosWeb;
    @Resource
    private CastorMarshaller castorMarshallerRetorno;
    @Resource
    private RepositoryParametroEntidadeExercicio repositoryParametroEntidadeExercicio;
    @Resource
    private RepositoryDebito repositoryDebito;
    @Resource
    private RepositorySolicitacaoAlvaraDebito repositorySolicitacaoAlvaraDebito;
    @Resource
    private RepositoryMobiliarioSituacao repositoryMobiliarioSituacao;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    private CalculoAlvaraOnlineResposta resposta;
    private GeraBloquetoResposta geraBloquetoResposta;
    @Resource
    private RepositoryDebitoParcela repositoryDebitoParcela;
    @Resource
    private RepositoryCoeficienteCalculo repositoryCoeficienteCalculo;
    @Resource
    private RepositoryFormaCalculo repositoryFormaCalculo;
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private SrvWebServiceGeoImpl srvWebServiceGeo;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private RepositoryUsuario repositoryUsuario;
    @Resource
    private RepositorySolicitacaoAlvara repositorySolicitacaoAlvara;
    @Autowired
    private SrvConsultaAtividadeFactory srvConsultaAtividadeFactory;

    public void setWebServiceTemplateAise(WebServiceTemplate webServiceTemplateAise) {
        this.webServiceTemplateAise = webServiceTemplateAise;
    }

    public void setWebServiceTemplateTributosWeb(WebServiceTemplate webServiceTemplateTributosWeb) {
        this.webServiceTemplateTributosWeb = webServiceTemplateTributosWeb;
    }

    public void setRepositoryParametroEntidadeExercicio(RepositoryParametroEntidadeExercicio repositoryParametroEntidadeExercicio) {
        this.repositoryParametroEntidadeExercicio = repositoryParametroEntidadeExercicio;
    }

    public void setRepositoryDebito(RepositoryDebito repositoryDebito) {
        this.repositoryDebito = repositoryDebito;
    }

    public CalculoAlvaraOnlineResposta getResposta() {
        return this.resposta;
    }

    public void setResposta(CalculoAlvaraOnlineResposta resposta) {
        this.resposta = resposta;
    }

    public GeraBloquetoResposta getGeraBloquetoResposta() {
        return this.geraBloquetoResposta;
    }

    public void setGeraBloquetoResposta(GeraBloquetoResposta geraBloquetoResposta) {
        this.geraBloquetoResposta = geraBloquetoResposta;
    }

    /*
     * Loose catch block
     */
    public CalculoAlvaraOnline calculoAlvaraOnline(CalculoAlvaraOnlineEnvio envio) throws SolicitacaoAlvaraException {
        this.logger.info((Object)("******CalculoAlvaraOnline******* " + envio.getCadastroGeral() + " **********"));
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            try {
                this.resposta = (CalculoAlvaraOnlineResposta)this.webServiceTemplateAise.marshalSendAndReceive((Object)envio);
                StreamSource source = new StreamSource(new ByteArrayInputStream(this.resposta.getRetorno().getBytes()));
                CalculoAlvaraOnline calculoAlvaraOnline = (CalculoAlvaraOnline)this.castorMarshallerRetorno.unmarshal((Source)source);
                return calculoAlvaraOnline;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Falha na gera\u00e7\u00e3o do D\u00e9bito - " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.logoffTemplateAise(envio.getUserKey());
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    private void logoffTemplateAise(String userKey) {
        LogoffEnvio logoffEnvio = new LogoffEnvio();
        logoffEnvio.setUserKey(userKey);
        this.webServiceTemplateAise.marshalSendAndReceive((Object)logoffEnvio);
    }

    public Integer geraBloquetoAgrupado(List<DebitoEntity> debitos) throws GeraDebitoException, JsonProcessingException {
        ArrayList listaDebitos = new ArrayList();
        try {
            for (DebitoEntity debito : debitos) {
                listaDebitos.addAll(this.montarListaParcelasWs(debito.getParcelas()));
            }
            String listaDebitoEnvioJson = this.montarJsonEnvioBloqueto(listaDebitos);
            return this.geraBloquetoWSTributosWeb(listaDebitoEnvioJson);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException("Falha na gera\u00e7\u00e3o do Bloqueto: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException("Falha na gera\u00e7\u00e3o do Bloqueto: " + e.getMessage(), e.getCause());
        }
    }

    public Integer geraBloqueto(List<DebitoParcelaEntity> parcelas) throws GeraDebitoException {
        try {
            List listaDebitos = this.montarListaParcelasWs(parcelas);
            String listaDebitoEnvioJson = this.montarJsonEnvioBloqueto(listaDebitos);
            return this.geraBloquetoWSTributosWeb(listaDebitoEnvioJson);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException("Falha na gera\u00e7\u00e3o do Bloqueto: " + e.getMessage());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException("Falha na gera\u00e7\u00e3o do Bloqueto", e.getCause());
        }
    }

    private Integer geraBloquetoWSTributosWeb(String listaDebitoEnvioJson) throws LoginWebServiceException {
        Integer idBloqueto = null;
        String userKey = this.loginWSTributosWeb(this.getUsuarioIntegraSGO().getUsuario(), this.getUsuarioIntegraSGO().getSenha());
        GeraBloquetoEnvio envio = new GeraBloquetoEnvio();
        envio.setUserKey(userKey);
        envio.setListaDebito(listaDebitoEnvioJson);
        this.geraBloquetoResposta = (GeraBloquetoResposta)this.webServiceTemplateTributosWeb.marshalSendAndReceive((Object)envio);
        String[] retorno = this.geraBloquetoResposta.getRetorno().split("=");
        idBloqueto = Integer.parseInt(retorno[retorno.length - 1]);
        LogoffEnvio logoffEnvio = new LogoffEnvio();
        logoffEnvio.setUserKey(userKey);
        this.webServiceTemplateTributosWeb.marshalSendAndReceive((Object)logoffEnvio);
        return idBloqueto;
    }

    private String montarJsonEnvioBloqueto(List<Debito> listaDebitos) throws JsonProcessingException {
        DebitoListEnvio debitoListEnvio = new DebitoListEnvio();
        debitoListEnvio.setSource(listaDebitos);
        debitoListEnvio.setUid("F176E2E3-6DCE-DEF4-0842-D7F1098F2FFE");
        debitoListEnvio.setLength(Integer.valueOf(listaDebitos.size()));
        Item items = new Item();
        items.setFilterFunction(null);
        items.setSort(null);
        items.setList(debitoListEnvio);
        items.setLength(Integer.valueOf(1));
        items.setListaDebitos(listaDebitos);
        ListaDebitoItem listaDebitoItem = new ListaDebitoItem();
        listaDebitoItem.setItems(items);
        ListaDebitoEnvio listaDebitoEnvio = new ListaDebitoEnvio();
        listaDebitoEnvio.setClassName("TTransportList");
        listaDebitoEnvio.setFreeObjectsOnClear(Boolean.valueOf(true));
        listaDebitoEnvio.setList(listaDebitoItem);
        ObjectMapper mapper = new ObjectMapper();
        String listaDebitoEnvioJson = "";
        listaDebitoEnvioJson = mapper.writeValueAsString((Object)listaDebitoEnvio);
        return listaDebitoEnvioJson;
    }

    private List<Debito> montarListaParcelasWs(List<DebitoParcelaEntity> parcelas) {
        ArrayList<Debito> listaDebitos = new ArrayList<Debito>();
        for (DebitoParcelaEntity parcela : parcelas) {
            Debito debitoWs = new Debito();
            debitoWs.setExercicio(Integer.valueOf(parcela.getId().getDebito().getId().getGuiaRecolhimento().getId().getEntidadeTributacao().getId().getExercicioTributacao().getExercicio().intValue()));
            debitoWs.setDescricaoSituacao(parcela.getSituacaoDebito().getDescricao());
            debitoWs.setEmiteBloqueto(Boolean.valueOf(true));
            debitoWs.setValor(parcela.getValorParcela());
            debitoWs.setNome(parcela.getId().getDebito().getId().getCadastroGeral().getPessoa().getNome());
            debitoWs.setEntidade(Integer.valueOf(parcela.getId().getDebito().getId().getGuiaRecolhimento().getId().getEntidadeTributacao().getId().getEntidade().getId().intValue()));
            debitoWs.setCadastroGeral(Integer.valueOf(parcela.getId().getDebito().getId().getCadastroGeral().getId().getCodigo().intValue()));
            debitoWs.setSubDivida(Integer.valueOf(parcela.getId().getDebito().getId().getSubdivida().intValue()));
            debitoWs.setPessoa(Integer.valueOf(parcela.getId().getDebito().getId().getCadastroGeral().getPessoa().getId().intValue()));
            debitoWs.setGuiaRecolhimento(Integer.valueOf(parcela.getId().getDebito().getId().getGuiaRecolhimento().getId().getGuiaRecolhimento().intValue()));
            debitoWs.setMx_internal_uid("E83BF797-6F7C-36CE-316F-D7F109970323");
            debitoWs.setDescricaoGuia(parcela.getId().getDebito().getId().getGuiaRecolhimento().getDescricao());
            debitoWs.setClassName("TDebitosEmAbertosVO");
            debitoWs.setMarcado(Boolean.valueOf(true));
            debitoWs.setSituacao(parcela.getSituacaoDebito().getDescricaoAbreviada());
            debitoWs.setTipoCadastro(Integer.valueOf(parcela.getId().getDebito().getId().getCadastroGeral().getId().getTipo().intValue()));
            debitoWs.setParcela(Integer.valueOf(parcela.getId().getParcela().intValue()));
            debitoWs.setVencimento(EloDateUtils.toAnsiDateString((Date)parcela.getDataVencimento(), (String)"dd-MM-yyyy"));
            listaDebitos.add(debitoWs);
        }
        return listaDebitos;
    }

    public GeraDebito geraDebito(String usuario, String senha, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long solicitacaoAlvara, String cnpjCpf, Integer guiaRecolhimento, String receita, Double valorPrincipal, String telaOrigem, String observacao, Date dataVencimento) throws BaseException, IOException {
        DebitoVO debitoVo = new DebitoVO();
        debitoVo.setExercicio(exercicio);
        debitoVo.setTipoCadastro(tipoCadastro);
        debitoVo.setCadastroGeral(cadastroGeral.toString());
        debitoVo.setGuiaRecolhimentoAise(Long.valueOf(guiaRecolhimento.longValue()));
        GeraDebitoEnvio envio = new GeraDebitoEnvio();
        if (exercicio != null) {
            envio.setExercicio(Integer.valueOf(exercicio.intValue()));
        }
        if (tipoCadastro != null) {
            envio.setTipoCadastro(Integer.valueOf(tipoCadastro.intValue()));
        }
        if (cadastroGeral != null) {
            envio.setCadastroGeral(Integer.valueOf(cadastroGeral.intValue()));
        }
        if (solicitacaoAlvara != null) {
            envio.setSolicitacaoAlvara(Integer.valueOf(solicitacaoAlvara.intValue()));
        }
        envio.setCnpjCpf(cnpjCpf);
        envio.setGuiaRecolhimento(guiaRecolhimento);
        envio.setReceita(receita);
        envio.setValorPrincipal(valorPrincipal);
        envio.setValorJuros(Double.valueOf(0.0));
        envio.setValorMulta(Double.valueOf(0.0));
        envio.setValorCorrecao(Double.valueOf(0.0));
        envio.setTelaOrigemDebito(telaOrigem);
        envio.setObservacao(observacao);
        envio.setDataVencimento(dataVencimento);
        return this.geraDebitoWSAise(usuario, senha, envio);
    }

    /*
     * Loose catch block
     */
    private GeraDebito geraDebitoWSAise(String usuario, String senha, GeraDebitoEnvio envio) throws BaseException {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            String userKey = this.loginWSAise(usuario, senha);
            try {
                envio.setUserKey(userKey);
                GeraDebitoResposta respostaGeraDebito = (GeraDebitoResposta)this.webServiceTemplateAise.marshalSendAndReceive((Object)envio);
                StreamSource source = new StreamSource(new ByteArrayInputStream(respostaGeraDebito.getRetorno().getBytes()));
                GeraDebito geraDebito = (GeraDebito)this.castorMarshallerRetorno.unmarshal((Source)source);
                if (geraDebito.getIdDebito().compareTo(0) == 0) {
                    throw new GeraDebitoException(String.format("%s%s", "N\u00e3o foi poss\u00edvel gerar o d\u00e9bito. ", geraDebito.getErro()));
                }
                GeraDebito geraDebito2 = geraDebito;
                return geraDebito2;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new GeraDebitoException(e.getMessage(), (Throwable)e);
            }
            finally {
                this.logoffTemplateAise(userKey);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    public GeraDebitoWeb geraDebitoWeb(String usuario, String senha, GeraDebitoWebEnvio envio) throws BaseException {
        String userKey = this.loginWSAise(usuario, senha);
        try {
            envio.setUserKey(userKey);
            GeraDebitoWebResposta respostaGeraDebitoWeb = (GeraDebitoWebResposta)this.webServiceTemplateAise.marshalSendAndReceive((Object)envio);
            StreamSource source = new StreamSource(new ByteArrayInputStream(respostaGeraDebitoWeb.getRetorno().getBytes()));
            GeraDebitoWeb geraDebitoWeb = (GeraDebitoWeb)this.castorMarshallerRetorno.unmarshal((Source)source);
            if (geraDebitoWeb.getIdDebito().compareTo(0) == 0) {
                throw new GeraDebitoException(String.format("%s%s", "N\u00e3o foi poss\u00edvel gerar o d\u00e9bito. ", geraDebitoWeb.getErro()));
            }
            GeraDebitoWeb geraDebitoWeb2 = geraDebitoWeb;
            return geraDebitoWeb2;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException(String.format("%s%s", "N\u00e3o foi poss\u00edvel gerar o d\u00e9bito. ", e.getMessage()), (Throwable)e);
        }
        finally {
            this.logoffTemplateAise(userKey);
        }
    }

    public UserDetails getUsuario() {
        return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    public String loginWeb() {
        UsuarioEntity usuario = this.repositoryUsuario.getUsuarioIntegraSGO();
        return this.loginWSTributosWeb(usuario.getUsuario(), usuario.getPassword());
    }

    public String loginWSAise(String userName, String password) {
        this.logger.info((Object)"Efetuando login no webservice (aise) - via SOAP");
        try {
            LoginEnvio envio = new LoginEnvio();
            envio.setUserName(userName);
            envio.setPassword(password);
            envio.setUserKey("");
            LoginResposta respostaLogin = (LoginResposta)this.webServiceTemplateAise.marshalSendAndReceive((Object)envio);
            if (!respostaLogin.getRetorno().booleanValue()) {
                throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel fazer o Login de integra\u00e7\u00e3o com o ApacheAise.");
            }
            return respostaLogin.getUserKey();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Falha ao obter o token de autentica\u00e7\u00e3o no webservice - " + e.getMessage(), e);
        }
    }

    public String loginWSTributosWeb(String userName, String password) {
        this.logger.info((Object)"Efetuando login no webservice (tributosWeb) - via SOAP");
        try {
            LoginEnvio envio = new LoginEnvio();
            envio.setUserName(userName);
            envio.setPassword(password);
            envio.setUserKey("");
            LoginResposta respostaLogin = (LoginResposta)this.webServiceTemplateTributosWeb.marshalSendAndReceive((Object)envio);
            if (EloStringUtils.isEmpty((String)respostaLogin.getUserKey()) || RESPONSE_FALSE.equalsIgnoreCase(respostaLogin.getUserKey())) {
                throw new LoginWebServiceException("Token vazio");
            }
            return respostaLogin.getUserKey();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Falha ao obter o token de autentica\u00e7\u00e3o no webservice - " + e.getMessage(), e);
        }
    }

    public Integer gerarDebitoLaudos(String usuario, String senha, Long exercicio, Long tipoCadastro, Long cadastroGeral, Long solicitacaoAlvara, Integer guiaRecolhimento, String receita, Double valorPrincipal) throws BaseException, IOException {
        Calendar data = Calendar.getInstance();
        data.set(2, data.get(2) + 1);
        data.set(5, 20);
        Date dataVencimento = data.getTime();
        String observacao = "D\u00e9bito gerado atrav\u00e9s do Alvar\u00e1 Online";
        GeraDebito geraDebito = this.geraDebito(usuario, senha, exercicio, tipoCadastro, cadastroGeral, solicitacaoAlvara, null, guiaRecolhimento, receita, valorPrincipal, "LaudoAlvara", observacao, dataVencimento);
        return geraDebito.getIdDebito();
    }

    public String geraCarneAlvaraOnline(String debito, Boolean emiteCotaUnica) {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            String userKey = this.loginWSTributosWeb(this.getUsuarioIntegraSGO().getUsuario(), this.getUsuarioIntegraSGO().getSenha());
            GeraCarneAlvaraOnlineEnvio envio = new GeraCarneAlvaraOnlineEnvio();
            envio.setDebito(debito);
            envio.setUserKey(userKey);
            envio.setEmiteCotaUnica(emiteCotaUnica);
            GeraCarneAlvaraOnlineResposta respostaCarneAlvara = (GeraCarneAlvaraOnlineResposta)this.webServiceTemplateTributosWeb.marshalSendAndReceive((Object)envio);
            if (EloStringUtils.isEmpty((String)respostaCarneAlvara.getCarne())) {
                throw new RuntimeException((Throwable)new GeraCarneException("resposta em branco"));
            }
            try {
                Long.parseLong(respostaCarneAlvara.getCarne());
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException((Throwable)new GeraCarneException(respostaCarneAlvara.getCarne()));
            }
            String string = respostaCarneAlvara.getCarne();
            return string;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException((Throwable)new GeraCarneException("Erro ao gerar carne: " + e.getMessage(), e.getCause()));
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    public Integer gerarDebitoAlvara(DebitoAlvaraVo debitoAlvaraVo, SolicitacaoAlvaraEntity solicitacaoAlvara) throws GeraDebitoException {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            UsuarioEntity usuarioIntegraSGO = this.getUsuarioIntegraSGO();
            this.logger.info((Object)("USUARIO...> " + usuarioIntegraSGO.getUsuario()));
            CalculoAlvaraOnlineEnvio envio = new CalculoAlvaraOnlineEnvio();
            envio.setUserKey(this.loginWSAise(usuarioIntegraSGO.getUsuario(), usuarioIntegraSGO.getSenha()));
            envio.setEntidade(Integer.valueOf(debitoAlvaraVo.getEntidadeTributacao().getId().getEntidade().getId().intValue()));
            envio.setExercicio(Integer.valueOf(debitoAlvaraVo.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio().intValue()));
            envio.setTipoCadastro(Integer.valueOf(debitoAlvaraVo.getCadastroGeral().getId().getTipo().intValue()));
            envio.setCadastroGeral(Integer.valueOf(debitoAlvaraVo.getCadastroGeral().getId().getCodigo().intValue()));
            envio.setGuiaRecolhimento(Integer.valueOf(debitoAlvaraVo.getGuiaRecolhimento().intValue()));
            envio.setSolicitacaoAlvara(Integer.valueOf(debitoAlvaraVo.getSolicitacaoAlvara().getSolicitacaoAlvara().intValue()));
            envio.setListaVencimento(debitoAlvaraVo.getListaVencimento());
            CalculoAlvaraOnline calculoAlvaraOnline = this.calculoAlvaraOnline(envio);
            if (calculoAlvaraOnline.getIdDebito().compareTo(0) == 0) {
                throw new GeraDebitoException(String.format("%s%s", "N\u00e3o foi poss\u00edvel gerar o d\u00e9bito do alvar\u00e1, entre em contato com o Setor de Alvar\u00e1. ", calculoAlvaraOnline.getErro()));
            }
            Integer n = calculoAlvaraOnline.getIdDebito();
            return n;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    public Integer gerarDebitoLaudo(DebitoLaudoVo debitoLaudoVo, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException, XmlMappingException {
        Boolean transacaoAtiva = UtilsController.commitTransaction();
        try {
            UsuarioEntity usuarioIntegraSGO = this.getUsuarioIntegraSGO();
            this.logger.info((Object)("USUARIO...> " + usuarioIntegraSGO.getUsuario()));
            Integer n = this.gerarDebitoLaudos(usuarioIntegraSGO.getUsuario(), usuarioIntegraSGO.getSenha(), debitoLaudoVo.getExercicio(), debitoLaudoVo.getSolicitacaoAlvara().getCadastroMobiliario().getId().getTipo(), debitoLaudoVo.getSolicitacaoAlvara().getCadastroMobiliario().getId().getCodigo(), solicitacaoAlvara.getSolicitacaoAlvara(), debitoLaudoVo.getGuiaRecolhimento(), debitoLaudoVo.getReceita(), debitoLaudoVo.getValorPrincipal());
            return n;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDebitoException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (Boolean.TRUE.equals(transacaoAtiva)) {
                UtilsController.startTransaction();
            }
        }
    }

    public void alteraMobiliarioSituacaoParaNormal(CadastroMobiliarioEntity cadastroMobiliario) {
        MobiliarioSituacaoEntity mobiliarioSituacaoAtual = new MobiliarioSituacaoEntity();
        for (MobiliarioSituacaoEntity mobiliarioSituacao : cadastroMobiliario.getMobiliarioSituacao()) {
            if (!mobiliarioSituacao.getAtual().equals(SimNaoEnum.SIM.getShortText())) continue;
            mobiliarioSituacaoAtual = mobiliarioSituacao;
        }
        mobiliarioSituacaoAtual.setDataAlteracao(new Date());
        mobiliarioSituacaoAtual.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
        mobiliarioSituacaoAtual.setAtual(SimNaoEnum.NAO.getShortText());
        MobiliarioSituacaoPK id = new MobiliarioSituacaoPK();
        id.setCadastroGeralPK(cadastroMobiliario.getId());
        id.setSequencia(this.repositoryMobiliarioSituacao.getSequencia(cadastroMobiliario.getId()));
        MobiliarioSituacaoEntity mobiliarioSituacaoNovo = new MobiliarioSituacaoEntity();
        mobiliarioSituacaoNovo.setId(id);
        mobiliarioSituacaoNovo.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
        mobiliarioSituacaoNovo.setDataInclusao(new Date());
        mobiliarioSituacaoNovo.setSituacaoMobiliario(this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_NORMAL));
        mobiliarioSituacaoNovo.setAtual(SimNaoEnum.SIM.getShortText());
        cadastroMobiliario.getMobiliarioSituacao().add(mobiliarioSituacaoNovo);
    }

    public Boolean possuiDebitoPago(Long guia, Long exercicio, CadastroGeralAisePK cadastroGeral) {
        Long qtdeParcAberto;
        Long qtdeParcelaDebito = this.repositoryDebito.getQtdeDeParcelasDebito(guia, exercicio, cadastroGeral);
        return !qtdeParcelaDebito.equals(qtdeParcAberto = this.repositoryDebitoParcela.verificaQtdeParcelasEmAberto(guia, exercicio, cadastroGeral));
    }

    private EntidadeAiseEntity getEntidade() {
        return this.getEntidadeTributacao().getId().getEntidade();
    }

    public BigDecimal calculaValorLicencaSanitaria(Long entidade, Long exercicio, SolicitacaoAlvaraEntity solicitacaoAlvara) {
        BigDecimal valor = this.repositoryCoeficienteCalculo.retornaValorLicencaSanitaria(solicitacaoAlvara.getAreaUtilizada(), exercicio, entidade);
        ParametroAlvaraEntity receita = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidade(), ParametroAlvaraEnum.RECEITA_LICENCASANITARIA);
        return this.calcularValorTaxa(entidade, exercicio, solicitacaoAlvara, receita, valor);
    }

    public BigDecimal calculaValorTaxaMobiliaria(Long entidade, Long exercicio, SolicitacaoAlvaraEntity solicitacaoAlvara, String taxaLocalizacao) {
        BigDecimal valor = this.repositoryCoeficienteCalculo.retornaValorTaxaLocalizacao(solicitacaoAlvara.getAreaUtilizada(), taxaLocalizacao, exercicio, entidade);
        ParametroAlvaraEntity receita = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidade(), ParametroAlvaraEnum.RECEITA_LOCALIZACAO);
        return this.calcularValorTaxa(entidade, exercicio, solicitacaoAlvara, receita, valor);
    }

    private BigDecimal calcularValorTaxa(Long entidade, Long exercicio, SolicitacaoAlvaraEntity solicitacao, ParametroAlvaraEntity receita, BigDecimal valor) {
        BigDecimal valorTotal = new BigDecimal(0);
        if (EloNumberUtils.isBiggerThanZero((Number)valor).booleanValue()) {
            BigDecimal total = BigDecimal.ZERO;
            total = !solicitacao.isNaturezaInicial() ? (solicitacao.isSituacaoMobiliarioVencido() || (solicitacao.isSituacaoMobiliarioNormal() || solicitacao.isSituacaoMobiliarioDesatualizado()) && !this.exercicioAtualEqualsDataAbertura(solicitacao.getCadastroMobiliario()) ? valor : this.calculaValorRestanteNoAno(valor)) : this.calculaValorRestanteNoAno(valor);
            ParametroAlvaraEntity codGuiaRecolhimento = this.repositoryParametroAlvara.getParametroAlvara(this.getEntidade(), ParametroAlvaraEnum.GUIARECOLHIMENTO);
            BigDecimal valorMinimo = this.repositoryFormaCalculo.carregarValorMinimo(entidade, exercicio, Long.valueOf(codGuiaRecolhimento.getValor()), receita.getValor());
            valorTotal = total.compareTo(valorMinimo) < 0 ? valorMinimo : total;
        }
        return valorTotal;
    }

    public BigDecimal calculaValorRestanteNoAno(BigDecimal valor) {
        if (EloNumberUtils.isBiggerThanZero((Number)valor).booleanValue()) {
            BigDecimal resultado = valor.divide(new BigDecimal(12), new MathContext(6, RoundingMode.HALF_UP));
            short mesAtual = EloDateUtils.getMonth((Date)new Date());
            int mesesRestante = 12 - mesAtual;
            return resultado.multiply(new BigDecimal(mesesRestante + 1));
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal calculaValorTaxaMobiliariaISSQN(SolicitacaoAlvaraEntity solicitacao, Long entidade, Long exercicio) throws BaseException {
        Integer maiorCodigoISSQN = this.retornaMaiorCodigoISSQN(solicitacao);
        BigDecimal valor = this.repositoryCoeficienteCalculo.retornaValorTaxaMobiliariaISSQN(maiorCodigoISSQN, entidade, exercicio);
        return this.calculaValorRestanteNoAno(valor);
    }

    public Integer retornaMaiorCodigoISSQN(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        SrvConsultaAtividade srvConsultaAtividade = this.srvConsultaAtividadeFactory.getConsultaAtividadeInstance(solicitacao);
        return srvConsultaAtividade.retornaMaiorCodigoISSQN(solicitacao);
    }

    public UsuarioEntity getUsuarioIntegraSGO() {
        return this.repositoryUsuario.getUsuarioIntegraSGO();
    }

    public void alteraMobiliarioSituacao(SolicitacaoAlvaraEntity solicitacao, SituacaoMobiliarioAlvaraEnum situacao) {
        SituacaoMobiliarioAlvaraEntity situacaoMobiliarioAlvara = this.getRepositorySituacaoMobiliarioAlvara().load(situacao.getCodigo());
        if (Objects.nonNull(solicitacao.getCadastroMobiliario()) && Objects.nonNull(solicitacao.getCadastroMobiliario().getMobiliarioSituacaoAtual()) && !solicitacao.getCadastroMobiliario().getMobiliarioSituacaoAtual().getId().equals(situacaoMobiliarioAlvara.getSituacaoMobiliario().getId())) {
            SituacaoMobiliarioEntity situacaoMobiliarioGravar = this.repositorySituacaoMobiliario.getSituacaoMobiliario(situacao);
            MobiliarioSituacaoEntity mobiliarioSituacaoAtual = new MobiliarioSituacaoEntity();
            for (MobiliarioSituacaoEntity mobiliarioSituacao : solicitacao.getCadastroMobiliario().getMobiliarioSituacao()) {
                if (!mobiliarioSituacao.getAtual().equals(SimNaoEnum.SIM.getShortText())) continue;
                mobiliarioSituacaoAtual = mobiliarioSituacao;
            }
            mobiliarioSituacaoAtual.setDataAlteracao(new Date());
            mobiliarioSituacaoAtual.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            mobiliarioSituacaoAtual.setAtual(SimNaoEnum.NAO.getShortText());
            this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacaoAtual);
            MobiliarioSituacaoPK id = new MobiliarioSituacaoPK();
            id.setCadastroGeralPK(solicitacao.getCadastroMobiliario().getId());
            id.setSequencia(this.repositoryMobiliarioSituacao.getSequencia(solicitacao.getCadastroMobiliario().getId()));
            MobiliarioSituacaoEntity mobiliarioSituacaoNovo = new MobiliarioSituacaoEntity();
            mobiliarioSituacaoNovo.setId(id);
            mobiliarioSituacaoNovo.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            mobiliarioSituacaoNovo.setDataInclusao(new Date());
            mobiliarioSituacaoNovo.setSituacaoMobiliario(situacaoMobiliarioGravar);
            mobiliarioSituacaoNovo.setAtual(SimNaoEnum.SIM.getShortText());
            solicitacao.getCadastroMobiliario().addMobiliarioSituacao(this.repositoryMobiliarioSituacao.saveOrUpdate(mobiliarioSituacaoNovo));
            solicitacao.setFinalizado(SimNaoEnum.getSimShortText());
            this.logger.info((Object)String.format("cadastro mobili\u00e1rio atualizando situacao: %d", solicitacao.getCadastroMobiliario().getId().getCodigo()));
            this.repositorySolicitacaoAlvara.saveOrUpdate(solicitacao);
        }
    }
}

