/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Socios;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Qualificacoes;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.ResponsavelLegal;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocial;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoContratoSocialPessoa;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.service.SrvContratoSocial;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.exception.CadastroMobiliarioException;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import br.com.elotech.tributacao.repository.aise.RepositoryPessoa;
import br.com.elotech.tributacao.service.SrvPessoa;
import br.com.elotech.unico.rest.exception.UnicoClientException;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.InvalidDateString;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class SrvContratoSocialImpl
implements SrvContratoSocial {
    private static final Log LOGGER = LogFactory.getLog(SrvContratoSocialImpl.class);
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;
    @Resource
    private RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial;
    @Resource
    private RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa;
    @Resource
    private SrvPessoa srvPessoa;
    @Resource
    private RepositoryPessoa repositoryPessoa;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public SolicitacaoAlvaraEntity preencherContratoSocialBySolicitacao(SolicitacaoAlvaraEntity solicitacao) throws CadastroMobiliarioException, InvalidDateString, UnicoClientException {
        try {
            SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacao.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            SolicitacaoAlvaraRedeSimDTO arquivoDadosEmpresa = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa());
            List socios = arquivoDadosEmpresa.getDados_solicitacao().getEmpresa().getSocios();
            BigDecimal capitalSocial = Optional.ofNullable(arquivoDadosEmpresa.getDados_solicitacao().getEmpresa().getNu_capital_social()).orElse(BigDecimal.ZERO);
            if (solicitacao.getContratoSocial() == null) {
                SolicitacaoContratoSocialEntity contrato = new SolicitacaoContratoSocialEntity();
                contrato.setId(this.repositorySolicitacaoContratoSocial.getSequence());
                contrato.setSolicitacaoAlvara(solicitacao);
                contrato.setNumeroAlteracao(this.nextNumeroContratoSocialByCadastroGeral(solicitacao.getCadastroMobiliario().getId()));
                solicitacao.setContratoSocial(contrato);
            }
            if (Objects.isNull(solicitacao.getContratoSocial().getPessoas())) {
                solicitacao.getContratoSocial().setPessoas(new ArrayList());
            }
            solicitacao.getContratoSocial().getPessoas().clear();
            String cpfResponsaval = Optional.ofNullable(arquivoDadosEmpresa.getDados_solicitacao().getEmpresa().getResponsavel_legal()).map(ResponsavelLegal::getNu_cpf).orElse("");
            if (!EloListUtils.safeIsEmpty((List)socios).booleanValue()) {
                for (Socios itemSocio : socios) {
                    PessoaEntity pessoa2 = this.repositoryPessoa.carregaPessoaMaisAntigaPorCpfCnpj(itemSocio.getNu_cpf_cnpj());
                    if (Objects.nonNull(pessoa2)) {
                        this.repositoryPessoa.flush();
                        pessoa2 = this.repositoryPessoa.refresh(pessoa2);
                    }
                    pessoa2 = this.preencherDadosPessoa(itemSocio, pessoa2);
                    BigDecimal percentualSocio = solicitacao.isSolicitacaoMEI() ? new BigDecimal(100) : this.getPercentualSocio(capitalSocial, itemSocio);
                    if (percentualSocio.compareTo(BigDecimal.ZERO) == 0) continue;
                    String responsavel = solicitacao.isSolicitacaoMEI() ? SimNaoEnum.getSimShortText() : (cpfResponsaval.equals(itemSocio.getNu_cpf_cnpj()) ? SimNaoEnum.getSimShortText() : SimNaoEnum.getNaoShortText());
                    SolicitacaoContratoSocialPessoaEntity contratoSocialPessoa = new SolicitacaoContratoSocialPessoaEntity();
                    contratoSocialPessoa.setId(this.repositorySolicitacaoContratoSocialPessoa.getSequence());
                    contratoSocialPessoa.setPessoa(pessoa2);
                    contratoSocialPessoa.setPercentualCapital(percentualSocio);
                    contratoSocialPessoa.setResponsavel(responsavel);
                    contratoSocialPessoa.setContratoSocial(solicitacao.getContratoSocial());
                    solicitacao.getContratoSocial().getPessoas().add(contratoSocialPessoa);
                }
                Boolean possuiRespons\u00e1vel = solicitacao.getContratoSocial().getPessoas().stream().anyMatch(pessoa -> SimNaoEnum.equalSim((String)pessoa.getResponsavel()));
                if (Boolean.FALSE.equals(possuiRespons\u00e1vel)) {
                    SolicitacaoContratoSocialPessoaEntity pessoaComMaiorPercentual = solicitacao.getContratoSocial().getPessoas().stream().max(Comparator.comparing(SolicitacaoContratoSocialPessoaEntity::getPercentualCapital)).orElse(null);
                    List pessoasComOMesmoPercentualMaior = solicitacao.getContratoSocial().getPessoas().stream().filter(pessoa -> pessoa.getPercentualCapital().compareTo(pessoaComMaiorPercentual.getPercentualCapital()) == 0).collect(Collectors.toList());
                    if (Objects.nonNull(pessoaComMaiorPercentual) && (solicitacao.getContratoSocial().getPessoas().size() == 1 || pessoasComOMesmoPercentualMaior.size() == 0)) {
                        pessoaComMaiorPercentual.setResponsavel(SimNaoEnum.getSimShortText());
                    }
                }
            }
            solicitacao.setContratoSocial(this.repositorySolicitacaoContratoSocial.saveOrUpdate(solicitacao.getContratoSocial()));
        }
        catch (Exception e) {
            throw new CadastroMobiliarioException("Falha ao preencher o contrato social pela solicita\u00e7\u00e3o " + e.getMessage(), (Throwable)e);
        }
        return solicitacao;
    }

    private Long nextNumeroContratoSocialByCadastroGeral(CadastroGeralAisePK cadastroGeralAisePK) {
        ContratoSocialEntity contrato = this.repositoryContratoSocial.findLastContratoByCadastroGeral(cadastroGeralAisePK);
        if (contrato != null && contrato.getNumeroAlteracao() != null) {
            return contrato.getNumeroAlteracao() + 1L;
        }
        return 1L;
    }

    private PessoaEntity preencherDadosPessoa(Socios itemSocio, PessoaEntity pessoa) throws UnicoClientException {
        if (pessoa == null) {
            LOGGER.info((Object)"NOVA PESSOA.....");
            pessoa = new PessoaEntity();
            pessoa.setCnpjCpf(itemSocio.getNu_cpf_cnpj());
            pessoa.setUsuarioInclusao(PortalUtils.getUsuarioalvaraonline());
            pessoa.setDataInclusao(new Date());
            if (Objects.nonNull(itemSocio.getDados_pessoa_fisica()) && Objects.nonNull(itemSocio.getDados_pessoa_fisica().getDocumento_identificacao())) {
                pessoa.setRg(itemSocio.getDados_pessoa_fisica().getDocumento_identificacao().getNu_documento_identificacao());
                pessoa.setOrgaoEmissor(itemSocio.getDados_pessoa_fisica().getDocumento_identificacao().getDs_orgao_expedidor());
            }
        }
        pessoa.setTipoPessoa(EloStringUtils.getTipoPessoaFromCnpjCpf((String)itemSocio.getNu_cpf_cnpj()));
        pessoa.setNome(itemSocio.getDs_nome());
        return this.srvPessoa.salvar(pessoa);
    }

    private BigDecimal getPercentualSocio(BigDecimal capitalSocial, Socios itemSocio) {
        if (Objects.isNull(itemSocio) || EloListUtils.safeIsEmpty((List)itemSocio.getQualificacoes()).booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal porcentagem = itemSocio.getQualificacoes().stream().filter(qualificacoes -> Objects.nonNull(qualificacoes.getDt_inicio_qualificacao())).sorted(Comparator.comparing(Qualificacoes::getDt_inicio_qualificacao, EloDateUtils::compareDatesFromStrings).reversed()).map(Qualificacoes::getNu_porcentagem_participacao).filter(Objects::nonNull).map(BigDecimal::new).findFirst().orElse(null);
        if (Objects.nonNull(porcentagem) && porcentagem.compareTo(BigDecimal.ZERO) != 0) {
            return porcentagem;
        }
        BigDecimal valorParticipacao = itemSocio.getQualificacoes().stream().sorted(Comparator.comparing(Qualificacoes::getDt_inicio_qualificacao, EloDateUtils::compareDatesFromStrings).reversed()).map(Qualificacoes::getNu_valor_participacao).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO);
        if (valorParticipacao.compareTo(BigDecimal.ZERO) != 0) {
            return valorParticipacao.multiply(BigDecimal.valueOf(100L)).divide(capitalSocial, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }

    public void setRepositorySolicitacaoContratoSocial(RepositorySolicitacaoContratoSocial repositorySolicitacaoContratoSocial) {
        this.repositorySolicitacaoContratoSocial = repositorySolicitacaoContratoSocial;
    }

    public void setRepositorySolicitacaoContratoSocialPessoa(RepositorySolicitacaoContratoSocialPessoa repositorySolicitacaoContratoSocialPessoa) {
        this.repositorySolicitacaoContratoSocialPessoa = repositorySolicitacaoContratoSocialPessoa;
    }

    public void setSrvPessoa(SrvPessoa srvPessoa) {
        this.srvPessoa = srvPessoa;
    }

    public void setRepositoryPessoa(RepositoryPessoa repositoryPessoa) {
        this.repositoryPessoa = repositoryPessoa;
    }

    public void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
    }
}

