/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeSemGeoImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaAtividadeCnaeSemGeo")
public class SrvConsultaAtividadeCnaeSemGeoImpl
extends SrvConsultaAtividadeSemGeoImpl {
    public static final String SERVICE_NAME = "srvConsultaAtividadeCnaeSemGeo";

    public RetornaAtividadeResponse consultar() throws BaseException {
        return super.consultar();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void carregarTabelaAtividadesAtuais() throws BaseException {
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            if (EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioAtividadeMeis()).booleanValue()) throw new ConsultaAtividadeException("N\u00e3o foi encontrado nenhum CNAE no cadastro mobili\u00e1rio, favor entrar em contato com o Setor de Alvar\u00e1, email: " + UtilsController.getEmailSetorAlvara());
            for (CadastroMobiliarioAtividadeMeiEntity atividadeCnae : this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
                if (!atividadeCnae.getAtividadeMei().getCnae().isAtivo() && this.consultaAtividadeVo.getSolicitacaoAlvara().isAlterandoEnderecoSemAlterarAtividade()) {
                    throw new ConsultaAtividadeException(EloStringUtils.build((Object[])new Object[]{"O CNAE ", atividadeCnae.getAtividadeMei().getCnae().getDescricao(), " n\u00e3o est\u00e1 ATIVO e n\u00e3o poder\u00e1 ser exercido no novo endere\u00e7o."}));
                }
                AtividadeMeiEntity atividade = atividadeCnae.getAtividadeMei();
                atividade.setPrincipal(atividadeCnae.getAtividadeMei().getPrincipal());
                atividade.setSituacao("A");
                this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividade);
                super.adicionarAtividade((Atividade)atividade);
            }
            return;
        } else {
            if (!this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) return;
            if (EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) throw new ConsultaAtividadeException("N\u00e3o foi encontrado nenhum CNAE no cadastro mobili\u00e1rio, favor entrar em contato com o Setor de Alvar\u00e1, email: " + UtilsController.getEmailSetorAlvara());
            for (MobiliarioCnaeEntity mobCnae : this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCnaes()) {
                if (!mobCnae.getId().getCnae().isAtivo() && this.consultaAtividadeVo.getSolicitacaoAlvara().isAlterandoEnderecoSemAlterarAtividade()) {
                    throw new ConsultaAtividadeException(EloStringUtils.build((Object[])new Object[]{"O CNAE ", mobCnae.getId().getCnae().getDescricao(), " n\u00e3o est\u00e1 ATIVO e n\u00e3o poder\u00e1 ser exercido no novo endere\u00e7o."}));
                }
                CnaeEntity atividade = mobCnae.getId().getCnae();
                atividade.setPrincipal(mobCnae.getId().getCnae().getPrincipal());
                atividade.setSituacao("A");
                this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividade);
                super.adicionarAtividade((Atividade)atividade);
            }
        }
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        listaSolicitacaoAtividades = this.prepararListaSolicitacaoAtividades(solicitacao);
        super.carregaExigenciasProibicaoNaSolicitacao(solicitacao, listaSolicitacaoAtividades);
    }

    public void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (solicitacao.isSolicitacaoCBO()) {
                solicitacao.setGrauRisco(atividade.getSequenciaCbo().getGrauRisco());
                if (!GrauDeRiscoEnum.isGrauRiscoAlto((String)atividade.getSequenciaCbo().getGrauRisco())) continue;
                break;
            }
            if (!solicitacao.isSolicitacaoMEI()) continue;
            solicitacao.setGrauRisco(atividade.getAtividadeMei().getGrauRisco());
            if (!GrauDeRiscoEnum.isGrauRiscoAlto((String)atividade.getAtividadeMei().getGrauRisco())) continue;
            break;
        }
    }
}

