/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.enumerator.MotivoIndeferimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.IndeferimentoRedeSimException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeGeoImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaAtividadeCnaeGeo")
public class SrvConsultaAtividadeCnaeGeoImpl
extends SrvConsultaAtividadeGeoImpl {
    public static final String SERVICE_NAME = "srvConsultaAtividadeCnaeGeo";

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeNova() {
        ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeNova();
        envio.setTipoAtividade(TipoAtividadeEnum.CNAE);
        return envio;
    }

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeExistente() {
        ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeExistente();
        envio.setTipoAtividade(TipoAtividadeEnum.CNAE);
        return envio;
    }

    protected void verificarAtividade(RetornaAtividadeResponse resposta) throws BaseException {
        super.verificarAtividade(resposta);
        CnaeEntity cnae = (CnaeEntity)this.consultaAtividadeVo.getAtividadeSelecionada();
        cnae.setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
        cnae.setTaxaLocalizacao(Integer.valueOf(Integer.parseInt(resposta.getRespostaWSAtividade().getCodTaxa())));
        this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)cnae);
        super.adicionarAtividade();
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCnaes()).booleanValue()) {
            for (MobiliarioCnaeEntity mobCnae : this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCnaes()) {
                if (!this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) continue;
                ConsultaAtividadeEnvio envio = this.prepararEnvioAtividadeExistente();
                envio.setCnae(mobCnae.getId().getCnae().getCodigo());
                RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
                mobCnae.getId().getCnae().setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
                CnaeEntity atividade = mobCnae.getId().getCnae();
                atividade.setPrincipal(mobCnae.getCnaePrincipal());
                atividade.setTaxaLocalizacao(Integer.valueOf(Integer.parseInt(resposta.getRespostaWSAtividade().getCodTaxa())));
                atividade.setSituacao("A");
                this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividade);
                super.verificarAtividade(resposta);
                this.consultaAtividadeVo.getListaAtiv().add(atividade);
            }
        } else {
            throw new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.DADOS_INCONSISTENTES, "N\u00e3o foi encontrado nenhum CNAE no cadastro mobili\u00e1rio, favor entrar em contato com o Setor de Alvar\u00e1, email: " + UtilsController.getEmailSetorAlvara());
        }
    }

    public ConsultaAtividadeEnvio prepararEnvioParaVerificacaoResponsavelTecnico(SolicitacaoAlvaraAtividadeEntity atividade) throws SolicitacaoAlvaraException {
        ConsultaAtividadeEnvio envio = super.prepararEnvioParaVerificacaoResponsavelTecnico(atividade);
        envio.setTipoAtividade(TipoAtividadeEnum.CNAE);
        return envio;
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        listaSolicitacaoAtividades = this.prepararListaSolicitacaoAtividades(solicitacao);
        super.carregaExigenciasProibicaoNaSolicitacao(solicitacao, listaSolicitacaoAtividades);
    }

    public void validaAtividadeNaoPermitida(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        this.consultaAtividadeVo = new ConsultaAtividadeVo();
        this.consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
        for (SolicitacaoAlvaraAtividadeEntity solicitacaoAlvaraAtividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeExistente();
            envio.setTipoAtividade(TipoAtividadeEnum.CNAE);
            envio.setCnae(solicitacaoAlvaraAtividade.getCnae().getCodigo());
            RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
            this.validaRespostaGeo(resposta);
        }
    }
}

