/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeSemGeoImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaAtividadeCboSemGeo")
public class SrvConsultaAtividadeCboSemGeoImpl
extends SrvConsultaAtividadeSemGeoImpl {
    public static final String SERVICE_NAME = "srvConsultaAtividadeCboSemGeo";

    public RetornaAtividadeResponse consultar() throws BaseException {
        super.adicionarAtividade(this.consultaAtividadeVo.getAtividadeSelecionada());
        return null;
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCbos()).booleanValue()) {
            for (CadastroMobiliarioCboEntity mobCbo : this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCbos()) {
                if (!mobCbo.getRhCbo().isAtivo() && this.consultaAtividadeVo.getSolicitacaoAlvara().isAlterandoEnderecoSemAlterarAtividade()) {
                    throw new ConsultaAtividadeException(EloStringUtils.build((Object[])new Object[]{"O CBO ", mobCbo.getRhCbo().getDescricao(), " n\u00e3o est\u00e1 ATIVO e n\u00e3o poder\u00e1 ser exercido no novo endere\u00e7o."}));
                }
                RhCboEntity atividade = mobCbo.getRhCbo();
                atividade.setPrincipal(mobCbo.getRhCbo().getPrincipal());
                atividade.setSituacao("A");
                this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividade);
                super.adicionarAtividade((Atividade)atividade);
            }
        } else {
            throw new ConsultaAtividadeException("N\u00e3o foi encontrado nenhum CBO no cadastro mobili\u00e1rio, favor entrar em contato com o Setor de Alvar\u00e1, email: " + UtilsController.getEmailSetorAlvara());
        }
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        listaSolicitacaoAtividades = this.prepararListaSolicitacaoAtividades(solicitacao);
        super.carregaExigenciasProibicaoNaSolicitacao(solicitacao, listaSolicitacaoAtividades);
    }

    public void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            solicitacao.setGrauRisco(atividade.getSequenciaCbo().getGrauRisco());
            if (!"C".equals(atividade.getSequenciaCbo().getGrauRisco())) continue;
            break;
        }
    }
}

