/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividadeDoc;
import br.com.elotech.portalarrecadacao.service.SrvConfiguracaoAtividadeDocumento;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocTipoInscricaoAlvara;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvConfiguracaoAtividadeDocumento")
public class SrvConfiguracaoAtividadeDocumentoImpl
implements SrvConfiguracaoAtividadeDocumento {
    @Resource
    private RepositoryConfiguracaoAtividade repositoryConfiguracaoAtividade;
    @Resource
    private RepositoryConfiguracaoAtividadeDoc repositoryConfiguracaoAtividadeDoc;
    @Resource
    private RepositoryTipoDocTipoInscricaoAlvara repositoryTipoDocTipoInscricaoAlvara;

    public ConfiguracaoAtividadeDocumentoEntity salvar(ConfiguracaoAtividadeDocumentoEntity configuracaoAtividadeDocumento) throws ValidacaoException {
        this.validarConfiguracaoAtividadeDocumento(configuracaoAtividadeDocumento);
        return this.repositoryConfiguracaoAtividadeDoc.save(configuracaoAtividadeDocumento);
    }

    public void validarConfiguracaoAtividadeDocumento(ConfiguracaoAtividadeDocumentoEntity configuracaoAtividadeDocumento) throws ValidacaoException {
        ValidacaoException ve = new ValidacaoException();
        configuracaoAtividadeDocumento.validar();
        if (this.isPossuiTipoDocEmTipoDocInscricaoAlvara(configuracaoAtividadeDocumento.getTipoDocumento(), configuracaoAtividadeDocumento.getConfiguracaoAtividade().getTipoInscricao())) {
            ve.adicionarMensagem("Este tipo de documento j\u00e1 est\u00e1 configurado para este tipo de inscri\u00e7\u00e3o.");
        } else if (this.existeTipoDocumentoAdicionado(configuracaoAtividadeDocumento)) {
            ve.adicionarMensagem("Este tipo de documento j\u00e1 adicionado.");
        }
        ve.lancarException();
    }

    public boolean isPossuiTipoDocEmTipoDocInscricaoAlvara(TipoDocumentoEntity tipoDocumento, String tipoInscricao) {
        return this.repositoryTipoDocTipoInscricaoAlvara.isExisteTipoDocumento(tipoDocumento, tipoInscricao);
    }

    public boolean existeTipoDocumentoAdicionado(ConfiguracaoAtividadeDocumentoEntity configuracaoAtividadeDocumento) {
        ConfiguracaoAtividadeEntity configuracaoAtividade = this.repositoryConfiguracaoAtividade.load(configuracaoAtividadeDocumento.getConfiguracaoAtividade().getIdConfiguracaoAtividade());
        return (configuracaoAtividade = this.repositoryConfiguracaoAtividade.carregarDocumentos(configuracaoAtividade)) != null && EloListUtils.safeIsEmpty((List)configuracaoAtividade.getDocumentosAtividade()) == false && configuracaoAtividade.getDocumentosAtividade().stream().anyMatch(doc -> doc.getTipoDocumento().equals((Object)configuracaoAtividadeDocumento.getTipoDocumento()) && doc.getTipo().equals((Object)configuracaoAtividadeDocumento.getTipo()));
    }
}

