/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.ConcessaoAlvaraNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.ParametroNaoConfiguradoException;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvBoletimImobiliario;
import br.com.elotech.tributacao.domain.aise.BoletimImobiliarioTerrenoEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.exception.EntidadeNaoConfiguradaException;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimImobiliarioTerreno;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;

@EloService
public class SrvBoletimImobiliarioImpl
implements SrvBoletimImobiliario {
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryBoletimImobiliarioTerreno repositoryBoletimImobiliarioTerreno;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidade;

    public void validarBoletimImobiliarioConcessaoAlvaraNaoPermitida(CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        List codigosBoletim;
        BoletimImobiliarioTerrenoEntity boletim;
        if (cadastroImobiliario == null) {
            return;
        }
        ParametroAlvaraEntity parametroBoletimPermissaoConcessaoAlvara = this.carregarParametroBoletimConcessaoAlvara(cadastroImobiliario);
        if (parametroBoletimPermissaoConcessaoAlvara != null && !EloStringUtils.isEmpty((String)parametroBoletimPermissaoConcessaoAlvara.getValor()) && (boletim = this.repositoryBoletimImobiliarioTerreno.loadByCadastroModeloGrupoCampo(cadastroImobiliario, (Long)(codigosBoletim = this.transformarParaLongList(parametroBoletimPermissaoConcessaoAlvara)).get(0), (Long)codigosBoletim.get(1), (Long)codigosBoletim.get(2))) != null && (SimNaoEnum.equalSim((String)boletim.getId().getModeloResposta().getDescricao()).booleanValue() || SimNaoEnum.equalSim((String)boletim.getDescricaoResposta()).booleanValue())) {
            throw new ConcessaoAlvaraNaoPermitidaException("Este im\u00f3vel est\u00e1 restrito \u00e0 concess\u00e3o de alvar\u00e1 de localiza\u00e7\u00e3o.");
        }
    }

    protected List<Long> transformarParaLongList(ParametroAlvaraEntity parametroBoletimPermissaoConcessaoAlvara) throws ParametroNaoConfiguradoException {
        String valor = parametroBoletimPermissaoConcessaoAlvara.getValor();
        ArrayList codigosBoletimValorParametro = Lists.newArrayList((Object[])valor.split(","));
        if (codigosBoletimValorParametro.size() != 3 || codigosBoletimValorParametro.stream().anyMatch(codigo -> !StringUtils.isNumeric((CharSequence)codigo))) {
            throw new ParametroNaoConfiguradoException(String.format("A configura\u00e7\u00e3o do par\u00e2metro %s est\u00e1 incorreta.", ParametroAlvaraEnum.BOLETIM_PROIBIDA_CONCESSAO_ALVARA));
        }
        List<Long> codigosBoletim = codigosBoletimValorParametro.stream().map(cod -> Long.valueOf(cod)).collect(Collectors.toList());
        return codigosBoletim;
    }

    protected ParametroAlvaraEntity carregarParametroBoletimConcessaoAlvara(CadastroImobiliarioEntity cadastroImobiliario) {
        return this.repositoryParametroAlvara.getParametroAlvara(this.getEntidade(), ParametroAlvaraEnum.BOLETIM_PROIBIDA_CONCESSAO_ALVARA);
    }

    protected EntidadeAiseEntity getEntidade() {
        EntidadeTributacaoEntity entidadeTributacao = this.repositoryEntidade.getExercicioAtual(EloDateUtils.getAnoAtual());
        if (entidadeTributacao != null) {
            return entidadeTributacao.getId().getEntidade();
        }
        throw new EntidadeNaoConfiguradaException("N\u00e3o foi encontrada nenhuma entidade para o exerc\u00edcio: " + EloDateUtils.getAnoAtual());
    }

    public void setRepositoryParametroAlvara(RepositoryParametroAlvara repositoryParametroAlvara) {
        this.repositoryParametroAlvara = repositoryParametroAlvara;
    }

    public void setRepositoryBoletimImobiliarioTerreno(RepositoryBoletimImobiliarioTerreno repositoryBoletimImobiliarioTerreno) {
        this.repositoryBoletimImobiliarioTerreno = repositoryBoletimImobiliarioTerreno;
    }
}

