/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ArquivoDocumentoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryArquivoDocumentoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvArquivoDocumentoAlvara;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.EloArquivoEntity;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;

@EloService(value="srvArquivoDocumentoAlvara")
@Scope(value="prototype")
public class SrvArquivoDocumentoAlvaraImpl
extends EloLogger
implements SrvArquivoDocumentoAlvara {
    @Resource
    private RepositoryArquivoDocumentoAlvara repositoryArquivoDocumentoAlvara;

    public ArquivoDocumentoAlvaraEntity salvarArquivoAlvara(byte[] documento, SolicitacaoAlvaraEntity solicitacaoAlvara, DocumentoAiseEntity documentoAise) {
        EloArquivoEntity eloArquivo = EloArquivoEntity.of((byte[])documento);
        eloArquivo.setId(this.repositoryArquivoDocumentoAlvara.getSequenceEloArquivo());
        eloArquivo.setNome(String.format("Alvar\u00e1 Localiza\u00e7\u00e3o - %s", solicitacaoAlvara.getNumeroSolicitacaoExercicio()));
        eloArquivo.setDataCriacao(new Date());
        ArquivoDocumentoAlvaraEntity arquivoDocumentoAlvara = new ArquivoDocumentoAlvaraEntity();
        arquivoDocumentoAlvara.setId(this.repositoryArquivoDocumentoAlvara.getSequence());
        arquivoDocumentoAlvara.setSolicitacao(solicitacaoAlvara);
        arquivoDocumentoAlvara.setDocumento(documentoAise);
        arquivoDocumentoAlvara.setEloArquivo(eloArquivo);
        this.repositoryArquivoDocumentoAlvara.saveOrUpdate(arquivoDocumentoAlvara);
        return arquivoDocumentoAlvara;
    }

    public ArquivoDocumentoAlvaraEntity buscarArquivoPeloIdArquivoDocumento(Long id) {
        return this.repositoryArquivoDocumentoAlvara.load(id);
    }

    public void setRepositoryArquivoDocumentoAlvara(RepositoryArquivoDocumentoAlvara repositoryArquivoDocumentoAlvara) {
        this.repositoryArquivoDocumentoAlvara = repositoryArquivoDocumentoAlvara;
    }
}

