/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.ProtocoloMenorQueOInicialException;
import br.com.elotech.portalarrecadacao.exception.RegistroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeLaudoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.Dados_solicitacao_documento;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoDocumentosDTO;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS04Service;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoDocumentoRedeSimEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EloService
public class ProcessamentoWS04ServiceImpl
implements ProcessamentoWS04Service {
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoWS04ServiceImpl.class);
    private static final String COMPLEMENTO_LOG_LIBERDADE_ECONOMICA = "liberdade econ\u00f4mica!";
    private static final String COMPLEMENTO_LOG_MEI = "MEI!";
    private static final long TIPODOCUMENTO_INVALIDO = 0L;
    private boolean geraCadastroLaudoRedeSim = false;
    private boolean habilitaProcessoAutomaticoMei = false;
    @Autowired
    private FacadeRedeSim facadeRedeSim;
    @Autowired
    private FacadeLaudoAlvara facadeLaudoAlvara;
    @Autowired
    private FacadeSolicitacaoAlvara facadeSolicitacaoAlvara;

    public Dados_solicitacao_documento processar(String protocolo, String token, String json, SolicitacaoDocumentosDTO solicitacaoDocumentosDTO) throws BaseException {
        Dados_solicitacao_documento dadosSolicitacaoDocumento = solicitacaoDocumentosDTO.getDados_solicitacao_documento();
        try {
            Long numeroProtocolo = EloStringUtils.getLongFromString((String)protocolo);
            if (RedeSimBaseResource.isLowerThanProtocoloInicialRedeSim((Long)numeroProtocolo).booleanValue()) {
                throw new ProtocoloMenorQueOInicialException(String.format("Protocolo %d menor que o inicial %d.", numeroProtocolo, RedeSimBaseResource.getProtocoloInicialRedeSim()));
            }
            SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.facadeRedeSim.getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            if (Objects.isNull(solicitacaoRedeSimEntity)) {
                throw new RegistroNaoEncontradoException(String.format("N\u00e3o existe uma solicita\u00e7\u00e3o (WS02) com o protocolo %s.", protocolo));
            }
            if (this.isTipoDocumentoInvalido(dadosSolicitacaoDocumento)) {
                log.info("WS04 - [{}] Tipo de documento inv\u00e1lido", (Object)token);
                this.addHistoricoAnalise(solicitacaoRedeSimEntity);
            } else {
                SolicitacaoDocRedeSimEntity solicitacaoDoc = this.facadeRedeSim.findSolicitacaoDocumento(solicitacaoDocumentosDTO);
                if (Objects.nonNull(solicitacaoDoc)) {
                    throw new RegistroProcessadoAnteriormenteException(String.format("Tipo de documento %d processado anteriormente.", dadosSolicitacaoDocumento.getCo_tipo_modelo_documento()));
                }
            }
            Integer tipoDocumentoFromRequest = dadosSolicitacaoDocumento.getCo_tipo_modelo_documento();
            TipoDocumentoRedeSimEnum tipoDocumento = TipoDocumentoRedeSimEnum.fromValue((Long)((Object)tipoDocumentoFromRequest));
            if (TipoDocumentoRedeSimEnum.INSCRICAO_MUNICIPAL.equals((Object)tipoDocumento) && this.existeHistorico(dadosSolicitacaoDocumento, TipoDocumentoRedeSimEnum.INSCRICAO_MUNICIPAL, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA)) {
                throw new RegistroProcessadoAnteriormenteException("Processado anteriormente.");
            }
            if (TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.equals((Object)tipoDocumento) && (this.existeHistorico(dadosSolicitacaoDocumento, TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO, SituacaoConsultaPreviaRedeSimEnum.TERMO_DISPENSA_ENVIADO) || this.existeHistorico(dadosSolicitacaoDocumento, TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO, SituacaoConsultaPreviaRedeSimEnum.ALVARA_ENVIADO))) {
                throw new RegistroProcessadoAnteriormenteException("Processado anteriormente.");
            }
            if (TipoDocumentoRedeSimEnum.ALVARA_LOCALIZACAO.equals((Object)tipoDocumento) && this.facadeRedeSim.existsSolicitacaoRedeSimWithSituacao(protocolo, SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA) && !EloListUtils.safeIsEmpty((List)solicitacaoRedeSimEntity.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                throw new RegistroProcessadoAnteriormenteException("Os laudos j\u00e1 foram gerados e j\u00e1 foram encaminhados para vistoria.");
            }
            if (TipoDocumentoRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO.equals((Object)tipoDocumento) && UtilsController.existeHistoricoAlvaraProvisorioEnviado((SolicitacaoRedeSimEntity)solicitacaoRedeSimEntity)) {
                throw new RegistroProcessadoAnteriormenteException("Processado anteriormente.");
            }
            SolicitacaoDocRedeSimEntity solicitacaoDocRedeSimEntity = this.saveSolicitacaoDocumento(solicitacaoDocumentosDTO);
            log.info("WS04 - [{}] SolicitacaoDocRedeSim: {}", (Object)token, (Object)solicitacaoDocRedeSimEntity.getId());
            Optional.ofNullable(dadosSolicitacaoDocumento).ifPresent(dsd -> dsd.setId(Integer.valueOf(solicitacaoDocRedeSimEntity.getId().intValue())));
            this.addHistoricoAnalise(solicitacaoRedeSimEntity);
            this.geraCadastroLaudoRedeSim = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_CADASTRO_LAUDO_VIA_INTEGRACAO_REDESIM));
            this.habilitaProcessoAutomaticoMei = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_PROCESSO_AUTOMATICO_SOLICITACAO_MEI));
            solicitacaoRedeSimEntity = this.recarregarSolicitacaoRedeSimEntity(protocolo);
            Boolean todosEventosAptos = UtilsController.areAllEventosAptos((SolicitacaoRedeSimEntity)solicitacaoRedeSimEntity);
            if (Boolean.TRUE.equals(todosEventosAptos) && !this.isRural(solicitacaoRedeSimEntity)) {
                log.info("WS04 - [{}] Iniciando a gera\u00e7\u00e3o autom\u00e1tica do cadastro! protocolo: {} ", (Object)token, (Object)protocolo);
                solicitacaoRedeSimEntity = this.recarregarSolicitacaoRedeSimEntity(protocolo);
                if (this.facadeRedeSim.possuiProcessoAutomatico(solicitacaoDocRedeSimEntity)) {
                    log.info("WS04 - [{}] Solicita\u00e7\u00e3o de documento j\u00e1 processada automaticamente!", (Object)token);
                    throw new RegistroProcessadoAnteriormenteException("Processado anteriormente.");
                }
                Boolean isInscricaoEnviada = Optional.ofNullable(solicitacaoRedeSimEntity).map(SolicitacaoRedeSimEntity::isInscricaoEnviada).orElse(false) != false || this.facadeRedeSim.existsSolicitacaoRedeSimWithSituacao(protocolo, SituacaoConsultaPreviaRedeSimEnum.INSCRICAO_ENVIADA);
                if (Boolean.TRUE.equals(isInscricaoEnviada)) {
                    if (!EloListUtils.safeIsEmpty((List)solicitacaoRedeSimEntity.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                        log.info("WS04 - [{}] Realizando a gera\u00e7\u00e3o autom\u00e1tica do(s) laudo(s)! protocolo: {} ", (Object)token, (Object)protocolo);
                        this.facadeLaudoAlvara.generateLaudosRedeSim(solicitacaoRedeSimEntity.getSolicitacaoAlvara());
                        log.info("WS04 - [{}] Finalizado a gera\u00e7\u00e3o autom\u00e1tica do(s) laudos!", (Object)token);
                    }
                    if (!(solicitacaoRedeSimEntity = this.recarregarSolicitacaoRedeSimEntity(protocolo)).getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica() && !EloListUtils.safeIsEmpty((List)solicitacaoRedeSimEntity.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                        this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.ENCAMINHADO_VISTORIA, Optional.of("O Cadastro se encontra com situa\u00e7\u00e3o em An\u00e1lise, e os Laudos j\u00e1 foram Disparados para as Secretarias!"));
                    }
                } else {
                    log.info("WS04 - [{}] Realizando a gera\u00e7\u00e3o autom\u00e1tica do cadastro! protocolo: {} ", (Object)token, (Object)protocolo);
                    this.facadeRedeSim.generateCadastroLaudoAutomatico(protocolo, solicitacaoDocRedeSimEntity, true);
                    log.info("WS04 - [{}] Finalizado a gera\u00e7\u00e3o autom\u00e1tica do cadastro!", (Object)token);
                }
                solicitacaoRedeSimEntity = this.recarregarSolicitacaoRedeSimEntity(protocolo);
                log.info("WS04 - [{}] In\u00edcio do processo de gera\u00e7\u00e3o de alvar\u00e1 / Inscri\u00e7\u00e3o municipal! protocolo {}", (Object)token, (Object)protocolo);
                dadosSolicitacaoDocumento.setId(Integer.valueOf(solicitacaoDocRedeSimEntity.getId().intValue()));
                if (Objects.nonNull(solicitacaoRedeSimEntity) && Objects.nonNull(solicitacaoRedeSimEntity.getSolicitacaoAlvara())) {
                    if (solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoMEINormal()) {
                        this.generateDocumentoMEI(solicitacaoRedeSimEntity, token, COMPLEMENTO_LOG_MEI);
                    } else if (!solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoMEI()) {
                        if (solicitacaoRedeSimEntity.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
                            this.generateDocumentoLiberdadeEconomica(solicitacaoRedeSimEntity, token, COMPLEMENTO_LOG_LIBERDADE_ECONOMICA);
                        } else {
                            boolean geraDebitoAutomatico = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GERA_DEBITO_AUTOMATICO_SOLICITACAO_REDESIM));
                            if (!geraDebitoAutomatico) {
                                this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_GERACAO_DEBITO, Optional.of("Aguardando a gera\u00e7\u00e3o do d\u00e9bito"));
                            } else {
                                this.generateDebitoAutomatico(solicitacaoRedeSimEntity);
                                if (solicitacaoRedeSimEntity.getSolicitacaoAlvara().isGrauRiscoBaixo()) {
                                    Boolean enviaAlvaraProvisorio = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_ALVARA_PROVISORIO_REDE_SIM));
                                    if (Boolean.TRUE.equals(enviaAlvaraProvisorio)) {
                                        solicitacaoRedeSimEntity.setAlvaraEnviado(TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO);
                                        solicitacaoRedeSimEntity.getSolicitacaoAlvara().setDataValidadeProvisorio(this.facadeRedeSim.calcularDataAlvaraProvisorio());
                                    } else {
                                        solicitacaoRedeSimEntity.setAlvaraEnviado(TipoAlvaraEnum.DEFINITIVO);
                                    }
                                    this.gerarAlvara(solicitacaoRedeSimEntity);
                                    if (enviaAlvaraProvisorio.booleanValue()) {
                                        this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO, Optional.of("Alvar\u00e1 Provis\u00f3rio"));
                                        this.facadeRedeSim.enviarAlvaraRiscoBaixo(solicitacaoRedeSimEntity, ModeloDocumentoRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO);
                                    } else {
                                        this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.ALVARA_EMITIDO, Optional.empty());
                                        this.facadeRedeSim.enviarAlvaraRiscoBaixo(solicitacaoRedeSimEntity, ModeloDocumentoRedeSimEnum.ALVARA_LOCALIZACAO);
                                    }
                                }
                            }
                        }
                    }
                }
                solicitacaoRedeSimEntity = this.recarregarSolicitacaoRedeSimEntity(protocolo);
                this.facadeRedeSim.updateSolicitacaoRedeSimParaWebIss(solicitacaoRedeSimEntity, null);
                log.info("WS04 - [{}] Fim do processo de gera\u00e7\u00e3o de alvar\u00e1 / Inscri\u00e7\u00e3o municipal! protocolo: {} ", (Object)token, (Object)protocolo);
            }
            return dadosSolicitacaoDocumento;
        }
        catch (Exception e) {
            if (e instanceof RegistroProcessadoAnteriormenteException || e instanceof ProtocoloMenorQueOInicialException || e instanceof RegistroNaoEncontradoException) {
                throw e;
            }
            log.error(String.format("WS04 - [%s] %s ", token, e.getMessage()), (Throwable)e);
            if (this.geraCadastroLaudoRedeSim || this.habilitaProcessoAutomaticoMei) {
                SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.facadeRedeSim.getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
                this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.SOLICITACAO_INCONSISTENTE, Optional.ofNullable(e.getMessage()));
                SolicitacaoDocRedeSimEntity solicitacaoDocRedeSimEntity = this.facadeRedeSim.findSolicitacaoDocumento(solicitacaoDocumentosDTO);
                if (Objects.nonNull(solicitacaoDocRedeSimEntity)) {
                    dadosSolicitacaoDocumento.setId(Integer.valueOf(solicitacaoDocRedeSimEntity.getId().intValue()));
                    this.facadeRedeSim.updateSolicitacaoDocumentosRedeSimParaProcessadaAutomaticamente(solicitacaoDocRedeSimEntity);
                }
            }
            throw e;
        }
    }

    private void generateDebitoAutomatico(SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        log.info("Gerando d\u00e9bito autom\u00e1tico pelo WS04 - procotolo: {}", (Object)solicitacaoRedeSim.getProtocolo());
        ImprimirTaxasAlvara numeroCarneBloqueto = this.facadeSolicitacaoAlvara.imprimirTaxas(solicitacaoRedeSim.getSolicitacaoAlvara());
        log.info("D\u00e9bito autom\u00e1tico gerado pelo WS04: bloqueto {}", (Object)Optional.ofNullable(numeroCarneBloqueto).map(ImprimirTaxasAlvara::getBloqueto).orElse("n\u00e3o foi gerado o d\u00e9bito!"));
        if (Objects.nonNull(numeroCarneBloqueto) && numeroCarneBloqueto.existsTaxa()) {
            this.facadeRedeSim.enviarDocumento(solicitacaoRedeSim, SituacaoRespostaRedeSimEnum.EM_ANALISE, Boolean.TRUE.booleanValue(), numeroCarneBloqueto);
        }
    }

    private boolean isRural(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) throws SolicitacaoAlvaraRedeSimException {
        SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO = PortalUtils.normalizeJson((String)solicitacaoRedeSimEntity.getArquivoDadosEmpresa());
        if (Objects.nonNull(solicitacaoRedeSimDTO) && Objects.nonNull(solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel())) {
            return solicitacaoRedeSimDTO.getDados_solicitacao().getEmpresa().getEndereco().getNatureza_imovel().getCo_tipo_natureza().equals("1");
        }
        return Boolean.FALSE;
    }

    private boolean isTipoDocumentoInvalido(Dados_solicitacao_documento dadosSolicitacaoDocumento) {
        return Objects.isNull(dadosSolicitacaoDocumento.getCo_tipo_modelo_documento()) || Long.valueOf(dadosSolicitacaoDocumento.getCo_tipo_modelo_documento().intValue()).equals(0L);
    }

    private void addHistoricoAnalise(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) throws BaseException {
        if (SituacaoConsultaPreviaRedeSimEnum.AGUARDANDO_SOLICITACAO.getSigla().equals(solicitacaoRedeSimEntity.getSituacao())) {
            this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSimEntity, SituacaoConsultaPreviaRedeSimEnum.ANALISE, Optional.empty());
        }
    }

    private SolicitacaoDocRedeSimEntity saveSolicitacaoDocumento(SolicitacaoDocumentosDTO solicitacao) throws BaseException {
        return this.facadeRedeSim.salvarSolicitacaoDocumento(solicitacao);
    }

    private boolean existeHistorico(Dados_solicitacao_documento dadosSolicitacaoDocumento, TipoDocumentoRedeSimEnum tipomodelo, SituacaoConsultaPreviaRedeSimEnum situacao) throws BaseException {
        Long tipoModeloDocumento = Optional.ofNullable(dadosSolicitacaoDocumento).filter(item -> Objects.nonNull(item.getCo_tipo_modelo_documento())).map(Dados_solicitacao_documento::getCo_tipo_modelo_documento).map(Long::valueOf).orElse(null);
        return Objects.nonNull(tipoModeloDocumento) && tipomodelo.getCodigo().compareTo(tipoModeloDocumento) == 0 && this.facadeRedeSim.existsSolicitacaoRedeSimWithSituacao(dadosSolicitacaoDocumento.getCo_protocolo_redesim(), situacao);
    }

    private SolicitacaoRedeSimEntity recarregarSolicitacaoRedeSimEntity(String protocolo) throws BaseException {
        return this.facadeRedeSim.getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }

    private void generateDocumentoMEI(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity, String token, String complementoLog) throws BaseException {
        if (!solicitacaoRedeSimEntity.isInscricaoEnviada()) {
            log.info("WS04 - [{}] Realizando a gera\u00e7\u00e3o da inscri\u00e7\u00e3o municipal {}", (Object)token, (Object)complementoLog);
            this.facadeRedeSim.generateAndSendInscricaoMunicipalRedeSim(solicitacaoRedeSimEntity);
            log.info("WS04 - [{}] Finalizada a gera\u00e7\u00e3o da inscri\u00e7\u00e3o municipal {}", (Object)token, (Object)complementoLog);
        }
    }

    private void generateDocumentoLiberdadeEconomica(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity, String token, String complementoLog) throws BaseException {
        log.info("WS04 - [{}] Realizando a gera\u00e7\u00e3o do termo de dispensa {}", (Object)token, (Object)complementoLog);
        this.facadeRedeSim.generateAndSendTermoDispensaRedeSim(solicitacaoRedeSimEntity);
        log.info("WS04 - [{}] Finalizada a gera\u00e7\u00e3o do termo de dispensa {}", (Object)token, (Object)complementoLog);
    }

    private void gerarAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSimEntity) throws BaseException {
        solicitacaoRedeSimEntity.setSolicitacaoAlvara(this.facadeRedeSim.montarObsAlvaraRedeSim(solicitacaoRedeSimEntity));
        this.facadeRedeSim.gerarAlvaraRedeSim(solicitacaoRedeSimEntity.getSolicitacaoAlvara());
        this.facadeRedeSim.salvarObsAlvaraGerado(solicitacaoRedeSimEntity.getSolicitacaoAlvara());
    }

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    public void setFacadeLaudoAlvara(FacadeLaudoAlvara facadeLaudoAlvara) {
        this.facadeLaudoAlvara = facadeLaudoAlvara;
    }

    public void setFacadeSolicitacaoAlvara(FacadeSolicitacaoAlvara facadeSolicitacaoAlvara) {
        this.facadeSolicitacaoAlvara = facadeSolicitacaoAlvara;
    }
}

