/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.EventosNaoTratadosException;
import br.com.elotech.portalarrecadacao.exception.ProtocoloMenorQueOInicialException;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosConsultaPrevia;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.integration.transformer.ProcessaConsulta;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS01Service;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EloService
public class ProcessamentoWS01ServiceImpl
implements ProcessamentoWS01Service {
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoWS01ServiceImpl.class);
    @Autowired
    private ProcessaConsulta processaConsulta;

    public Long processar(String protocolo, String token, String json, ConsultaPreviaDTO consultaPreviaDTO) throws BaseException {
        DadosConsultaPrevia dadosConsultaPrevia = consultaPreviaDTO.getDados_consulta_previa();
        Long numeroProtocolo = EloStringUtils.getLongFromString((String)protocolo);
        if (RedeSimBaseResource.isLowerThanProtocoloInicialRedeSim((Long)numeroProtocolo).booleanValue()) {
            throw new ProtocoloMenorQueOInicialException(String.format("Protocolo %d menor que o inicial %d.", numeroProtocolo, RedeSimBaseResource.getProtocoloInicialRedeSim()));
        }
        if (this.processaConsulta.existeConsultaOuSolicitacaoComProtocolo(dadosConsultaPrevia.getCo_protocolo_redesim(), TipoSolicitacaoRedeSimEnum.CONSULTA)) {
            throw new RegistroProcessadoAnteriormenteException("Processado anteriormente.");
        }
        List naturezas = this.processaConsulta.getNaturezaEventoConsulta(consultaPreviaDTO.getDados_consulta_previa().getEventos());
        if (EloListUtils.safeIsEmpty((List)naturezas).booleanValue()) {
            String eventos = consultaPreviaDTO.getDados_consulta_previa().getEventos().stream().map(Evento::getCo_evento).map(String::valueOf).collect(Collectors.joining(","));
            throw new EventosNaoTratadosException(String.format("Protocolo %s - eventos n\u00e3o tratados pelo sistema: %s.", protocolo, eventos));
        }
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.processaConsulta.process(consultaPreviaDTO);
        return solicitacaoRedeSim.getId();
    }

    public void setProcessaConsulta(ProcessaConsulta processaConsulta) {
        this.processaConsulta = processaConsulta;
    }
}

