/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.service;

import br.com.elotech.portalarrecadacao.rest.dto.UserDTO;
import br.com.elotech.portalarrecadacao.rest.response.TokenResponse;
import br.com.elotech.portalarrecadacao.rest.security.model.UserAuthentication;
import br.com.elotech.portalarrecadacao.rest.security.token.TokenHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class SrvTokenAuthentication {
    @Autowired
    private TokenHandler tokenHandler;

    public TokenResponse createUserToken(UserDTO user) {
        return this.tokenHandler.createUserToken(user.getUsername());
    }

    public TokenResponse createUserUnicoToken(UserDTO user, String tokenUnico) {
        return this.tokenHandler.createUnicoUserToken(user.getUsername(), tokenUnico);
    }

    public Authentication getAuthentication(String token) {
        UserDetails userDetails = this.tokenHandler.parseUserFromToken(token);
        return new UserAuthentication(userDetails);
    }

    public String getTokenUnico(String token) {
        return this.tokenHandler.parseUnicoFromToken(token);
    }

    public Authentication getAuthenticationRedeSim() {
        UserDetails userDetails = this.tokenHandler.loadUserRedeSim();
        return new UserAuthentication(userDetails);
    }
}

