/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.service;

import br.com.elotech.portalarrecadacao.rest.factory.RestRequestFactory;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestRequestService {
    private static final Logger logger = LoggerFactory.getLogger(RestRequestService.class);
    private RestTemplate restTemplate;
    private String user;
    private String password;

    public RestRequestService() {
        this.createRestTemplateWithoutSecurity();
    }

    public RestRequestService(String user, String password) {
        this.user = user;
        this.password = password;
        this.createRestTemplate();
    }

    public <T> T get(String uri, Map<String, String> uriParams) {
        return (T)this.restTemplate.getForObject(uri, String.class, uriParams);
    }

    public <T> ResponseEntity<T> post(String uri, HttpEntity<MultiValueMap<String, String>> uriParams, Class<T> classe) {
        return this.restTemplate.postForEntity(uri, uriParams, classe, new Object[0]);
    }

    public <T> ResponseEntity<T> postWithBody(String uri, HttpEntity<String> httpEntity, Class<T> classe) {
        return this.restTemplate.postForEntity(uri, httpEntity, classe, new Object[0]);
    }

    private HttpComponentsClientHttpRequestFactory getClientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectTimeout(240000);
        httpRequestFactory.setReadTimeout(240000);
        return httpRequestFactory;
    }

    private void createRestTemplateWithoutSecurity() {
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)this.getClientHttpRequestFactory());
        this.restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
    }

    private void createRestTemplate() {
        try {
            this.restTemplate = RestRequestFactory.createTemplate((String)this.user, (String)this.password);
            this.restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public <T> ResponseEntity<T> patch(String url, HttpEntity<MultiValueMap<String, String>> uriParams, Class<T> classe) {
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.PATCH, uriParams, String.class, new Object[0]);
        return exchange;
    }

    public <T> ResponseEntity<T> getWithHeaders(String url, HttpEntity<String> entity, Class<T> classe) {
        ResponseEntity exchange = this.restTemplate.exchange(url, HttpMethod.GET, entity, classe, new Object[0]);
        return exchange;
    }
}

