/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.security.filter;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.AutenticacaoRedeSimException;
import br.com.elotech.portalarrecadacao.rest.mapper.AlvaraRestObjectMapper;
import br.com.elotech.portalarrecadacao.rest.response.AlvaraErrorMessage;
import br.com.elotech.portalarrecadacao.rest.response.Erro;
import br.com.elotech.portalarrecadacao.rest.response.RedeSimErrorMessage;
import br.com.elotech.portalarrecadacao.rest.security.filter.ExtractTokenUtils;
import br.com.elotech.portalarrecadacao.rest.service.SrvTokenAuthentication;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class AuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final String APP_API_V1_INTEGRACAO_STATUS_DOCUMENTOS = "/app/api/v1/integracao/status-documentos";
    private final String APP_API_V1_INTEGRACAO_CONSULTAS_PREVIAS = "/app/api/v1/integracao/consultas-previas";
    private final String APP_API_V1_INTEGRACAO_EMPRESAS = "/app/api/v1/integracao/empresas";
    private final String APP_API_V1_INTEGRACAO_RETORNO_EXIGENCIA = "/app/api/v1/integracao/retorno-exigencias";
    private final String APP_API_V1_INTEGRACAO_SOLICITACOES_DOCUMENTOS = "/app/api/v1/integracao/solicitacoes-documentos";
    private final String APP_API_V1_INTEGRACAO_ENDERECO = "/app/api/v1/integracao/endereco";
    private final List<String> INTEGRACOES_TOKEN_CONSULTA_PREVIA = Arrays.asList("/app/api/v1/integracao/consultas-previas", "/app/api/v1/integracao/endereco");
    private final List<String> INTEGRACOES_TOKEN_SOLICITACAO = Arrays.asList("/app/api/v1/integracao/empresas", "/app/api/v1/integracao/solicitacoes-documentos", "/app/api/v1/integracao/status-documentos", "/app/api/v1/integracao/retorno-exigencias");
    @Autowired
    private AlvaraRestObjectMapper alvaraRestObjectMapper;
    @Autowired
    private SrvTokenAuthentication srvTokenAuthentication;

    private boolean necessitaTokenConsultaPrevia(String uri) {
        return this.INTEGRACOES_TOKEN_CONSULTA_PREVIA.stream().anyMatch(uri::contains);
    }

    private boolean necessitaTokenSolicitacao(String uri) {
        return this.INTEGRACOES_TOKEN_SOLICITACAO.stream().anyMatch(uri::contains);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("Iniciando filtro de autentica\u00e7\u00e3o");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Optional token = ExtractTokenUtils.tryGetToken((HttpServletRequest)httpRequest);
        if (token.isPresent()) {
            this.tryAuthenticateUserByToken(httpResponse, (String)token.get(), httpRequest.getRequestURI());
        }
        chain.doFilter(request, response);
    }

    private void tryAuthenticateUserByToken(HttpServletResponse httpResponse, String token, String uri) throws IOException {
        try {
            log.debug("Tentativa de autentica\u00e7\u00e3o por token");
            Authentication authentication = null;
            if (this.necessitaTokenConsultaPrevia(uri) || this.necessitaTokenSolicitacao(uri)) {
                String tokenSalvo = this.getTokenClienteRedeSim(uri);
                if (!token.equals(tokenSalvo)) {
                    throw new AutenticacaoRedeSimException("Acesso n\u00e3o autorizado. Token inv\u00e1lido.");
                }
                authentication = this.srvTokenAuthentication.getAuthenticationRedeSim();
            } else {
                authentication = this.srvTokenAuthentication.getAuthentication(token);
            }
            log.debug("A autentica\u00e7\u00e3o foi realizada com sucesso!");
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (AutenticacaoRedeSimException ex) {
            log.error(ex.getMessage());
            Erro erro = new Erro();
            erro.setCo_retorno(Long.valueOf(9006L));
            erro.setDs_retorno(ex.getMessage());
            RedeSimErrorMessage message = new RedeSimErrorMessage();
            message.getErros().add(erro);
            this.sendJsonHttpResponse(httpResponse, this.alvaraRestObjectMapper.writeValueAsString((Object)message), Integer.valueOf(401));
        }
        catch (AuthenticationException ex) {
            log.error("Falha na autentica\u00e7\u00e3o. Motivo [{}]", (Object)ex.getMessage());
            this.sendJsonHttpResponse(httpResponse, this.createJsonResponseFromException((Throwable)ex), Integer.valueOf(401));
        }
        catch (ExpiredJwtException ex) {
            log.error(ex.getMessage());
            this.sendJsonHttpResponse(httpResponse, this.createJsonResponseFromException((Throwable)ex), Integer.valueOf(403));
        }
        catch (MalformedJwtException ex) {
            log.error(ex.getMessage());
            this.sendJsonHttpResponse(httpResponse, this.createJsonResponseFromException((Throwable)ex), Integer.valueOf(400));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            this.sendJsonHttpResponse(httpResponse, this.createJsonResponseFromException((Throwable)ex), Integer.valueOf(500));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendJsonHttpResponse(HttpServletResponse httpResponse, String errorJson, Integer status) {
        try {
            log.debug("Escrevendo resposta JSON para a requisi\u00e7\u00e3o solicitada");
            httpResponse.setContentType(MediaType.APPLICATION_JSON.toString());
            httpResponse.getOutputStream().write(errorJson.getBytes());
        }
        catch (IOException e) {
            log.error("Erro ao escrever erro em formato JSON na resposta da requisi\u00e7\u00e3o. Motivo [{}]", (Object)e.getMessage(), (Object)e);
        }
        finally {
            httpResponse.setStatus(status.intValue());
            SecurityContextHolder.clearContext();
        }
    }

    private String createJsonResponseFromException(Throwable ex) throws JsonProcessingException {
        AlvaraErrorMessage error = new AlvaraErrorMessage();
        error.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        error.setMessage(ex.getMessage());
        error.setException(ex.getClass().getName());
        return this.alvaraRestObjectMapper.writeValueAsString((Object)error);
    }

    private String getTokenClienteRedeSim(String uri) throws BaseException {
        if (this.necessitaTokenConsultaPrevia(uri)) {
            return UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.CLIENT_TOKEN_CONSULTA_PREVIA_REDESIM).getValor();
        }
        if (this.necessitaTokenSolicitacao(uri)) {
            return UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.CLIENT_TOKEN_SOLICITACAO_REDESIM).getValor();
        }
        return null;
    }
}

