/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.SolicitacaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SistemaFiscalizacaoEnum;
import br.com.elotech.portalarrecadacao.exception.EncerramentoProcessoException;
import br.com.elotech.portalarrecadacao.exception.LaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.ProcessoFiscalizacaoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoNaoEncontradaException;
import br.com.elotech.portalarrecadacao.facade.FacadeParecerDoLaudo;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeUsuario;
import br.com.elotech.portalarrecadacao.rest.dto.ConcluirVistoriaDTO;
import br.com.elotech.portalarrecadacao.rest.dto.ProcessoFiscalizacaoAndamentoLaudoDTO;
import br.com.elotech.portalarrecadacao.rest.dto.StatusHttpDTO;
import br.com.elotech.portalarrecadacao.rest.resource.BaseResource;
import br.com.elotech.portalarrecadacao.rest.security.model.UserAuthentication;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.list.EloListUtils;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.bind.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/laudos"})
public class LaudoAlvaraResource
extends BaseResource {
    @RequestMapping(value={"/parecer"}, method={RequestMethod.POST})
    public ResponseEntity<?> parecer(@Valid @RequestBody ProcessoFiscalizacaoAndamentoLaudoDTO processo) throws BaseException {
        String sistemaFiscalizacao = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRACAO_FISCALIZACAO_SISTEMA);
        if (SistemaFiscalizacaoEnum.ELOTECH.toString().equalsIgnoreCase(sistemaFiscalizacao)) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        AndamentoLaudoAlvaraEntity andamentoLaudoAlvaraEntity = ((FacadeParecerDoLaudo)SpringContext.getBean(FacadeParecerDoLaudo.class)).salvarParecerLaudoFiscalizacao(processo);
        if (Objects.nonNull(andamentoLaudoAlvaraEntity)) {
            StatusHttpDTO status = new StatusHttpDTO();
            status.setStatus(Integer.valueOf(200));
            return new ResponseEntity((Object)status, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/concluir-vistoria"}, method={RequestMethod.POST})
    public ResponseEntity<?> concluirVistoria(@Valid @RequestBody ConcluirVistoriaDTO vistoria, @AuthenticationPrincipal UserAuthentication usuarioAutenticado) throws EncerramentoProcessoException {
        try {
            UsuarioEntity usuario = ((FacadeUsuario)SpringContext.getBean(FacadeUsuario.class)).getUsuarioAlvaraLaudoByUsuarioCpfCnpj(usuarioAutenticado.getName());
            SolicitacaoAlvaraEntity solicitacao = this.recuperarSolicitacaoVistoria(vistoria);
            LaudoAlvaraEntity laudo = this.getLaudoConfiguradoNoParametroEEncaminhadoParaVistoria(solicitacao);
            ProcessoFiscalizacaoAndamentoLaudoDTO processo = new ProcessoFiscalizacaoAndamentoLaudoDTO();
            processo.setLaudo(laudo.getIdLaudoAlvara());
            processo.setSituacao(StatusLaudoAlvara.EM_ANALISE.getCodigo());
            processo.setDataParecer(new Date());
            processo.setDescricao(String.format("Situa\u00e7\u00e3o O.S Fiscaliza\u00e7\u00e3o: %s", vistoria.getStatus()));
            processo.setFiscal(vistoria.getFiscal());
            processo.setUsuario(usuario.getUsuario());
            processo.setUrl(vistoria.getUrl());
            return this.parecer(processo);
        }
        catch (Throwable e) {
            throw new EncerramentoProcessoException(e.getMessage());
        }
    }

    private LaudoAlvaraEntity getLaudoConfiguradoNoParametroEEncaminhadoParaVistoria(SolicitacaoAlvaraEntity solicitacao) throws BaseException, ProcessoFiscalizacaoException, LaudoNaoEncontradoException {
        String tipoLaudo = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.INTEGRACAO_FISCALIZACAO_TIPOS_LAUDOS);
        String[] tipos = tipoLaudo.split(",");
        if (tipos.length > 1) {
            throw new ProcessoFiscalizacaoException("Existe mais de um tipo de laudo cadastrado no par\u00e2metro.");
        }
        Optional<LaudoAlvaraEntity> laudo = solicitacao.getLaudos().stream().filter(l -> l.getTipoLaudo().getCodigo().getValue().equals(tipoLaudo.trim()) && l.getStatus() == StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA).findFirst();
        if (!laudo.isPresent()) {
            throw new LaudoNaoEncontradoException(String.format("Laudo %s (%s) n\u00e3o encontrado na solicita\u00e7\u00e3o, ou o andamento do laudo \u00e9 diferente de Encaminhado para vistoria", tipoLaudo.trim(), StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA.descricaoCapitalize()));
        }
        return laudo.get();
    }

    private SolicitacaoAlvaraEntity recuperarSolicitacaoVistoria(ConcluirVistoriaDTO vistoria) throws BaseException, SolicitacaoNaoEncontradaException {
        SolicitacaoAlvaraVo solicitacaoVo = this.criarFiltroPesquisa(vistoria);
        List solicitacoes = ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).buscaSolicitacaoAlvaraPorCpfCnpj(solicitacaoVo);
        if (EloListUtils.safeIsEmpty((List)solicitacoes).booleanValue()) {
            throw new SolicitacaoNaoEncontradaException("Solicita\u00e7\u00e3o n\u00e3o encontrada.");
        }
        if (solicitacoes.size() > 1) {
            throw new ProcessoFiscalizacaoException("Foram encontradas mais de uma solicita\u00e7\u00e3o.");
        }
        return (SolicitacaoAlvaraEntity)solicitacoes.get(0);
    }

    private SolicitacaoAlvaraVo criarFiltroPesquisa(ConcluirVistoriaDTO vistoria) {
        SolicitacaoAlvaraVo solicitacaoVo = new SolicitacaoAlvaraVo();
        if (vistoria != null) {
            if (vistoria.getNumeroSolicitacao() != null) {
                solicitacaoVo.setNumeroSolicitacao(String.valueOf(vistoria.getNumeroSolicitacao()));
            }
            solicitacaoVo.setExercicio(vistoria.getExercicio());
            return solicitacaoVo;
        }
        return solicitacaoVo;
    }
}

