/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ArquivoDocumentoAlvaraEntity;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.util.jwt.JwtUtils;
import io.jsonwebtoken.MalformedJwtException;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/integracao/imprimir-documento"})
public class ImprimirDocumentoEloArquivoResource
extends RedeSimBaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImprimirDocumentoEloArquivoResource.class);
    @Resource
    private FacadeDocumento facadeDocumento;

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<?> getDocumento(@RequestParam(value="token") String token) throws BaseException {
        try {
            ArquivoDocumentoAlvaraEntity arquivoDocumento = this.facadeDocumento.imprimirDocumentoEloArquivo(JwtUtils.recuperarIdArquivo((String)token));
            if (arquivoDocumento != null) {
                byte[] content = arquivoDocumento.getEloArquivo().getContent().getBinary();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
                headers.add("Content-Disposition", "inline;filename=alvara.pdf");
                headers.setCacheControl("must-revalidate, post-check=0, pre-check=0");
                return new ResponseEntity((Object)content, (MultiValueMap)headers, HttpStatus.OK);
            }
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        catch (MalformedJwtException mje) {
            LOGGER.error(mje.getMessage(), (Throwable)mje);
            return new ResponseEntity((Object)"Token inv\u00e1lido!", HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)"N\u00e3o foi poss\u00edvel imprimir o documento solicitacado.", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void setFacadeDocumento(FacadeDocumento facadeDocumento) {
        this.facadeDocumento = facadeDocumento;
    }
}

