/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoProcessadaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.facade.FacadeFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosConsultaPrevia;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS01Service;
import br.com.elotech.portalarrecadacao.utils.JsonUtils;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/integracao/consultas-previas"})
public class ConsultaPreviaResource
extends RedeSimBaseResource {
    private static final Logger log = LoggerFactory.getLogger(ConsultaPreviaResource.class);
    @Autowired
    private FacadeRedeSim facadeRedeSim;
    @Resource
    private FacadeFilaRecebimentoRedeSim facadeFilaRecebimentoRedeSim;
    @Autowired
    private ProcessamentoWS01Service processamentoWS01Service;

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<DadosConsultaPrevia> consultaPrevia(@RequestBody ConsultaPreviaDTO consultaPreviaDTO) throws BaseException {
        Gson gson = new Gson();
        String request = JsonUtils.sanitize((String)gson.toJson((Object)consultaPreviaDTO));
        String randomToken = UUID.randomUUID().toString();
        DadosConsultaPrevia dadosConsultaPrevia = consultaPreviaDTO.getDados_consulta_previa();
        String protocolo = dadosConsultaPrevia.getCo_protocolo_redesim();
        log.info("[{}] Recebendo requisi\u00e7\u00e3o - {} ({}): {}", new Object[]{randomToken, TipoFilaRecebimentoRedeSimEnum.WS01.getDescricao(), protocolo, request});
        SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.facadeRedeSim.getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.CONSULTA);
        FilaRecebimentoProcessadaRedeSimEntity ultimoProcessamento = this.facadeFilaRecebimentoRedeSim.findFilaRecebimentoProcessByTipoAndProtocolo(TipoFilaRecebimentoRedeSimEnum.WS01, protocolo).stream().max(Comparator.comparing(FilaRecebimentoProcessadaRedeSimEntity::getId)).orElse(null);
        if (Objects.nonNull(solicitacaoRedeSimEntity) && Objects.nonNull(ultimoProcessamento)) {
            throw new RegistroProcessadoAnteriormenteException("Registro processado anteriormente");
        }
        FilaRecebimentoRedeSimEntity fila = new FilaRecebimentoRedeSimEntity();
        fila.setProtocolo(protocolo);
        fila.setTipo(TipoFilaRecebimentoRedeSimEnum.WS01);
        fila.setRequest(request);
        fila.setDataRecebimento(new Date());
        fila = this.facadeFilaRecebimentoRedeSim.salvarFilaRecebimento(fila);
        dadosConsultaPrevia.setId(fila.getId());
        return new ResponseEntity((Object)dadosConsultaPrevia, HttpStatus.CREATED);
    }

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    public void setProcessamentoWS01Service(ProcessamentoWS01Service processamentoWS01Service) {
        this.processamentoWS01Service = processamentoWS01Service;
    }
}

