/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.issExterno;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.enumerator.ParametroGeralEnum;
import br.com.elotech.portalarrecadacao.enumerator.SufixoMetodosIssExterno;
import br.com.elotech.portalarrecadacao.exception.IntegracaoISSException;
import br.com.elotech.portalarrecadacao.integration.vo.CodigoLiberacaoIssExterno;
import br.com.elotech.portalarrecadacao.integration.vo.PessoaIssExterno;
import br.com.elotech.portalarrecadacao.rest.AlvaraObjectMapper;
import br.com.elotech.portalarrecadacao.rest.issExterno.RestTemplateFactory;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.util.date.EloDateUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@EloService(value="srvClientIssExterno")
@Scope(value="prototype")
public class SrvClientIssExterno
extends EloLogger {
    private final RepositoryParametroGeral repositoryParametroGeral;
    private static final String CHAVE_LINK_CODIGO_LIBERACAO = ":cpf_cnpj";

    @Autowired
    public SrvClientIssExterno(RepositoryParametroGeral repositoryParametroGeral) {
        this.repositoryParametroGeral = repositoryParametroGeral;
    }

    public PessoaIssExterno incluirPessoa(Object objetoEnvio, String linkAPIIssExterno) throws IntegracaoISSException {
        PessoaIssExterno pessoaIncluida = null;
        try {
            URL url = this.montarURLIncluirPessoa(linkAPIIssExterno);
            RestTemplate rt = this.autenticarServico();
            pessoaIncluida = (PessoaIssExterno)rt.postForObject(url.toURI(), objetoEnvio, PessoaIssExterno.class);
            this.validarPessoaIncluida(pessoaIncluida);
            return pessoaIncluida;
        }
        catch (BaseException | IOException | URISyntaxException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | RestClientException e) {
            this.logger.info((Object)String.format("Falha ao inserir a pessoa na base do ISS: %s%s", System.lineSeparator(), AlvaraObjectMapper.jsonToString((Object)objetoEnvio)), e);
            this.logger.error((Object)e.getMessage(), e);
            String message = "N\u00e3o foi poss\u00edvel carregar o c\u00f3digo SGO da integra\u00e7\u00e3o ISS. Verifique o par\u00e2metro LINK_API_ISS_EXTERNO. ";
            if (pessoaIncluida != null) {
                this.logger.info((Object)pessoaIncluida.getAdditionalProperties().toString());
                message = message + pessoaIncluida.getAdditionalProperties().toString();
            }
            throw new IntegracaoISSException(message);
        }
    }

    private void validarPessoaIncluida(PessoaIssExterno pessoaIncluida) throws IntegracaoISSException {
        if (pessoaIncluida == null) {
            throw new IntegracaoISSException("");
        }
    }

    private URL montarURLIncluirPessoa(String linkAPIIssExterno) throws BaseException, MalformedURLException {
        linkAPIIssExterno = linkAPIIssExterno.concat(SufixoMetodosIssExterno.INSERIR_PESSOA.getSufixo());
        this.logger.info((Object)linkAPIIssExterno);
        return new URL(linkAPIIssExterno);
    }

    private RestTemplate autenticarServico() throws MalformedURLException, IOException, BaseException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        String usuario = this.repositoryParametroGeral.getParametro(ParametroGeralEnum.WEBINTEGRAUSUARIO_ISS_E.getModulo(), ParametroGeralEnum.WEBINTEGRAUSUARIO_ISS_E.name());
        String senha = this.repositoryParametroGeral.getParametro(ParametroGeralEnum.WEBINTEGRASENHA_ISS_E.getModulo(), ParametroGeralEnum.WEBINTEGRASENHA_ISS_E.name());
        return RestTemplateFactory.createTemplate((String)usuario, (String)senha);
    }

    public CodigoLiberacaoIssExterno gerarCodigoLiberacaoSGO(String cnpjCpf, String linkAPIIssExterno) throws ClientProtocolException, IOException, URISyntaxException, BaseException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        URL url = this.montarURLCodigoLiberacao(cnpjCpf, linkAPIIssExterno);
        RestTemplate rt = this.autenticarServico();
        CodigoLiberacaoIssExterno resultado = (CodigoLiberacaoIssExterno)rt.postForObject(url.toURI(), null, CodigoLiberacaoIssExterno.class);
        return resultado;
    }

    private URL montarURLCodigoLiberacao(String cnpjCpf, String linkAPIIssExterno) throws BaseException, MalformedURLException {
        linkAPIIssExterno = this.substituirParametroCpf(linkAPIIssExterno, cnpjCpf);
        this.logger.info((Object)("URL: " + linkAPIIssExterno));
        return new URL(linkAPIIssExterno);
    }

    private String substituirParametroCpf(String linkIssExterno, String cnpjCpf) {
        linkIssExterno = linkIssExterno.concat(SufixoMetodosIssExterno.GERAR_CODIGO_LIBERACAO.getSufixo());
        return linkIssExterno.replace(CHAVE_LINK_CODIGO_LIBERACAO, cnpjCpf);
    }

    public PessoaIssExterno consultarPessoa(String cnpjCpf, String linkAPIIssExterno) throws BaseException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        try {
            URL url = this.montarURLConsultaPessoa(cnpjCpf, linkAPIIssExterno);
            RestTemplate rt = this.autenticarServico();
            ResponseEntity response = this.executarConsultaPessoa(url, rt);
            return this.transformarRetornoEmPessoaIssExterno(response, cnpjCpf);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.info((Object)String.format("Falha ao consultar o cpf %s pessoa na base do ISS.", AlvaraObjectMapper.jsonToString((Object)cnpjCpf)), (Throwable)e);
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private PessoaIssExterno transformarRetornoEmPessoaIssExterno(ResponseEntity<String> response, String cnpjCpf) {
        try {
            if (!this.existePessoa(response)) {
                return null;
            }
            ObjectMapper instance = AlvaraObjectMapper.getInstance();
            instance.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
            instance.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            return (PessoaIssExterno)instance.readValue((String)response.getBody(), PessoaIssExterno.class);
        }
        catch (Exception e) {
            this.logger.info((Object)String.format(">>>>>> CONSULTA PESSOA: Pessoa com o cpf: %s n\u00e3o encontrada.", cnpjCpf));
            this.logger.info((Object)String.format(">>>>>> CONSULTA PESSOA: Hora da consulta: %s.", EloDateUtils.toDateTimeStringDefault((Date)new Date())));
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean existePessoa(ResponseEntity<String> response) {
        return !"\"\"".equals(response.getBody());
    }

    private URL montarURLConsultaPessoa(String cnpjCpf, String linkAPIIssExterno) throws BaseException, MalformedURLException {
        linkAPIIssExterno = linkAPIIssExterno.concat(SufixoMetodosIssExterno.CONSULTAR_PESSOA.getSufixo());
        linkAPIIssExterno = linkAPIIssExterno.concat(cnpjCpf);
        this.logger.info((Object)linkAPIIssExterno);
        return new URL(linkAPIIssExterno);
    }

    private ResponseEntity<String> executarConsultaPessoa(URL url, RestTemplate rt) throws URISyntaxException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        return rt.exchange(url.toURI(), HttpMethod.GET, entity, String.class);
    }
}

