/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDeserializer
extends JsonDeserializer<Date> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateDeserializer.class);

    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        String stringDate = (String)p.readValueAs(String.class);
        try {
            return formatter.parse(stringDate);
        }
        catch (ParseException ex) {
            LOGGER.warn("Erro ao fazer parse de data vindo do JSON. {}", (Object)ex.getMessage());
            return null;
        }
    }

    public Class<?> handledType() {
        return Date.class;
    }
}

