/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.integration.dto.consulta;

import br.com.elotech.portalarrecadacao.integration.dto.consulta.ArquivosEntidadeRegistro;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ClassificacaoRisco;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Solicitante;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.ArquivoRegistro;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Empresa;
import br.com.elotech.util.json.EloJsonUtils;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect
public class DadosSolicitacao
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String co_protocolo_redesim;
    private String dt_solicitacao;
    private String dt_autenticacao;
    private String co_recibo_dbe;
    private String nu_identificacao_dbe;
    private Empresa empresa;
    private Solicitante solicitante;
    private boolean is_vinculado;
    private List<Evento> eventos_redesim;
    private int co_tipo_entidade_registro;
    private String nu_cnpj_entidade_registro;
    private int nu_cnpj_entidade_registro_matriz;
    private ArquivosEntidadeRegistro arquivos_entidade_registro;
    private ClassificacaoRisco classificacao_risco;
    private Boolean is_atualizacao_matriz;
    private Boolean is_processo_mei;
    private int nu_sequencial;

    public static final DadosSolicitacao of(JsonNode json) {
        DadosSolicitacao dadosSolicitacao = new DadosSolicitacao();
        ArrayList eventos = new ArrayList();
        ArrayList arquivosRegistro = new ArrayList();
        JsonNode dados_solicitacao = json.get("dados_solicitacao");
        dadosSolicitacao.setId(dados_solicitacao.get("id").asInt());
        dadosSolicitacao.setCo_protocolo_redesim(dados_solicitacao.get("co_protocolo_redesim").asText());
        dadosSolicitacao.setDt_solicitacao(String.valueOf(dados_solicitacao.get("dt_solicitacao")));
        dadosSolicitacao.setDt_autenticacao(String.valueOf(dados_solicitacao.get("dt_autenticacao")));
        dadosSolicitacao.setEmpresa((Empresa)EloJsonUtils.fromJson((String)dados_solicitacao.get("empresa").toString(), Empresa.class));
        if (Objects.nonNull(dados_solicitacao.get("solicitante"))) {
            dadosSolicitacao.setSolicitante((Solicitante)EloJsonUtils.fromJson((String)dados_solicitacao.get("solicitante").toString(), Solicitante.class));
        }
        dados_solicitacao.get("eventos_redesim").elements().forEachRemaining(data -> {
            Evento evento = new Evento();
            evento.setCo_evento(data.get("co_evento").asInt());
            eventos.add(evento);
        });
        dadosSolicitacao.setEventos_redesim(eventos);
        dadosSolicitacao.setCo_tipo_entidade_registro(dados_solicitacao.get("co_tipo_entidade_registro").asInt());
        if (Objects.nonNull(dados_solicitacao.get("arquivos_entidade_registro")) && json.get("dados_solicitacao").get("arquivos_entidade_registro").getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            dados_solicitacao.get("arquivos_entidade_registro").elements().forEachRemaining(data -> {
                ArquivoRegistro arquivoRegistro = new ArquivoRegistro();
                arquivoRegistro.setNu_tipo_arquivo(Integer.valueOf(data.get("nu_tipo_arquivo").asInt()));
                arquivoRegistro.setDs_url_servico(data.get("ds_url_servico").asText());
                arquivosRegistro.add(arquivoRegistro);
            });
            ArquivosEntidadeRegistro arquivosEntidadeRegistro = new ArquivosEntidadeRegistro();
            arquivosEntidadeRegistro.setArquivo_registro(arquivosRegistro);
            dadosSolicitacao.setArquivos_entidade_registro(arquivosEntidadeRegistro);
        } else if (Objects.nonNull(dados_solicitacao.get("arquivos_entidade_registro"))) {
            dadosSolicitacao.setArquivos_entidade_registro((ArquivosEntidadeRegistro)EloJsonUtils.fromJson((String)dados_solicitacao.get("arquivos_entidade_registro").toString(), ArquivosEntidadeRegistro.class));
        }
        return dadosSolicitacao;
    }

    public int getId() {
        return this.id;
    }

    public String getCo_protocolo_redesim() {
        return this.co_protocolo_redesim;
    }

    public String getDt_solicitacao() {
        return this.dt_solicitacao;
    }

    public String getDt_autenticacao() {
        return this.dt_autenticacao;
    }

    public String getCo_recibo_dbe() {
        return this.co_recibo_dbe;
    }

    public String getNu_identificacao_dbe() {
        return this.nu_identificacao_dbe;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public Solicitante getSolicitante() {
        return this.solicitante;
    }

    public boolean is_vinculado() {
        return this.is_vinculado;
    }

    public List<Evento> getEventos_redesim() {
        return this.eventos_redesim;
    }

    public int getCo_tipo_entidade_registro() {
        return this.co_tipo_entidade_registro;
    }

    public String getNu_cnpj_entidade_registro() {
        return this.nu_cnpj_entidade_registro;
    }

    public int getNu_cnpj_entidade_registro_matriz() {
        return this.nu_cnpj_entidade_registro_matriz;
    }

    public ArquivosEntidadeRegistro getArquivos_entidade_registro() {
        return this.arquivos_entidade_registro;
    }

    public ClassificacaoRisco getClassificacao_risco() {
        return this.classificacao_risco;
    }

    public Boolean getIs_atualizacao_matriz() {
        return this.is_atualizacao_matriz;
    }

    public Boolean getIs_processo_mei() {
        return this.is_processo_mei;
    }

    public int getNu_sequencial() {
        return this.nu_sequencial;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setCo_protocolo_redesim(String co_protocolo_redesim) {
        this.co_protocolo_redesim = co_protocolo_redesim;
    }

    public void setDt_solicitacao(String dt_solicitacao) {
        this.dt_solicitacao = dt_solicitacao;
    }

    public void setDt_autenticacao(String dt_autenticacao) {
        this.dt_autenticacao = dt_autenticacao;
    }

    public void setCo_recibo_dbe(String co_recibo_dbe) {
        this.co_recibo_dbe = co_recibo_dbe;
    }

    public void setNu_identificacao_dbe(String nu_identificacao_dbe) {
        this.nu_identificacao_dbe = nu_identificacao_dbe;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setSolicitante(Solicitante solicitante) {
        this.solicitante = solicitante;
    }

    public void set_vinculado(boolean is_vinculado) {
        this.is_vinculado = is_vinculado;
    }

    public void setEventos_redesim(List<Evento> eventos_redesim) {
        this.eventos_redesim = eventos_redesim;
    }

    public void setCo_tipo_entidade_registro(int co_tipo_entidade_registro) {
        this.co_tipo_entidade_registro = co_tipo_entidade_registro;
    }

    public void setNu_cnpj_entidade_registro(String nu_cnpj_entidade_registro) {
        this.nu_cnpj_entidade_registro = nu_cnpj_entidade_registro;
    }

    public void setNu_cnpj_entidade_registro_matriz(int nu_cnpj_entidade_registro_matriz) {
        this.nu_cnpj_entidade_registro_matriz = nu_cnpj_entidade_registro_matriz;
    }

    public void setArquivos_entidade_registro(ArquivosEntidadeRegistro arquivos_entidade_registro) {
        this.arquivos_entidade_registro = arquivos_entidade_registro;
    }

    public void setClassificacao_risco(ClassificacaoRisco classificacao_risco) {
        this.classificacao_risco = classificacao_risco;
    }

    public void setIs_atualizacao_matriz(Boolean is_atualizacao_matriz) {
        this.is_atualizacao_matriz = is_atualizacao_matriz;
    }

    public void setIs_processo_mei(Boolean is_processo_mei) {
        this.is_processo_mei = is_processo_mei;
    }

    public void setNu_sequencial(int nu_sequencial) {
        this.nu_sequencial = nu_sequencial;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DadosSolicitacao)) {
            return false;
        }
        DadosSolicitacao other = (DadosSolicitacao)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$co_protocolo_redesim = this.getCo_protocolo_redesim();
        String other$co_protocolo_redesim = other.getCo_protocolo_redesim();
        if (this$co_protocolo_redesim == null ? other$co_protocolo_redesim != null : !this$co_protocolo_redesim.equals(other$co_protocolo_redesim)) {
            return false;
        }
        String this$dt_solicitacao = this.getDt_solicitacao();
        String other$dt_solicitacao = other.getDt_solicitacao();
        if (this$dt_solicitacao == null ? other$dt_solicitacao != null : !this$dt_solicitacao.equals(other$dt_solicitacao)) {
            return false;
        }
        String this$dt_autenticacao = this.getDt_autenticacao();
        String other$dt_autenticacao = other.getDt_autenticacao();
        if (this$dt_autenticacao == null ? other$dt_autenticacao != null : !this$dt_autenticacao.equals(other$dt_autenticacao)) {
            return false;
        }
        String this$co_recibo_dbe = this.getCo_recibo_dbe();
        String other$co_recibo_dbe = other.getCo_recibo_dbe();
        if (this$co_recibo_dbe == null ? other$co_recibo_dbe != null : !this$co_recibo_dbe.equals(other$co_recibo_dbe)) {
            return false;
        }
        String this$nu_identificacao_dbe = this.getNu_identificacao_dbe();
        String other$nu_identificacao_dbe = other.getNu_identificacao_dbe();
        if (this$nu_identificacao_dbe == null ? other$nu_identificacao_dbe != null : !this$nu_identificacao_dbe.equals(other$nu_identificacao_dbe)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        Solicitante this$solicitante = this.getSolicitante();
        Solicitante other$solicitante = other.getSolicitante();
        if (this$solicitante == null ? other$solicitante != null : !this$solicitante.equals(other$solicitante)) {
            return false;
        }
        if (this.is_vinculado() != other.is_vinculado()) {
            return false;
        }
        List this$eventos_redesim = this.getEventos_redesim();
        List other$eventos_redesim = other.getEventos_redesim();
        if (this$eventos_redesim == null ? other$eventos_redesim != null : !((Object)this$eventos_redesim).equals(other$eventos_redesim)) {
            return false;
        }
        if (this.getCo_tipo_entidade_registro() != other.getCo_tipo_entidade_registro()) {
            return false;
        }
        String this$nu_cnpj_entidade_registro = this.getNu_cnpj_entidade_registro();
        String other$nu_cnpj_entidade_registro = other.getNu_cnpj_entidade_registro();
        if (this$nu_cnpj_entidade_registro == null ? other$nu_cnpj_entidade_registro != null : !this$nu_cnpj_entidade_registro.equals(other$nu_cnpj_entidade_registro)) {
            return false;
        }
        if (this.getNu_cnpj_entidade_registro_matriz() != other.getNu_cnpj_entidade_registro_matriz()) {
            return false;
        }
        ArquivosEntidadeRegistro this$arquivos_entidade_registro = this.getArquivos_entidade_registro();
        ArquivosEntidadeRegistro other$arquivos_entidade_registro = other.getArquivos_entidade_registro();
        if (this$arquivos_entidade_registro == null ? other$arquivos_entidade_registro != null : !this$arquivos_entidade_registro.equals(other$arquivos_entidade_registro)) {
            return false;
        }
        ClassificacaoRisco this$classificacao_risco = this.getClassificacao_risco();
        ClassificacaoRisco other$classificacao_risco = other.getClassificacao_risco();
        if (this$classificacao_risco == null ? other$classificacao_risco != null : !this$classificacao_risco.equals(other$classificacao_risco)) {
            return false;
        }
        Boolean this$is_atualizacao_matriz = this.getIs_atualizacao_matriz();
        Boolean other$is_atualizacao_matriz = other.getIs_atualizacao_matriz();
        if (this$is_atualizacao_matriz == null ? other$is_atualizacao_matriz != null : !((Object)this$is_atualizacao_matriz).equals(other$is_atualizacao_matriz)) {
            return false;
        }
        Boolean this$is_processo_mei = this.getIs_processo_mei();
        Boolean other$is_processo_mei = other.getIs_processo_mei();
        if (this$is_processo_mei == null ? other$is_processo_mei != null : !((Object)this$is_processo_mei).equals(other$is_processo_mei)) {
            return false;
        }
        return this.getNu_sequencial() == other.getNu_sequencial();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DadosSolicitacao;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $co_protocolo_redesim = this.getCo_protocolo_redesim();
        result = result * 59 + ($co_protocolo_redesim == null ? 43 : $co_protocolo_redesim.hashCode());
        String $dt_solicitacao = this.getDt_solicitacao();
        result = result * 59 + ($dt_solicitacao == null ? 43 : $dt_solicitacao.hashCode());
        String $dt_autenticacao = this.getDt_autenticacao();
        result = result * 59 + ($dt_autenticacao == null ? 43 : $dt_autenticacao.hashCode());
        String $co_recibo_dbe = this.getCo_recibo_dbe();
        result = result * 59 + ($co_recibo_dbe == null ? 43 : $co_recibo_dbe.hashCode());
        String $nu_identificacao_dbe = this.getNu_identificacao_dbe();
        result = result * 59 + ($nu_identificacao_dbe == null ? 43 : $nu_identificacao_dbe.hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        Solicitante $solicitante = this.getSolicitante();
        result = result * 59 + ($solicitante == null ? 43 : $solicitante.hashCode());
        result = result * 59 + (this.is_vinculado() ? 79 : 97);
        List $eventos_redesim = this.getEventos_redesim();
        result = result * 59 + ($eventos_redesim == null ? 43 : ((Object)$eventos_redesim).hashCode());
        result = result * 59 + this.getCo_tipo_entidade_registro();
        String $nu_cnpj_entidade_registro = this.getNu_cnpj_entidade_registro();
        result = result * 59 + ($nu_cnpj_entidade_registro == null ? 43 : $nu_cnpj_entidade_registro.hashCode());
        result = result * 59 + this.getNu_cnpj_entidade_registro_matriz();
        ArquivosEntidadeRegistro $arquivos_entidade_registro = this.getArquivos_entidade_registro();
        result = result * 59 + ($arquivos_entidade_registro == null ? 43 : $arquivos_entidade_registro.hashCode());
        ClassificacaoRisco $classificacao_risco = this.getClassificacao_risco();
        result = result * 59 + ($classificacao_risco == null ? 43 : $classificacao_risco.hashCode());
        Boolean $is_atualizacao_matriz = this.getIs_atualizacao_matriz();
        result = result * 59 + ($is_atualizacao_matriz == null ? 43 : ((Object)$is_atualizacao_matriz).hashCode());
        Boolean $is_processo_mei = this.getIs_processo_mei();
        result = result * 59 + ($is_processo_mei == null ? 43 : ((Object)$is_processo_mei).hashCode());
        result = result * 59 + this.getNu_sequencial();
        return result;
    }

    public String toString() {
        return "DadosSolicitacao(id=" + this.getId() + ", co_protocolo_redesim=" + this.getCo_protocolo_redesim() + ", dt_solicitacao=" + this.getDt_solicitacao() + ", dt_autenticacao=" + this.getDt_autenticacao() + ", co_recibo_dbe=" + this.getCo_recibo_dbe() + ", nu_identificacao_dbe=" + this.getNu_identificacao_dbe() + ", empresa=" + this.getEmpresa() + ", solicitante=" + this.getSolicitante() + ", is_vinculado=" + this.is_vinculado() + ", eventos_redesim=" + this.getEventos_redesim() + ", co_tipo_entidade_registro=" + this.getCo_tipo_entidade_registro() + ", nu_cnpj_entidade_registro=" + this.getNu_cnpj_entidade_registro() + ", nu_cnpj_entidade_registro_matriz=" + this.getNu_cnpj_entidade_registro_matriz() + ", arquivos_entidade_registro=" + this.getArquivos_entidade_registro() + ", classificacao_risco=" + this.getClassificacao_risco() + ", is_atualizacao_matriz=" + this.getIs_atualizacao_matriz() + ", is_processo_mei=" + this.getIs_processo_mei() + ", nu_sequencial=" + this.getNu_sequencial() + ")";
    }
}

