/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.gerador;

import br.com.elotech.portalarrecadacao.gerador.GeraMigracaoMeiAcessibilidade;
import br.com.elotech.util.string.EloStringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeraMigracaoMeiAcessibilidade {
    private static final Logger logger = LoggerFactory.getLogger(GeraMigracaoMeiAcessibilidade.class);
    private static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String URL_CONNECTION = "jdbc:oracle:thin:@homoscan.pmm.gov.br:1521/orahomo";
    private static final String DB_USER = "tributos";
    private static final String DB_PASS = "elotributo";
    private static List<String> listaNaoEncontrados;
    private static List<AtividadeMei> listaMei;

    public static void main(String[] args) {
        try {
            listaNaoEncontrados = new ArrayList();
            listaMei = new ArrayList();
            System.out.println("** Estabelecendo conex\u00e3o...");
            Connection connection = GeraMigracaoMeiAcessibilidade.createConnection();
            Statement statement = connection.createStatement();
            System.out.println("** Conectado ao Banco de Dados!");
            if (GeraMigracaoMeiAcessibilidade.existeColunasNecessarias((Statement)statement)) {
                System.out.println("++ iniciando carregamento do arquivo...");
                String arquivoPlanilha = "src/main/java/br/com/elotech/portalarrecadacao/gerador/MEI_ACESSIBILIDADE.xls";
                FileInputStream inp = new FileInputStream(arquivoPlanilha);
                Workbook planilha = WorkbookFactory.create((InputStream)inp);
                System.out.println("++ iniciando leitura da planilha...");
                Sheet sheet = planilha.getSheetAt(0);
                System.out.println("-=-=-=- " + sheet.getLastRowNum() + " registro(s) encontrado(s) na planilha! -=-=-=-");
                System.out.println("++ iniciando atualiza\u00e7\u00e3o dos dados...");
                listaMei = GeraMigracaoMeiAcessibilidade.getAtividadeMei((Statement)statement);
                for (int i = 2; i <= sheet.getLastRowNum(); ++i) {
                    Row linha = sheet.getRow(i);
                    long idMei = GeraMigracaoMeiAcessibilidade.getIDParaUpdate((Row)linha);
                    if (idMei <= 0L) continue;
                    GeraMigracaoMeiAcessibilidade.atualizaMei((Statement)statement, (Row)linha, (long)idMei);
                }
                GeraMigracaoMeiAcessibilidade.atualizaDemaisMeis((Statement)statement);
                connection.close();
                System.out.println("** Desconectado!");
                System.out.println("-=-=-=-=-=- " + listaNaoEncontrados.size() + " problema(s) encontrado(s) -=-=-=-=-=-");
                GeraMigracaoMeiAcessibilidade.imprimirListaNaoEncontrados();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo n\u00e3o encontrado");
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo com formato inv\u00e1lido");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static long getIDParaUpdate(Row linha) {
        String codigoCnae = linha != null && linha.getCell(0) != null ? linha.getCell(0).getStringCellValue() : "";
        String ocupacao = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        String cnaeFormatado = codigoCnae.replaceAll("/", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll(" ", "").replaceAll("\r", "").replaceAll("\t", "").replaceAll("\n", "");
        for (AtividadeMei atividadeMei : listaMei) {
            String ocupacaoMeiFormatado;
            String ocupacaoFormatado;
            if (!cnaeFormatado.equals(String.valueOf(atividadeMei.codigoCnae)) || !(ocupacaoFormatado = EloStringUtils.retiraAcentos((String)ocupacao).replaceAll(Pattern.quote("(A)"), "").replaceAll(" ", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll("[\"']", "")).equalsIgnoreCase(ocupacaoMeiFormatado = EloStringUtils.retiraAcentos((String)atividadeMei.ocupacao).replaceAll(Pattern.quote("(A)"), "").replaceAll(" ", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll("[\"']", ""))) continue;
            return atividadeMei.codigo;
        }
        listaNaoEncontrados.add("Nao encontrou o C\u00f3digo = " + codigoCnae + " e Descri\u00e7\u00e3o = " + ocupacao);
        return 0L;
    }

    public static Connection createConnection() throws ClassNotFoundException, SQLException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        return DriverManager.getConnection("jdbc:oracle:thin:@homoscan.pmm.gov.br:1521/orahomo", "tributos", "elotributo");
    }

    public static List<AtividadeMei> getAtividadeMei(Statement statement) throws SQLException {
        GeraMigracaoMeiAcessibilidade m = new GeraMigracaoMeiAcessibilidade();
        String sql = "SELECT am.atividadeMei, c.codigo, am.ocupacao FROM TRIBATIVIDADEMEI am inner join CNAE c on am.CNAE = c.cnae ";
        ResultSet resultSet = statement.executeQuery(sql);
        ArrayList<AtividadeMei> listaAtividadeMei = new ArrayList<AtividadeMei>();
        while (resultSet.next()) {
            GeraMigracaoMeiAcessibilidade geraMigracaoMeiAcessibilidade = m;
            geraMigracaoMeiAcessibilidade.getClass();
            AtividadeMei at = new AtividadeMei(geraMigracaoMeiAcessibilidade, null);
            at.codigo = resultSet.getLong(1);
            at.codigoCnae = resultSet.getString(2);
            at.ocupacao = resultSet.getString(3);
            listaAtividadeMei.add(at);
        }
        return listaAtividadeMei;
    }

    public static void atualizaMei(Statement statement, Row linha, long idMei) {
        String codigoCnae = linha != null && linha.getCell(0) != null ? linha.getCell(0).getStringCellValue() : "";
        String ocupacao = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        String cnaeFormatado = codigoCnae.replaceAll("/", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll(" ", "").replaceAll("\r", "").replaceAll("\t", "").replaceAll("\n", "");
        String sql = "update TRIBATIVIDADEMEI set PERMITEALVARASEMACESSIBILIDADE = 'N', VERIFICARAREA = 'N'  where atividademei = " + idMei;
        try {
            statement.execute(sql);
            System.out.println("Alterado com sucesso: C\u00f3digo do Cnae = " + cnaeFormatado + " e Ocupa\u00e7\u00e3o = " + ocupacao.toUpperCase());
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void atualizaDemaisMeis(Statement statement) {
        try {
            String sql = "update TRIBATIVIDADEMEI set PERMITEALVARASEMACESSIBILIDADE = 'S',  VERIFICARAREA = 'S' where PERMITEALVARASEMACESSIBILIDADE is null ";
            statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean existeColunasNecessarias(Statement statement) {
        boolean valido = true;
        if (!GeraMigracaoMeiAcessibilidade.existeColunaPermiteAlvaraSemAcessibilidade((Statement)statement)) {
            valido = false;
        }
        if (!GeraMigracaoMeiAcessibilidade.existeColunaVerificarArea((Statement)statement)) {
            valido = false;
        }
        return valido;
    }

    private static boolean existeColunaPermiteAlvaraSemAcessibilidade(Statement statement) {
        String sql = "SELECT * from TRIBATIVIDADEMEI where PERMITEALVARASEMACESSIBILIDADE = 'S'";
        try {
            statement.executeQuery(sql);
            return true;
        }
        catch (SQLException e) {
            System.out.println("** \u00c9 necess\u00e1rio criar a coluna PERMITEALVARASEMACESSIBILIDADE.\n** Execute o script que encontra-se no arquivo VersaoBanco_Alvara6.elo");
            return false;
        }
    }

    private static boolean existeColunaVerificarArea(Statement statement) {
        String sql = "SELECT * from TRIBATIVIDADEMEI where VerificarArea = 'S'";
        try {
            statement.executeQuery(sql);
            return true;
        }
        catch (SQLException e) {
            System.out.println("** \u00c9 necess\u00e1rio criar a coluna VERIFICARAREA.\n** Execute o script que encontra-se no arquivo VersaoBanco_Alvara6.elo");
            return false;
        }
    }

    private static void imprimirListaNaoEncontrados() {
        for (String string : listaNaoEncontrados) {
            System.out.println(string);
        }
    }
}

