/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.gerador;

import br.com.elotech.portalarrecadacao.gerador.GeraMigracaoCboAcessibilidade;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeraMigracaoCboAcessibilidade {
    private static final Logger logger = LoggerFactory.getLogger(GeraMigracaoCboAcessibilidade.class);
    private static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String URL_CONNECTION = "jdbc:oracle:thin:@homoscan.pmm.gov.br:1521/orahomo";
    private static final String DB_USER = "tributos";
    private static final String DB_PASS = "elotributo";
    private static List<String> listaNaoEncontrados;
    private static List<AtividadeCbo> listaCbo;

    public static void main(String[] args) {
        try {
            listaNaoEncontrados = new ArrayList();
            listaCbo = new ArrayList();
            System.out.println("** Estabelecendo conex\u00e3o...");
            Connection connection = GeraMigracaoCboAcessibilidade.createConnection();
            Statement statement = connection.createStatement();
            System.out.println("** Conectado ao Banco de Dados!");
            if (GeraMigracaoCboAcessibilidade.existeColunaPermiteAlvaraSemAcessibilidade((Statement)statement)) {
                System.out.println("++ iniciando carregamento do arquivo...");
                String arquivoPlanilha = "src/main/java/br/com/elotech/portalarrecadacao/gerador/restricao_acessibilidade_cbo.xls";
                FileInputStream inp = new FileInputStream(arquivoPlanilha);
                Workbook planilha = WorkbookFactory.create((InputStream)inp);
                System.out.println("++ iniciando leitura da planilha...");
                Sheet sheet = planilha.getSheetAt(0);
                System.out.println("-=-=-=- " + sheet.getLastRowNum() + " registro(s) encontrado(s) na planilha! -=-=-=-");
                System.out.println("++ iniciando atualiza\u00e7\u00e3o dos dados...");
                listaCbo = GeraMigracaoCboAcessibilidade.getAtividadeCbo((Statement)statement);
                for (int i = 2; i <= sheet.getLastRowNum(); ++i) {
                    Row linha = sheet.getRow(i);
                    long idCbo = GeraMigracaoCboAcessibilidade.getIDParaUpdate((Row)linha);
                    if (idCbo <= 0L) continue;
                    GeraMigracaoCboAcessibilidade.atualizaCbo((Statement)statement, (Row)linha, (long)idCbo);
                }
                GeraMigracaoCboAcessibilidade.atualizaDemaisCBOs((Statement)statement);
                connection.close();
                System.out.println("** Desconectado!");
                System.out.println("-=-=-=-=-=- " + listaNaoEncontrados.size() + " problema(s) encontrado(s) -=-=-=-=-=-");
                GeraMigracaoCboAcessibilidade.imprimirListaNaoEncontrados();
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo n\u00e3o encontrado");
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo com formato inv\u00e1lido");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static long getIDParaUpdate(Row linha) {
        String descricao;
        String codigoCbo = linha != null && linha.getCell(0) != null ? String.valueOf(linha.getCell(0).getNumericCellValue()) : "";
        String string = descricao = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        if (codigoCbo.contains(".0")) {
            codigoCbo = codigoCbo.replace(".0", "");
        }
        for (AtividadeCbo atividadeCbo : listaCbo) {
            if (!codigoCbo.equals(String.valueOf(atividadeCbo.codigoCbo))) continue;
            return atividadeCbo.id;
        }
        listaNaoEncontrados.add("Nao encontrou o C\u00f3digo = " + codigoCbo + " e Descri\u00e7\u00e3o = " + descricao);
        return 0L;
    }

    public static Connection createConnection() throws ClassNotFoundException, SQLException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        return DriverManager.getConnection("jdbc:oracle:thin:@homoscan.pmm.gov.br:1521/orahomo", "tributos", "elotributo");
    }

    public static List<AtividadeCbo> getAtividadeCbo(Statement statement) throws SQLException {
        GeraMigracaoCboAcessibilidade m = new GeraMigracaoCboAcessibilidade();
        String sql = "SELECT c.sequenciaCbo, c.cbo, c.descricao FROM RHCBO c";
        ResultSet resultSet = statement.executeQuery(sql);
        ArrayList<AtividadeCbo> listaAtividadeCbo = new ArrayList<AtividadeCbo>();
        while (resultSet.next()) {
            GeraMigracaoCboAcessibilidade geraMigracaoCboAcessibilidade = m;
            geraMigracaoCboAcessibilidade.getClass();
            AtividadeCbo at = new AtividadeCbo(geraMigracaoCboAcessibilidade, null);
            at.id = resultSet.getLong(1);
            at.codigoCbo = resultSet.getString(2);
            listaAtividadeCbo.add(at);
        }
        return listaAtividadeCbo;
    }

    public static void atualizaCbo(Statement statement, Row linha, long idCbo) {
        String descricao;
        String codigoCbo = linha != null && linha.getCell(0) != null ? String.valueOf(linha.getCell(0).getNumericCellValue()) : "";
        String string = descricao = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        if (codigoCbo.contains(".0")) {
            codigoCbo = codigoCbo.replace(".0", "");
        }
        String sql = "update RHCBO set PERMITEALVARASEMACESSIBILIDADE = 'N' where sequenciaCbo = " + idCbo;
        try {
            statement.execute(sql);
            System.out.println("Alterado com sucesso: C\u00f3digo do CBO = " + codigoCbo + " e Ocupa\u00e7\u00e3o = " + descricao.toUpperCase());
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void atualizaDemaisCBOs(Statement statement) {
        try {
            String sql = "update RHCBO set PERMITEALVARASEMACESSIBILIDADE = 'S' where PERMITEALVARASEMACESSIBILIDADE is null ";
            statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean existeColunaPermiteAlvaraSemAcessibilidade(Statement statement) {
        String sql = "SELECT * from RHCBO where PERMITEALVARASEMACESSIBILIDADE = 'S'";
        try {
            statement.executeQuery(sql);
            return true;
        }
        catch (SQLException e) {
            System.out.println("** \u00c9 necess\u00e1rio criar a coluna PERMITEALVARASEMACESSIBILIDADE.\n** Execute o script que encontra-se no arquivo VersaoBanco_Alvara6.elo");
            return false;
        }
    }

    private static void imprimirListaNaoEncontrados() {
        for (String string : listaNaoEncontrados) {
            System.out.println(string);
        }
    }
}

