/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.gerador;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeraChangeSetSQL {
    private static final Logger logger = LoggerFactory.getLogger(GeraChangeSetSQL.class);
    private static final String CREATE_TABLE = "CREATE TABLE";
    private static final String CREATE_SEQUENCE = "CREATE SEQUENCE";
    private static final String ALTER_TABLE = "ALTER TABLE";
    private static final String INSERT = "INSERT";
    private static final String UPDATE = "UPDATE";
    private static final String DELETE = "DELETE";
    private static final String CREATE_OR_REPLACE_VIEW = "CREATE OR REPLACE VIEW";
    private static final String DROP_TABLE = "DROP TABLE";
    private static Integer idChangeSet = 1;
    private static StringBuilder changeSet = new StringBuilder();
    private static List<String> listaUID = new ArrayList();

    public static void main(String[] args) {
        File file1 = new File("src/main/resources/liquibase/sql/v3462_id1_claudio.sql");
        GeraChangeSetSQL.lerArquivo((File)file1);
        GeraChangeSetSQL.imprimirListaUID();
    }

    private static void imprimirListaUID() {
        for (String sql : listaUID) {
            System.out.println(sql);
        }
    }

    public static void lerArquivo(File file) {
        try (BufferedReader leitor = new BufferedReader(new FileReader(file));){
            String linha = "";
            StringBuilder sql = new StringBuilder();
            while ((linha = leitor.readLine()) != null) {
                if (linha.length() <= 0 || linha.trim().startsWith("--") || linha.trim().startsWith("/*")) continue;
                sql.append(linha + "\n");
                if (!linha.trim().endsWith(";")) continue;
                if (sql.toString().trim().toUpperCase().startsWith("INSERT") || sql.toString().trim().toUpperCase().startsWith("UPDATE") || sql.toString().trim().toUpperCase().startsWith("DELETE")) {
                    listaUID.add(sql.toString());
                } else {
                    GeraChangeSetSQL.montarChangeSet((StringBuilder)sql);
                }
                sql.delete(0, sql.length());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void montarChangeSet(StringBuilder sqlOriginal) {
        String sqlModificado = sqlOriginal.toString().trim().replaceAll("\n", " ").replaceAll("\t", " ").replaceAll("\r", " ").replaceAll(" +", " ").trim();
        changeSet.append("<changeSet id=\"" + idChangeSet + "\" author=\"claudio\">\n");
        if (GeraChangeSetSQL.temPreConditions((String)sqlModificado)) {
            GeraChangeSetSQL.montarPreCondition((String)sqlModificado);
        }
        changeSet.append("<sql>\n");
        changeSet.append(sqlOriginal.toString().trim() + "\n");
        changeSet.append("</sql>\n");
        changeSet.append("</changeSet>");
        Integer n = idChangeSet;
        Integer n2 = idChangeSet = Integer.valueOf(idChangeSet + 1);
        System.out.println(changeSet);
        changeSet.delete(0, changeSet.length());
    }

    private static void montarPreCondition(String sql) {
        String tipoSql = GeraChangeSetSQL.getTipoSql((String)sql);
        if (tipoSql.equals("CREATE TABLE")) {
            GeraChangeSetSQL.montarPreConditionTableExists((String)sql, (boolean)true, (int)3);
        } else if (tipoSql.equals("ALTER TABLE")) {
            if (GeraChangeSetSQL.isAddFK((String)sql)) {
                GeraChangeSetSQL.montarPreConditionForeignKeyConstraintExists((String)sql);
            } else if (GeraChangeSetSQL.isAddColumn((String)sql)) {
                GeraChangeSetSQL.montarPreConditionColumnExists((String)sql, (boolean)true);
            } else if (GeraChangeSetSQL.isDropColumn((String)sql)) {
                GeraChangeSetSQL.montarPreConditionColumnExists((String)sql, (boolean)false);
            }
        } else if (!tipoSql.equals("INSERT") && !tipoSql.equals("UPDATE")) {
            if (tipoSql.equals("CREATE SEQUENCE")) {
                GeraChangeSetSQL.montarPreConditionSequenceExists((String)sql, (boolean)true);
            } else if (tipoSql.equals("CREATE OR REPLACE VIEW")) {
                GeraChangeSetSQL.montarPreConditionViewExists((String)sql, (boolean)true);
            } else if (tipoSql.equals("DROP TABLE")) {
                GeraChangeSetSQL.montarPreConditionTableExists((String)sql, (boolean)false, (int)3);
            }
        }
    }

    private static void montarPreConditionTableExists(String sql, boolean usarTagNot, int posicaoNomeTabelaNoSql) {
        String nomeTabela = GeraChangeSetSQL.getNomeTabela((String)sql, (int)posicaoNomeTabelaNoSql);
        String mensagem = usarTagNot ? "A tabela " + nomeTabela.toUpperCase() + " j\u00e1 existe" : "A tabela " + nomeTabela.toUpperCase() + " n\u00e3o existe";
        changeSet.append("<preConditions onFail=\"MARK_RAN\" onFailMessage=\"" + mensagem + "\">\n");
        if (usarTagNot) {
            GeraChangeSetSQL.abrirTagNot();
        }
        changeSet.append("<tableExists tableName=\"" + nomeTabela.toUpperCase() + "\"/>\n");
        if (usarTagNot) {
            GeraChangeSetSQL.fecharTagNot();
        }
        changeSet.append("</preConditions>\n");
    }

    private static void montarPreConditionForeignKeyConstraintExists(String sql) {
        String nomeTabela = GeraChangeSetSQL.getNomeTabela((String)sql, (int)3);
        String nomeFK = GeraChangeSetSQL.getNomeConstraint((String)sql);
        changeSet.append("<preConditions onFail=\"MARK_RAN\" onFailMessage=\"A Foreign Key " + nomeFK.toUpperCase() + " j\u00e1 existe na tabela " + nomeTabela.toUpperCase() + "\">\n");
        changeSet.append("<not>\n");
        changeSet.append("<foreignKeyConstraintExists foreignKeyName=\"" + nomeFK.toUpperCase() + "\" foreignKeyTableName=\"" + nomeTabela + "\"/>\n");
        changeSet.append("</not>\n");
        changeSet.append("</preConditions>\n");
    }

    private static void montarPreConditionColumnExists(String sql, boolean usarTagNot) {
        String nomeTabela = GeraChangeSetSQL.getNomeTabela((String)sql, (int)3);
        boolean isAddColumn = GeraChangeSetSQL.isAddColumn((String)sql);
        List nomeColunas = isAddColumn ? GeraChangeSetSQL.getNomeColunaAdd((String)sql) : GeraChangeSetSQL.getNomeColunaDrop((String)sql);
        String colunas = "";
        if (nomeColunas.size() > 1) {
            for (String coluna : nomeColunas) {
                colunas = colunas + coluna + ", ";
            }
            colunas = colunas.substring(0, colunas.length() - 2);
            boolean usaTagAnd = false;
            String mensagem = usarTagNot ? "Verifique se as colunas " + colunas.toUpperCase() + " j\u00e1 existem na tabela " + nomeTabela.toUpperCase() : "Verifique se as colunas " + colunas.toUpperCase() + " existem na tabela " + nomeTabela.toUpperCase();
            changeSet.append("<preConditions onFail=\"MARK_RAN\" onFailMessage=\"" + mensagem + "\">\n");
            for (String coluna : nomeColunas) {
                if (usaTagAnd) {
                    GeraChangeSetSQL.abrirTagAnd();
                }
                if (usarTagNot) {
                    GeraChangeSetSQL.abrirTagNot();
                }
                changeSet.append("<columnExists tableName=\"" + nomeTabela.toUpperCase() + "\" columnName=\"" + coluna.toUpperCase() + "\"/>\n");
                if (usarTagNot) {
                    GeraChangeSetSQL.fecharTagNot();
                }
                if (usaTagAnd) {
                    GeraChangeSetSQL.fecharTagAnd();
                }
                usaTagAnd = true;
            }
            changeSet.append("</preConditions>\n");
        } else {
            changeSet.append("<preConditions onFail=\"MARK_RAN\" onFailMessage=\"A coluna " + ((String)nomeColunas.get(0)).toUpperCase() + " j\u00e1 existe na tabela " + nomeTabela.toUpperCase() + "\">\n");
            if (usarTagNot) {
                GeraChangeSetSQL.abrirTagNot();
            }
            changeSet.append("<columnExists tableName=\"" + nomeTabela.toUpperCase() + "\" columnName=\"" + ((String)nomeColunas.get(0)).toUpperCase() + "\"/>\n");
            if (usarTagNot) {
                GeraChangeSetSQL.fecharTagNot();
            }
            changeSet.append("</preConditions>\n");
        }
    }

    private static void montarPreConditionSequenceExists(String sql, boolean usarTagAnd) {
        String nomeSequence = GeraChangeSetSQL.getNomeSequence((String)sql);
        String mensagem = usarTagAnd ? "A sequence " + nomeSequence.toUpperCase() + " j\u00e1 existe" : "A sequence " + nomeSequence.toUpperCase() + " n\u00e3o existe";
        changeSet.append("<preConditions onFail=\"MARK_RAN\" onFailMessage=\"" + mensagem + "\">\n");
        if (usarTagAnd) {
            GeraChangeSetSQL.abrirTagAnd();
        }
        changeSet.append("<dbms type=\"oracle\"/>\n");
        changeSet.append("<sqlCheck expectedResult=\"0\">SELECT COUNT(*) FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = '" + nomeSequence.toUpperCase() + "'</sqlCheck>\n");
        if (usarTagAnd) {
            GeraChangeSetSQL.fecharTagAnd();
        }
        changeSet.append("</preConditions>\n");
    }

    private static void montarPreConditionViewExists(String sql, boolean usarTagNot) {
        String nomeView = GeraChangeSetSQL.getNomeView((String)sql);
        String mensagem = usarTagNot ? "A view " + nomeView.toUpperCase() + " j\u00e1 existe" : "A view " + nomeView.toUpperCase() + " n\u00e3o existe";
        changeSet.append("<preConditions onFail=\"MARK_RAN\" onFailMessage=\"" + mensagem + "\">\n");
        if (usarTagNot) {
            GeraChangeSetSQL.abrirTagNot();
        }
        changeSet.append("<viewExists viewName=\"" + nomeView.toUpperCase() + "\"/>\n");
        if (usarTagNot) {
            GeraChangeSetSQL.fecharTagNot();
        }
        changeSet.append("</preConditions>\n");
    }

    private static boolean temPreConditions(String sql) {
        return GeraChangeSetSQL.getTipoSql((String)sql).length() > 0;
    }

    private static String getTipoSql(String sql) {
        if (sql.trim().toUpperCase().startsWith("CREATE TABLE")) {
            return "CREATE TABLE";
        }
        if (sql.trim().toUpperCase().startsWith("ALTER TABLE")) {
            return "ALTER TABLE";
        }
        if (sql.trim().toUpperCase().startsWith("INSERT")) {
            return "INSERT";
        }
        if (sql.trim().toUpperCase().startsWith("UPDATE")) {
            return "UPDATE";
        }
        if (sql.trim().toUpperCase().startsWith("CREATE SEQUENCE")) {
            return "CREATE SEQUENCE";
        }
        if (sql.trim().toUpperCase().startsWith("CREATE OR REPLACE VIEW")) {
            return "CREATE OR REPLACE VIEW";
        }
        if (sql.trim().toUpperCase().startsWith("DROP TABLE")) {
            return "DROP TABLE";
        }
        return "";
    }

    private static String getNomeTabela(String sql, int posicaoNomeTabelaNoSql) {
        String nomeTabela = sql.split(" ")[posicaoNomeTabelaNoSql - 1];
        String tipoSql = GeraChangeSetSQL.getTipoSql((String)sql);
        if (tipoSql.equals("CREATE TABLE") || tipoSql.equals("INSERT")) {
            nomeTabela = nomeTabela.split(Pattern.quote("("))[0];
        }
        nomeTabela = nomeTabela.trim().replaceAll(";", "");
        return nomeTabela.split(" ")[0];
    }

    private static boolean isAddFK(String sql) {
        return sql.toUpperCase().contains("ADD CONSTRAINT") && sql.toUpperCase().contains("FOREIGN KEY");
    }

    private static boolean isAddColumn(String sql) {
        return sql.toUpperCase().contains("ADD") && !sql.toUpperCase().contains("FOREIGN KEY") && !sql.toUpperCase().contains("PRIMARY KEY");
    }

    private static boolean isDropColumn(String sql) {
        return sql.toUpperCase().contains("DROP") && !sql.toUpperCase().contains("CONSTRAINT");
    }

    private static String getNomeConstraint(String sql) {
        String nomeConstraint = sql.split(" ")[5];
        return nomeConstraint.split(" ")[0];
    }

    private static String getNomeSequence(String sql) {
        String nomeSequence = sql.split(" ")[2];
        return nomeSequence.split(" ")[0];
    }

    private static String getNomeView(String sql) {
        String nomeView = sql.split(" ")[4];
        return nomeView.split(" ")[0];
    }

    private static List<String> getNomeColunaAdd(String sql) {
        ArrayList<String> colunas = new ArrayList<String>();
        if (sql.toUpperCase().contains("ADD(") || sql.toUpperCase().contains("ADD (")) {
            String[] partesDoAdd;
            int inicio = sql.indexOf("(");
            int fim = sql.lastIndexOf(")");
            String entreParenteses = sql.substring(inicio + 1, fim);
            for (String addColumn : partesDoAdd = entreParenteses.split(",")) {
                colunas.add(addColumn.trim().split(" ")[0]);
            }
        } else {
            colunas.add(sql.split(" ")[4]);
        }
        return colunas;
    }

    private static List<String> getNomeColunaDrop(String sql) {
        ArrayList<String> colunas = new ArrayList<String>();
        if (sql.toUpperCase().contains("DROP(") || sql.toUpperCase().contains("DROP (")) {
            String[] valoresEntreParenteses;
            int inicio = sql.indexOf("(");
            int fim = sql.lastIndexOf(")");
            String entreParenteses = sql.substring(inicio + 1, fim);
            for (String addColumn : valoresEntreParenteses = entreParenteses.split(",")) {
                colunas.add(addColumn.trim().split(" ")[0]);
            }
        } else if (sql.toUpperCase().contains("COLUMN")) {
            colunas.add(sql.split(" ")[5].replaceAll(";", ""));
        } else {
            colunas.add(sql.split(" ")[4].replaceAll(";", ""));
        }
        return colunas;
    }

    private static void abrirTagNot() {
        changeSet.append("<not>\n");
    }

    private static void fecharTagNot() {
        changeSet.append("</not>\n");
    }

    private static void abrirTagAnd() {
        changeSet.append("<and>\n");
    }

    private static void fecharTagAnd() {
        changeSet.append("</and>\n");
    }
}

