/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.factory;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.repository.RepositoryParametroAlvara;
import br.com.elotech.portalarrecadacao.service.SrvConsultaTaxaMobiliaria;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SrvConsultaTaxaMobiliariaFactory {
    @Resource
    private RepositoryParametroAlvara repositoryParametroAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;

    public SrvConsultaTaxaMobiliaria getConsultaTaxaMobiliariaInstance(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        EntidadeTributacaoEntity entidade = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
        ParametroAlvaraEntity parametro = this.repositoryParametroAlvara.getParametroAlvara(entidade.getId().getEntidade(), ParametroAlvaraEnum.NOME_DO_SERVICE_CONSULTA_TAXA_MOBILIARIA);
        if (parametro != null && !EloStringUtils.isEmpty((String)parametro.getValor())) {
            SrvConsultaTaxaMobiliaria srvConsultaTaxaMobiliaria = this.getBean(parametro.getValor());
            return srvConsultaTaxaMobiliaria;
        }
        return null;
    }

    private SrvConsultaTaxaMobiliaria getBean(String beanName) {
        return (SrvConsultaTaxaMobiliaria)SpringContext.getBean((String)beanName, SrvConsultaTaxaMobiliaria.class);
    }
}

