/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.factory;

import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividade;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SrvConsultaAtividadeFactory
extends EloLogger {
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;

    public SrvConsultaAtividade getConsultaAtividadeInstance(SolicitacaoAlvaraEntity solicitacao) {
        boolean usaGeo = this.repositoryParametroGeral.verificaIntegradoGeo();
        if (solicitacao.isSolicitacaoMEI() || solicitacao.isSolicitacaoJuridicaNormal() || solicitacao.isSolicitacaoPrestadorServico()) {
            return this.getBean(usaGeo ? "srvConsultaAtividadeNovoGeoImpl" : "srvConsultaAtividadeCnaeSemGeo");
        }
        if (solicitacao.isSolicitacaoCBO()) {
            return this.getBean(usaGeo ? "srvConsultaAtividadeCboGeo" : "srvConsultaAtividadeCboSemGeo");
        }
        return null;
    }

    private SrvConsultaAtividade getBean(String beanName) {
        return (SrvConsultaAtividade)SpringContext.getBean((String)beanName, SrvConsultaAtividade.class);
    }
}

