/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandBuscaModeloRespostaPorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandEfetivaAlteracaoSocio;
import br.com.elotech.portalarrecadacao.command.CommandNotificarValidacaoDocumento;
import br.com.elotech.portalarrecadacao.command.CommandSalvarDocumento;
import br.com.elotech.portalarrecadacao.command.CommandSalvarSolicitacaoAlvaraValidadeSefaz;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeSefazEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaEntity;

public abstract class FacadeValidacaoDocumentos
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandSalvarDocumento getCommandSalvarDocumento();

    protected abstract CommandBuscaModeloRespostaPorCodigo getCommandBuscaModeloRespostaPorCodigo();

    protected abstract CommandSalvarSolicitacaoAlvaraValidadeSefaz getCommandSalvarSolicitacaoAlvaraValidadeSefaz();

    protected abstract CommandEfetivaAlteracaoSocio getCommandEfetivaAlteracaoSocio();

    protected abstract CommandNotificarValidacaoDocumento getCommandNotificarValidacaoDocumento();

    public SolicitacaoAlvaraDocumentoEntity salvarDocumento(SolicitacaoAlvaraDocumentoEntity documento) throws BaseException {
        CommandSalvarDocumento command = this.getCommandSalvarDocumento();
        command.setDocumento(documento);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getDocumento();
    }

    public ModeloRespostaEntity buscaModeloRespostaByCodigo(Long codigo) throws BaseException {
        CommandBuscaModeloRespostaPorCodigo command = this.getCommandBuscaModeloRespostaPorCodigo();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getModeloResposta();
    }

    public void salvarValidadeSefaz(SolicitacaoAlvaraValidadeSefazEntity solicitacaoAlvaraValidadeSefaz) throws BaseException {
        CommandSalvarSolicitacaoAlvaraValidadeSefaz command = this.getCommandSalvarSolicitacaoAlvaraValidadeSefaz();
        command.setSolicitacaoAlvaraValidadeSefaz(solicitacaoAlvaraValidadeSefaz);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void efetivaAlteracaoSocio(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandEfetivaAlteracaoSocio command = this.getCommandEfetivaAlteracaoSocio();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void notificarValidacaoDocumento(SolicitacaoAlvaraDocumentoEntity documento) throws BaseException {
        CommandNotificarValidacaoDocumento command = this.getCommandNotificarValidacaoDocumento();
        command.setSolicitacaoAlvaraDocumentoEntity(documento);
        this.getCommandContainer().executeCommand((Command)command);
    }
}

