/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.domain.Page;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregarPessoasPorCpfCnpjOrderById;
import br.com.elotech.portalarrecadacao.command.CommandCarregarRestricoesAlvaraPorUsuarioCpfCnpj;
import br.com.elotech.portalarrecadacao.command.CommandCarregarUsuarioPorId;
import br.com.elotech.portalarrecadacao.command.CommandCarregarUsuarioPorSeletor;
import br.com.elotech.portalarrecadacao.command.CommandCarregarUsuariosPorModuloPaginado;
import br.com.elotech.portalarrecadacao.command.CommandSalvarCadastroRestricaoUsuarioAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarTipoDocUsuarioAlvara;
import br.com.elotech.portalarrecadacao.command.CommandUsuarioAlvaraLaudoByUsuarioCpfCnpj;
import br.com.elotech.portalarrecadacao.controller.dataModel.UsuarioDataModel;
import br.com.elotech.tributacao.command.CommandCarregarUsuariosPorModulo;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoUsuarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.domain.vo.UsuarioVo;
import br.com.elotech.util.filter.HashMapEloFilter;
import br.com.elotech.util.sql.Modulo;
import java.util.List;

public abstract class FacadeUsuario
extends Facade {
    private static final long serialVersionUID = -3775932188524221589L;

    protected abstract CommandUsuarioAlvaraLaudoByUsuarioCpfCnpj getCommandUsuarioAlvaraLaudoByUsuarioCpfCnpj();

    protected abstract CommandCarregarRestricoesAlvaraPorUsuarioCpfCnpj getCommandCarregarRestricoesAlvaraPorUsuarioCpfCnpj();

    protected abstract CommandCarregarUsuariosPorModulo getCommandCarregarUsuariosPorModulo();

    protected abstract CommandSalvarTipoDocUsuarioAlvara getCommandSalvarTipoDocUsuarioAlvara();

    protected abstract CommandCarregarUsuariosPorModuloPaginado getCommandCarregarUsuariosPorModuloPaginado();

    protected abstract CommandCarregarUsuarioPorId getCommandCarregarUsuarioPorId();

    protected abstract CommandCarregarPessoasPorCpfCnpjOrderById getCommandCarregarPessoasPorCpfCnpjOrderById();

    protected abstract CommandCarregarUsuarioPorSeletor getCommandCarregarUsuarioPorSeletor();

    protected abstract CommandSalvarCadastroRestricaoUsuarioAlvara getCommandSalvarCadastroRestricaoUsuarioAlvara();

    public UsuarioEntity getUsuarioAlvaraLaudoByUsuarioCpfCnpj(String usuarioCpfCnpj) throws BaseException {
        CommandUsuarioAlvaraLaudoByUsuarioCpfCnpj command = this.getCommandUsuarioAlvaraLaudoByUsuarioCpfCnpj();
        command.setUsuarioOuCpfCnpj(usuarioCpfCnpj);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuario();
    }

    public UsuarioEntity getRestricoesPorUsuarioCpfCnpj(String usuarioCpfCnpj) throws BaseException {
        CommandCarregarRestricoesAlvaraPorUsuarioCpfCnpj command = this.getCommandCarregarRestricoesAlvaraPorUsuarioCpfCnpj();
        command.setUsuarioOuCpfCnpj(usuarioCpfCnpj);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuario();
    }

    public List<UsuarioEntity> carregarUsuariosPorModulo(Modulo modulo) throws BaseException {
        CommandCarregarUsuariosPorModulo command = this.getCommandCarregarUsuariosPorModulo();
        command.setModulo(modulo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuarios();
    }

    public Page<UsuarioVo> carregarUsuariosPorModulo(UsuarioDataModel usuarioDataModel, int pagina, int tamanhoPagina) throws BaseException {
        CommandCarregarUsuariosPorModuloPaginado command = this.getCommandCarregarUsuariosPorModuloPaginado();
        command.setPagina(pagina);
        command.setTamanhoPagina(tamanhoPagina);
        command.setUsuarioDataModel(usuarioDataModel);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuarios();
    }

    public List<TipoDocumentoUsuarioAlvaraEntity> salvarTipoDocUsuarioAlvara(UsuarioEntity usuarioSelecionado) throws BaseException {
        CommandSalvarTipoDocUsuarioAlvara command = this.getCommandSalvarTipoDocUsuarioAlvara();
        command.setUsuarioAlvara(usuarioSelecionado);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTipoDocumentoUsuarioAlvara();
    }

    public UsuarioEntity carregaUsuarioPorId(String idUsuario) throws BaseException {
        CommandCarregarUsuarioPorId command = this.getCommandCarregarUsuarioPorId();
        command.setIdUsuario(idUsuario);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuario();
    }

    public List<PessoaEntity> carregaPessoasOrderById(String cpfCnpj) throws BaseException {
        CommandCarregarPessoasPorCpfCnpjOrderById command = this.getCommandCarregarPessoasPorCpfCnpjOrderById();
        command.setCpfCnpj(cpfCnpj);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getPessoas();
    }

    public List<UsuarioEntity> carregarUsuarioPorSeletor(HashMapEloFilter filtro) throws BaseException {
        CommandCarregarUsuarioPorSeletor command = this.getCommandCarregarUsuarioPorSeletor();
        command.setFilter(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuarios();
    }

    public List<CadastroRestricaoAlvaraEntity> salvarCadastroRestricaoUsuarioAlvara(UsuarioEntity usuarioSelecionado) throws BaseException {
        CommandSalvarCadastroRestricaoUsuarioAlvara command = this.getCommandSalvarCadastroRestricaoUsuarioAlvara();
        command.setUsuarioAlvara(usuarioSelecionado);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCadastroRestricaoUsuarioAlvara();
    }
}

