/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandBuildRelatorioDispensaLicencaAmbiental;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAlvarasEmitidos;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaLaudoAlvaraRelatorio;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaQuantidadeConsultaSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregarLaudosVencidos;
import br.com.elotech.portalarrecadacao.command.CommandCarregarSolicitacoesDispensaAmbiental;
import br.com.elotech.portalarrecadacao.command.CommandCarregarSolicitacoesQuePodemSolicitarDispensaAmbiental;
import br.com.elotech.portalarrecadacao.command.CommandImprimeRelatorio;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDispensaAmbientalEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioLaudoVo;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroRelatorioSolicitacoesVo;
import br.com.elotech.portalarrecadacao.domain.vo.QuantidadeConsultaSolicitacaoVo;
import br.com.elotech.portalarrecadacao.domain.vod.DispensaAmbientalVO;
import br.com.elotech.portalarrecadacao.enumerator.TipoPesquisaDispensaAmbientalEnum;
import br.com.elotech.report.DataSet;
import br.com.elotech.report.Parameter;
import br.com.elotech.tributacao.domain.dto.ImprimeRelatorioDto;
import br.com.elotech.tributacao.domain.vo.SubReportVo;
import java.util.List;
import java.util.Map;

public abstract class FacadeRelatorios
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaListaSolicitacao getCommandCarregaListaSolicitacao();

    protected abstract CommandImprimeRelatorio getCommandImprimeRelatorio();

    protected abstract CommandCarregaListaLaudoAlvaraRelatorio getCommandCarregaListaLaudoAlvaraRelatorio();

    protected abstract CommandCarregaListaQuantidadeConsultaSolicitacao getCommandCarregaListaQuantidadeConsultaSolicitacao();

    protected abstract CommandCarregaListaAlvarasEmitidos getCommandCarregaListaAlvarasEmitidos();

    protected abstract CommandCarregarLaudosVencidos getCommandCarregarLaudosVencidos();

    protected abstract CommandBuildRelatorioDispensaLicencaAmbiental getCommandBuildRelatorioDispensaLicencaAmbiental();

    protected abstract CommandCarregarSolicitacoesDispensaAmbiental getCommandCarregarSolicitacoesDispensaAmbiental();

    protected abstract CommandCarregarSolicitacoesQuePodemSolicitarDispensaAmbiental getCommandCarregarSolicitacoesQuePodemSolicitarDispensaAmbiental();

    public List<SolicitacaoAlvaraEntity> carregarListaSolicitacoes(FiltroRelatorioSolicitacoesVo filtro) throws BaseException {
        CommandCarregaListaSolicitacao command = this.getCommandCarregaListaSolicitacao();
        command.setFiltroRelatorioSolicitacoesVo(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaSolicitacoes();
    }

    public byte[] imprimeRelatorio(String relatorioJasper, DataSet dataSet, List<SubReportVo> subReports, Map<String, Parameter> parametros) throws BaseException {
        CommandImprimeRelatorio command = this.getCommandImprimeRelatorio();
        command.setRelatorioJasper(relatorioJasper);
        command.setDataSet(dataSet);
        command.setSubReports(subReports);
        command.setParametros(parametros);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getReportByteArray();
    }

    public List<LaudoAlvaraEntity> carregarListaLaudos(FiltroRelatorioLaudoVo filtro) throws BaseException {
        CommandCarregaListaLaudoAlvaraRelatorio command = this.getCommandCarregaListaLaudoAlvaraRelatorio();
        command.setFiltroRelatorioLaudoVo(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaLaudos();
    }

    public List<QuantidadeConsultaSolicitacaoVo> carregarListaQuantidadeConsultaSolicitacao(FiltroRelatorioSolicitacoesVo filtro) throws BaseException {
        CommandCarregaListaQuantidadeConsultaSolicitacao command = this.getCommandCarregaListaQuantidadeConsultaSolicitacao();
        command.setFiltroRelatorioSolicitacoesVo(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaQuantidade();
    }

    public List<SolicitacaoAlvaraEntity> carregarListaAlvarasEmitidos(FiltroRelatorioSolicitacoesVo filtro) throws BaseException {
        CommandCarregaListaAlvarasEmitidos command = this.getCommandCarregaListaAlvarasEmitidos();
        command.setFiltroRelatorioSolicitacoesVo(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaAlvarasEmitidos();
    }

    public List<LaudoAlvaraEntity> carregarLaudosVencidos(FiltroRelatorioLaudoVo filtro) throws BaseException {
        CommandCarregarLaudosVencidos command = this.getCommandCarregarLaudosVencidos();
        command.setFiltroRelatorioLaudoVo(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLaudosVencidos();
    }

    public ImprimeRelatorioDto buildRelatorioDispensaLicencaAmbiental(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandBuildRelatorioDispensaLicencaAmbiental command = this.getCommandBuildRelatorioDispensaLicencaAmbiental();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getDto();
    }

    public List<SolicitacaoDispensaAmbientalEntity> carregarSolicitacoesDispensaAmbiental() throws BaseException {
        CommandCarregarSolicitacoesDispensaAmbiental command = this.getCommandCarregarSolicitacoesDispensaAmbiental();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacoesDispensa();
    }

    public List<DispensaAmbientalVO> carregarSolicitacoesQuePodemSolicitarDispensaAmbiental(TipoPesquisaDispensaAmbientalEnum tipoPesquisa) throws BaseException {
        CommandCarregarSolicitacoesQuePodemSolicitarDispensaAmbiental command = this.getCommandCarregarSolicitacoesQuePodemSolicitarDispensaAmbiental();
        command.setTipoPesquisa(tipoPesquisa);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacoes();
    }
}

