/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregarProibicoesAtivas;
import br.com.elotech.portalarrecadacao.command.CommandCarregarProibicoesAtividade;
import br.com.elotech.portalarrecadacao.command.CommandExcluirProibicaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandSalvarProibicaoAtividade;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import java.util.List;

public abstract class FacadeProibicao
extends Facade {
    private static final long serialVersionUID = -3732217454959967960L;

    protected abstract CommandCarregarProibicoesAtividade getCommandCarregarProibicoesAtividade();

    protected abstract CommandCarregarProibicoesAtivas getCommandCarregarProibicoesAtivas();

    protected abstract CommandSalvarProibicaoAtividade getCommandSalvarProibicaoAtividade();

    protected abstract CommandExcluirProibicaoAtividade getCommandExcluirProibicaoAtividade();

    public List<ProibicaoEntity> carregarProibicoesAtivas() throws BaseException {
        CommandCarregarProibicoesAtivas command = this.getCommandCarregarProibicoesAtivas();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getProibicoes();
    }

    public List<ProibicaoAtividadeEntity> carregarExigenciasPorConfiguracaoAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) throws BaseException {
        CommandCarregarProibicoesAtividade command = this.getCommandCarregarProibicoesAtividade();
        command.setConfiguracaoAtividade(configuracaoAtividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.carregarProibicoesAtividade();
    }

    public void salvarProibicaoAtividade(ProibicaoAtividadeEntity proibicaoAtividade) throws BaseException {
        CommandSalvarProibicaoAtividade command = this.getCommandSalvarProibicaoAtividade();
        command.setProibicaoAtividade(proibicaoAtividade);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public void excluirProibicaoAtividade(ProibicaoAtividadeEntity proibicaoAtividade) throws BaseException {
        CommandExcluirProibicaoAtividade command = this.getCommandExcluirProibicaoAtividade();
        command.setProibicaoAtividade(proibicaoAtividade);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }
}

