/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAberturaProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.command.CommandAberturaProcessoFiscalizacaoAutomatico;
import br.com.elotech.portalarrecadacao.command.CommandCancelamentoProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.command.CommandReativarLaudosCancelados;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ProcessoFiscalizacao;
import java.util.List;
import java.util.Optional;

public abstract class FacadeProcessoFiscalizacao
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandAberturaProcessoFiscalizacao getCommandAberturaProcessoFiscalizacao();

    protected abstract CommandAberturaProcessoFiscalizacaoAutomatico getCommandAberturaProcessoFiscalizacaoAutomatico();

    protected abstract CommandCancelamentoProcessoFiscalizacao getCommandCancelamentoProcessoFiscalizacao();

    protected abstract CommandReativarLaudosCancelados getCommandReativarLaudosCancelados();

    public List<ProcessoFiscalizacao> abrirProcesso(SolicitacaoAlvaraEntity solicitacao, Optional<Integer> idAssunto) throws BaseException {
        CommandAberturaProcessoFiscalizacao command = this.getCommandAberturaProcessoFiscalizacao();
        command.setSolicitacao(solicitacao);
        command.setIdAssunto(idAssunto);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getProcessoFiscalizacao();
    }

    public void abrirProcessoAutomatico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandAberturaProcessoFiscalizacaoAutomatico command = this.getCommandAberturaProcessoFiscalizacaoAutomatico();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void cancelarProcessoFiscalizacao(SolicitacaoAlvaraEntity solicitacao, String motivo) throws BaseException {
        CommandCancelamentoProcessoFiscalizacao command = this.getCommandCancelamentoProcessoFiscalizacao();
        command.setSolicitacao(solicitacao);
        command.setMotivo(motivo);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void reativarLaudosCanceladosFiscalizacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandReativarLaudosCancelados command = this.getCommandReativarLaudosCancelados();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }
}

