/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAddAndamentoCanceladoEmTodosLaudos;
import br.com.elotech.portalarrecadacao.command.CommandCarregaLaudos;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaLaudoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaObservacaoTipoLaudo;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaTipoLaudo;
import br.com.elotech.portalarrecadacao.command.CommandCarregaUltimoContatoPessoa;
import br.com.elotech.portalarrecadacao.command.CommandLaudosCancelados;
import br.com.elotech.portalarrecadacao.command.CommandReativarLaudosCancelados;
import br.com.elotech.portalarrecadacao.command.CommandSalvarAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarParecerLaudoFiscalizacao;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoTipoLaudoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.rest.dto.ProcessoFiscalizacaoAndamentoLaudoDTO;
import br.com.elotech.tributacao.domain.aise.ContatoPessoaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import java.util.Date;
import java.util.List;

public abstract class FacadeParecerDoLaudo
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaListaLaudoAlvara getCommandCarregaListaLaudoAlvara();

    protected abstract CommandCarregaListaAndamentoLaudoAlvara getCommandCarregaListaAndamentoLaudoAlvara();

    protected abstract CommandSalvarAndamentoLaudoAlvara getCommandSalvarAndamentoLaudoAlvara();

    protected abstract CommandCarregaListaTipoLaudo getCommandCarregaListaTipoLaudo();

    protected abstract CommandCarregaUltimoContatoPessoa getCommandCarregaUltimoContatoPessoa();

    protected abstract CommandCarregaLaudos getCommandCarregaLaudos();

    protected abstract CommandCarregaListaObservacaoTipoLaudo getCommandCarregaListaObservacaoTipoLaudo();

    protected abstract CommandSalvarParecerLaudoFiscalizacao getCommandSalvarParecerLaudoFiscalizacao();

    protected abstract CommandAddAndamentoCanceladoEmTodosLaudos getCommandAddAndamentoCanceladoEmTodosLaudos();

    protected abstract CommandReativarLaudosCancelados getCommandReativarLaudosCancelados();

    protected abstract CommandLaudosCancelados getCommandLaudosCancelados();

    public List<LaudoAlvaraEntity> getCarregaListaLaudoAlvara(StatusLaudoAlvara situacao, Date periodoInicial, Date periodoFinal, String cnpjCpf, UsuarioEntity usuario) throws BaseException {
        CommandCarregaListaLaudoAlvara command = this.getCommandCarregaListaLaudoAlvara();
        command.setSituacao(situacao);
        command.setCnpjCpf(cnpjCpf);
        command.setPeriodoInicial(periodoInicial);
        command.setPeriodoFinal(periodoFinal);
        command.setUsuario(usuario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaLaudosAlvaras();
    }

    public List<AndamentoLaudoAlvaraEntity> getCarregaListaAndamentoLaudoAlvara(Long codigoLaudo) throws BaseException {
        CommandCarregaListaAndamentoLaudoAlvara command = this.getCommandCarregaListaAndamentoLaudoAlvara();
        command.setCodigoLaudo(codigoLaudo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaAndamentoLaudo();
    }

    public AndamentoLaudoAlvaraEntity salvarAndamentoLaudo(AndamentoLaudoAlvaraEntity andamentoLaudo) throws BaseException {
        CommandSalvarAndamentoLaudoAlvara command = this.getCommandSalvarAndamentoLaudoAlvara();
        command.setAndamentoLaudoAlvara(andamentoLaudo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getAndamentoLaudoAlvara();
    }

    public List<TipoLaudoEntity> getListaTipoLaudo() throws BaseException {
        CommandCarregaListaTipoLaudo command = this.getCommandCarregaListaTipoLaudo();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaTipoLaudo();
    }

    public ContatoPessoaEntity carregarUltimoContatoPessoa(PessoaEntity pessoa) throws BaseException {
        CommandCarregaUltimoContatoPessoa command = this.getCommandCarregaUltimoContatoPessoa();
        command.setPessoa(pessoa);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getContatoPessoa();
    }

    public List<LaudoAlvaraEntity> carregaLaudos() throws BaseException {
        CommandCarregaLaudos command = this.getCommandCarregaLaudos();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLaudos();
    }

    public List<ObservacaoTipoLaudoEntity> listaObservacoesTipoLaudo(TipoLaudoEntity tipoLaudo, String exibirNoAlvara) throws BaseException {
        CommandCarregaListaObservacaoTipoLaudo command = this.getCommandCarregaListaObservacaoTipoLaudo();
        command.setTipoLaudo(tipoLaudo);
        command.setExibirNoAlvara(exibirNoAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getObservacoesTipoLaudo();
    }

    public AndamentoLaudoAlvaraEntity salvarParecerLaudoFiscalizacao(ProcessoFiscalizacaoAndamentoLaudoDTO processo) throws BaseException {
        CommandSalvarParecerLaudoFiscalizacao command = this.getCommandSalvarParecerLaudoFiscalizacao();
        command.setProcessoFiscalizacaoAndamentoLaudoDTO(processo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getAndamentoLaudoAlvaraEntity();
    }

    public void addAndamentoCanceladoEmTodosLaudos(SolicitacaoAlvaraEntity solicitacao, String motivoCancelamento) throws BaseException {
        CommandAddAndamentoCanceladoEmTodosLaudos command = this.getCommandAddAndamentoCanceladoEmTodosLaudos();
        command.setMotivoCancelamento(motivoCancelamento);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void reativarLaudosCancelados(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandReativarLaudosCancelados command = this.getCommandReativarLaudosCancelados();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public boolean verificarTodosLaudosCancelados(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandLaudosCancelados command = this.getCommandLaudosCancelados();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isTodosLaudosCancelados();
    }
}

