/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregarParametroAlvaraPorFiltro;
import br.com.elotech.portalarrecadacao.command.CommandCarregarParametroGeral;
import br.com.elotech.portalarrecadacao.command.CommandCarregarParametroGeralPorFiltro;
import br.com.elotech.portalarrecadacao.command.CommandCarregarParametroNaturezaPorFiltro;
import br.com.elotech.portalarrecadacao.command.CommandSalvarParametroAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarParametroGeral;
import br.com.elotech.portalarrecadacao.command.CommandSalvarParametroNatureza;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroParametro;
import br.com.elotech.tributacao.domain.ParametroGeralEntity;
import br.com.elotech.util.sql.Modulo;
import java.util.List;

public abstract class FacadeParametro
extends Facade {
    private static final long serialVersionUID = 937254111109604153L;

    protected abstract CommandCarregarParametroAlvaraPorFiltro getCommandCarregarParametroAlvaraPorFiltro();

    protected abstract CommandSalvarParametroAlvara getCommandSalvarParametroAlvara();

    protected abstract CommandCarregarParametroGeralPorFiltro getCommandCarregarParametroGeralPorFiltro();

    protected abstract CommandSalvarParametroGeral getCommandSalvarParametroGeral();

    protected abstract CommandCarregarParametroNaturezaPorFiltro getCommandCarregarParametroNaturezaPorFiltro();

    protected abstract CommandSalvarParametroNatureza getCommandSalvarParametroNatureza();

    protected abstract CommandCarregarParametroGeral getCommandCarregarParametroGeral();

    public List<ParametroAlvaraEntity> carregarParametrosAlvara(FiltroParametro filtro) throws BaseException {
        CommandCarregarParametroAlvaraPorFiltro command = this.getCommandCarregarParametroAlvaraPorFiltro();
        command.setFiltro(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getParametros();
    }

    public void salvarParametroAlvara(ParametroAlvaraEntity parametro) throws BaseException {
        CommandSalvarParametroAlvara command = this.getCommandSalvarParametroAlvara();
        command.setParametroAlvara(parametro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public List<ParametroGeralEntity> carregarParametrosGeral(FiltroParametro filtro) throws BaseException {
        CommandCarregarParametroGeralPorFiltro command = this.getCommandCarregarParametroGeralPorFiltro();
        command.setFiltro(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getParametros();
    }

    public void salvarParametroGeral(ParametroGeralEntity parametro) throws BaseException {
        CommandSalvarParametroGeral command = this.getCommandSalvarParametroGeral();
        command.setParametroGeral(parametro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public List<ParametroAlvaraNaturezaEntity> carregarParametrosNatureza(FiltroParametro filtro) throws BaseException {
        CommandCarregarParametroNaturezaPorFiltro command = this.getCommandCarregarParametroNaturezaPorFiltro();
        command.setFiltro(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getParametros();
    }

    public void salvarParametroNatureza(ParametroAlvaraNaturezaEntity parametro) throws BaseException {
        CommandSalvarParametroNatureza command = this.getCommandSalvarParametroNatureza();
        command.setParametroNatureza(parametro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public ParametroGeralEntity carregarParametroGeral(String parametro, Modulo modulo) throws BaseException {
        CommandCarregarParametroGeral command = this.getCommandCarregarParametroGeral();
        command.setParametro(parametro);
        command.setModulo(modulo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getParametro();
    }
}

