/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAddAndamentoLaudo;
import br.com.elotech.portalarrecadacao.command.CommandBuscaExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandBuscaLaudosPorSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregarLaudosExigidosPorConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandDeleteLaudoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandExcluirLaudoExigido;
import br.com.elotech.portalarrecadacao.command.CommandExisteLaudoComSituacaoCancelado;
import br.com.elotech.portalarrecadacao.command.CommandExistsScriptsGeracaoLaudoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandFindLaudoById;
import br.com.elotech.portalarrecadacao.command.CommandGeraLaudos;
import br.com.elotech.portalarrecadacao.command.CommandGeracaoLaudosRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandGetRenderLaudoBotaoAlteracao;
import br.com.elotech.portalarrecadacao.command.CommandSalvarLaudoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarLaudoExigido;
import br.com.elotech.portalarrecadacao.command.CommandSolicitacaoPossuiLaudoAmbiental;
import br.com.elotech.portalarrecadacao.command.CommandVerificaSeDocumentoCancelado;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import java.util.List;

public abstract class FacadeLaudoAlvara
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandSalvarLaudoAlvara getCommandSalvarLaudoAlvara();

    protected abstract CommandBuscaLaudosPorSolicitacaoAlvara getCommandBuscaLaudoPorSolicitacaoAlvara();

    protected abstract CommandGeraLaudos getCommandGerarLaudos();

    protected abstract CommandDeleteLaudoAlvara getCommandDeleteLaudoAlvara();

    protected abstract CommandBuscaExigenciaRedeSim getCommandBuscaExigenciaRedeSim();

    protected abstract CommandAddAndamentoLaudo getCommandAddAndamentoLaudo();

    protected abstract CommandCarregarLaudosExigidosPorConfiguracaoAtividade getCommandCarregarLaudosExigidosPorConfiguracaoAtividade();

    protected abstract CommandSalvarLaudoExigido getCommandSalvarLaudoExigido();

    protected abstract CommandExcluirLaudoExigido getCommandExcluirLaudoExigido();

    protected abstract CommandFindLaudoById getCommandFindLaudoById();

    protected abstract CommandVerificaSeDocumentoCancelado getCommandVerificaSeDocumentoCancelado();

    protected abstract CommandExisteLaudoComSituacaoCancelado getCommandExisteLaudoComSituacaoCancelado();

    protected abstract CommandGetRenderLaudoBotaoAlteracao getCommandGetRenderLaudoBotaoAlteracao();

    protected abstract CommandSolicitacaoPossuiLaudoAmbiental getCommandSolicitacaoPossuiLaudoAmbiental();

    protected abstract CommandGeracaoLaudosRedeSim getCommandGeracaoLaudosRedeSim();

    protected abstract CommandExistsScriptsGeracaoLaudoAlvara getCommandExistsScriptsGeracaoLaudoAlvara();

    public void addAndamentoLaudo(LaudoAlvaraEntity laudo, AndamentoLaudoAlvaraEntity andamentoLaudo, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandAddAndamentoLaudo command = this.getCommandAddAndamentoLaudo();
        command.setLaudo(laudo);
        command.setAndamentoLaudo(andamentoLaudo);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public LaudoAlvaraEntity salvarLaudoAlvara(LaudoAlvaraEntity laudo) throws BaseException {
        CommandSalvarLaudoAlvara command = this.getCommandSalvarLaudoAlvara();
        command.setLaudo(laudo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getLaudos();
    }

    public List<LaudoAlvaraEntity> buscaLaudosPorSolicitacao(Long idSolicitacao) throws BaseException {
        CommandBuscaLaudosPorSolicitacaoAlvara command = this.getCommandBuscaLaudoPorSolicitacaoAlvara();
        command.setIdSolicitacao(idSolicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLaudos();
    }

    public void gerarLaudos(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandGeraLaudos command = this.getCommandGerarLaudos();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void generateLaudosRedeSim(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandGeracaoLaudosRedeSim command = this.getCommandGeracaoLaudosRedeSim();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void deleteLaudoAlvara(LaudoAlvaraEntity laudo) throws BaseException {
        CommandDeleteLaudoAlvara command = this.getCommandDeleteLaudoAlvara();
        command.setLaudoAlvara(laudo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public List<ExigenciaRedeSimEntity> buscaLaudosExigidosRedeSim() throws BaseException {
        CommandBuscaExigenciaRedeSim command = this.getCommandBuscaExigenciaRedeSim();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getExigencias();
    }

    public List<LaudoExigidoEntity> carregarLaudosExigidosPorConfiguracao(ConfiguracaoAtividadeEntity configuracaoAtividade) throws BaseException {
        CommandCarregarLaudosExigidosPorConfiguracaoAtividade command = this.getCommandCarregarLaudosExigidosPorConfiguracaoAtividade();
        command.setConfiguracaoAtividade(configuracaoAtividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLaudosExigidos();
    }

    public LaudoExigidoEntity salvarLaudoExigido(LaudoExigidoEntity laudoExigido) throws BaseException {
        CommandSalvarLaudoExigido command = this.getCommandSalvarLaudoExigido();
        command.setLaudoExigido(laudoExigido);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getLaudoExigido();
    }

    public void excluirLaudoExigido(LaudoExigidoEntity laudo) throws BaseException {
        CommandExcluirLaudoExigido command = this.getCommandExcluirLaudoExigido();
        command.setLaudoExigido(laudo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public LaudoAlvaraEntity findLaudoById(Long idLaudo) throws BaseException {
        CommandFindLaudoById command = this.getCommandFindLaudoById();
        command.setIdLaudo(idLaudo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLaudo();
    }

    public boolean verificaExisteDocumentoOuDocCancelado(CadastroGeralAisePK cadastroGeral, Long numeroDoc) throws BaseException {
        CommandVerificaSeDocumentoCancelado command = this.getCommandVerificaSeDocumentoCancelado();
        command.setCadastroGeral(cadastroGeral);
        command.setNumeroDoc(numeroDoc);
        command.setTipoDocumento(DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
        this.getCommandContainer().executeCommand((Command)command);
        return command.isDocumentoCancelado();
    }

    public boolean isExisteLaudoComSituacaoCancelado(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandExisteLaudoComSituacaoCancelado command = this.getCommandExisteLaudoComSituacaoCancelado();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isSolicitacaoComLaudoCancelado();
    }

    public boolean getRenderLaudoBotaoAlteracao(LaudoAlvaraEntity laudo) throws BaseException {
        CommandGetRenderLaudoBotaoAlteracao command = this.getCommandGetRenderLaudoBotaoAlteracao();
        command.setLaudo(laudo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRender();
    }

    public boolean solicitacaoPossuiLaudoAmbiental(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandSolicitacaoPossuiLaudoAmbiental command = this.getCommandSolicitacaoPossuiLaudoAmbiental();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)command);
        return command.possuiLaudoAmbiental();
    }

    public boolean existsScriptsGeracaoLaudoAlvara() throws BaseException {
        CommandExistsScriptsGeracaoLaudoAlvara command = this.getCommandExistsScriptsGeracaoLaudoAlvara();
        this.getCommandContainer().executeCommand((Command)command);
        return command.existsScriptsGeracaoLaudoAlvara();
    }
}

