/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandConsultaExigenciaPorConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.command.CommandConsultaTipoExigenciaPorDescricao;
import br.com.elotech.portalarrecadacao.command.CommandExcluirExigencia;
import br.com.elotech.portalarrecadacao.command.CommandSalvarExigencia;
import br.com.elotech.portalarrecadacao.domain.ExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import java.util.List;

public abstract class FacadeExigencia
extends Facade {
    private static final long serialVersionUID = -3732217454959967960L;

    protected abstract CommandConsultaTipoExigenciaPorDescricao getCommandConsultaTipoExigenciaPorDescricao();

    protected abstract CommandConsultaExigenciaPorConfiguracaoAtividade getCommandConsultaExigenciaPorConfiguracaoAtividade();

    protected abstract CommandSalvarExigencia getCommandSalvarExigencia();

    protected abstract CommandExcluirExigencia getCommandExcluirExigencia();

    public List<TipoExigenciaEntity> consultarTipoExigenciaPorDescricao(String descricao) throws BaseException {
        CommandConsultaTipoExigenciaPorDescricao command = this.getCommandConsultaTipoExigenciaPorDescricao();
        command.setDescricao(descricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTiposExigencias();
    }

    public List<ExigenciaEntity> consultarExigenciasPorConfiguracaoAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) throws BaseException {
        CommandConsultaExigenciaPorConfiguracaoAtividade command = this.getCommandConsultaExigenciaPorConfiguracaoAtividade();
        command.setConfiguracaoAtividade(configuracaoAtividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getExigencias();
    }

    public void salvarExigencia(ExigenciaEntity exigenciaEntity) throws BaseException {
        CommandSalvarExigencia command = this.getCommandSalvarExigencia();
        command.setExigencia(exigenciaEntity);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public void excluirExigencia(ExigenciaEntity exigencia) throws BaseException {
        CommandExcluirExigencia command = this.getCommandExcluirExigencia();
        command.setExigencia(exigencia);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }
}

